{extends file="helpers/view/view.tpl"}

{block name="override_tpl"}
	<script type="text/javascript">
	var admin_order_tab_link = "{$link->getAdminLink('AdminOrders')|addslashes}";
	var id_order = {$order->id};
	var id_lang = {$current_id_lang};
	var id_currency = {$order->id_currency};
	var id_customer = {$order->id_customer|intval};
	{assign var=PS_TAX_ADDRESS_TYPE value=Configuration::get('PS_TAX_ADDRESS_TYPE')}
	var id_address = {$order->$PS_TAX_ADDRESS_TYPE};
	var currency_sign = "{$currency->sign}";
	var currency_format = "{$currency->format}";
	var currency_blank = "{$currency->blank}";
	var priceDisplayPrecision = {$smarty.const._PS_PRICE_DISPLAY_PRECISION_|intval};
	var use_taxes = {if $order->getTaxCalculationMethod() == $smarty.const.PS_TAX_INC}true{else}false{/if};
	var stock_management = {$stock_management|intval};
	var txt_add_product_stock_issue = "{l s='Are you sure you want to add this quantity?' js=1}";
	var txt_add_product_new_invoice = "{l s='Are you sure you want to create a new invoice?' js=1}";
	var txt_add_product_no_product = "{l s='Error: No product has been selected' js=1}";
	var txt_add_product_no_product_quantity = "{l s='Error: Quantity of products must be set' js=1}";
	var txt_add_product_no_product_price = "{l s='Error: Product price must be set' js=1}";
	var txt_confirm = "{l s='Are you sure?' js=1}";
	var statesShipped = new Array();
	var has_voucher = {if count($discounts)}1{else}0{/if};
	{foreach from=$states item=state}
		{if (!$currentState->shipped && $state['shipped'])}
			statesShipped.push({$state['id_order_state']});
		{/if}
	{/foreach}
	</script>

	<div class="panel kpi-container">
		<div class="row">
			<div class="col-xs-6 col-sm-3 box-stats color3" >
				<div class="kpi-content">
					<i class="icon-calendar-empty"></i>
					<span class="title">{l s='Date'}</span>
					<span class="value">{dateFormat date=$order->date_add full=false}</span>
				</div>
			</div>
			<div class="col-xs-6 col-sm-3 box-stats color4" >
				<div class="kpi-content">
					<i class="icon-money"></i>
					<span class="title">{l s='Total'}</span>
					<span class="value">{displayPrice price=$order->total_paid_tax_incl currency=$currency->id}</span>
				</div>
			</div>
			<div class="col-xs-6 col-sm-3 box-stats color2" >
				<div class="kpi-content">
					<i class="icon-comments"></i>
					<span class="title">{l s='Messages'}</span>
					<span class="value"><a href="{$link->getAdminLink('AdminCustomerThreads')|escape:'html':'UTF-8'}">{sizeof($customer_thread_message)}</a></span>
				</div>
			</div>
			<div class="col-xs-6 col-sm-3 box-stats color1" >
				<a href="#start_products">
					<div class="kpi-content">
						<i class="icon-book"></i>
						<span class="title">{l s='Products'}</span>
						<span class="value">{sizeof($products)}</span>
					</div>
				</a>
			</div>
		</div>
	</div>
	{hook h="displayAdminOrder" id_order=$order->id}
	<div class="row">
		<div class="col-lg-7">
			<div class="panel">
				<div class="panel-heading">
					<i class="icon-credit-card"></i>
					{l s='Order'}
					<span class="badge">{if $order_type == 0}{$document}{else}{$order->reference}{/if}</span>
					<span class="badge">{l s="#"}{$order->id}</span>
					<div class="panel-heading-action">
						<div class="btn-group">
							<a class="btn btn-default" href="{$link->getAdminLink('AdminOrders')|escape:'html':'UTF-8'}&amp;vieworder&amp;id_order={$previousOrder|intval}">
								<i class="icon-backward"></i>
							</a>
							<a class="btn btn-default" href="{$link->getAdminLink('AdminOrders')|escape:'html':'UTF-8'}&amp;vieworder&amp;id_order={$nextOrder|intval}">
								<i class="icon-forward"></i>
							</a>
						</div>
					</div>
				</div>
				<!-- Orders Actions -->
				<div class="well hidden-print">

					{if $document_type == 'bc'}
					
						<a class="btn btn-default finvoice fancybox.iframe" href="{$soracaisse_view_dir}&display_page=Document&order=1&iddoc={$document_number}&sctoken={$sctoken}">
							<i class="icon-file"></i>
							{$soracaisse->lang('View / Print order')}
						</a>
						
					{elseif $document_type == 'tic'}

						<a class="btn btn-default fticket fancybox.iframe" href="{$soracaisse_view_dir}&display_page=Ticket&idticket={$document_number}&sctoken={$sctoken}">
							<i class="icon-file"></i>
							{$soracaisse->lang('View / Print receipt')}
						</a>
						&nbsp;
						{if isset($invoice_number) && !empty($invoice_number)}
							<a class="btn btn-default finvoice fancybox.iframe" href="{$soracaisse_view_dir}&display_page=Document&invoice=1&iddoc={$invoice_number}&idticket={$document_number}&sctoken={$sctoken}">
								<i class="icon-file"></i>
								{$soracaisse->lang('View / Print invoice')}
							</a>
						{else}
							<span class="span label label-inactive">
								<i class="icon-remove"></i>
								{l s='No invoice'}
							</span>
						{/if}
					{else}
					<!-- TODO -->
					{/if}
					
					
				</div>
				<!-- Tab nav -->
				<ul class="nav nav-tabs" id="tabOrder">
					<li class="active">
						<a href="#status">
							<i class="icon-time"></i>
							{l s='Status'} <span class="badge">{$history|@count}</span>
						</a>
					</li>
					<li>
						<a href="#documents">
							<i class="icon-file-text"></i>
							{if $order_type == 0}
								{l s='Documents'} <span class="badge">{$total_document}</span>
							{else}
								{l s='Documents'} <span class="badge">{$order->getDocuments()|@count}</span>
							{/if}
						</a>
					</li>
				</ul>
				<!-- Tab content -->
				<div class="tab-content panel">
					<!-- Tab status -->
					<div class="tab-pane active" id="status">
						<h4 class="visible-print">{l s='Status'} <span class="badge">({$history|@count})</span></h4>
						<!-- History of status -->
						<div class="table-responsive">
							<table class="table history-status row-margin-bottom">
								<tbody>
									{foreach from=$history item=row key=key}
										{if ($key == 0)}
											<tr>
												<td style="background-color:{$row['color']}"><img src="../img/os/{$row['id_order_state']|intval}.gif" width="16" height="16" alt="{$row['ostate_name']|stripslashes}" /></td>
												<td style="background-color:{$row['color']};color:{$row['text-color']}">{$row['ostate_name']|stripslashes}</td>
												<td style="background-color:{$row['color']};color:{$row['text-color']}">{if $row['employee_lastname']}{$row['employee_firstname']|stripslashes} {$row['employee_lastname']|stripslashes}{/if}</td>
												<td style="background-color:{$row['color']};color:{$row['text-color']}">{dateFormat date=$row['date_add'] full=true}</td>
											</tr>
										{else}
											<tr>
												<td><img src="../img/os/{$row['id_order_state']|intval}.gif" width="16" height="16" /></td>
												<td>{$row['ostate_name']|stripslashes}</td>
												<td>{if $row['employee_lastname']}{$row['employee_firstname']|stripslashes} {$row['employee_lastname']|stripslashes}{else}&nbsp;{/if}</td>
												<td>{dateFormat date=$row['date_add'] full=true}</td>
											</tr>
										{/if}
									{/foreach}
								</tbody>
							</table>
						</div>
						<!-- Change status form -->
						
								{if $order_type == 0}
									<form action="" method="post" class="form-horizontal well hidden-print">
										<div class="row">
											<div class="col-lg-4">
												<button type="submit" name="submitRecall" class="btn btn-primary">
													{$soracaisse->lang('Recall')} {$document} {$soracaisse->lang('in Sora Caisse')}
												
												</button>
											</div>

											{if $return_mode == 1 && $document_type == 'tic'}
												<div class="col-lg-5">
													<button type="submit" name="submitRecallReturn" class="btn btn-primary">
														{$soracaisse->lang('Create return for')} {$document} {$soracaisse->lang('in Sora Caisse')}
													
													</button>
												</div>
											{/if}

										</div>
									</form>
								{else}
									<form action="{$currentIndex|escape:'html':'UTF-8'}&amp;vieworder&amp;token={$smarty.get.token}" method="post" class="form-horizontal well hidden-print">
										<div class="row">
											<div class="col-lg-9">
												<select id="id_order_state" class="chosen form-control" name="id_order_state">
												{foreach from=$states item=state}
													<option value="{$state['id_order_state']|intval}"{if $state['id_order_state'] == $currentState->id} selected="selected" disabled="disabled"{/if}>{$state['name']|escape}</option>
												{/foreach}
												</select>
												<input type="hidden" name="id_order" value="{$order->id}" />
											</div>
											<div class="col-lg-3">
												<button type="submit" name="submitState" class="btn btn-primary">
													{l s='Update status'}
												</button>
											</div>
										</div>
									</form>
								{/if}
							
					</div>
					<!-- Tab documents -->
					<div class="tab-pane" id="documents">
		
						<h4 class="visible-print">{l s='Documents'} <span class="badge">({$total_document})</span></h4>

						<div class="table-responsive">
							<table class="table" id="documents_table">
								<thead>
									<tr>
										<th>
											<span class="title_box ">{l s='Date'}</span>
										</th>
										<th>
											<span class="title_box ">{l s='Document'}</span>
										</th>
										<th>
											<span class="title_box ">{l s='Number'}</span>
										</th>
										<th>
											<span class="title_box ">{l s='Amount'}</span>
										</th>
										<th></th>
									</tr>
								</thead>
								<tbody>

								{if empty($invoice) && empty($ticket) && empty($cmd)}
									<tr>
										<td colspan="5" class="list-empty">
											<div class="list-empty-msg">
												<i class="icon-warning-sign list-empty-icon"></i>
												{l s='There is no available document'}
											</div>
										</td>
									</tr>
								{/if}

								{if isset($invoice) && !empty($invoice)}
									<tr id="invoice_{$invoice_number}">
										<td>{dateFormat date=$invoice['dateadd']}</td>
										<td>{$soracaisse->lang('Cash register invoice')}</td>
										<td>
											<a target="_blank" class="finvoice fancybox.iframe" href="{$soracaisse_view_dir}&display_page=Document&invoice=1&iddoc={$invoice_number}&idticket={$document_number}&sctoken={$sctoken}">#FA-{$invoice_number}</a>
										</td>
										<td>{$invoice['p_ticket_r']}</td>
									</tr>
								{/if}

								{if isset($ticket) && !empty($ticket)}
									<tr id="ticket">
										<td>{dateFormat date=$ticket['date']}</td>
										<td>{$soracaisse->lang('Cash register receipt')}</td>
										<td>
											<a target="_blank" class="fticket fancybox.iframe" href="{$soracaisse_view_dir}&display_page=Ticket&idticket={$ticket['id_ticket']}&sctoken={$sctoken}">
											#TIC-{$ticket['id_ticket']}</a>
										</td>
										<td>{$ticket['p_ticket_r']}</td>
									</tr>
								{/if}

								{if isset($cmd) && !empty($cmd)}
									<tr id="invoice_{$cmd['id_cmd']}">
										<td>{dateFormat date=$cmd['dateadd']}</td>
										<td>{$soracaisse->lang('Cash register order')}</td>
										<td>
											<a target="_blank" class="finvoice fancybox.iframe" href="{$soracaisse_view_dir}&display_page=Document&order=1&iddoc={$cmd['id_cmd']}&sctoken={$sctoken}">#BC-{$cmd['id_cmd']}</a>
										</td>
										<td>{$cmd['total_cmd']}</td>
									</tr>

								{/if}

								{if isset($orderslip) && !empty($orderslip)}
									<tr id="orderslip_{$orderslip['avnumber']}">
										<td>{dateFormat date=$orderslip['dateadd']}</td>
										<td>{$soracaisse->lang('Cash register order slip')}</td>
										<td>
											<a target="_blank" class="finvoice fancybox.iframe" href="{$soracaisse_view_dir}&display_page=OrderSlip&idav={$orderslip['avnumber']}&sctoken={$sctoken}">#AV-{$orderslip['avnumber']}</a>
										</td>
										<td>{$orderslip['amount']}</td>
									</tr>

								{/if}
								</tbody>
							</table>
						</div>
					</div>
				</div>
				<script>
					$('#tabOrder a').click(function (e) {
						e.preventDefault()
						$(this).tab('show')
					})
				</script>
				<hr />
				<!-- Tab nav -->
				<ul class="nav nav-tabs" id="myTab">
					<li class="active">
						<a href="#shipping">
							<i class="icon-truck "></i>
							{l s='Shipping'} <span class="badge">{$order->getShipping()|@count}</span>
						</a>
					</li>
				</ul>
				<!-- Tab content -->
				<div class="tab-content panel">
					<!-- Tab shipping -->
					<div class="tab-pane active" id="shipping">
						<h4 class="visible-print">{l s='Shipping'} <span class="badge">({$order->getShipping()|@count})</span></h4>
						<!-- Shipping block -->
						
						<div class="form-horizontal">
							
							<div class="table-responsive">
								<table class="table" id="shipping_table">
									<thead>
										<tr>
											<th>
												<span class="title_box ">{l s='Date'}</span>
											</th>
											<th>
												<span class="title_box ">{l s='Type'}</span>
											</th>
											<th>
												<span class="title_box ">{l s='Carrier'}</span>
											</th>
										</tr>
									</thead>
									<tbody>
										<tr>
											<td>{dateFormat date=$order->date_add full=false}</td>
											<td>{$soracaisse->lang('retrait magasin')}</td>
											<td>Sora Caisse</td>
										</tr>
									</tbody>
								</table>
							</div>
							
							
						</div>
						
					</div>
					
				</div>
				<script>
					$('#myTab a').click(function (e) {
						e.preventDefault()
						$(this).tab('show')
					})
				</script>
			</div>
			<!-- Payments block -->
			<div id="formAddPaymentPanel" class="panel">
				<div class="panel-heading">
					<i class="icon-money"></i>
					{l s="Payment"}
				</div>

				<div class="table-responsive">
					<table class="table">
						<thead>
							<tr>
								<th><span class="title_box ">{l s='Date'}</span></th>
								<th><span class="title_box ">{l s='Payment method'}</span></th>
								<th><span class="title_box ">{l s='Amount'}</span></th>
							</tr>
						</thead>
						<tbody>
								
						{if $payments.cb1 != 0}
							<tr>
								<td>{dateFormat date=$payments.cbd1 full=true}</td>
								<td>{$soracaisse->lang('Credit card')} </td>
								<td>{displayPrice price=$payments.cb1}</td>
							</tr>
						{/if}		
						
						{if $payments.cb2 != 0}
							<tr>
								<td>{dateFormat date=$payments.cbd2 full=true}</td>
								<td>{$soracaisse->lang('Credit card')} </td>
								<td>{displayPrice price=$payments.cb2}</td>

							</tr>
						{/if}

						{if $payments.cb3 != 0}
							<tr>
								<td>{dateFormat date=$payments.cbd3 full=true}</td>
								<td>{$soracaisse->lang('Credit card')} </td>
								<td>{displayPrice price=$payments.cb3}</td>

							</tr>
						{/if}

						{if $payments.ch1 != 0}
							<tr>
								<td>{dateFormat date=$payments.chd1 full=true}</td>
								<td>{$soracaisse->lang('Cheque')} </td>
								<td>{displayPrice price=$payments.ch1}</td>
							</tr>
						{/if}		
						
						{if $payments.ch2 != 0}
							<tr>
								<td>{dateFormat date=$payments.chd2 full=true}</td>
								<td>{$soracaisse->lang('Cheque')} </td>
								<td>{displayPrice price=$payments.ch2}</td>

							</tr>
						{/if}

						{if $payments.ch3 != 0}
							<tr>
								<td>{dateFormat date=$payments.chd3 full=true}</td>
								<td>{$soracaisse->lang('Cheque')} </td>
								<td>{displayPrice price=$payments.ch3}</td>

							</tr>
						{/if}

						{if $payments.es1 != 0}
							<tr>
								<td>{dateFormat date=$payments.esd1 full=true}</td>
								<td>{$soracaisse->lang('Cash')} </td>
								<td>{displayPrice price=$payments.es1}</td>
							</tr>
						{/if}		
						
						{if $payments.es2 != 0}
							<tr>
								<td>{dateFormat date=$payments.esd2 full=true}</td>
								<td>{$soracaisse->lang('Cash')} </td>
								<td>{displayPrice price=$payments.es2}</td>

							</tr>
						{/if}

						{if $payments.es3 != 0}
							<tr>
								<td>{dateFormat date=$payments.esd3 full=true}</td>
								<td>{$soracaisse->lang('Cash')} </td>
								<td>{displayPrice price=$payments.es3}</td>

							</tr>
						{/if}

						{if $payments.kd1 != 0}
							<tr>
								<td>{dateFormat date=$payments.kdd1 full=true}</td>
								<td>{$soracaisse->lang('Gift voucher')} (KDO-{$payments.kdn1})</td>
								<td>{displayPrice price=$payments.kd1}</td>
							</tr>
						{/if}		
						
						{if $payments.kd2 != 0}
							<tr>
								<td>{dateFormat date=$payments.kdd2 full=true}</td>
								<td>{$soracaisse->lang('Gift voucher')} (KDO-{$payments.kdn2})</td>
								<td>{displayPrice price=$payments.kd2}</td>

							</tr>
						{/if}

						{if $payments.kd3 != 0}
							<tr>
								<td>{dateFormat date=$payments.kdd3 full=true}</td>
								<td>{$soracaisse->lang('Gift voucher')} (KDO-{$payments.kdn3})</td>
								<td>{displayPrice price=$payments.kd3}</td>

							</tr>
						{/if}

						{if $payments.av1 != 0}
							<tr>
								<td>{dateFormat date=$payments.avd1 full=true}</td>
								<td>{$soracaisse->lang('Voucher')} (AV-{$payments.avn1})</td>
								<td>{displayPrice price=$payments.av1}</td>
							</tr>
						{/if}		
						
						{if $payments.av2 != 0}
							<tr>
								<td>{dateFormat date=$payments.avd2 full=true}</td>
								<td>{$soracaisse->lang('Voucher')} (AV-{$payments.avn2})</td>
								<td>{displayPrice price=$payments.av2}</td>

							</tr>
						{/if}

						{if $payments.av3 != 0}
							<tr>
								<td>{dateFormat date=$payments.avd3 full=true}</td>
								<td>{$soracaisse->lang('Voucher')} (AV-{$payments.avn3})</td>
								<td>{displayPrice price=$payments.av3}</td>

							</tr>
						{/if}

						{if $payments.cr1 != 0}
							<tr>
								<td>{dateFormat date=$payments.crd1 full=true}</td>
								<td>{$soracaisse->lang('Credit')}</td>
								<td>{displayPrice price=$payments.cr1}</td>

							</tr>
						{/if}

						{if $payments.chr1 != 0}
							<tr>
								<td>{dateFormat date=$payments.chrd1 full=true}</td>
								<td>{$soracaisse->lang('Cheque restaurant')}</td>
								<td>{displayPrice price=$payments.chr1}</td>

							</tr>
						{/if}

						{if $payments.vir1 != 0}
							<tr>
								<td>{dateFormat date=$payments.vird1 full=true}</td>
								<td>{$soracaisse->lang('Bankwire')}</td>
								<td>{displayPrice price=$payments.vir1}</td>

							</tr>
						{/if}

						{if $document_type == 'bc'}
							<tr>
								<td></td>
								<td><b>{$soracaisse->lang('rest pay')}</b></td>
								<td><b>{displayPrice price=($order->total_paid_tax_incl - $total_payments)}</b></td>

							</tr>
						{/if}


						

								
						{if $payments.cb1 == 0 && $payments.cb2 == 0 && $payments.cb3 == 0 && $payments.ch1 == 0 && $payments.ch2 == 0 && $payments.ch3 == 0 && 
						$payments.es1 == 0 && $payments.es2 == 0 && $payments.es3 == 0 && $payments.kd1 == 0 && $payments.kd2 == 0 && $payments.kd3 == 0 && 
						$payments.av1 == 0 && $payments.av2 == 0 && $payments.av3 == 0 && $payments.cr1 == 0 && $payments.chr1 == 0 && $payments.vir1 == 0}

							<tr>
								<td class="list-empty hidden-print" colspan="3">
									<div class="list-empty-msg">
										<i class="icon-warning-sign list-empty-icon"></i>
										{l s='No payment methods are available'}
									</div>
								</td>
							</tr>

						{/if}
						</tbody>
					</table>
				</div>

			</div>
		</div>
		<div class="col-lg-5">
			<!-- Customer informations -->
			<div class="panel">
				{if $customer->id}
					<div class="panel-heading">
						<i class="icon-user"></i>
						{l s='Customer'}
						<span class="badge">
							<a href="?tab=AdminCustomers&amp;id_customer={$customer->id}&amp;viewcustomer&amp;token={getAdminToken tab='AdminCustomers'}">
								{if Configuration::get('PS_B2B_ENABLE')}{$customer->company} - {/if}
								{$gender->name|escape:'html':'UTF-8'}
								{$customer->firstname}
								{$customer->lastname}
							</a>
						</span>
						<span class="badge">
							{l s='#'}{$customer->id}
						</span>
					</div>
					<div class="row">
						<div class="col-xs-6">
							{if ($customer->isGuest())}
								{l s='This order has been placed by a guest.'}
								{if (!Customer::customerExists($customer->email))}
									<form method="post" action="index.php?tab=AdminCustomers&amp;id_customer={$customer->id}&amp;token={getAdminToken tab='AdminCustomers'}">
										<input type="hidden" name="id_lang" value="{$order->id_lang}" />
										<input class="btn btn-default" type="submit" name="submitGuestToCustomer" value="{l s='Transform a guest into a customer'}" />
										<p class="help-block">{l s='This feature will generate a random password and send an email to the customer.'}</p>
									</form>
								{else}
									<div class="alert alert-warning">
										{l s='A registered customer account has already claimed this email address'}
									</div>
								{/if}
							{else}
								<dl class="well list-detail">
									<dt>{l s='Email'}</dt>
										<dd><a href="mailto:{$customer->email}"><i class="icon-envelope-o"></i> {$customer->email}</a></dd>
									<dt>{l s='Account registered'}</dt>
										<dd class="text-muted"><i class="icon-calendar-o"></i> {dateFormat date=$customer->date_add full=true}</dd>
									<dt>{l s='Valid orders placed'}</dt>
										<dd><span class="badge">{$customerStats['nb_orders']|intval}</span></dd>
									<dt>{l s='Total spent since registration'}</dt>
										<dd><span class="badge badge-success">{displayPrice price=Tools::ps_round(Tools::convertPrice($customerStats['total_orders'], $currency), 2) currency=$currency->id}</span></dd>
									{if Configuration::get('PS_B2B_ENABLE')}
										<dt>{l s='Siret'}</dt>
											<dd>{$customer->siret}</dd>
										<dt>{l s='APE'}</dt>
											<dd>{$customer->ape}</dd>
									{/if}
								</dl>
							{/if}
						</div>

						<div class="col-xs-6">
							<div class="form-group hidden-print">
								<a href="?tab=AdminCustomers&amp;id_customer={$customer->id}&amp;viewcustomer&amp;token={getAdminToken tab='AdminCustomers'}" class="btn btn-default btn-block">{l s='View full details...'}</a>
							</div>
							<div class="panel panel-sm">
								<div class="panel-heading">
									<i class="icon-eye-slash"></i>
									{l s='Private note'}
								</div>
								<form id="customer_note" class="form-horizontal" action="ajax.php" method="post" onsubmit="saveCustomerNote({$customer->id});return false;" >
									<div class="form-group">
										<div class="col-lg-12">
											<textarea name="note" id="noteContent" class="textarea-autosize" onkeyup="$(this).val().length > 0 ? $('#submitCustomerNote').removeAttr('disabled') : $('#submitCustomerNote').attr('disabled', 'disabled')">{$customer->note}</textarea>
										</div>
									</div>
									<div class="row">
										<div class="col-lg-12">
											<button type="submit" id="submitCustomerNote" class="btn btn-default pull-right" disabled="disabled">
												<i class="icon-save"></i>
												{l s='Save'}
											</button>
										</div>
									</div>
									<span id="note_feedback"></span>
								</form>
							</div>
						</div>
					</div>
				{/if}
				<!-- Tab nav -->
				<div class="row">
					<ul class="nav nav-tabs" id="tabAddresses">
						<li class="active">
							<a href="#addressShipping">
								<i class="icon-truck"></i>
								{l s='Shipping address'}
							</a>
						</li>
						<li>
							<a href="#addressInvoice">
								<i class="icon-file-text"></i>
								{l s='Invoice address'}
							</a>
						</li>
					</ul>
					<!-- Tab content -->
					<div class="tab-content panel">
						<!-- Tab status -->
						<div class="tab-pane  in active" id="addressShipping">
							<!-- Addresses -->
							<h4 class="visible-print">{l s='Shipping address'}</h4>
							{if !$order->isVirtual()}
							<!-- Shipping address -->
								{if $can_edit}
									<form class="form-horizontal hidden-print" method="post" action="{$link->getAdminLink('AdminOrders')|escape:'html':'UTF-8'}&amp;vieworder&amp;id_order={$order->id|intval}">
										<div class="form-group">
											<div class="col-lg-9">
												<select name="id_address">
													{foreach from=$customer_addresses item=address}
													<option value="{$address['id_address']}"
														{if $address['id_address'] == $order->id_address_delivery}
															selected="selected"
														{/if}>
														{$address['alias']} -
														{$address['address1']}
														{$address['postcode']}
														{$address['city']}
														{if !empty($address['state'])}
															{$address['state']}
														{/if},
														{$address['country']}
													</option>
													{/foreach}
												</select>
											</div>
											<div class="col-lg-3">
												<button class="btn btn-default" type="submit" name="submitAddressShipping"><i class="icon-refresh"></i> {l s='Change'}</button>
											</div>
										</div>
									</form>
								{/if}
								<div class="well">
									<div class="row">
										<div class="col-sm-6">
											<a class="btn btn-default pull-right" href="?tab=AdminAddresses&amp;id_address={$addresses.delivery->id}&amp;addaddress&amp;realedit=1&amp;id_order={$order->id}{if ($addresses.delivery->id == $addresses.invoice->id)}&amp;address_type=1{/if}&amp;token={getAdminToken tab='AdminAddresses'}&amp;back={$smarty.server.REQUEST_URI|urlencode}">
												<i class="icon-pencil"></i>
												{l s='Edit'}
											</a>
											{displayAddressDetail address=$addresses.delivery newLine='<br />'}
											{if $addresses.delivery->other}
												<hr />{$addresses.delivery->other}<br />
											{/if}
										</div>
										<div class="col-sm-6 hidden-print">
											<div id="map-delivery-canvas" style="height: 190px"></div>
										</div>
									</div>
								</div>
							{/if}
						</div>
						<div class="tab-pane " id="addressInvoice">
							<!-- Invoice address -->
							<h4 class="visible-print">{l s='Invoice address'}</h4>
							{if $can_edit}
								<form class="form-horizontal hidden-print" method="post" action="{$link->getAdminLink('AdminOrders')|escape:'html':'UTF-8'}&amp;vieworder&amp;id_order={$order->id|intval}">
									<div class="form-group">
										<div class="col-lg-9">
											<select name="id_address">
												{foreach from=$customer_addresses item=address}
												<option value="{$address['id_address']}"
													{if $address['id_address'] == $order->id_address_invoice}
													selected="selected"
													{/if}>
													{$address['alias']} -
													{$address['address1']}
													{$address['postcode']}
													{$address['city']}
													{if !empty($address['state'])}
														{$address['state']}
													{/if},
													{$address['country']}
												</option>
												{/foreach}
											</select>
										</div>
										<div class="col-lg-3">
											<button class="btn btn-default" type="submit" name="submitAddressInvoice"><i class="icon-refresh"></i> {l s='Change'}</button>
										</div>
									</div>
								</form>
							{/if}
							<div class="well">
								<div class="row">
									<div class="col-sm-6">
										<a class="btn btn-default pull-right" href="?tab=AdminAddresses&amp;id_address={$addresses.invoice->id}&amp;addaddress&amp;realedit=1&amp;id_order={$order->id}{if ($addresses.delivery->id == $addresses.invoice->id)}&amp;address_type=2{/if}&amp;back={$smarty.server.REQUEST_URI|urlencode}&amp;token={getAdminToken tab='AdminAddresses'}">
											<i class="icon-pencil"></i>
											{l s='Edit'}
										</a>
										{displayAddressDetail address=$addresses.invoice newLine='<br />'}
										{if $addresses.invoice->other}
											<hr />{$addresses.invoice->other}<br />
										{/if}
									</div>
									<div class="col-sm-6 hidden-print">
										<div id="map-invoice-canvas" style="height: 190px"></div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<script>
					$('#tabAddresses a').click(function (e) {
						e.preventDefault()
						$(this).tab('show')
					})
				</script>
			</div>
			<div class="panel">
				<div class="panel-heading">
					<i class="icon-envelope"></i> {l s='Messages'} <span class="badge">{sizeof($customer_thread_message)}</span>
				</div>
				{if (sizeof($messages))}
					<div class="panel panel-highlighted">
						<div class="message-item">
							{foreach from=$messages item=message}
								<div class="message-avatar">
									<div class="avatar-md">
										<i class="icon-user icon-2x"></i>
									</div>
								</div>
								<div class="message-body">
									
									<span class="message-date">&nbsp;<i class="icon-calendar"></i>
										{dateFormat date=$message['date_add']} - 
									</span>
									<h4 class="message-item-heading">
										{if ($message['elastname']|escape:'html':'UTF-8')}{$message['efirstname']|escape:'html':'UTF-8'}
											{$message['elastname']|escape:'html':'UTF-8'}{else}{$message['cfirstname']|escape:'html':'UTF-8'} {$message['clastname']|escape:'html':'UTF-8'}
										{/if}
										{if ($message['private'] == 1)}
											<span class="badge badge-info">{l s='Private'}</span>
										{/if}
									</h4>
									<p class="message-item-text">
										{$message['message']|escape:'html':'UTF-8'|nl2br}
									</p>
								</div>
								{*if ($message['is_new_for_me'])}
									<a class="new_message" title="{l s='Mark this message as \'viewed\''}" href="{$smarty.server.REQUEST_URI}&amp;token={$smarty.get.token}&amp;messageReaded={$message['id_message']}">
										<i class="icon-ok"></i>
									</a>
								{/if*}
							{/foreach}
						</div>
					</div>
				{/if}
				<div id="messages" class="well hidden-print">
					<form action="{$smarty.server.REQUEST_URI|escape:'html':'UTF-8'}&amp;token={$smarty.get.token|escape:'html':'UTF-8'}" method="post" onsubmit="if (getE('visibility').checked == true) return confirm('{l s='Do you want to send this message to the customer?'}');">
						<div id="message" class="form-horizontal">
							<div class="form-group">
								<label class="control-label col-lg-3">{l s='Choose a standard message'}</label>
								<div class="col-lg-9">
									<select class="chosen form-control" name="order_message" id="order_message" onchange="orderOverwriteMessage(this, '{l s='Do you want to overwrite your existing message?'}')">
										<option value="0" selected="selected">-</option>
										{foreach from=$orderMessages item=orderMessage}
										<option value="{$orderMessage['message']|escape:'html':'UTF-8'}">{$orderMessage['name']}</option>
										{/foreach}
									</select>
									<p class="help-block">
										<a href="{$link->getAdminLink('AdminOrderMessage')|escape:'html':'UTF-8'}">
											{l s='Configure predefined messages'}
											<i class="icon-external-link"></i>
										</a>
									</p>
								</div>
							</div>

							<div class="form-group">
								<label class="control-label col-lg-3">{l s='Display to customer?'}</label>
								<div class="col-lg-9">
									<span class="switch prestashop-switch fixed-width-lg">
										<input type="radio" name="visibility" id="visibility_on" value="0" />
										<label for="visibility_on">
											{l s='Yes'}
										</label>
										<input type="radio" name="visibility" id="visibility_off" value="1" checked="checked" /> 
										<label for="visibility_off">
											{l s='No'}
										</label>
										<a class="slide-button btn"></a>
									</span>
								</div>
							</div>

							<div class="form-group">
								<label class="control-label col-lg-3">{l s='Message'}</label>
								<div class="col-lg-9">
									<textarea id="txt_msg" class="textarea-autosize" name="message">{Tools::getValue('message')|escape:'html':'UTF-8'}</textarea>
									<p id="nbchars"></p>
								</div>
							</div>


							<input type="hidden" name="id_order" value="{$order->id}" />
							<input type="hidden" name="id_customer" value="{$order->id_customer}" />
							<button type="submit" id="submitMessage" class="btn btn-primary pull-right" name="submitMessage">
								{l s='Send message'}
							</button>
							<a class="btn btn-default" href="{$link->getAdminLink('AdminCustomerThreads')|escape:'html':'UTF-8'}">
								{l s='Show all messages'}
								<i class="icon-external-link"></i>
							</a>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>

	<div class="row" id="start_products">
		<div class="col-lg-12">

				<div class="panel">
					<div class="panel-heading">
						<i class="icon-shopping-cart"></i>
						{l s='Products'} <span class="badge">{$products|@count}</span>
					</div>

					<div class="table-responsive">
						<table class="table" id="orderProducts">
							<thead>
								<tr>
									<th></th>
									<th><span class="title_box ">{l s='Product'}</span></th>
									<th>
										<span class="title_box ">{l s='Unit Price'}</span>
										<small class="text-muted">{$soracaisse->lang('Tax incl.')}</small>
									</th>
									<th class="text-center"><span class="title_box ">{l s='Qty'}</span></th>
									<th class="text-center"><span class="title_box ">{$soracaisse->lang('Reduction')}</span></th>
									{if $display_warehouse}<th><span class="title_box ">{l s='Warehouse'}</span></th>{/if}
									{if ($order->hasBeenPaid())}<th class="text-center"><span class="title_box ">{l s='Refunded'}</span></th>{/if}
									{if $stock_management}<th class="text-center"><span class="title_box ">{l s='Available quantity'}</span></th>{/if}
									<th>
										<span class="title_box ">{l s='Total'}</span>
										<small class="text-muted">{$soracaisse->lang('Tax incl.')}</small>
									</th>
								</tr>
							</thead>
							<tbody>
							{foreach from=$products item=product key=k}
								{assign var=product_price value=$product['unit_price_tax_incl']}

									<tr class="product-line-row">
										<td>{if isset($product.image) && $product.image->id}{$product.image_tag}{/if}</td>
										<td>
											<a href="{$link->getAdminLink('AdminProducts')|escape:'html':'UTF-8'}&amp;id_product={$product['product_id']|intval}&amp;updateproduct&amp;token={getAdminToken tab='AdminProducts'}">
												<span class="productName">{$product['product_name']}</span><br />
												{if $product.product_reference}{l s='Reference number:'} {$product.product_reference}<br />{/if}
												{if $product.product_supplier_reference}{l s='Supplier reference:'} {$product.product_supplier_reference}{/if}
											</a>
										</td>
										<td>
											<span class="product_price_show">{displayPrice price=$product_price currency=$currency->id}</span>
										</td>
										<td class="productQuantity text-center">
											<span class="product_quantity_show{if (int)$product['product_quantity'] > 1} badge{/if}">{$product['product_quantity']}</span>
										</td>
										<td class="text-center">
											{if $product['reduction_percent'] > 0}
												{$product['reduction_percent']}%
											{elseif $product['reduction_amount'] > 0}
												{displayPrice price=$product['reduction_amount'] currency=$currency->id}
											{/if}
										</td>
										{if $display_warehouse}
											<td>{$product.warehouse_name|escape:'html':'UTF-8'}</td>
										{/if}

										{if ($order->hasBeenPaid())}
											<td class="productQuantity text-center">
												{if !empty($product['product_quantity_refunded'])}
													{l s='%s (%s refund)' sprintf=[$product['product_quantity_refunded'], $product['amount_refund']]}
												{/if}
											</td>
										{/if}
										<!--{if $order->hasBeenDelivered() || $order->hasProductReturned()}
											<td class="productQuantity text-center">
												{$product['product_quantity_return']}
												{if count($product['return_history'])}
													<span class="tooltip">
														<span class="tooltip_label tooltip_button">+</span>
														<span class="tooltip_content">
														<span class="title">{l s='Return history'}</span>
														{foreach $product['return_history'] as $return}
															{l s='%1s - %2s - %3s' sprintf=[{dateFormat date=$return.date_add}, $return.product_quantity, $return.state]}<br />
														{/foreach}
														</span>
													</span>
												{/if}
											</td>
										{/if}-->
										{if $stock_management}<td class="productQuantity product_stock text-center">{$product['current_stock']}</td>{/if}
										<td class="total_product">
											{displayPrice price=$product['total_price_tax_incl'] currency=$currency->id}
										</td>

									</tr>


								
							{/foreach}
							
							</tbody>
						</table>
					</div>

					
					<div class="row">
						
						
							<div class="panel panel-total">
								<div class="table-responsive">
									<table class="table">
										{* Assign order price *}
										
											{assign var=order_product_price value=$order->total_products_wt}
											{assign var=order_product_price_tax_excl value=($order->total_products)}
											{assign var=order_discount_price value=$order->total_discounts_tax_incl}
											{assign var=order_wrapping_price value=$order->total_wrapping_tax_incl}
											{assign var=order_shipping_price value=$order->total_shipping_tax_incl}
										
										<tr id="total_discounts" {if $order->total_discounts_tax_incl == 0}style="display: none;"{/if}>
											<td class="text-right"  style="width: 92%;">{l s='Discounts'}</td>
											<td class="amount text-right">
												-{displayPrice price=$order_discount_price currency=$currency->id}
											</td>
										</tr>

										<tr id="total_products">
											<td class="text-right" style="width: 92%;">{$soracaisse->lang('Products tax excl.')}</td>
											<td class="amount text-right">
												{displayPrice price=$order_product_price_tax_excl currency=$currency->id}
											</td>
										</tr>
										
			 							<tr id="total_taxes">
			 								<td class="text-right" style="width: 92%;">{l s='Taxes'}</td>
			 								<td class="amount text-right" >{displayPrice price=($order->total_paid_tax_incl-$order->total_paid_tax_excl) currency=$currency->id}</td>
			 							</tr>
										<tr id="total_order">
											<td class="text-right" style="width: 92%;"><strong>{l s='Total tax incl.'}</strong></td>
											<td class="amount text-right">
												<strong>{displayPrice price=$order->total_paid_tax_incl currency=$currency->id}</strong>
											</td>
										</tr>
									</table>

									{if $return_mode == 1 && $document_type == 'tic'}
									<form class="form-horizontal well hidden-print" method="post" action="">
										<div class="row">
												
											<div class="col-lg-4">
												<button type="submit" name="submitRecallReturn" class="btn btn-primary">
													{$soracaisse->lang('Create return for')} {$document} {$soracaisse->lang('in Sora Caisse')}
												
												</button>
											</div>

										</div>
									</form>
									{/if}
								</div>
							</div>
						</div>
					</div>
				</div>

		</div>
	</div>

	<div class="row">
		<div class="col-lg-12">

			<!-- linked orders block -->
			{if count($order->getBrother()) > 0}
			<div class="panel">
				<div class="panel-heading">
					<i class="icon-cart"></i>
					{l s='Linked orders'}
				</div>
				<div class="table-responsive">
					<table class="table">
						<thead>
							<tr>
								<th>
									{l s='Order no. '}
								</th>
								<th>
									{l s='Status'}
								</th>
								<th>
									{l s='Amount'}
								</th>
								<th></th>
							</tr>
						</thead>
						<tbody>
							{foreach $order->getBrother() as $brother_order}
							<tr>
								<td>
									<a href="{$current_index}&amp;vieworder&amp;id_order={$brother_order->id}&amp;token={$smarty.get.token|escape:'html':'UTF-8'}">#{$brother_order->id}</a>
								</td>
								<td>
									{$brother_order->getCurrentOrderState()->name[$current_id_lang]}
								</td>
								<td>
									{displayPrice price=$brother_order->total_paid_tax_incl currency=$currency->id}
								</td>
								<td>
									<a href="{$current_index}&amp;vieworder&amp;id_order={$brother_order->id}&amp;token={$smarty.get.token|escape:'html':'UTF-8'}">
										<i class="icon-eye-open"></i>
										{l s='See the order'}
									</a>
								</td>
							</tr>
							{/foreach}
						</tbody>
					</table>
					
				</div>
			</div>
			{/if}
		</div>
	</div>

	<script type="text/javascript">
		var geocoder = new google.maps.Geocoder();
		var delivery_map, invoice_map;

		$(document).ready(function()
		{
			$(".textarea-autosize").autosize();

			geocoder.geocode({
				address: '{$addresses.delivery->address1},{$addresses.delivery->postcode},{$addresses.delivery->city}{if ($addresses.delivery->id_state)},{$addresses.deliveryState->name}{/if},{$addresses.delivery->country}'
				}, function(results, status) {
				if (status === google.maps.GeocoderStatus.OK)
				{
					delivery_map = new google.maps.Map(document.getElementById('map-delivery-canvas'), {
						zoom: 10,
						mapTypeId: google.maps.MapTypeId.ROADMAP,
						center: results[0].geometry.location
					});
					var delivery_marker = new google.maps.Marker({
						map: delivery_map,
						position: results[0].geometry.location,
						url: 'http://maps.google.com?q={$addresses.delivery->address1|urlencode},{$addresses.delivery->postcode|urlencode},{$addresses.delivery->city|urlencode}{if ($addresses.delivery->id_state)},{$addresses.deliveryState->name|urlencode}{/if},{$addresses.delivery->country|urlencode}'
					});
					google.maps.event.addListener(delivery_marker, 'click', function() {
						window.open(delivery_marker.url);
					});
				}
			});

			geocoder.geocode({
				address: '{$addresses.invoice->address1},{$addresses.invoice->postcode},{$addresses.invoice->city}{if ($addresses.invoice->id_state)},{$addresses.deliveryState->name}{/if},{$addresses.invoice->country}'
				}, function(results, status) {
				if (status === google.maps.GeocoderStatus.OK)
				{
					invoice_map = new google.maps.Map(document.getElementById('map-invoice-canvas'), {
						zoom: 10,
						mapTypeId: google.maps.MapTypeId.ROADMAP,
						center: results[0].geometry.location
					});
					invoice_marker = new google.maps.Marker({
						map: invoice_map,
						position: results[0].geometry.location,
						url: 'http://maps.google.com?q={$addresses.invoice->address1|urlencode},{$addresses.invoice->postcode|urlencode},{$addresses.invoice->city|urlencode}{if ($addresses.invoice->id_state)},{$addresses.deliveryState->name|urlencode}{/if},{$addresses.invoice->country|urlencode}'
					});
					google.maps.event.addListener(invoice_marker, 'click', function() {
						window.open(invoice_marker.url);
					});
				}
			});
			
			var date = new Date();
			var hours = date.getHours();
			if (hours < 10)
				hours = "0" + hours;
			var mins = date.getMinutes();
			if (mins < 10)
				mins = "0" + mins;
			var secs = date.getSeconds();
			if (secs < 10)
				secs = "0" + secs;

			$('.datepicker').datetimepicker({
				prevText: '',
				nextText: '',
				dateFormat: 'yy-mm-dd ' + hours + ':' + mins + ':' + secs
			});
		});

		// Fix wrong maps center when map is hidden
		$('#tabAddresses').click(function(){
			x = delivery_map.getZoom();
			c = delivery_map.getCenter();
			google.maps.event.trigger(delivery_map, 'resize');
			delivery_map.setZoom(x);
			delivery_map.setCenter(c);

			x = invoice_map.getZoom();
			c = invoice_map.getCenter();
			google.maps.event.trigger(invoice_map, 'resize');
			invoice_map.setZoom(x);
			invoice_map.setCenter(c);
		});
	</script>

{/block}
