{extends file="helpers/view/view.tpl"}

{block name="override_tpl"}
	<script type="text/javascript">
	var admin_order_tab_link = "{$link->getAdminLink('AdminOrders')|addslashes}";
	var id_order = {$order->id};
	var id_lang = {$current_id_lang};
	var id_currency = {$order->id_currency};
	var id_customer = {$order->id_customer|intval};
	{assign var=PS_TAX_ADDRESS_TYPE value=Configuration::get('PS_TAX_ADDRESS_TYPE')}
	var id_address = {$order->$PS_TAX_ADDRESS_TYPE};
	var currency_sign = "{$currency->sign}";
	var currency_format = "{$currency->format}";
	var currency_blank = "{$currency->blank}";
	var priceDisplayPrecision = 2;
	var use_taxes = {if $order->getTaxCalculationMethod() == $smarty.const.PS_TAX_INC}true{else}false{/if};
	var token = "{$smarty.get.token|escape:'htmlall':'UTF-8'}";
	var stock_management = {$stock_management|intval};

	var txt_add_product_stock_issue = "{l s='Are you sure you want to add this quantity?' js=1}";
	var txt_add_product_new_invoice = "{l s='Are you sure you want to create a new invoice?' js=1}";
	var txt_add_product_no_product = "{l s='Error: No product has been selected' js=1}";
	var txt_add_product_no_product_quantity = "{l s='Error: Quantity of products must be set' js=1}";
	var txt_add_product_no_product_price = "{l s='Error: Product price must be set' js=1}";
	var txt_confirm = "{l s='Are you sure?' js=1}";

	var statesShipped = new Array();
	{foreach from=$states item=state}
		{if (!$currentState->shipped && $state['shipped'])}
			statesShipped.push({$state['id_order_state']});
		{/if}
	{/foreach}
	</script>

	{assign var="hook_invoice" value={hook h="displayInvoice" id_order=$order->id}}
	{if ($hook_invoice)}
	<div style="float: right; margin: -40px 40px 10px 0;">{$hook_invoice}</div><br class="clear" />
	{/if}

<div class="toolbar-placeholder" id="order_toolbar">
	<div class="toolbarBox toolbarHead">
		
			<ul class="cc_button">
								
				<li>
					<a title="Retour à la liste" href="{$link->getAdminLink('AdminOrders')|escape:'htmlall':'UTF-8'}" class="toolbar_btn" id="desc-order-back">
						<span class="process-icon-back"></span>
						<div>{l s='Back to list'}</div>
					</a>
				</li>
			</ul>
		
		<div class="pageTitle">
			<h3>
				<span style="font-weight: normal;">												
					<span class="breadcrumb item-0 ">{$order_head}</span>
				</span>
				
			</h3>
		</div>
	</div>
</div>

<div class="bloc-command">
	<div class="button-command">
			{if $document_type == 'bc'}
			
				<a class="button finvoice fancybox.iframe" href="{$soracaisse_view_dir}&display_page=Document&order=1&iddoc={$document_number}&sctoken={$sctoken}">
					<img src="../img/admin/charged_ok.gif" alt="{l s='View invoice'}" />
					{$soracaisse->lang('View / Print order')}
				</a>
				
			{elseif $document_type == 'tic'}

				<a class="button fticket fancybox.iframe" href="{$soracaisse_view_dir}&display_page=Ticket&idticket={$document_number}&sctoken={$sctoken}">
					<img src="../img/admin/charged_ok.gif" alt="{l s='View invoice'}" />
					{$soracaisse->lang('View / Print receipt')}
				</a>
				&nbsp;
				{if isset($invoice_number) && !empty($invoice_number)}
					<a class="button finvoice fancybox.iframe" href="{$soracaisse_view_dir}&display_page=Document&invoice=1&iddoc={$invoice_number}&idticket={$document_number}&sctoken={$sctoken}">
						<img src="../img/admin/charged_ok.gif" alt="{l s='View invoice'}" />
						{$soracaisse->lang('View / Print invoice')}
					</a>
				{else}
					<img src="../img/admin/charged_ko.gif" alt="{l s='No invoice'}" /> {l s='No invoice'}
				{/if}
			{else}
			<!-- TODO -->
			{/if}
		</div>
		<div class="metadata-command">
			<dl>
				<dt>{l s='Date'} </dt>
				<dd>{dateFormat date=$order->date_add full=true}</dd>
			|</dl>
			<dl>
				<dt>{l s='Messages:'}</dt>
				<dd>{sizeof($messages)}</dd>
			|</dl>
			<dl>
				<dt><a href="{$link->getAdminLink('AdminCustomerThreads')|escape:'htmlall':'UTF-8'}">{l s='New Customer Messages:'}</a></dt>
				<dd><a href="{$link->getAdminLink('AdminCustomerThreads')|escape:'htmlall':'UTF-8'}">{sizeof($customer_thread_message)}</a></dd>
			|</dl>
			<dl>
				<dt>{l s='Products:'}</dt>
				<dd id="product_number">{sizeof($products)}</dd>
			|</dl>
			<dl>
				<dt>{l s='Total'}</dt>
				<dd class="total_paid">{displayPrice price=$order->total_paid_tax_incl currency=$currency->id}</dd>
			</dl>
		<div class="clear"></div>
	</div>
</div>
	<div class="container-command">
		<!-- Left column -->
		<div style="width: 49%; float:left;">
			<!-- Change status form -->
			{if $order_type == 0}
				<form action="" method="post">
					<div style="float: left; margin-bottom: 11px; width: 50%;">
						<button type="submit" name="submitRecall" class="button">
							{$soracaisse->lang('Recall')} {$document} {$soracaisse->lang('in Sora Caisse')}
						
						</button>
					</div>

					{if $return_mode == 1 && $document_type == 'tic'}
						<div style="float: left; margin-bottom: 11px; width: 50%;">
							<button style="float:right;" type="submit" name="submitRecallReturn" class="button">
								{$soracaisse->lang('Create return for')} {$document} {$soracaisse->lang('in Sora Caisse')}
							
							</button>
						</div>
					{/if}

				</form>
			{else}
				<form action="{$currentIndex}&vieworder&token={$smarty.get.token}" method="post">
					<select id="id_order_state" name="id_order_state">
					{foreach from=$states item=state}
						<option value="{$state['id_order_state']}"{if $state['id_order_state'] == $currentState->id} selected="selected" disabled="disabled"{/if}>{$state['name']|stripslashes}</option>
					{/foreach}
					</select>
					<input type="hidden" name="id_order" value="{$order->id}" />
					<input type="submit" name="submitState" value="{l s='Add'}" class="button" />
				</form>
			{/if}

			<br />

			<!-- History of status -->
			<table cellspacing="0" cellpadding="0" class="table history-status" style="width: 100%;">
				<colgroup>
					<col width="1%"/>
					<col width=""/>
					<col width="20%"/>
					<col width="20%"/>
				</colgroup>
			{foreach from=$history item=row key=key}
				{if ($key == 0)}
				<tr>
					<th><img src="../img/os/{$row['id_order_state']}.gif" /></th>
					<th>{$row['ostate_name']|stripslashes}</th>
					<th>{if $row['employee_lastname']}{$row['employee_firstname']|stripslashes} {$row['employee_lastname']|stripslashes}{/if}</th>
					<th>{dateFormat date=$row['date_add'] full=true}</th>
				</tr>
				{else}
				<tr class="{if ($key % 2)}alt_row{/if}">
					<td><img src="../img/os/{$row['id_order_state']}.gif" /></td>
					<td>{$row['ostate_name']|stripslashes}</td>
					<td>{if $row['employee_lastname']}{$row['employee_firstname']|stripslashes} {$row['employee_lastname']|stripslashes}{else}&nbsp;{/if}</td>
					<td>{dateFormat date=$row['date_add'] full=true}</td>
				</tr>
				{/if}
			{/foreach}
			</table>

			{if $customer->id}
			<!-- Customer informations -->
			<br />
			<fieldset>
				<legend><img src="../img/admin/tab-customers.gif" /> {l s='Customer information'}</legend>
				<span style="font-weight: bold; font-size: 14px;"><a href="?tab=AdminCustomers&id_customer={$customer->id}&viewcustomer&token={getAdminToken tab='AdminCustomers'}"> {$gender->name|escape:'htmlall':'UTF-8'} {$customer->firstname} {$customer->lastname}</a></span> ({l s='#'}{$customer->id})<br />
				(<a href="mailto:{$customer->email}">{$customer->email}</a>)<br /><br />
				{if ($customer->isGuest())}
					{l s='This order has been placed by a guest.'}
					{if (!Customer::customerExists($customer->email))}
					<form method="post" action="index.php?tab=AdminCustomers&id_customer={$customer->id}&token={getAdminToken tab='AdminCustomers'}">
						<input type="hidden" name="id_lang" value="{$order->id_lang}" />
						<p class="center"><input class="button" type="submit" name="submitGuestToCustomer" value="{l s='Transform a guest into a customer'}" /></p>
						{l s='This feature will generate a random password and send an email to the customer.'}
					</form>
					{else}
						<div><b style="color:red;">{l s='A registered customer account has already claimed this email address'}</b></div>
					{/if}
				{else}
					{l s='Account registered:'} <b>{dateFormat date=$customer->date_add full=true}</b><br />
					{l s='Valid orders placed:'} <b>{$customerStats['nb_orders']}</b><br />
					{l s='Total spent since registration:'} <b>{displayPrice price=Tools::ps_round(Tools::convertPrice($customerStats['total_orders'], $currency), 2) currency=$currency->id}</b><br />
				{/if}
			{/if}
			</fieldset>

			<!-- Sources block -->
			{if (sizeof($sources))}
			<br />
			<fieldset>
				<legend><img src="../img/admin/tab-stats.gif" /> {l s='Sources'}</legend>
				<ul {if sizeof($sources) > 3}style="height: 200px; overflow-y: scroll;"{/if}>
				{foreach from=$sources item=source}
					<li>
						{dateFormat date=$source['date_add'] full=true}<br />
						<b>{l s='From'}</b>{if $source['http_referer'] != ''}<a href="{$source['http_referer']}">{parse_url($source['http_referer'], $smarty.const.PHP_URL_HOST)|regex_replace:'/^www./':''}</a>{else}-{/if}<br />
						<b>{l s='To'}</b> <a href="http://{$source['request_uri']}">{$source['request_uri']|truncate:100:'...'}</a><br />
						{if $source['keywords']}<b>{l s='Keywords'}</b> {$source['keywords']}<br />{/if}<br />
					</li>
				{/foreach}
				</ul>
			</fieldset>
			{/if}

			<!-- Admin order hook -->
			{hook h="displayAdminOrder" id_order=$order->id}
		</div>
		<!-- END Left column -->

		<!-- Right column -->
		<div style="width: 49%; float:right;">
			<div class="button-command-prev-next">
				<b>{l s='Orders'}</b> :
				{if $previousOrder}<a class="button" href="{$link->getAdminLink('AdminOrders')|escape:'htmlall':'UTF-8'}&vieworder&id_order={$previousOrder}">{l s='< Prev'}</a>{/if}
				{if $nextOrder}<a class="button" href="{$link->getAdminLink('AdminOrders')|escape:'htmlall':'UTF-8'}&vieworder&id_order={$nextOrder}">{l s='Next >'}</a>{/if}
			</div>
			<div class="clear"></div>
			
			<!-- linked orders block -->
			{if count($order->getBrother()) > 0}
				<fieldset>
					<legend><img src="../img/admin/tab-orders.gif" /> {l s='Linked orders'}</legend>
					<table class="table" width="100%;" cellspacing="0" cellpadding="0">
						<thead>
							<tr>
								<th width="10%">
									{l s='Order no. '}
								</th>
								<th>
									{l s='Status'}
								</th>
								<th width="10%">
									{l s='Amount'}
								</th>
								<th width="5%">
								</th>
							</tr>
						</thead>
						<tbody>
							{foreach $order->getBrother() as $brother_order}
								<tr>
									<td>
										<a href="{$current_index}&vieworder&id_order={$brother_order->id}&token={$smarty.get.token|escape:'htmlall':'UTF-8'}">#{'%06d'|sprintf:$brother_order->id}</a>
									</td>
									<td>
										{$brother_order->getCurrentOrderState()->name[$current_id_lang]}
									</td>
									<td>
										{displayPrice price=$brother_order->total_paid_tax_incl currency=$currency->id}
									</td>
									<td>
										<a href="{$current_index}&vieworder&id_order={$brother_order->id}&token={$smarty.get.token|escape:'htmlall':'UTF-8'}"><img alt="{l s='See the order'}" src="../img/admin/details.gif"></a>
									</td>
								</tr>
							{/foreach}
						</tbody>
					</table>
				</fieldset>
				<br />
			{/if}
			
			<!-- Documents block -->
			<fieldset>
				<legend><img src="../img/admin/details.gif" /> {l s='Documents'}</legend>

				<table class="table" width="100%;" cellspacing="0" cellpadding="0" id="documents_table">
					<thead>
					<tr>
						<th style="width:10%">{l s='Date'}</th>
						<th style="">{l s='Document'}</th>
						<th style="width:20%">{l s='Number'}</th>
						<th style="width:10%">{l s='Amount'}</th>
						<th style="width:1%"></th>
					</tr>
					</thead>
					<tbody>

					{if empty($invoice) && empty($ticket) && empty($cmd)}
						<tr>
							<td colspan="5" class="list-empty">
								<div class="list-empty-msg">
									<i class="icon-warning-sign list-empty-icon"></i>
									{l s='There is no available document'}
								</div>
							</td>
						</tr>
					{/if}

					{if isset($invoice) && !empty($invoice)}
						<tr id="invoice_{$invoice_number}">
							<td>{dateFormat date=$invoice['dateadd']}</td>
							<td>{$soracaisse->lang('Cash register invoice')}</td>
							<td>
								<a target="_blank" class="finvoice fancybox.iframe" href="{$soracaisse_view_dir}&display_page=Document&invoice=1&iddoc={$invoice_number}&idticket={$document_number}&sctoken={$sctoken}">#FA-{$invoice_number}</a>
							</td>
							<td>{$invoice['p_ticket_r']}</td>
						</tr>
					{/if}

					{if isset($ticket) && !empty($ticket)}
						<tr id="ticket">
							<td>{dateFormat date=$ticket['date']}</td>
							<td>{$soracaisse->lang('Cash register receipt')}</td>
							<td>
								<a target="_blank" class="fticket fancybox.iframe" href="{$soracaisse_view_dir}&display_page=Ticket&idticket={$ticket['id_ticket']}&sctoken={$sctoken}">
								#TIC-{$ticket['id_ticket']}</a>
							</td>
							<td>{$ticket['p_ticket_r']}</td>
						</tr>
					{/if}

					{if isset($cmd) && !empty($cmd)}
						<tr id="invoice_{$cmd['id_cmd']}">
							<td>{dateFormat date=$cmd['dateadd']}</td>
							<td>{$soracaisse->lang('Cash register order')}</td>
							<td>
								<a target="_blank" class="finvoice fancybox.iframe" href="{$soracaisse_view_dir}&display_page=Document&order=1&iddoc={$cmd['id_cmd']}&sctoken={$sctoken}">#BC-{$cmd['id_cmd']}</a>
							</td>
							<td>{$cmd['total_cmd']}</td>
						</tr>

					{/if}

					{if isset($orderslip) && !empty($orderslip)}
						<tr id="orderslip_{$orderslip['avnumber']}">
							<td>{dateFormat date=$orderslip['dateadd']}</td>
							<td>{$soracaisse->lang('Cash register order slip')}</td>
							<td>
								<a target="_blank" class="finvoice fancybox.iframe" href="{$soracaisse_view_dir}&display_page=OrderSlip&idav={$orderslip['avnumber']}&sctoken={$sctoken}">#AV-{$orderslip['avnumber']}</a>
							</td>
							<td>{$orderslip['amount']}</td>
						</tr>

					{/if}
					</tbody>
				</table>

			</fieldset>
			<br />

			<!-- Payments block -->
			<fieldset>
				<legend><img src="../img/admin/money.gif" /> {l s='Payment: '}</legend>

					<table class="table" width="100%" cellspacing="0" cellpadding="0">
						<colgroup>
							<col width="15%"/>
							<col width=""/>
							<col width="10%"/>
							<col width="1%"/>
						</colgroup>
						<thead>
							<tr>
								<th>{l s='Date'}</th>
								<th>{l s='Payment method'}</th>
								<th>{l s='Amount'}</th>
								<th>&nbsp;</th>
							</tr>
						</thead>
						<tbody>
								
						{if $payments.cb1 != 0}
							<tr>
								<td>{dateFormat date=$payments.cbd1 full=true}</td>
								<td>{$soracaisse->lang('Credit card')} </td>
								<td>{displayPrice price=$payments.cb1}</td>
							</tr>
						{/if}		
						
						{if $payments.cb2 != 0}
							<tr>
								<td>{dateFormat date=$payments.cbd2 full=true}</td>
								<td>{$soracaisse->lang('Credit card')} </td>
								<td>{displayPrice price=$payments.cb2}</td>

							</tr>
						{/if}

						{if $payments.cb3 != 0}
							<tr>
								<td>{dateFormat date=$payments.cbd3 full=true}</td>
								<td>{$soracaisse->lang('Credit card')} </td>
								<td>{displayPrice price=$payments.cb3}</td>

							</tr>
						{/if}

						{if $payments.ch1 != 0}
							<tr>
								<td>{dateFormat date=$payments.chd1 full=true}</td>
								<td>{$soracaisse->lang('Cheque')} </td>
								<td>{displayPrice price=$payments.ch1}</td>
							</tr>
						{/if}		
						
						{if $payments.ch2 != 0}
							<tr>
								<td>{dateFormat date=$payments.chd2 full=true}</td>
								<td>{$soracaisse->lang('Cheque')} </td>
								<td>{displayPrice price=$payments.ch2}</td>

							</tr>
						{/if}

						{if $payments.ch3 != 0}
							<tr>
								<td>{dateFormat date=$payments.chd3 full=true}</td>
								<td>{$soracaisse->lang('Cheque')} </td>
								<td>{displayPrice price=$payments.ch3}</td>

							</tr>
						{/if}

						{if $payments.es1 != 0}
							<tr>
								<td>{dateFormat date=$payments.esd1 full=true}</td>
								<td>{$soracaisse->lang('Cash')} </td>
								<td>{displayPrice price=$payments.es1}</td>
							</tr>
						{/if}		
						
						{if $payments.es2 != 0}
							<tr>
								<td>{dateFormat date=$payments.esd2 full=true}</td>
								<td>{$soracaisse->lang('Cash')} </td>
								<td>{displayPrice price=$payments.es2}</td>

							</tr>
						{/if}

						{if $payments.es3 != 0}
							<tr>
								<td>{dateFormat date=$payments.esd3 full=true}</td>
								<td>{$soracaisse->lang('Cash')} </td>
								<td>{displayPrice price=$payments.es3}</td>

							</tr>
						{/if}

						{if $payments.kd1 != 0}
							<tr>
								<td>{dateFormat date=$payments.kdd1 full=true}</td>
								<td>{$soracaisse->lang('Gift voucher')} (KDO-{$payments.kdn1})</td>
								<td>{displayPrice price=$payments.kd1}</td>
							</tr>
						{/if}		
						
						{if $payments.kd2 != 0}
							<tr>
								<td>{dateFormat date=$payments.kdd2 full=true}</td>
								<td>{$soracaisse->lang('Gift voucher')} (KDO-{$payments.kdn2})</td>
								<td>{displayPrice price=$payments.kd2}</td>

							</tr>
						{/if}

						{if $payments.kd3 != 0}
							<tr>
								<td>{dateFormat date=$payments.kdd3 full=true}</td>
								<td>{$soracaisse->lang('Gift voucher')} (KDO-{$payments.kdn3})</td>
								<td>{displayPrice price=$payments.kd3}</td>

							</tr>
						{/if}

						{if $payments.av1 != 0}
							<tr>
								<td>{dateFormat date=$payments.avd1 full=true}</td>
								<td>{$soracaisse->lang('Voucher')} (AV-{$payments.avn1})</td>
								<td>{displayPrice price=$payments.av1}</td>
							</tr>
						{/if}		
						
						{if $payments.av2 != 0}
							<tr>
								<td>{dateFormat date=$payments.avd2 full=true}</td>
								<td>{$soracaisse->lang('Voucher')} (AV-{$payments.avn2})</td>
								<td>{displayPrice price=$payments.av2}</td>

							</tr>
						{/if}

						{if $payments.av3 != 0}
							<tr>
								<td>{dateFormat date=$payments.avd3 full=true}</td>
								<td>{$soracaisse->lang('Voucher')} (AV-{$payments.avn3})</td>
								<td>{displayPrice price=$payments.av3}</td>

							</tr>
						{/if}

						{if $payments.cr1 != 0}
							<tr>
								<td>{dateFormat date=$payments.crd1 full=true}</td>
								<td>{$soracaisse->lang('Credit')}</td>
								<td>{displayPrice price=$payments.cr1}</td>

							</tr>
						{/if}

						{if $payments.chr1 != 0}
							<tr>
								<td>{dateFormat date=$payments.chrd1 full=true}</td>
								<td>{$soracaisse->lang('Cheque restaurant')}</td>
								<td>{displayPrice price=$payments.chr1}</td>

							</tr>
						{/if}

						{if $payments.vir1 != 0}
							<tr>
								<td>{dateFormat date=$payments.vird1 full=true}</td>
								<td>{$soracaisse->lang('Bankwire')}</td>
								<td>{displayPrice price=$payments.vir1}</td>

							</tr>
						{/if}

						{if $document_type == 'bc'}
							<tr>
								<td></td>
								<td><b>{$soracaisse->lang('rest pay')}</b></td>
								<td><b>{displayPrice price=($order->total_paid_tax_incl - $total_payments)}</b></td>

							</tr>
						{/if}
	
						{if $payments.cb1 == 0 && $payments.cb2 == 0 && $payments.cb3 == 0 && $payments.ch1 == 0 && $payments.ch2 == 0 && $payments.ch3 == 0 && 
						$payments.es1 == 0 && $payments.es2 == 0 && $payments.es3 == 0 && $payments.kd1 == 0 && $payments.kd2 == 0 && $payments.kd3 == 0 && 
						$payments.av1 == 0 && $payments.av2 == 0 && $payments.av3 == 0 && $payments.cr1 == 0 && $payments.chr1 == 0 && $payments.vir1 == 0}

							<tr>
								<td colspan="6" class="center">
									<h3>{l s='No payments are available'}</h3>
								</td>
							</tr>

						{/if}
						</tbody>
					
					</table>
				</form>
			</fieldset>
			<br />

			<!-- Shipping block -->
			{if !$order->isVirtual()}
				<fieldset>
					<legend><img src="../img/admin/delivery.gif" /> {l s='Shipping'}</legend>

					<div class="clear" style="float: left; margin-right: 10px;">
						<span>{l s='Recycled packaging'}</span>
						{if $order->recyclable}
						<img src="../img/admin/enabled.gif" />
						{else}
						<img src="../img/admin/disabled.gif" />
						{/if}
					</div>
					<div style="float: left;">
						<span>{l s='Gift wrapping'}</span>
						{if $order->gift}
						<img src="../img/admin/enabled.gif" />
						</div>
						<div style="clear: left; margin: 0px 42px 0px 42px; padding-top: 2px;">
							{if $order->gift_message}
							<div style="border: 1px dashed #999; padding: 5px; margin-top: 8px;"><b>{l s='Message'}</b><br />{$order->gift_message|nl2br}</div>
							{/if}
						{else}
						<img src="../img/admin/disabled.gif" />
						{/if}
					</div>
					<div class="clear" style="margin-bottom: 10px;"></div>

					<table class="table" width="100%" cellspacing="0" cellpadding="0" id="shipping_table">
					<colgroup>
						<col width="15%"/>
						<col width=""/>
						<col width="20%"/>
					</colgroup>
						<thead>
						<tr>
							<th>{l s='Date'}</th>
							<th>{l s='Type'}</th>
							<th>{l s='Carrier'}</th>
						</tr>
						</thead>
						<tbody>
						<tr>
							<td>{dateFormat date=$order->date_add full=false}</td>
							<td>{$soracaisse->lang('retrait magasin')}</td>
							<td>Sora Caisse</td>
						</tr>
						</tbody>
					</table>

					{if $carrierModuleCall}
						{$carrierModuleCall}
					{/if}
				</fieldset>
				<br />

			{/if}
		</div>
		<!-- END Right column -->
		<div class="clear" style="margin-bottom: 10px;"></div>
	</div>
<!-- Checkpoint -->
	<div class="container-command container-command-top-spacing">
		<!-- Addresses -->
		{if !$order->isVirtual()}
			<div style="width: 49%; float:left;">
				<!-- Shipping address -->
				<fieldset>
					<legend><img src="../img/admin/delivery.gif" alt="{l s='Shipping address'}" />{l s='Shipping address'}</legend>

					<div style="float: right">
						<a href="http://maps.google.com/maps?f=q&hl={$iso_code_lang}&geocode=&q={$addresses.delivery->address1} {$addresses.delivery->postcode} {$addresses.delivery->city} {if ($addresses.delivery->id_state)} {$addresses.deliveryState->name}{/if}" target="_blank"><img src="../img/admin/google.gif" alt="" class="middle" /></a>
					</div>

					{displayAddressDetail address=$addresses.delivery newLine='<br />'}
					{if $addresses.delivery->other}<hr />{$addresses.delivery->other}<br />{/if}
				</fieldset>
			</div>
		{/if}
		<div style="width: 49%; float:right;">
			<!-- Invoice address -->
			<fieldset>
				<legend><img src="../img/admin/invoice.gif" alt="{l s='Invoice address'}" />{l s='Invoice address'}</legend>

				<div style="float: right">
				
				</div>

				{displayAddressDetail address=$addresses.invoice newLine='<br />'}
				{if $addresses.invoice->other}<hr />{$addresses.invoice->other}<br />{/if}
			</fieldset>
		</div>
		<div class="clear" style="margin-bottom: 10px;"></div>
	</div>

	<form style="width: 98%" class="container-command-top-spacing" action="{$current_index}&vieworder&token={$smarty.get.token}&id_order={$order->id}" method="post" onsubmit="return orderDeleteProduct('{l s='This product cannot be returned.'}', '{l s='Quantity to cancel is greater than quantity available.'}');">
		<input type="hidden" name="id_order" value="{$order->id}" />
		<fieldset style="width: 100%; ">
			<div style="display: none">
				<input type="hidden" value="{$order->getWarehouseList()|implode}" id="warehouse_list" />
			</div>
			<legend><img src="../img/admin/cart.gif" alt="{l s='Products:'}" />{l s='Products:'}</legend>
			<div style="float:left;width: 100%;">

				<table style="width: 100%;" cellspacing="0" cellpadding="0" class="table" id="orderProducts">
					<tr>
						<th height="39" align="center" style="width: 7%">&nbsp;</th>
						<th>{l s='Product'}</th>
						<th style="width: 15%; text-align: center">
							{l s='Unit Price'}
							<small class="text-muted">{$soracaisse->lang('Tax incl.')}</small>
						</th>
						<th style="width: 4%; text-align: center">{l s='Qty'}</th>
						<th style="width: 15%; text-align: center">{$soracaisse->lang('Reduction')}</th>
						{if $display_warehouse}<th style="text-align: center">{l s='Warehouse'}</th>{/if}
						{if ($order->hasBeenPaid())}<th style="width: 3%; text-align: center">{l s='Refunded'}</th>{/if}
						{if $stock_management}<th style="width: 10%; text-align: center">{l s='Available quantity'}</th>{/if}
						<th style="width: 10%; text-align: center">
							{l s='Total'}
							<small class="text-muted">{$soracaisse->lang('Tax incl.')}</small>
						</th>
					</tr>
			
					{foreach from=$products item=product key=k}
						{assign var=product_price value=$product['unit_price_tax_incl']}

						<tr class="product-line-row">
							<td style="text-align: center">{if isset($product.image) && $product.image->id}{$product.image_tag}{/if}</td>
							<td style="text-align: center">
								<a href="{$link->getAdminLink('AdminProducts')|escape:'html':'UTF-8'}&amp;id_product={$product['product_id']|intval}&amp;updateproduct&amp;token={getAdminToken tab='AdminProducts'}">
									<span class="productName">{$product['product_name']}</span><br />
									{if $product.product_reference}{l s='Reference number:'} {$product.product_reference}<br />{/if}
									{if $product.product_supplier_reference}{l s='Supplier reference:'} {$product.product_supplier_reference}{/if}
								</a>
							</td>
							<td style="text-align: center">
								<span class="product_price_show">{displayPrice price=$product_price currency=$currency->id}</span>
							</td>
							<td style="text-align: center">
								<span class="product_quantity_show{if (int)$product['product_quantity'] > 1} badge{/if}">{$product['product_quantity']}</span>
							</td>
							<td style="text-align: center">
								{if $product['reduction_percent'] > 0}
									{$product['reduction_percent']}%
								{elseif $product['reduction_amount'] > 0}
									{displayPrice price=$product['reduction_amount'] currency=$currency->id}
								{/if}
							</td>
							{if $display_warehouse}
								<td style="text-align: center">{$product.warehouse_name|escape:'html':'UTF-8'}</td>
							{/if}

							{if ($order->hasBeenPaid())}
								<td style="text-align: center">
									{if !empty($product['product_quantity_refunded'])}
										{l s='%s (%s refund)' sprintf=[$product['product_quantity_refunded'], $product['amount_refund']]}
									{/if}
								</td>
							{/if}
	
							{if $stock_management}<td style="text-align: center">{$product['current_stock']}</td>{/if}
							<td style="text-align: center">
								{displayPrice price=$product['total_price_tax_incl'] currency=$currency->id}
							</td>

						</tr>
								
					{/foreach}
				</table>

				<div style="float:right; margin-top: 20px;">
					{* Assign order price *}
										
					{assign var=order_product_price value=$order->total_products_wt}
					{assign var=order_product_price_tax_excl value=($order->total_products)}
					{assign var=order_discount_price value=$order->total_discounts_tax_incl}
					{assign var=order_wrapping_price value=$order->total_wrapping_tax_incl}
					{assign var=order_shipping_price value=$order->total_shipping_tax_incl}
					<table class="table" width="450px;" style="border-radius:0px;"cellspacing="0" cellpadding="0">

						<tr id="total_discounts" {if $order->total_discounts_tax_incl == 0}style="display: none;"{/if}>
							<td class="text-right">{l s='Discounts'}</td>
							<td class="amount" align="right">
								-{displayPrice price=$order_discount_price currency=$currency->id}
							</td>
						</tr>

						<tr id="total_products">
							<td class="text-right">{$soracaisse->lang('Products tax excl.')}</td>
							<td class="amount" align="right">
								{displayPrice price=$order_product_price_tax_excl currency=$currency->id}
							</td>
						</tr>
						
							<tr id="total_taxes">
								<td class="text-right">{l s='Taxes'}</td>
								<td class="amount" align="right">{displayPrice price=($order->total_paid_tax_incl-$order->total_paid_tax_excl) currency=$currency->id}</td>
							</tr>
						<tr id="total_order">
							<td class="text-right"><strong>{l s='Total tax incl.'}</strong></td>
							<td class="amount" align="right">
								<strong>{displayPrice price=$order->total_paid_tax_incl currency=$currency->id}</strong>
							</td>
						</tr>
					</table>
				</div>
		</fieldset>
	</form>
	<div class="clear" style="height:20px;">&nbsp;</div>

	<div style="float: left">
		<form action="{$smarty.server.REQUEST_URI}&token={$smarty.get.token}" method="post" onsubmit="if (getE('visibility').checked == true) return confirm('{l s='Do you want to send this message to the customer?'}');">
		<fieldset style="width: 400px;">
			<legend style="cursor: pointer;" onclick="$('#message').slideToggle();$('#message_m').slideToggle();return false"><img src="../img/admin/email_edit.gif" /> {l s='New message'}</legend>
			<div id="message_m" style="display: {if Tools::getValue('message')}none{else}block{/if}; overflow: auto; width: 400px;">
				<a href="#" onclick="$('#message').slideToggle();$('#message_m').slideToggle();return false"><b>{l s='Click here'}</b> {l s='to add a comment or send a message to the customer.'}</a>
			</div>
			<a href="{$link->getAdminLink('AdminCustomerThreads')|escape:'htmlall':'UTF-8'}"><b>{l s='Click here'}</b> {l s='to see all messages.'}</a><br>
			<div id="message" style="display: {if Tools::getValue('message')}block{else}none{/if}">
						<select name="order_message" id="order_message" onchange="orderOverwriteMessage(this, '{l s='Do you want to overwrite your existing message?'}')">
							<option value="0" selected="selected">- {l s='Choose a standard message'} -</option>
			{foreach from=$orderMessages item=orderMessage}
				<option value="{$orderMessage['message']|escape:'htmlall':'UTF-8'}">{$orderMessage['name']}</option>
			{/foreach}
						</select><br /><br />
						<b>{l s='Display to customer?'}</b>
						<input type="radio" name="visibility" id="visibility" value="0" /> {l s='Yes'}
						<input type="radio" name="visibility" value="1" checked="checked" /> {l s='No'}
						<p id="nbchars" style="display:inline;font-size:10px;color:#666;"></p><br /><br />
				<textarea id="txt_msg" name="message" cols="50" rows="8" onKeyUp="var length = document.getElementById('txt_msg').value.length; if (length > 600) length = '600+'; document.getElementById('nbchars').innerHTML = '{l s='600 characters, max.'} (' + length + ')';">{Tools::getValue('message')|escape:'htmlall':'UTF-8'}</textarea><br /><br />
				<input type="hidden" name="id_order" value="{$order->id}" />
				<input type="hidden" name="id_customer" value="{$order->id_customer}" />
				<input type="submit" class="button" name="submitMessage" value="{l s='Send'}" />
			</div>
		</fieldset>
		</form>

	{if (sizeof($messages))}
		<br />
		<fieldset style="width: 400px;">
		<legend><img src="../img/admin/email.gif" /> {l s='Messages'}</legend>
		{foreach from=$messages item=message}
			<div style="overflow:auto; width:400px;" {if $message['is_new_for_me']}class="new_message"{/if}>
			{if ($message['is_new_for_me'])}
				<a class="new_message" title="{l s='Mark this message as \'viewed\''}" href="{$smarty.server.REQUEST_URI}&token={$smarty.get.token}&messageReaded={$message['id_message']}"><img src="../img/admin/enabled.gif" alt="" /></a>
			{/if}
			{l s='At'} <i>{dateFormat date=$message['date_add']}
			</i> {l s='from'} <b>{if ($message['elastname']|escape:'htmlall':'UTF-8')}{$message['efirstname']|escape:'htmlall':'UTF-8'} {$message['elastname']|escape:'htmlall':'UTF-8'}{else}{$message['cfirstname']|escape:'htmlall':'UTF-8'} {$message['clastname']|escape:'htmlall':'UTF-8'}{/if}</b>
			{if ($message['private'] == 1)}<span style="color:red; font-weight:bold;">{l s='Private'}</span>{/if}
			<p>{$message['message']|escape:'htmlall':'UTF-8'|nl2br}</p>
			</div>
			<br />
		{/foreach}
		</fieldset>
	{/if}
	</div>
	<div class="clear">&nbsp;</div>
	<br /><br /><a href="{$current_index}&token={$smarty.get.token}"><img src="../img/admin/arrow2.gif" /> {l s='Back to list'}</a><br />
{/block}