<?php
class AdminOrdersController extends AdminOrdersControllerCore
{
    public function initToolbar()
    {
        if (!class_exists('ScPsorder')) {
            return parent::initToolbar();
        }

        if ($this->display == 'view') {

            if (_PS_VERSION_ == 1.5) {
                $order = new Order((int)Tools::getValue('id_order'));
            } elseif (_PS_VERSION_ >= 1.6) {
                $order = $this->loadObject();
                if (!Validate::isLoadedObject($order)) {
                    Tools::redirectAdmin($this->context->link->getAdminLink('AdminOrders'));
                }
            }

            $customer = $this->context->customer;

            $bIsSoraCaisse = ScPsorder::getSoraCaisseDocByPrestashopReference($order->reference);

            if ($bIsSoraCaisse === true) {

                $aDoc = ScTools::getDocWithType($order->reference);

                global $ScModule;

                if (empty($ScModule)) {
                    $ScModule = Module::getInstanceByName('soracaisse');
                }

                $this->toolbar_title[] = sprintf($ScModule->lang('Cash register document %1$s from %2$s %3$s'), $aDoc['type'] . '-' . $aDoc['number'], $customer->firstname, $customer->lastname);

            } else {

                $this->toolbar_title[] = sprintf($this->l('Order %1$s from %2$s %3$s'), $order->reference, $customer->firstname, $customer->lastname);

            }

            if ($order->hasBeenShipped()) {
                $type = $this->l('Return products');
            } elseif ($order->hasBeenPaid()) {
                $type = $this->l('Standard refund');
            } else {
                $type = $this->l('Cancel products');
            }

            if (!$order->hasBeenShipped() && !$this->lite_display) {
                $this->toolbar_btn['new'] = array(
                    'short' => 'Create',
                    'href' => '#',
                    'desc' => $this->l('Add a product'),
                    'class' => 'add_product'
                );
            }

            if (Configuration::get('PS_ORDER_RETURN') && !$this->lite_display) {
                
                $this->toolbar_btn['standard_refund'] = array(
                    'short' => 'Create',
                    'href' => '',
                    'desc' => $type,
                    'class' => 'process-icon-standardRefund'
                );
            }

            if ($order->hasInvoice() && !$this->lite_display) {
                
                $this->toolbar_btn['partial_refund'] = array(
                    'short' => 'Create',
                    'href' => '',
                    'desc' => $this->l('Partial refund'),
                    'class' => 'process-icon-partialRefund'
                );
            }
        }

        $res = parent::initToolbar();

        if (Context::getContext()->shop->getContext() != Shop::CONTEXT_SHOP &&
            isset($this->toolbar_btn['new']) &&
            Shop::isFeatureActive()) {
            unset($this->toolbar_btn['new']);
        }
        
        return $res;
    }

    public function renderView()
    {
        if (!class_exists('ScPsorder')) {
            return parent::renderView();
        }

        if (!class_exists('ScStore')) {
            return parent::renderView();
        }

        if (empty($this->context->cookie->scidstore)) {
            ScStore::setStoreContextByShopContext((int)$this->context->shop->id);
        }

        $order = new Order(Tools::getValue('id_order'));

        if (!Validate::isLoadedObject($order)) {

            if (_PS_VERSION_ == 1.5) {
                throw new PrestaShopException('object can\'t be loaded');
            } elseif (_PS_VERSION_ >= 1.6) {
                $this->errors[] = Tools::displayError('The order cannot be found within your database.');
            }
        }

        $customer = new Customer($order->id_customer);

        $carrier = new Carrier($order->id_carrier);

        $products = $this->getProducts($order);

        $currency = new Currency((int)$order->id_currency);

        // Carrier module call

        $carrier_module_call = null;

        if ($carrier->is_module) {

            $module = Module::getInstanceByName($carrier->external_module_name);
            if (method_exists($module, 'displayInfoByCart')) {
                $carrier_module_call = call_user_func(array($module, 'displayInfoByCart'), $order->id_cart);
            }
        }

        // Retrieve addresses information
        $addressInvoice = new Address($order->id_address_invoice, $this->context->language->id);

        if (Validate::isLoadedObject($addressInvoice) && $addressInvoice->id_state) {
            $invoiceState = new State((int)$addressInvoice->id_state);
        }

        if ($order->id_address_invoice == $order->id_address_delivery) {

            $addressDelivery = $addressInvoice;

            if (isset($invoiceState)) {
                $deliveryState = $invoiceState;
            }
        } else {

            $addressDelivery = new Address($order->id_address_delivery, $this->context->language->id);

            if (Validate::isLoadedObject($addressDelivery) && $addressDelivery->id_state) {
                $deliveryState = new State((int)($addressDelivery->id_state));
            }
        }

        $this->toolbar_title = sprintf($this->l('Order #%1$d (%2$s) - %3$s %4$s'), $order->id, $order->reference, $customer->firstname, $customer->lastname);

        if (Shop::isFeatureActive()) {

            $shop = new Shop((int)$order->id_shop);
            $this->toolbar_title .= ' - ' . sprintf($this->l('Shop: %s'), $shop->name);
        }

        // gets warehouses to ship products, if and only if advanced stock management is activated

        $warehouse_list = null;
        $order_details = $order->getOrderDetailList();

        foreach ($order_details as $order_detail) {

            $product = new Product($order_detail['product_id']);

            if (Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') && $product->advanced_stock_management) {

                $warehouses = Warehouse::getWarehousesByProductId($order_detail['product_id'], $order_detail['product_attribute_id']);

                foreach ($warehouses as $warehouse) {

                    if (!isset($warehouse_list[$warehouse['id_warehouse']])) {
                        $warehouse_list[$warehouse['id_warehouse']] = $warehouse;
                    }
                }
            }
        }

        $payment_methods = array();

        foreach (PaymentModule::getInstalledPaymentModules() as $payment) {

            $module = Module::getInstanceByName($payment['name']);

            if (Validate::isLoadedObject($module) && $module->active) {
                $payment_methods[] = $module->displayName;
            }
        }

        // display warning if there are products out of stock

        $display_out_of_stock_warning = false;

        $current_order_state = $order->getCurrentOrderState();

        if (Configuration::get('PS_STOCK_MANAGEMENT') && (!Validate::isLoadedObject($current_order_state) ||
         ($current_order_state->delivery != 1 && $current_order_state->shipped != 1))) {
            $display_out_of_stock_warning = true;
        }

        // products current stock (from stock_available)
        foreach ($products as &$product) {
            // Get total customized quantity for current product
            $customized_product_quantity = 0;

            if (is_array($product['customizedDatas'])) {

                $bIsInt = false;

                if (defined('_SC_DECIMAL_QTIES_')) {

                    if (_SC_DECIMAL_QTIES_ > 0) {
                        foreach ($product['customizedDatas'] as $customizationPerAddress) {
                            foreach ($customizationPerAddress as $customizationId => $customization) {
                                $customized_product_quantity += (float)$customization['quantity'];
                            }
                        }
                    } else {
                        $bIsInt = true;
                    }
                } else {
                    $bIsInt = true;
                }

                if ($bIsInt === true) {

                    foreach ($product['customizedDatas'] as $customizationPerAddress) {
                        foreach ($customizationPerAddress as $customizationId => $customization) {
                            $customized_product_quantity += (int)$customization['quantity'];
                        }
                    }
                }
            }

            $product['customized_product_quantity'] = $customized_product_quantity;
            $product['current_stock'] = StockAvailable::getQuantityAvailableByProduct($product['product_id'], $product['product_attribute_id'], $product['id_shop']);

            $resume = OrderSlip::getProductSlipResume($product['id_order_detail']);

            $product['quantity_refundable'] = $product['product_quantity'] - $resume['product_quantity'];
            $product['amount_refundable'] = $product['total_price_tax_incl'] - $resume['amount_tax_incl'];
            $product['amount_refundable_tax_incl'] = $product['total_price_tax_incl'] - $resume['amount_tax_incl'];
            $product['amount_refund'] = Tools::displayPrice($resume['amount_tax_incl'], $currency);
            $product['refund_history'] = OrderSlip::getProductSlipDetail($product['id_order_detail']);
            $product['return_history'] = OrderReturn::getProductReturnDetail($product['id_order_detail']);


            // if the current stock requires a warning
            if ($product['current_stock'] == 0 && $display_out_of_stock_warning) {
                $this->displayWarning($this->l('This product is out of stock: ') . ' ' . $product['product_name']);
            }

            if ($product['id_warehouse'] != 0) {

                $warehouse = new Warehouse((int)$product['id_warehouse']);

                $product['warehouse_name'] = $warehouse->name;

                $warehouse_location = WarehouseProductLocation::getProductLocation($product['product_id'], $product['product_attribute_id'], $product['id_warehouse']);

                if (!empty($warehouse_location)) {
                    $product['warehouse_location'] = $warehouse_location;
                } else {
                    $product['warehouse_location'] = false;
                }

            } else {

                $product['warehouse_name'] = '--';

                $product['warehouse_location'] = false;
            }
        }

        $gender = new Gender((int)$customer->id_gender, $this->context->language->id);

        $history = $order->getHistory($this->context->language->id);

        if (_PS_VERSION_ > 1.5) {
            foreach ($history as &$order_state) {
                $order_state['text-color'] = Tools::getBrightness($order_state['color']) < 128 ? 'white' : 'black';
            }
        }

        // Smarty assign
        $this->tpl_view_vars = array(
            'order' => $order,
            'cart' => new Cart($order->id_cart),
            'customer' => $customer,
            'gender' => $gender,
            'customer_addresses' => $customer->getAddresses($this->context->language->id),
            'addresses' => array(
                'delivery' => $addressDelivery,
                'deliveryState' => isset($deliveryState) ? $deliveryState : null,
                'invoice' => $addressInvoice,
                'invoiceState' => isset($invoiceState) ? $invoiceState : null
            ),
            'customerStats' => $customer->getStats(),
            'products' => $products,
            'discounts' => $order->getCartRules(),
            'orders_total_paid_tax_incl' => $order->getOrdersTotalPaid(),
            'total_paid' => $order->getTotalPaid(),
            'returns' => OrderReturn::getOrdersReturn($order->id_customer, $order->id),
            'customer_thread_message' => CustomerThread::getCustomerMessages($order->id_customer),
            'orderMessages' => OrderMessage::getOrderMessages($order->id_lang),
            'messages' => Message::getMessagesByOrderId($order->id, true),
            'carrier' => new Carrier($order->id_carrier),
            'history' => $history,
            'states' => OrderState::getOrderStates($this->context->language->id),
            'warehouse_list' => $warehouse_list,
            'sources' => ConnectionsSource::getOrderSources($order->id),
            'currentState' => $order->getCurrentOrderState(),
            'currency' => new Currency($order->id_currency),
            'currencies' => Currency::getCurrenciesByIdShop($order->id_shop),
            'previousOrder' => $order->getPreviousOrderId(),
            'nextOrder' => $order->getNextOrderId(),
            'current_index' => self::$currentIndex,
            'can_edit' => ($this->tabAccess['edit'] == 1),
            'carrierModuleCall' => $carrier_module_call,
            'iso_code_lang' => $this->context->language->iso_code,
            'id_lang' => $this->context->language->id,
            'current_id_lang' => $this->context->language->id,
            'invoices_collection' => $order->getInvoicesCollection(),
            'not_paid_invoices_collection' => $order->getNotPaidInvoicesCollection(),
            'payment_methods' => $payment_methods,
            'invoice_management_active' => Configuration::get('PS_INVOICE', null, null, $order->id_shop),
            'display_warehouse' => (int)Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT')
        );

        if (_PS_VERSION_ >= 1.6) {

            $this->tpl_view_vars['HOOK_CONTENT_ORDER'] = Hook::exec('displayAdminOrderContentOrder', array(
                'order' => $order,
                'products' => $products,
                'customer' => $customer));

            $this->tpl_view_vars['HOOK_CONTENT_SHIP'] = Hook::exec('displayAdminOrderContentShip', array(
                'order' => $order,
                'products' => $products,
                'customer' => $customer));

            $this->tpl_view_vars['HOOK_TAB_ORDER'] = Hook::exec('displayAdminOrderTabOrder', array(
                'order' => $order,
                'products' => $products,
                'customer' => $customer));

            $this->tpl_view_vars['HOOK_TAB_SHIP'] = Hook::exec('displayAdminOrderTabShip', array(
                'order' => $order,
                'products' => $products,
                'customer' => $customer));
        }

        $bIsSoraCaisse = ScPsorder::getSoraCaisseDocByPrestashopReference($order->reference);

        if ($bIsSoraCaisse === true) {

            $aScOrder = $aScTicket = array();
            $aDoc = ScTools::getDocWithType($order->reference);
            $sMsg = ScPsorder::postProcess(strtolower($aDoc['type']), $aDoc['number'], $order);
            $aPayments = ScPayment::getPaymentsFromSQL($aDoc['number'], ($aDoc['type'] == 'TIC' ? false : true));

            $this->context->smarty->assign($this->tpl_view_vars);

            $sScToken = Db::getInstance()->getValue('SELECT `value` 
                                FROM `' . _DB_PREFIX_ . 'configuration` 
                                WHERE `name`= "SORA_CAISSE_TOKEN"');

            if ($aDoc['type'] == 'TIC') {

                $sTicketNumber = $aDoc['number'];

                $aScTicket = ScTicket::getTicket($sTicketNumber);

                $sOrderNumber = Db::getInstance()->getValue('SELECT c.`id_cmd`
                     FROM `' . _DB_PREFIX_ . 'caisse_cmd` c
                     WHERE c.`id_solde_ticket` = ' . $sTicketNumber . '
                     AND c.`id_customer` = ' . $order->id_customer);

                $sInvoiceNumber = Db::getInstance()->getValue('SELECT i.`id_facture`
                     FROM `' . _DB_PREFIX_ . 'caisse_facture` i
                     WHERE i.`id_ticket` = ' . $sTicketNumber . ' AND i.`ispro`=0');

                $sOrderSlipNumber = Db::getInstance()->getValue('SELECT os.`id_avoir`
                     FROM `' . _DB_PREFIX_ . 'caisse_avoir` os
                     WHERE os.`id_ticket` = ' . $sTicketNumber);

                $TotalPayments = ScPayment::getTotalFromSQL('all', 'caisse_paiement', 'id_ticket=' . $sTicketNumber);
            
            } elseif ($aDoc['type'] == 'BC') {

                $sOrderNumber = $aDoc['number'];
                $aScOrder = ScOrder::getOrder($sOrderNumber);
                $sTicketNumber = $aScOrder['id_solde_ticket'];

                if ($aScOrder['statut'] == 0) {

                    $TotalPayments =ScPayment::getTotalFromSQL('all', 'caisse_cmd_paiement', 'id_cmd='.$aDoc['number']);
                    $sInvoiceNumber = $sOrderSlipNumber = '';

                } else {

                    $TotalPayments = ScPayment::getTotalFromSQL('all', 'caisse_cmd_paiement', 'id_cmd='.$sTicketNumber);
                    $aScTicket = ScTicket::getTicket($sTicketNumber);
                    $sInvoiceNumber = Db::getInstance()->getValue('SELECT i.`id_facture`
                                     FROM `' . _DB_PREFIX_ . 'caisse_facture` i
                                     WHERE i.`id_ticket` = ' . $sTicketNumber . ' AND i.`ispro`=0
                                     AND i.`id_customer` = ' . $order->id_customer);

                    $sOrderSlipNumber = Db::getInstance()->getValue('SELECT os.`id_avoir`
                                     FROM `' . _DB_PREFIX_ . 'caisse_avoir` os
                                     WHERE os.`id_cmd` = ' . $aScOrder['id_cmd']);
                }

            }

            global $ScModule;

            if (empty($ScModule)) {
                $ScModule = Module::getInstanceByName('soracaisse');
            }

            $CountDoc = 0;

            if (!empty($sTicketNumber)) {
                $CountDoc++;
            }

            if (!empty($sOrderNumber)) {
                $CountDoc++;
            }

            if (!empty($sInvoiceNumber)) {
                $CountDoc++;
            }

            if (!empty($sOrderSlipNumber)) {
                $CountDoc++;
            }

            $this->context->smarty->assign(array(
                'order_type' => _SC_PSORDER_,
                'soracaisse_view_dir' => _SC_VIEW_,
                'soracaisse' => $ScModule,
                'document' => $aDoc['type'] . '-' . $aDoc['number'],
                'document_type' => strtolower($aDoc['type']),
                'document_number' => $aDoc['number'],
                'invoice_number' => $sInvoiceNumber,
                'cmd' => (!empty($sOrderNumber) ? $aScOrder : ''),
                'invoice' => (!empty($sInvoiceNumber) ? ScInvoice::getInvoice($sInvoiceNumber) : ''),
                'ticket' => (!empty($aScTicket) ? $aScTicket : ''),
                'orderslip' => (!empty($sOrderSlipNumber) ? ScOrderSlip::getOrderSlip($sOrderSlipNumber) : ''),
                'sctoken' => $sScToken,
                'return_mode' => _SC_ASSOCIATED_TICKET_,
                'total_document' => $CountDoc,
                'payments' => $aPayments,
                'total_payments' => $TotalPayments,
                'show_toolbar' => false
            ));

            if (_PS_VERSION_ == 1.5) {

                $this->context->smarty->assign(array(
                    'order_head' => sprintf($ScModule->lang('Cash register document %1$s from %2$s %3$s'), $aDoc['type'] . '-' . $aDoc['number'], $customer->firstname, $customer->lastname),
                ));
            }

            $view = $this->context->smarty->fetch(_PS_MODULE_DIR_ . 'soracaisse/views/templates/admin/orders/view'.str_replace('.', '', substr(_PS_VERSION_, 0, 3)) . '.tpl');

        } else {

            $helper = new HelperView($this);
            $this->setHelperDisplay($helper);

            $helper->tpl_vars = $this->tpl_view_vars;

            if (!is_null($this->base_tpl_view)) {
                $helper->base_tpl = $this->base_tpl_view;
            }

            $view = $helper->generateView();
        }

        return $view;
    }
}
