function printReceipt(sParams,bNoPrice) {

    var res = sParams.split("|");
    var domain = res[0];
    var receipt = res[1];

    $.cookie("scprinterdefault", domain, { expires: 365, path: "/" });

    $('#Printersend').dialog('open');

    var builder = new epson.ePOSBuilder();

    builder.addPulse(builder.DRAWER_1, builder.PULSE_100);
    builder.addPulse(builder.DRAWER_2, builder.PULSE_100);

    builder.addTextLang('fr').addTextSmooth(true);

    builder.addTextAlign(builder.ALIGN_CENTER);
    builder.addTextSize(1, 2);

    var sMention = strip_tags($('.tcmentions').html(),'');

    builder.addTextPosition(0);
    builder.addText(sMention.trim());
    builder.addTextSize(1, 1);
    builder.addText('\n\n');
    builder.addText(strip_tags($('.tcdate').html(),'') + '\n');
    builder.addBarcode(strip_tags($('.tcnumber').html(),''), builder.BARCODE_CODE39, builder.HRI_BELOW, builder.FONT_A, 2, 80);
  
    $('#table_ticket td').each(function(index,value){
        
        if($(this).hasClass('tccustomer')){
            builder.addTextAlign(builder.ALIGN_LEFT);
            builder.addText('\n' + strip_tags($(this).html(),'') + '\n');
        }

        if($(this).hasClass('tccurrency')){
            builder.addTextAlign(builder.ALIGN_RIGHT);
            builder.addTextSize(2, 1);
            builder.addText(strip_tags($(this).html(),'')+ '\n'); 

            builder.addTextSize(1, 1);
            builder.addTextAlign(builder.ALIGN_LEFT);
            builder.addFeedUnit(12);
        }

        if($(this).hasClass('productname')){

            sProductName = strip_tags($(this).html(),'');

            sProductName = formatstrlen(sProductName.length,sProductName,'','');

            builder.addText(sProductName.toUpperCase());
        }

        if($(this).hasClass('productprice')){
            builder.addTextPosition(400).addText(toPrice8( (bNoPrice=== true ? '--' : strip_tags($(this).find('.pprice').html(),'')) ) + '\n');
        }

        if($(this).hasClass('productecotax') && bNoPrice === false){
            builder.addText(strip_tags($(this).html(),'') + '\n');
        }

        if($(this).hasClass('productpack')){
            builder.addText(strip_tags($(this).html(),'') + '\n');
        }

        if($(this).hasClass('productreduction') && bNoPrice === false){
            builder.addTextStyle(false, false, true, builder.COLOR_1);
            builder.addText(strip_tags($(this).html(),'').toUpperCase());
        }

        if($(this).hasClass('productreductionamount') && bNoPrice === false){
            builder.addTextStyle(false, false, false, builder.COLOR_1);
            builder.addTextPosition(400).addText(toPrice8(strip_tags($(this).html(),'')) + '\n');
        }

        if($(this).hasClass('marginthree')){
            builder.addText('\n');
        }

        if($(this).hasClass('producttotal')){
            builder.addTextStyle(false, false, true, builder.COLOR_1);
            builder.addText(strip_tags($(this).html(),'').toUpperCase());
        }

        if($(this).hasClass('producttotalprice')){
            builder.addTextPosition(400).addText(toPrice8( (bNoPrice=== true ? '--' : strip_tags($(this).find('.pprice').html(),'')) ) + '\n');
        }

        if($(this).hasClass('productglobalreduction') && bNoPrice === false){
            builder.addText(strip_tags($(this).html(),'').toUpperCase());
        }

        if($(this).hasClass('productglobalreductionprice') && bNoPrice === false){
            builder.addTextPosition(400).addText(toPrice8(strip_tags($(this).html(),'')) + '\n');
        }

        if($(this).hasClass('productloyalty') && bNoPrice === false){
            builder.addText(strip_tags($(this).html(),'').toUpperCase());
        }

        if($(this).hasClass('productloyaltyprice') && bNoPrice === false){
            builder.addTextPosition(400).addText(toPrice8(strip_tags($(this).html(),'')) + '\n');
        }

        if($(this).hasClass('producttotalglobal') && bNoPrice === false){
            builder.addText(strip_tags($(this).html(),'').toUpperCase());
        }

        if($(this).hasClass('producttotalglobalprice') && bNoPrice === false){
            builder.addTextPosition(400).addText(toPrice8(strip_tags($(this).html(),'')) + '\n');
        }

        if($(this).hasClass('marginfive') && bNoPrice === false){
            builder.addText('\n');
        }

        if($(this).hasClass('modepaiementtitle') && bNoPrice === false){
            builder.addTextStyle(false, false, false, builder.COLOR_1);
            builder.addText(strip_tags($(this).html(),'') + '\n');
        }

        if($(this).hasClass('modepaiement') && bNoPrice === false){
            builder.addText(strip_tags($(this).html(),''));
        }

        if($(this).hasClass('modepaiementamount') && bNoPrice === false){
            builder.addTextPosition(400).addText(toPrice8(strip_tags($(this).html(),'')) + '\n');
        }

        if($(this).hasClass('totaltva') && bNoPrice === false){
            builder.addText(strip_tags($(this).html(),''));
        }

        if($(this).hasClass('totaltvaamount') && bNoPrice === false){
            builder.addTextPosition(400).addText(toPrice8(strip_tags($(this).html(),'')) + '\n');
        }

        if($(this).hasClass('margintwenty') && bNoPrice === false){
            builder.addText('\n\n');
        }

        if($(this).hasClass('loyaltyrecap') && bNoPrice === false){
             builder.addText(strip_tags($(this).html(),'') + '\n');
        }

    });

    builder.addTextStyle(false, false, false, builder.COLOR_1);

    if($('.seller').html() != ''){
        builder.addText('\n\n' + strip_tags($('.seller').html(),'') + '\n\n');
    }

    if($('.personaltxt').html() != ''){
        builder.addText(strip_tags($('.personaltxt').html(),'') + '\n');
    }
  
    

    builder.addFeedUnit(24);
    builder.addCut(builder.CUT_FEED);

   

    // send to printer
   var epos = new epson.ePOSPrint();
    epos.address = 'http://' + domain + '/cgi-bin/epos/service.cgi?devid=' + receipt + '&timeout=10000';
    epos.onreceive = function (res) {
        $('#Printersend').dialog('close');
        if (!res.success) {
            $('#Printerreceive').dialog('open');
            return;
        }
    }
    epos.onerror = function (err) {
        $('#Printersend').dialog('close');
        $('#Printererror').dialog('open');
    }
    epos.send(builder.toString());
}

function toPrice8(val) {
    return ('        ' + val).slice(-8);
}

function strip_tags(input, allowed) {

    if(typeof(input) == 'undefined'){
        return '';
    }

  input = input.trim();

  allowed = (((allowed || '') + '')
    .toLowerCase()
    .match(/<[a-z][a-z0-9]*>/g) || [])
    .join(''); // making sure the allowed arg is a string containing only tags in lowercase (<a><b><c>)
  var tags = /<\/?([a-z][a-z0-9]*)\b[^>]*>/gi,
    commentsAndPhpTags = /<!--[\s\S]*?-->|<\?(?:php)?[\s\S]*?\?>/gi;
  return input.replace(commentsAndPhpTags, '')
    .replace(tags, function($0, $1) {
      return allowed.indexOf('<' + $1.toLowerCase() + '>') > -1 ? $0 : '';
    });
}

var nextSpace = 27;
var maxlen = 27;
function formatstrlen(baseStringLength,sEntryString,str,sOutputString){

    if(baseStringLength <= maxlen){
        
        return sEntryString.trim();
    }
    else{

        if(str == ''){
            str = sEntryString.trim();
        }
    
        if (str.length > maxlen)
        {  

            nextSpace = parseInt(nextSpace)+parseInt(strpos(str.substr(nextSpace, str.length), " "));

            if(isNaN(nextSpace)){

                nextSpace = 27;

                return sEntryString;
            }
            else{
                
                sEntryString = str.substr(0, nextSpace).trim()+'\n';

                sOutputString += sEntryString;

                str = str.substr(nextSpace, str.length);

                return formatstrlen(baseStringLength,sEntryString,str,sOutputString);
            }
      
          
  
        }
        else{

            if(str != ""){
                sOutputString += str.trim();
            }

            nextSpace = 27;

            return sOutputString;
        }

    }
}

function strpos(haystack, needle, offset) {

  var i = (haystack + '')
    .indexOf(needle, (offset || 0));
  return i === -1 ? false : i;
}