CREATE TABLE IF NOT EXISTS `PREFIX_caisse_access` (
  `id_profile` int(10) NOT NULL,
  `id_function` int(10) NOT NULL,
  `active` int(1) NOT NULL,
  KEY `id_profile` (`id_profile`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_avoir` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_store` INT(10) NOT NULL,
  `id_avoir` varchar(100) NOT NULL,
  `id_customer` int(10) NOT NULL,
  `id_address` int(10) NOT NULL,
  `code` varchar(100) NOT NULL,
  `montant` decimal(10,2) NOT NULL,
  `deleted` varchar(100) NOT NULL DEFAULT '0',
  `date_add` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `date_expire` datetime NOT NULL,
  `id_ticket` varchar(100) NOT NULL,
  `id_cmd` varchar(100) NOT NULL,
  `id_facture` VARCHAR(100) NOT NULL,
  `id_r_avoir` varchar(100) NOT NULL,
  `id_deleted_ticket` varchar(100) NOT NULL,
  `id_deleted_cmd` varchar(7) NOT NULL,
  `id_rstore` INT(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_bon_cadeau` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_store` INT(10) NOT NULL,
  `id_bon_cadeau` varchar(100) NOT NULL,
  `code` varchar(100) NOT NULL,
  `montant` decimal(10,2) NOT NULL,
  `date_add` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted` varchar(100) NOT NULL DEFAULT '0',
  `date_expire` datetime NOT NULL,
  `id_ticket` varchar(100) NOT NULL,
  `id_cmd` varchar(100) NOT NULL,
  `r_id_bon_cadeau` varchar(100) NOT NULL,
  `id_deleted_ticket` varchar(100) NOT NULL,
  `id_deleted_cmd` varchar(7) NOT NULL,
  `de` varchar(255) NOT NULL,
  `a` varchar(255) NOT NULL,
  `free_txt` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_mvt` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_mvt` VARCHAR(50) NOT NULL,
  `id_store` INT(10) NOT NULL,
  `id_employee` int(10) NOT NULL,
  `id_countcash` INT(10) NOT NULL,
  `montant` decimal(10,2) NOT NULL,
  `document` VARCHAR(50) NOT NULL,
  `type` varchar(4) NOT NULL,
  `motif` varchar(255) NOT NULL,
  `detail` varchar(255) NOT NULL,
  `date` DATETIME NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_cmd` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_cmd` varchar(100) NOT NULL,
  `id_store` int(10) NOT NULL,
  `id_employee` int(10) NOT NULL,
  `id_customer` int(10) NOT NULL,
  `id_address1` int(10) NOT NULL,
  `statut` int(2) NOT NULL,
  `id_solde_ticket` varchar(6) NOT NULL,
  `id_solde_facture` VARCHAR(6) NOT NULL,
  `total_cmd` decimal(10,2) NOT NULL,
  `total_cmd_hr` DECIMAL(10,2) NOT NULL,
  `is_reward` int(1) NOT NULL DEFAULT '0',
  `comments` TEXT NOT NULL,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_solde` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_cmd_detail` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_cmd` varchar(100) NOT NULL,
  `id_store` int(10) NOT NULL,
  `id_product` int(10) NOT NULL,
  `id_attribute` int(10) NOT NULL,
  `ean_product` varchar(13) NOT NULL,
  `upc_product` varchar(12) NOT NULL,
  `name` TEXT NOT NULL,
  `supplier_name` varchar(255) NOT NULL,
  `supplier_ref` varchar(255) NOT NULL,
  `reference` varchar(255) NOT NULL,
  `wholesale_price` decimal(12,6) NOT NULL,
  `tva` decimal(10,3) NOT NULL,
  `id_tax` INT(10) NOT NULL,
  `ecotax` decimal(12,6) NOT NULL,
  `pu_ht` decimal(12,6) NOT NULL,
  `pu_ttc` decimal(12,2) NOT NULL,
  `quantity` int(10) NOT NULL,
  `weight` float NOT NULL,
  `rp` decimal(12,2) NOT NULL,
  `rpo` decimal(10,2) NOT NULL,
  `p_ttc` decimal(12,2) NOT NULL,
  `p_ht_wrg` DECIMAL(12,6) NOT NULL,
  `comments` TEXT NOT NULL,
  `id_employee` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_cmd_paiement` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_cmd` varchar(100) NOT NULL,
  `id_store` int(10) NOT NULL,
  `id_employee` int(10) NOT NULL,
  `cb1` decimal(10,2) NOT NULL,
  `cb2` decimal(10,2) NOT NULL,
  `cb3` decimal(10,2) NOT NULL,
  `es1` decimal(10,2) NOT NULL,
  `es2` decimal(10,2) NOT NULL,
  `es3` decimal(10,2) NOT NULL,
  `ch1` decimal(10,2) NOT NULL,
  `ch2` decimal(10,2) NOT NULL,
  `ch3` decimal(10,2) NOT NULL,
  `cr1` decimal(10,2) NOT NULL,
  `chr1` decimal(10,2) NOT NULL,
  `av1` decimal(10,2) NOT NULL,
  `avn1` varchar(100) NOT NULL,
  `av2` decimal(10,2) NOT NULL,
  `avn2` varchar(100) NOT NULL,
  `av3` decimal(10,2) NOT NULL,
  `avn3` varchar(100) NOT NULL,
  `kd1` decimal(10,2) NOT NULL,
  `kdn1` varchar(100) NOT NULL,
  `kd2` decimal(10,2) NOT NULL,
  `kdn2` varchar(100) NOT NULL,
  `kd3` decimal(10,2) NOT NULL,
  `kdn3` varchar(100) NOT NULL,
  `vir1` DECIMAL(10,2) NOT NULL,
  `remise_global_prix` decimal(10,2) NOT NULL,
  `remise_global_pourcent` decimal(10,2) NOT NULL,
  `p_cmd_hr` decimal(10,2) NOT NULL,
  `p_cmd_r` decimal(10,2) NOT NULL,
  `cbd1` DATETIME NOT NULL,
  `cbd2` DATETIME NOT NULL,
  `cbd3` DATETIME NOT NULL,
  `chd1` DATETIME NOT NULL,
  `chd2` DATETIME NOT NULL,
  `chd3` DATETIME NOT NULL,
  `crd1` DATETIME NOT NULL,
  `chrd1` DATETIME NOT NULL,
  `esd1` DATETIME NOT NULL,
  `esd2` DATETIME NOT NULL,
  `esd3` DATETIME NOT NULL,
  `avd1` DATETIME NOT NULL,
  `avd2` DATETIME NOT NULL,
  `avd3` DATETIME NOT NULL,
  `kdd1` DATETIME NOT NULL,
  `kdd2` DATETIME NOT NULL,
  `kdd3` DATETIME NOT NULL,
  `vird1` DATETIME NOT NULL,
  `rendu` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_configuration` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `value` TEXT NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

INSERT IGNORE INTO `PREFIX_caisse_configuration` (`id`, `name`, `value`) VALUES
(1, 'SC_VERSION', 'SCVERSION'),
(2, 'SC_INVOICE_PRINTER', ''),
(3, 'SC_ORDER_PRINTER', ''),
(4, 'SC_ORDER_SLIP_PRINTER', ''),
(5, 'SC_LOG_PRINTER', ''),
(6, 'SC_COUNTCASH_PRINTER', ''),
(7, 'SC_TICKET_PRINTER', ''),
(8, 'SC_VOUCHER_PRINTER', ''),
(9, 'SC_MULTI_STOCK', '0');

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_countcash` (
  `id` INT(10) NOT NULL AUTO_INCREMENT,
  `id_store` int(10) NOT NULL,
  `id_employee` INT(10) NOT NULL DEFAULT '0',
  `b500` INT(10) NOT NULL DEFAULT '0',
  `b200` INT(10) NOT NULL DEFAULT '0',
  `b100` INT(10) NOT NULL DEFAULT '0',
  `b50` INT(10) NOT NULL DEFAULT '0',
  `b20` INT(10) NOT NULL DEFAULT '0',
  `b10` INT(10) NOT NULL DEFAULT '0',
  `b5` INT(10) NOT NULL DEFAULT '0',
  `p2` INT(10) NOT NULL DEFAULT '0',
  `p1` INT(10) NOT NULL DEFAULT '0',
  `p05` INT(10) NOT NULL DEFAULT '0',
  `p02` INT(10) NOT NULL DEFAULT '0',
  `p01` INT(10) NOT NULL DEFAULT '0',
  `p005` INT(10) NOT NULL DEFAULT '0',
  `p002` INT(10) NOT NULL DEFAULT '0',
  `p001` INT(10) NOT NULL DEFAULT '0',
  `totalesp` DECIMAL(10,2) NOT NULL DEFAULT '0.00',
  `totalcb` DECIMAL(10,2) NOT NULL DEFAULT '0.00',
  `totalch` DECIMAL(10,2) NOT NULL DEFAULT '0.00',
  `totalchr` DECIMAL(10,2) NOT NULL DEFAULT '0.00',
  `balance_prev_day` DECIMAL(10,2) NOT NULL DEFAULT '0.00',
  `total_sell` DECIMAL(10,2) NOT NULL DEFAULT '0.00',
  `fond_caisse` DECIMAL(10,2) NOT NULL DEFAULT '0.00',
  `contribution` DECIMAL(10,2) NOT NULL DEFAULT '0.00',
  `levy` DECIMAL(10,2) NOT NULL DEFAULT '0.00',
  `theorical_balance` DECIMAL(10,2) NOT NULL DEFAULT '0.00',
  `cash_gap` DECIMAL(10,2) NOT NULL DEFAULT '0.00',
  `comments` TEXT NOT NULL,
  `date_add` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `control_id_employee` INT(10) NOT NULL DEFAULT '0',
  `control_date` DATETIME NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_facture` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_facture` varchar(100) NOT NULL,
  `id_store` int(10) NOT NULL,
  `id_employee` int(10) NOT NULL,
  `id_ticket` varchar(100) NOT NULL,
  `id_customer` int(10) NOT NULL,
  `id_address1` int(10) NOT NULL,
  `id_address2` int(10) NOT NULL,
  `comments` TEXT NOT NULL,
  `is_reward` int(1) NOT NULL DEFAULT '0',
  `ispro` INT(1) NOT NULL,
  `id_state` INT(1) NOT NULL,
  `remise_global_prix` DECIMAL(10,2) NOT NULL,
  `remise_global_pourcent` DECIMAL(10,2) NOT NULL,
  `p_invoice_hr` DECIMAL(10,2) NOT NULL,
  `p_invoice_r` DECIMAL(10,2) NOT NULL,
  `date_add` DATETIME NOT NULL,
  `date_cancel` DATETIME NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_favorites` (
  `id` INT(10) NOT NULL AUTO_INCREMENT,
  `id_store` INT(10) NOT NULL,
  `id_employee` INT(10) NOT NULL,
  `ids` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_paiement` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_store` int(10) NOT NULL,
  `id_ticket` varchar(100) NOT NULL,
  `id_employee` int(10) NOT NULL,
  `c` int(10) NOT NULL,
  `cb1` decimal(10,2) NOT NULL,
  `cb2` decimal(10,2) NOT NULL,
  `cb3` decimal(10,2) NOT NULL,
  `es1` decimal(10,2) NOT NULL,
  `es2` decimal(10,2) NOT NULL,
  `es3` decimal(10,2) NOT NULL,
  `ch1` decimal(10,2) NOT NULL,
  `ch2` decimal(10,2) NOT NULL,
  `ch3` decimal(10,2) NOT NULL,
  `cr1` decimal(10,2) NOT NULL,
  `chr1` decimal(10,2) NOT NULL,
  `av1` decimal(10,2) NOT NULL,
  `avn1` varchar(100) NOT NULL,
  `av2` decimal(10,2) NOT NULL,
  `avn2` varchar(100) NOT NULL,
  `av3` decimal(10,2) NOT NULL,
  `avn3` varchar(100) NOT NULL,
  `kd1` decimal(10,2) NOT NULL,
  `kdn1` varchar(100) NOT NULL,
  `kd2` decimal(10,2) NOT NULL,
  `kdn2` varchar(100) NOT NULL,
  `kd3` decimal(10,2) NOT NULL,
  `kdn3` varchar(100) NOT NULL,
  `vir1` DECIMAL(10,2) NOT NULL,
  `cbd1` DATETIME NOT NULL,
  `cbd2` DATETIME NOT NULL,
  `cbd3` DATETIME NOT NULL,
  `chd1` DATETIME NOT NULL,
  `chd2` DATETIME NOT NULL,
  `chd3` DATETIME NOT NULL,
  `crd1` DATETIME NOT NULL,
  `chrd1` DATETIME NOT NULL,
  `esd1` DATETIME NOT NULL,
  `esd2` DATETIME NOT NULL,
  `esd3` DATETIME NOT NULL,
  `avd1` DATETIME NOT NULL,
  `avd2` DATETIME NOT NULL,
  `avd3` DATETIME NOT NULL,
  `kdd1` DATETIME NOT NULL,
  `kdd2` DATETIME NOT NULL,
  `kdd3` DATETIME NOT NULL,
  `vird1` DATETIME NOT NULL,
  `date_solde` DATETIME NOT NULL,
  `rendu` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_search_index` (
  `id_index` INT(10) NOT NULL AUTO_INCREMENT,
  `id_store` INT(10) NOT NULL DEFAULT '0',
  `id_shop` INT(10) NOT NULL DEFAULT '0',
  `id_lang` INT(10) NOT NULL DEFAULT '0',
  `id_product` INT(10) NULL DEFAULT NULL,
  `id_product_attribute` INT(10) NULL DEFAULT NULL,
  `name` VARCHAR(3000) NULL DEFAULT NULL,
  `ean13` VARCHAR(13) NOT NULL,
  `upc` VARCHAR(12) NOT NULL,
  `reference` VARCHAR(255) NOT NULL,
  `supplier_name` VARCHAR(255) NOT NULL,
  `supplier_reference` VARCHAR(255) NOT NULL,
  `wholesale_price` DECIMAL(10,6) NOT NULL,
  `reduction` DECIMAL(10,6) NOT NULL,
  `reduction_type` VARCHAR(50) NOT NULL,
  `reduction_amount` DECIMAL(10,6) NOT NULL,
  `reduction_value` DECIMAL(10,6) NOT NULL,
  `price_ht` DECIMAL(10,6) NOT NULL,
  `price_ttc_hr` DECIMAL(10,2) NOT NULL,
  `price_ttc` DECIMAL(10,2) NOT NULL,
  `tax` DECIMAL(10,2) NOT NULL,
  `ecotaxttc` DECIMAL(10,2) NOT NULL,
  `image` VARCHAR(1000) NOT NULL,
  `description_short` TEXT NOT NULL,
  `description` TEXT NOT NULL,
  PRIMARY KEY (`id_index`),
  INDEX `id_product` (`id_product`),
  INDEX `id_product_attribute` (`id_product_attribute`),
  INDEX `name` (`name`),
  INDEX `ean13` (`ean13`),
  INDEX `upc` (`upc`),
  INDEX `reference` (`reference`),
  INDEX `supplier_name` (`supplier_name`),
  INDEX `supplier_reference` (`supplier_reference`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_shortcuts` (
  `id` INT(10) NOT NULL AUTO_INCREMENT,
  `id_store` INT(10) NOT NULL,
  `ids` LONGTEXT NOT NULL,
  UNIQUE INDEX `id_store` (`id_store`),
  PRIMARY KEY (`id`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_store` (
  `id_store` INT(10) NOT NULL AUTO_INCREMENT,
  `id_shop` INT(10) NULL DEFAULT '1',
  `id_warehouse` INT(10) NULL DEFAULT '0',
  `id_dec` INT(10) NULL DEFAULT '0',
  `id_inc` INT(10) NULL DEFAULT '0',
  `id_customer_group` INT(10) NULL DEFAULT '1',
  `lang` VARCHAR(50) NULL,
  `name` VARCHAR(255) NOT NULL,
  `url` VARCHAR(255) NOT NULL,
  `header` TEXT NOT NULL,
  `footer` TEXT NOT NULL,
  `footer_tc` TEXT NOT NULL,
  `footer_tc_employee` INT(1) NOT NULL DEFAULT '1',
  `active` INT(1) NOT NULL DEFAULT '1',
  `licence` VARCHAR(20) NULL DEFAULT NULL,
  PRIMARY KEY (`id_store`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

INSERT IGNORE INTO `PREFIX_caisse_store` (`id_store`,`name`, `licence`) VALUES ('1','MON MAGASIN', 'INCLUS');

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_ticket` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_ticket` varchar(100) NOT NULL,
  `id_store` int(10) NOT NULL,
  `id_customer` int(10) NOT NULL,
  `id_address` int(10) NOT NULL,
  `id_employee` int(10) NOT NULL,
  `remise_global_prix` decimal(10,2) NOT NULL,
  `remise_global_pourcent` decimal(10,2) NOT NULL,
  `is_reward` int(1) NOT NULL DEFAULT '0',
  `p_ticket_hr` decimal(10,2) NOT NULL,
  `p_ticket_r` decimal(10,2) NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_ticket_detail` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_ticket` varchar(100) NOT NULL,
  `id_store` int(10) NOT NULL,
  `id_product` int(10) NOT NULL,
  `id_attribute` int(10) NOT NULL,
  `ean_product` varchar(13) NOT NULL,
  `upc_product` varchar(12) NOT NULL,
  `name` TEXT NOT NULL,
  `supplier_name` varchar(255) NOT NULL,
  `supplier_ref` varchar(255) NOT NULL,
  `reference` varchar(255) NOT NULL,
  `wholesale_price` decimal(12,6) NOT NULL,
  `tva` decimal(10,3) NOT NULL,
  `id_tax` INT(10) NOT NULL,
  `ecotax` decimal(12,6) NOT NULL,
  `pu_ht` decimal(12,6) NOT NULL,
  `pu_ttc` decimal(12,2) NOT NULL,
  `quantity` int(4) NOT NULL,
  `weight` float NOT NULL,
  `rp` decimal(12,2) NOT NULL,
  `rpo` decimal(10,2) NOT NULL,
  `p_ttc` decimal(12,2) NOT NULL,
  `p_ht_wrg` DECIMAL(12,6) NOT NULL,
  `rbt` decimal(10,2) NOT NULL,
  `qte_rbt` decimal(10,2) NOT NULL,
  `transfert_compta` INT(1) NOT NULL DEFAULT '0',
  `comments` TEXT NOT NULL,
  `id_employee` int(10) NOT NULL,
  `codeCompta` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_ticket_stby` (
  `id_stby` int(10) NOT NULL AUTO_INCREMENT,
  `id_comment` INT(10) NOT NULL,
  `id_store` int(10) NOT NULL,
  `id_employee` int(10) NOT NULL,
  `id_customer` INT(10) NOT NULL,
  `id_address` INT(10) NOT NULL,
  `remise_global_prix` decimal(10,2) NOT NULL,
  `remise_global_pourcent` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `date_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_stby`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_ticket_stby_comment` (
 `id_comment` INT(11) NOT NULL AUTO_INCREMENT,
 `commentary` LONGTEXT NULL,
 PRIMARY KEY (`id_comment`)
) ENGINE=MYSQL_ENGINE  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_ticket_stby_detail` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_stby` int(10) NOT NULL,
  `id_store` int(10) NOT NULL,
  `id_product` int(10) NOT NULL,
  `id_attribute` int(10) NOT NULL,
  `ean_product` varchar(13) NOT NULL,
  `upc_product` varchar(12) NOT NULL,
  `name` TEXT NOT NULL,
  `supplier_name` varchar(255) NOT NULL,
  `supplier_ref` varchar(255) NOT NULL,
  `reference` varchar(255) NOT NULL,
  `wholesale_price` decimal(12,6) NOT NULL,
  `tva` decimal(10,3) NOT NULL,
  `ecotax` decimal(12,6) NOT NULL,
  `pu_ht` decimal(12,6) NOT NULL,
  `pu_ttc` decimal(12,2) NOT NULL,
  `quantity` int(4) NOT NULL,
  `weight` float NOT NULL,
  `rp` decimal(12,2) NOT NULL,
  `rpo` decimal(10,2) NOT NULL,
  `p_ttc` decimal(12,2) NOT NULL,
  `id_employee` int(10) NOT NULL,
  `codeCompta` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_warehouse_shop` (
  `id_shop` INT(10) NULL DEFAULT NULL,
  `id_warehouse` INT(10) NULL DEFAULT NULL,
  `id_dec` INT(10) NULL DEFAULT NULL,
  `id_inc` INT(10) NULL DEFAULT NULL,
  UNIQUE INDEX `id_shop` (`id_shop`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_employee_reduction` (
    `id_employee_reduction` INT(10) NOT NULL AUTO_INCREMENT,
    `id_employee` INT(10) NOT NULL,
    `amount` DECIMAL(12,2) NOT NULL,
    PRIMARY KEY (`id_employee_reduction`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8 AUTO_INCREMENT = 1;

CREATE TABLE IF NOT EXISTS `PREFIX_caisse_employee_reduction_history` (
    `id_reduction_history` INT(10) NOT NULL AUTO_INCREMENT,
    `id_employee` INT(10) NOT NULL DEFAULT '0',
    `id_store` INT(10) NOT NULL DEFAULT '0',
    `document` VARCHAR(6) NOT NULL,
    `document_number` VARCHAR(50) NOT NULL,
    `type` TINYINT(1) NOT NULL DEFAULT '0' COMMENT '0 -> tic | 1 -> cmd',
    `credit_before_amount_save` FLOAT(12,2) NOT NULL DEFAULT '0.00',
    `amount` FLOAT(12,2) NOT NULL DEFAULT '0.00',
    `credit_after_amount_save` FLOAT(12,2) NOT NULL DEFAULT '0.00',
    `date_add` DATETIME NOT NULL,
    PRIMARY KEY (`id_reduction_history`)
) ENGINE=MYSQL_ENGINE DEFAULT CHARSET=utf8 AUTO_INCREMENT = 1;