<?php
/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: contact@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    PriceMinister
 * @copyright  Copyright (c) 2011-2014 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2014 Common Services Co Ltd (http://www.common-services.com)
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * 
 */
if ( ! defined('_MODULE_PRICEMINISTER_VERSION_') )
    define('_MODULE_PRICEMINISTER_VERSION_', '3.7.06') ;

class PriceMinister extends Module
{
    const Add = 'a';
    const Remove = 'd';
    const Update = 'u';

    private $_categories = null;
    private $onlyActivesCategories = false;
    private $_html = '';
    private $_postErrors = array();
    
    private $_config = array(
        'PM_CURRENT_VERSION' => null,
        // NO MORE USED
        'PM_HTTPS_URL' => 'https://ws.priceminister.com/',
        'PM_HTTP_URL' => 'http://ws.priceminister.com/',
        // Credentials
        //
	'PM_LOGIN' => array(2 => 'Myshop'),
        'PM_TOKEN' => array(2 => 'Mypassword'),
        'PM_TEST' => false,
        'PM_DEBUG' => false,
        'PM_PROFILES' => null,

        // For PS 1.5+
        //
        'PM_WAREHOUSE' => null,
        // Orders
        //
	'PM_ORDERS_REQUEST' => null,
        'PM_IMPORT_METHOD' => null,
        'PM_FORCE_IMPORT' => null,
        'PM_CUSTOMER_ACCOUNT' => self::ONE_CUSTOMER_ACCOUNT,
        'PM_INDIVIDUAL_DOMAIN' => null,
        // Price Minister Customer
        //
	'PM_CUSTOMER_ID' => null,
        // Saved Categories
        //
	'PM_CATEGORIES' => null,
        'PM_CATEGORIES_FORMULA' => null,
        'PM_CATEGORIES_MAPPING' => null,
        
        // Params
        //
	'PM_OUT_OF_STOCK' => null,
        'PM_PRICE_FORMULA' => null,
        'PM_STATE' => null,
        'PM_SENTSTATE' => null,
        'PM_UPDATE_MODE' => null,
        'PM_UPDATE_MODE_ENABLED' => null,
        'PM_IMAGE_TYPE' => null,
        'PM_IMAGE_OPTIONNAL' => null,
        // ShippingMatrix
        // 
        'PM_SHIPPING_METHODS' => null,
        'PM_PM_CARRIERS' => null,
        'PM_PS_CARRIERS' => null,
        'PM_SHIPPING_TABLE' => null,
        'PM_ADDRESS_MAP'    => null,
        // Specials
        //
	'PM_SPECIALS' => null,
        'PM_TAXES' => null,
        
        // Condition/State/Etat
        //
	'PM_CONDITION_MAP' => null,
        
        // Cron
        'PM_CRON_TOKEN' => null,
        
        'PM_FEATURES_MAPPING_L' => null,
        'PM_FEATURES_MAPPING_R' => null,

        'PM_PROFILES_FORMATS' => null,
        
        'PM_COMMENT' => null,
        'PM_FASHION_GENDER' => null,
        'PM_FASHION_AUDIENCE' => null,
        'PM_FASHION_TYPE' => null
    );
    
    private $_default_formula = '@ + 10%';
    private $_default_comment = 'Envoi rapide et soign&eacute;...';
    private $_conditions = array(
        'N' => 'Neuf',
        'CN' => 'Comme neuf',
        'TBE' => 'Tr&egrave;s bon Etat',
        'BE' => 'Bon Etat',
        'EC' => 'Etat correct',
    );
    public static $pm_carriers = array(
        'fr' => array(
            'Colis Prive',
            'So Colissimo',
            'Colissimo',
            'CHRONOPOST',
            'TNT',
            'UPS',
            'Fedex',
            'Tatex',
            'GLS',
            'DHL',
            'France Express',
            'Courrier Suivi',
            'Exapaq'
        ),
        'es' => array(
            'Unknwown'
        )
    );
    public static $pm_shipping_methods = array(
        'fr' => array(
            'Normal',
            'Suivi',
            'Recommande',
            'So Colissimo',
            'Chronopost',
            'Retrait chez le vendeur'
        ),
        'es' => array(
            'Unknwown'
        )
    );
    public static $pm_shipping_zones = array(
        'France' => 'France',
        'Drom_Com' => 'DROM COM',
        'Europe' => 'Europe',
        'Monde' => 'Monde'
    ) ;
            
    const ONE_CUSTOMER_ACCOUNT = 1;
    const INDIVIDUAL_CUSTOMER_ACCOUNT = 2;

    function __construct()
    {
        $this->name = 'priceminister';
        $this->author = 'Common-Services';
        $this->page = basename(__FILE__, '.php');
        $this->tab = 'market_place';
        $this->version = _MODULE_PRICEMINISTER_VERSION_ ;
        $this->module_key = '8a0a8e805c0c0247ffe7d6f7b31028cf';
        $this->displayName = $this->l('Price Minister');
        $this->description = $this->l('This extension allow to manage products, orders, stock from/to Price Minister');

        parent::__construct();

        $this->path = str_replace('\\', '/', dirname(__FILE__)) . '/';
        $this->url = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->name . '/';
        $this->images = $this->url . 'images/';
        $this->js = $this->url . 'js/';

        if ( (defined('PS_ADMIN_DIR') || defined('_PS_ADMIN_DIR_')) && self::isInstalled($this->name))
        {
            if (!is_array(unserialize(base64_decode(self::configurationGet('PM_LOGIN')))) OR
                    !base64_decode(self::configurationGet('PM_STATE')) OR
                    !base64_decode(self::configurationGet('PM_SENTSTATE')))
            {
                $this->warning = $this->l('Your module is not yet configured !');
            }            
            if (preg_match('/^1\.[1-2]/', _PS_VERSION_))
                if (!Hook::get('backOfficeHeader'))
                    $this->warning = $this->l('Old Prestashop release: Hook "backOfficeHeader" need to be installed ; please contact us !');
                
            if ( ! function_exists('curl_init'))
                $this->warning = $this->l('PHP cURL must be installed for this module working...');

            if (!(int) self::configurationGet('PS_SHOP_ENABLE'))
                $this->warning = $this->l('Be carefull, your shop is in maintenance mode, the module might not work in that mode');
            
            if ( ! $this->active )
                $this->warning = $this->l('Be carefull, your module is inactive, this mode stops all pending operations for this module, please change the status to active in your module list');
        }
        
        $this->initContext();
    }

    // Retrocompatibility 1.4/1.5
    private function initContext()
    {
        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {
            $this->context = Context::getContext();
            
            if ( ! $this->context->controller instanceOf AdminModulesController && 
                 ! $this->context->controller instanceOf AdminOrdersController && ! strstr($_SERVER['REQUEST_URI'], $this->url) )    
                    return ;
            
            if ( ! isset($this->context->currency) || ! $this->context->currency instanceOf Currency )
                $this->context->currency = new Currency(Configuration::get('PS_CURRENCY_DEFAULT')) ;
            
            if (!isset($this->context->employee->id_lang) || !$this->context->employee->id_lang)
            {
                //$id_employee = Configuration::get('MONECHELLE_EMPLOYEE') ; // to be implemented ASAP
                $id_employee = null;
                $employee = new Employee($id_employee ? $id_employee : 1);

                // Force context for F/O scripts (ie: products options, import orders)
                $this->context->employee = $employee;
                $this->context->language = new Language($employee->id_lang);

                $this->id_lang = (int) $employee->id_lang;
            }
            else
            {
                $this->id_lang = (int) $this->context->employee->id_lang;
            }
        }
        else // ps1.4
        {
            global $smarty, $cookie;
            
            $this->context = new StdClass();
            $this->context->smarty = $smarty;
            $this->context->cookie = $cookie;
            $this->context->shop = new StdClass();
            
            if (!isset($cookie->id_lang) || !$cookie->id_lang)
                $this->id_lang = (int) self::configurationGet('PS_LANG_DEFAULT') ;
            else
               $this->id_lang = (int)$cookie->id_lang;
            
        }
    }

    public function install()
    {
        $pass = true;

        foreach ($this->_config as $key => $value)
        {
            if (!self::configurationUpdateValue($key, (is_array($value) ? base64_encode(serialize($value)) : $value)))
            {
                $pass = false;
            }
        }

        if (!parent::install() OR
                !$this->_installTables() OR
                !$this->_createCustomer() OR
                !$this->_addMarketPlaceField())
        {
            $pass = false;
        }

        // Install Tabs
        //
        if ($pass)
        {
            $pass = $this->_tabSetup(self::Add);
        }

        // Add Hooks
        //
        $this->_hookSetup(self::Add);

        if($pass){
            require_once(dirname(__FILE__) . '/classes/PM_Context.class.php');
            $pass = PM_Context::save($this->context);
        }
        
        return($pass);
    }

    public function uninstall()
    {
        $pass = true;

        // Remove Hooks
        //
        $this->_hookSetup(self::Remove);

        if (!parent::uninstall() OR
                !$this->_removeMarketPlaceField() OR
                !$this->_tabSetup(self::Remove) OR
                !$this->_deleteCustomer() OR
                !$this->_removeTables()
        )
        {
            $pass = false;
        }

        foreach ($this->_config as $key => $value)
        {
            if (!Configuration::deleteByName($key))
            {
                $pass = false;
            }
        }

        return($pass);
    }


    private function _postValidation()
    {
        $languages = Language::getLanguages();

        // Form fields
        //
        $marketPlaceLang = Tools::getValue('pm_lang');

        $i = 0;
        $pm_logins = Tools::getValue('pm_login');
        $pm_tokens = Tools::getValue('pm_token');
        $pm_profileids = Tools::getValue('pm_profileid');
        $pm_mappingaliases = Tools::getValue('pm_mappingaliase');

        $formulas = Tools::getValue('formula');
        $outofstocks = Tools::getValue('outofstock');
        $state = Tools::getValue('state');
        $sentstate = Tools::getValue('sentstate');
        
        $ps_carriers = Tools::getValue('ps_carriers');
        $pm_carriers = Tools::getValue('pm_carriers');        
        $pm_shipping_table = Tools::getValue('pm_shipping_table') ;
        $pm_shipping_defaults = Tools::getValue('pm_shipping_defaults') ;
        
        $condition_map = Tools::getValue('condition_map');

        // Init
        //
        $pm_login = array();
        $pm_token = array();
        $pm_profileid = array();
        $pm_mappingalias = array();

        $formula = array();
        $outofstock = array();
        $error = null;

        //
        // Stack errors for each languages
        //
        foreach ($marketPlaceLang as $id_lang)
        {
            foreach ($languages as $lang)
                if ($lang['id_lang'] == $id_lang)
                    break;

            $pm_login[$id_lang] = trim($pm_logins[$i]);
            $pm_token[$id_lang] = trim($pm_tokens[$i]);
            /*
              $pm_profileid[$id_lang]     = trim($pm_profileids[$i]) ;
              $pm_mappingalias[$id_lang]  = trim($pm_mappingaliases[$i]) ;
             */
            $formula[$id_lang] = trim($formulas[$i]);

            if (!empty($pm_login[$id_lang]))
            {
                if (empty($pm_login[$id_lang]) && $id_lang == $lang['id_lang'])
                    $error .= $this->l('You must fill your Login') . ' (' . $lang['name'] . ')' . '<br />';
                if (empty($pm_token[$id_lang]) && $id_lang == $lang['id_lang'])
                    $error .= $this->l('You must fill your Token') . ' (' . $lang['name'] . ')' . '<br />';
                if (strlen($pm_token[$id_lang]) != 32 && $id_lang == $lang['id_lang'])
                    $error .= $this->l('The token must contains 32 characters') . ' (' . $lang['name'] . ')' . '<br />';
                if (empty($formula[$id_lang]))
                    $error .= $this->l('Formula must be set') . ' (' . $lang['name'] . ')' . '<br />';
            }
            $i++;
        }

        if (!intval($state))
            $error .= $this->l('You must choose an order state') . '<br />';
        if (!intval($sentstate))
            $error .= $this->l('You must choose a sent order state') . '<br />';

        if (!isset($condition_map) || empty($condition_map['N']))
            $error .= $this->l('The condition map must be filled') . '<br />';
        
        $pass = true ;
        
        if ( ! isset($ps_carriers['fr']) || ! is_array($ps_carriers['fr']) || ! max($ps_carriers['fr']) ) 
            $pass = false ;
        if ( ! isset($pm_carriers['fr']) || ! is_array($pm_carriers['fr']) || ! max($pm_carriers['fr']) ) 
            $pass = false ;
        
        if ( ! $pass )
            $error .= $this->l('You must configure your shipping matrix') . '<br />' ;
        
        $pass = true ;
        
        if ( ! isset($pm_shipping_table['carrier']) || ! is_array($pm_shipping_table['carrier']) || ! max($pm_shipping_table['carrier']) )
            $pass = false ;
        if ( ! isset($pm_shipping_table['zone']) || ! is_array($pm_shipping_table['zone']) || ! max($pm_shipping_table['zone']) )
            $pass = false ;
        /*
        // Commented out: not yet mandatory
        if ( ! $pass )
            $error .= $this->l('You must configure your shipping table') . '<br />' ;     
        */

        if ( ! ($id_customer = $this->_createCustomer()) )
        {
            $this->_postErrors[] = $this->l('Unable to install: _createCustomer') ;        
        }
        else
        {
            require_once(_PS_MODULE_DIR_ . 'priceminister/classes/PSPM_Address.class.php');

            PSPM_Address::createShippingLocations($id_customer) ;      
        }
        
        $this->_hookSetup(self::Add);

        // Update Tabs
        //
        $this->_tabSetup(self::Update);


        if (!empty($error))
            $this->_postErrors[] = $error;
    }

    private function _postProcess()
    {
        
        require_once(dirname(__FILE__) . '/classes/PM_Context.class.php');
        PM_Context::save($this->context) ;
        
        $languages = Language::getLanguages();

        $marketPlaceLang = Tools::getValue('pm_lang');

        $i = 0;
        $pm_logins = Tools::getValue('pm_login');
        $pm_tokens = Tools::getValue('pm_token');
        $pm_profileids = Tools::getValue('pm_profileid');
        $pm_mappingaliases = Tools::getValue('pm_mappingaliase');

        $pm_tests = Tools::getValue('pm_test');
        $pm_debugs = Tools::getValue('pm_debug');

        $formulas = Tools::getValue('formula');
        $outofstocks = Tools::getValue('outofstock');
        $shippingprices = Tools::getValue('shippingprice');
        $comments = Tools::getValue('comment');

        $shipping_methods = Tools::getValue('shipping_methods');
        $ps_carriers = Tools::getValue('ps_carriers');
        $pm_carriers = Tools::getValue('pm_carriers');
        $pm_shipping_table = Tools::getValue('pm_shipping_table');
        $pm_shipping_defaults = Tools::getValue('pm_shipping_defaults');

        $state = Tools::getValue('state');
        $sentstate = Tools::getValue('sentstate');

        $specials = Tools::getValue('specials');
        $taxes = Tools::getValue('taxes');

        $import_method = Tools::getValue('import_method');
        $pm_categories = Tools::getValue('categoryBox');
        $pm_categories_formula = Tools::getValue('categories_formulas');
        $pm_categories_mapping = Tools::getValue('categories_mapping');

        $condition_map = Tools::getValue('condition_map');
        $update_mode = Tools::getValue('update_mode');
        $update_mode_enabled = (bool)Tools::getValue('update_mode_enabled');

        $force_import = Tools::getValue('force_import');
        $customer_account = Tools::getValue('customer_account');
        $customer_domain = Tools::getValue('customer_domain');
        
        $excluded_manufacturers = Tools::getValue('selected-manufacturers') ;
        $excluded_suppliers = Tools::getValue('selected-suppliers') ;

        $warehouse = Tools::getValue('warehouse');
        $image_type = Tools::getValue('image_type');
        $image_optionnal = Tools::getValue('image_optionnal');
        
        $safe_descriptions = Tools::getValue('safe_descriptions');

        $pm_login = array();
        $pm_token = array();
        $pm_profileid = array();
        $pm_mappingalias = array();

        $pm_test = array();
        $pm_debug = array();
        $debug = 0;

        $formula = array();
        $outofstock = array();
        $shippingprice = array();
        $comment = array();
        $carrier = array();
        $error = null;
        $profiles_settings = array();
        $profiles_formats = array();
        $taxe = array();
        $special = array();

        $pmTokens = array();

        $fashion_gender_mapping = Tools::getValue('fashion_gender');
        $fashion_type_mapping = Tools::getValue('fashion_type');
        $fashion_audience_mapping = Tools::getValue('fashion_audience');
        $fashion = Tools::getValue('fashion');
        $features_mapping = Tools::getValue('features_mapping');
        
        /* debuss-a : customisable attributes */
        $custom_attr = Tools::getValue('custom-attr');
        /* !debuss-a : customisable attributes */

        foreach ($marketPlaceLang as $id_lang)
        {
            foreach ($languages as $lang)
                if ($lang['id_lang'] == $id_lang)
                    break;

            $pm_login[$id_lang] = trim($pm_logins[$i]);
            $pm_token[$id_lang] = trim($pm_tokens[$i]);

            $pm_test[$id_lang] = isset($pm_tests[$i]) ? true : false;
            $pm_debug[$id_lang] = isset($pm_debugs[$i]) ? true : false;

            if (isset($pm_debugs[$i]) && $pm_debug[$id_lang])
                $debug = 1;

            $pm_profileid[$id_lang] = trim($pm_profileids[$i]);
            $pm_mappingalias[$id_lang] = trim($pm_mappingaliases[$i]);

            $outofstock[$id_lang] = trim($outofstocks[$i]);
            $shippingprice[$id_lang] = trim($shippingprices[$i]);

            $comment[$id_lang] = trim($comments[$i]);
            $formula[$id_lang] = trim($formulas[$i]);

            $taxe[$id_lang] = isset($taxes[$i]) ? trim($taxes[$i]) : true;
            $special[$id_lang] = isset($specials[$i]) ? trim($specials[$i]) : false;

            // Profiles 2 Categories
            //
            $lang = Language::getIsoById($id_lang);

            $profiles_index = Tools::getValue('index-' . $lang);
            $profiles = Tools::getValue('profiles-' . $lang);
            $profiles_settings[$id_lang] = array();

            if (is_array($profiles))
            {
                foreach ($profiles_index as $key => $profile_index)
                {
                    $profiles[$key] = preg_replace('/[^0-9]/', '', $profiles[$key]);

                    if (empty($profiles[$key]))
                    {
                        continue;
                    }
                    $categories = Tools::getValue('categories-' . $lang . '-' . $profile_index);

                    $profiles_settings[$id_lang][] = array('ids' => $profiles[$key], 'categories' => $categories);

                    // Mapping des champs a exporter (profiles)
                    //
                    if (($selected_fields = Tools::getValue('selected-fields-' . $profiles[$key])))
                    {
                        $selected_fields_sep = Tools::getValue('fs-' . $profiles[$key]);
                        $selected_fields_del = Tools::getValue('del-' . $profiles[$key]);
                        $profiles_formats[$profiles[$key]] = array('fields' => $selected_fields, 'fs' => $selected_fields_sep, 'del' => $selected_fields_del);
                    }
                }
            }
            // Cron Token
            //
            $pmTokens[$id_lang] = md5($pm_token[$id_lang]);

            $i++;
        }
        self::configurationUpdateValue('PM_CRON_TOKEN', base64_encode(serialize($pmTokens)));

        //
        // Encode settings in configuration
        //
        self::configurationUpdateValue('PM_PROFILES', base64_encode(serialize($profiles_settings)));
        self::configurationUpdateValue('PM_PROFILES_FORMATS', base64_encode(serialize($profiles_formats)));

        self::configurationUpdateValue('PM_OUT_OF_STOCK', base64_encode(serialize($outofstock)));

        self::configurationUpdateValue('PM_PRICE_FORMULA', base64_encode(serialize($formula)));
        self::configurationUpdateValue('PM_COMMENT', base64_encode(serialize($comment)));

        self::configurationUpdateValue('PM_STATE', base64_encode($state));
        self::configurationUpdateValue('PM_SENTSTATE', base64_encode($sentstate));
        self::configurationUpdateValue('PM_IMPORT_METHOD', base64_encode($import_method));

        self::configurationUpdateValue('PM_SPECIALS', base64_encode(serialize($special)));
        self::configurationUpdateValue('PM_TAXES', base64_encode(serialize($taxe)));

        self::configurationUpdateValue('PM_LOGIN', base64_encode(serialize($pm_login)));
        self::configurationUpdateValue('PM_TOKEN', base64_encode(serialize($pm_token)));

        self::configurationUpdateValue('PM_TEST', base64_encode(serialize($pm_test)));
        self::configurationUpdateValue('PM_DEBUG', base64_encode(serialize($pm_debug)));

        self::configurationUpdateValue('PM_CATEGORIES', base64_encode(serialize($pm_categories)));
        self::configurationUpdateValue('PM_CATEGORIES_FORMULA', base64_encode(serialize($pm_categories_formula)));
        self::configurationUpdateValue('PM_CATEGORIES_MAPPING', base64_encode(serialize($pm_categories_mapping)));

        self::configurationUpdateValue('PM_CONDITION_MAP', base64_encode(serialize($condition_map)));
        self::configurationUpdateValue('PM_UPDATE_MODE', base64_encode($update_mode));
        self::configurationUpdateValue('PM_UPDATE_MODE_ENABLED', $update_mode_enabled);

        self::configurationUpdateValue('PM_WAREHOUSE', $warehouse);
        self::configurationUpdateValue('PM_IMAGE_TYPE', $image_type);
        self::configurationUpdateValue('PM_IMAGE_OPTIONNAL', (bool)$image_optionnal);
        self::configurationUpdateValue('PM_SAFE_DESCRIPTIONS', $safe_descriptions);

        self::configurationUpdateValue('PM_CUSTOMER_ACCOUNT', base64_encode($customer_account));
        self::configurationUpdateValue('PM_INDIVIDUAL_DOMAIN', base64_encode($customer_domain));

        // Shipping Matrix
        self::configurationUpdateValue('PM_SHIPPING_METHODS', base64_encode(serialize($shipping_methods)));
        self::configurationUpdateValue('PM_PM_CARRIERS', base64_encode(serialize($pm_carriers)));
        self::configurationUpdateValue('PM_PS_CARRIERS', base64_encode(serialize($ps_carriers)));
        self::configurationUpdateValue('PM_SHIPPING_TABLE', base64_encode(serialize($pm_shipping_table)));
        self::configurationUpdateValue('PM_SHIPPING_DEFAULTS', base64_encode(serialize($pm_shipping_defaults)));

        self::configurationUpdateValue('PM_FASHION_GENDER', base64_encode(serialize($fashion_gender_mapping)));
        self::configurationUpdateValue('PM_FASHION_AUDIENCE', base64_encode(serialize($fashion_audience_mapping)));
        self::configurationUpdateValue('PM_FASHION_TYPE', base64_encode(serialize($fashion_type_mapping)));

        if (isset($features_mapping['ps']) && $features_mapping['ps'])
            self::configurationUpdateValue('PM_FEATURES_MAPPING_L', base64_encode(serialize($features_mapping['ps'])));
        if (isset($features_mapping['pm']) && $features_mapping['pm'])
            self::configurationUpdateValue('PM_FEATURES_MAPPING_R', base64_encode(serialize($features_mapping['pm'])));

        if (isset($fashion['prestashop']) && $fashion['prestashop'])
            self::configurationUpdateValue('PM_ATTRIBUTES_MAPPING_L', base64_encode(serialize($fashion['prestashop'])));
        if (isset($fashion['pm']) && $fashion['pm'])
            self::configurationUpdateValue('PM_ATTRIBUTES_MAPPING_R', base64_encode(serialize($fashion['pm'])));

        self::configurationUpdateValue('PM_FILTER_MANUFACTURERS', base64_encode(serialize($excluded_manufacturers)));
        self::configurationUpdateValue('PM_FILTER_SUPPLIERS', base64_encode(serialize($excluded_suppliers)));
        
        /* debuss-a : customisable attributes */
        self::configurationUpdateValue('PM_CUSTOM_ATTR', base64_encode(serialize($custom_attr)));
        /* !debuss-a : customisable attributes */
        
        // Tables Updates
        //
        if (!$this->_installTables())
            $this->_postErrors[] = '_installTables failed';

        if (!$this->_addMarketPlaceField())
            $this->_postErrors[] = '_addMarketPlaceField failed';

        if (!$this->_postErrors){
            if(version_compare(_PS_VERSION_, '1.6', '>=')){
                $this->_html .= '<div class="bootstrap">' .$this->displayConfirmation('Configuration updated') . '</div>';
            }else{
                $this->_html .= '<div class="conf confirm">' . $this->l('Configuration updated') . '</div>';
            }
        }
        if ($debug)
        {
            $this->_html .= sprintf('<div class="conf confirm">Memory Peak: %.02f MB - Post Count: %s</div>', memory_get_peak_usage() / 1024 / 1024, count($_POST, COUNT_RECURSIVE));
        }
    }

    private function _selected_tab()
    {
        $selected_tab = Tools::getValue('selected_tab');
        $default_tab = 'priceminister' ;
        return( $selected_tab ? $selected_tab : $default_tab);
    }

    public function versionCheck()
    {
        $currentVersion = self::configurationGet('PM_CURRENT_VERSION') ;
        
        if ( Tools::isSubmit('submit') )
        {
            self::configurationUpdateValue('PM_CURRENT_VERSION', $this->version) ;
        }
        elseif ( (int)$currentVersion )
        {
            if ( version_compare($this->version, $currentVersion, '>') )
            {
                $this->_html .= sprintf('<div class="conf confirm" style="font-weight:bold">' 
                        . $this->l('Module Update: Your version will be auto-updated from %s to %s after configuration changes') . '<br />' 
                        . $this->l('Please verify again your settings. Please clear your Smarty and Browser caches...') .
                        '</div>', $currentVersion, $this->version);
            }
        }
        elseif ( $currentVersion == null )
        {
            $this->_html .= '
                    <div style="display:block;font-size:1.2em;position:relative;" class="hint">
                    <ul>
                        <li>' . $this->l('Be effective, do not waste your time :') . '</li>
                        <li>' . $this->l('For beginning, Supposing you have basis knowledge on it, please use basis functions') . '</li>
                        <li>' . $this->l('Do not try to hard tune the module. Almost all parameters are correctly configured by default.') . '</li>
                      </ul>
                    </div>
                    <br />' ;  
        }
    }

    private function _autoAddJS($url)
    {
        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {   
            return ( $this->context->controller->addJS($url) && '');
        }
        else
        {
            return( sprintf('<script type="text/javascript" src="%s"></script>', $url) ) ;
        }
    }
    
    private function _autoAddCSS($url, $media = 'all')
    {
        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {
            return( $this->context->controller->addCSS($url, $media) && '' );
        }
        else
        {
            return(sprintf('<link rel="stylesheet" type="text/css" href="%s">', $url)) ;
        }
    }   
    public function getContent()
    {
        require_once(dirname(__FILE__) . '/classes/PM_Context.class.php');
        
        $this->context->smarty->caching = false ;
        $this->context->smarty->force_compile = true ;              
                
        $this->versionCheck() ;
        
        if ($this->_categories == null)
            $this->_categories = Category::getCategories(intval($this->id_lang), $this->onlyActivesCategories);

        $view_params = array();
        $view_params["PS16_class"] = "";
        
        //PS1.6
        if (version_compare(_PS_VERSION_, '1.6', '>=')){
            $view_params["PS16_class"] = 'bootstrap'; // any value may be assigned this is just an indicator
        }
        $view_params['errors_list'] = array();
        $view_params['request_uri'] = Tools::htmlentitiesUTF8($_SERVER['REQUEST_URI']);
        $view_params['images_url'] = $this->images;
        $view_params['js_url'] = $this->js;
        $view_params['module_url'] = $this->url;
        $view_params['module_description'] = $this->description;
        $view_params['version'] = $this->version;
        $view_params['error_messages'] = array() ;
        
        if (Tools::isSubmit('submit'))
        {
            $this->_postValidation();
            if (!sizeof($this->_postErrors))
            {
                $this->_postProcess();
            }
            else
            {
                $this->_postProcess();
                $view_params['error_messages'] = array();
                foreach ($this->_postErrors AS $err)
                {
                    $view_params['error_messages'][] = $err;
                }
            }
        }

        $view_params['selected_tab'] = $this->_selected_tab();
        $view_params['menu_lang'] = $this->_tabs_lang($view_params['selected_tab']);

        $view_params['selected_tab_priceminister'] = $view_params['selected_tab'] == 'priceminister' ? 'selected' : '';
        $view_params['selected_tab_informations'] = $view_params['selected_tab'] == 'informations' ? 'selected' : '';
        $view_params['selected_tab_profiles'] = $view_params['selected_tab'] == 'profiles' ? 'selected' : '';
        $view_params['selected_tab_categories'] = $view_params['selected_tab'] == 'categories' ? 'selected' : '';
        $view_params['selected_tab_parameters'] = $view_params['selected_tab'] == 'parameters' ? 'selected' : '';
        $view_params['selected_tab_shipping'] = $view_params['selected_tab'] == 'shipping' ? 'selected' : '';
        $view_params['selected_tab_fashion'] = $view_params['selected_tab'] == 'fashion' ? 'selected' : '';
        $view_params['selected_tab_cron'] = $view_params['selected_tab'] == 'cron' ? 'selected' : '';
        $view_params['selected_tab_filters'] = $view_params['selected_tab'] == 'filters' ? 'selected' : '';

        $view_params['priceminister'] = $this->_priceminister();
        $view_params['informations'] = $this->_informations();
        $view_params['credentials'] = $this->_credentials($view_params['selected_tab']);
        $view_params['profiles'] = $this->_profiles();
        $view_params['categories'] = $this->_categories();
        $view_params['parameters'] = $this->_parameters();
        $view_params['shippings'] = $this->_shipping();
        $view_params['fashion'] = $this->_fashion();
        $view_params['cron'] = $this->_cron();
        $view_params['filters'] = $this->_filters();
        
        $compatibility_msg_16 = "";
        
        if(version_compare(_PS_VERSION_, '1.6', '>='))
        {
            foreach($view_params['error_messages'] as $er){
                $compatibility_msg_16 .= $this->displayError($er);
            }        
            unset($view_params['error_messages']);
            $compatibility_msg_16 = '<div class="bootstrap">' . $compatibility_msg_16 . '</div>'; //needed until module is compatible with bootstrap layout
        }
        
        $this->context->smarty->assign($view_params);
        $this->_html .= $this->context->smarty->fetch($this->path . 'views/configure/priceminister.tpl');

        return $compatibility_msg_16.$this->_html;
    }

    private function _tabs_lang($selected_tab = FALSE)
    {
        $view_params = array();
        $languages = Language::getLanguages();
        $i = 0;
        foreach ($languages as $language)
        {
            $menu = array();
            // For active languages
            if ($language['active'] === false)
            {
                continue;
            }
            // Allow only available platforms
            switch ($language['iso_code'])
            {
                case 'fr' :
                //case 'es' :
                    $pass = true;
                    break;
                default :
                    $pass = false;
                    continue;
            }
            if (!$pass)
            {
                continue;
            }
            $menu['iso_code'] = $language['iso_code'];
            $menu['selected'] = $selected_tab == $language['iso_code'] ? 'selected' : '';
            $menu['id_lang'] = $language['id_lang'];
            $menu['alt'] = $language['name'];
            $menu['desc'] = preg_replace('/\s.*/', '', $language['name']);

            $i++;
            $view_params[] = $menu;
        }
        return $view_params;
    }

    // PriceMinister Tab
    //
    function _priceminister() 
    {
        $view_params = array() ;
        $view_params['prestashop_version']  = _PS_VERSION_ ; 
       
        return $view_params;          
    }
    // Information Tab
    //
    function _informations() 
    {
        $lang = Language::getIsoById($this->id_lang) ;
        // Display only if the module seems to be configured
        //
        $display = true ;
        
        if ( !($login = self::configurationGet('PM_LOGIN')) || !count($login) )
                $display = false ;
       
        $php_infos = array() ;
        $prestashop_infos = array() ;
        $env_infos = array() ;

        // AJAX Checker
        //
        $env_infos['ajax'] = array();
        $env_infos['ajax']['message'] = $this->l('AJAX execution failed. Please first verify your module configuration. If the problem persists please send a screenshot of this page to the support.');
        $env_infos['ajax']['level'] = 'error';
        $env_infos['ajax']['display'] = false ;
        $env_infos['ajax']['script'] = array('name' => 'env_check_url', 'url' => $this->url . 'functions/check_env.php?action=ajax') ;

        // PHP Configuration Check
        //
        if (!function_exists('curl_init'))
        {
            $php_infos['curl'] = array() ;
            $php_infos['curl']['message'] = $this->l('PHP cURL must be installed on this server. The module require the cURL library and can\'t work without') ;
            $php_infos['curl']['level']   = 'error' ;
            $php_infos['curl']['link']    = 'http://php.net/manual/' . $lang . '/book.curl.php' ;
        }

        if (!method_exists('DOMDocument', 'createElement'))
        {
            $php_infos['curl'] = array();
            $php_infos['curl']['message'] = $this->l('PHP DOMDocument (XML Library) must be installed on this server. The module require this library and can\'t work without');
            $php_infos['curl']['level'] = 'error';
            $php_infos['curl']['link'] = 'http://php.net/manual/' . $lang . '/class.domdocument.php';
        }
        
        if ( is_dir(_PS_MODULE_DIR_ . 'priceminister/export') && ! is_writable(_PS_MODULE_DIR_ . 'priceminister/export') )
        {
            $php_infos['export_permissions']['message'] = sprintf($this->l('You have to set write permissions to the %s directory and its subsequents files'), _PS_MODULE_DIR_ . 'priceminister/export') ;
            $php_infos['export_permissions']['level']   = 'error' ;
        }  
        
        if ( version_compare(_PS_VERSION_,'1.4','>=') && $_SERVER['HTTP_HOST'] != Configuration::get('PS_SHOP_DOMAIN') && $_SERVER['HTTP_HOST'] != Configuration::get('PS_SHOP_DOMAIN_SSL') )
        {
            $php_infos['wrong_domain']['message'] =  $this->l('Your are currently connected with the following domain name:').' <span style="color:navy">'.$_SERVER['HTTP_HOST'].'</span><br />'.
                                                        $this->l('This one is different from the main shop domain name set in "Preferences > SEO & URLs":').' <span style="color:green">'.Configuration::get('PS_SHOP_DOMAIN').'</span>' ;
            $php_infos['wrong_domain']['level']   = 'error' ;
        }              
        
        if ( ($max_execution_time = ini_get('max_execution_time')) && $max_execution_time < 120 )
        {
            $php_infos['timelimit']['message']  = sprintf($this->l('PHP value: max_execution_time recommended value is at least 120. your limit is currently set to %d') . '<br />', $max_execution_time) ;
            $php_infos['timelimit']['level']   = 'warn' ;            
        }
        
        // Memory Limit
        $memory_limit = ini_get('memory_limit') ;
        $unit = strtolower(substr($memory_limit, -1));
        $val = preg_replace('[^0-9]', '', $memory_limit);
        switch ($unit)
        {
            case 'g' :
                $val = $val * 1024 * 1024 * 1024;
                break;
            case 'm' :
                $val = $val * 1024 * 1024;
                break;
            case 'k' :
                $val = $val * 1024;
                break;
            default :
                $val = false;
        }
        // Switch to MB
        $memory_limit = $val / (1024 * 1024) ;
        $memory_limit_config = 128 ;
        if ( $memory_limit > 0 && $memory_limit < $memory_limit_config )
        {
            $php_infos['memory']['message']  = sprintf($this->l('PHP value: memory_limit recommended value is at least %sMB. your limit is currently set to %sMB') . '<br />', $memory_limit_config, $memory_limit) ;
            $php_infos['memory']['level']   = 'warn' ;            
        }
        
        if ( (ini_get('suhosin.post.max_vars') && ini_get('suhosin.post.max_vars') < 1000) || (ini_get('suhosin.request.max_vars') && ini_get('suhosin.request.max_vars') < 1000) )
        {
            $php_infos['suhosin']['message']  = sprintf($this->l('PHP value: suhosin/max_vars could trouble your module configuration') . '<br />') ;
            $php_infos['suhosin']['level']   = 'warn' ;            
        }   
        
        if ( ini_get('max_input_vars') != null && ini_get('max_input_vars') < 1000 )
        {
            $php_infos['max_input_vars']['message']  = sprintf($this->l('PHP value: max_input_vars could trouble your module configuration') . '<br />') ;
            $php_infos['max_input_vars']['level']   = 'warn' ;            
        }    
        // Prestashop Configuration Check
        //
        if ( !(int)self::configurationGet('PS_SHOP_ENABLE') )
        {
            $prestashop_infos['maintenance']['message'] = $this->l('Be carefull, your shop is in maintenance mode, the module might not work in that mode');
            $prestashop_infos['maintenance']['level']   = 'warn' ;
        }
        
        // Check if birthday is mandatory
        //
        $pass = true ;
        $customerCheck = new Customer() ; 
        
        if ( version_compare(_PS_VERSION_, '1.5', '>=') )
        {
            $customRequiredFields = $customerCheck->getfieldsRequiredDatabase() ;
            
            if ( is_array($customRequiredFields) && count($customRequiredFields) )
                foreach($customRequiredFields as $customRequiredField)
                    if ( isset($customRequiredField['field_name']) && $customRequiredField['field_name'] == 'birthday' )
                        $pass = false ;
        }
        
        $customerRules = $customerCheck->getValidationRules('Customer');
        $pass = $pass && ! ( is_array($customerRules['required']) && in_array('birthday', $customerRules['required']) ) ;
        
        if ( ! $pass )
        {
            $prestashop_infos['birthday_issue']['message'] = $this->l('Birthday field is required which is not the default in Prestashop core program. This configuration is not allowed by Marketplaces modules. Please fix it !')  ;
            $prestashop_infos['birthday_issue']['level'] = 'error';            
        }
        
        
        if ( ! count($prestashop_infos) ) 
             $prestashop_info_ok = true ;
        else $prestashop_info_ok = false ;
        
        if ( ! count($php_infos) ) 
             $php_info_ok = true ;
        else $php_info_ok = false ;
        
        
        $view_params = array() ;
        $view_params['images']              = $this->images ; 
        $view_params['display']             = $display ; 
        $view_params['env_infos']           = $env_infos;
        $view_params['php_infos']           = $php_infos ; 
        $view_params['php_info_ok']         = $php_info_ok ; 
        $view_params['prestashop_infos']    = $prestashop_infos ; 
        $view_params['prestashop_info_ok']  = $prestashop_info_ok ; 
        $view_params['url']                 = $this->url ;         
       
        return $view_params;        
    }
        
    
    //
    // Credentials Menu
    //
    private function _credentials($selected_tab = FALSE)
    {
        $languages = Language::getLanguages();

        // Acc s API
        $pm_logins = unserialize(base64_decode(self::configurationGet('PM_LOGIN')));
        $pm_tokens = unserialize(base64_decode(self::configurationGet('PM_TOKEN')));
        $pm_tests = unserialize(base64_decode(self::configurationGet('PM_TEST')));
        $pm_debugs = unserialize(base64_decode(self::configurationGet('PM_DEBUG')));

        $i = 0;
        $view_params = array();
        foreach ($languages as $language)
        {
            // For active languages
            if ($language['active'] === false)
            {
                continue;
            }
            $lang_param = array();
            // Allow only available platforms
            switch ($language['iso_code'])
            {
                case 'fr' :
                    $pass = true;
                    break;
                default :
                    $pass = false;
                    continue;
            }
            if (!$pass)
            {
                continue;
            }

            $lang_param['tab_selected'] = $selected_tab == $language['iso_code'] ? 'selected' : '';
            $lang_param['id_lang'] = $language['id_lang'];
            $lang_param['iso_code'] = $language['iso_code'];
            $lang_param['name'] = $language['name'];
            $lang_param['pm_login'] = isset($pm_logins[$language['id_lang']]) ? trim($pm_logins[$language['id_lang']]) : '';
            ;
            $lang_param['pm_token'] = isset($pm_tokens[$language['id_lang']]) ? trim($pm_tokens[$language['id_lang']]) : '';
            $lang_param['pm_test'] = isset($pm_tests[$language['id_lang']]) && intval($pm_tests[$language['id_lang']]) ? true : false;
            $lang_param['pm_debug'] = isset($pm_debugs[$language['id_lang']]) && intval($pm_debugs[$language['id_lang']]) ? true : false;
            $lang_param['pm_test_checked'] = $lang_param['pm_test'] ? 'checked="checked"' : '';
            $lang_param['pm_test_style'] = $lang_param['pm_test'] ? ' style="color:red" ' : '';
            $lang_param['pm_debug_checked'] = $lang_param['pm_debug'] ? 'checked="checked"' : '';
            $lang_param['pm_debug_style'] = $lang_param['pm_debug'] ? ' style="color:red" ' : '';

            $lang_param['settings'] = $this->_settings($lang_param['id_lang']);

            $i++;
            $view_params[] = $lang_param;
        }
        return $view_params;
    }

    private function _profiles()
    {
        require_once($this->path . 'classes/PSPM_Product.class.php');

        $view_params = array();

        // Layout Fields
        $layout_fields_arr = array();
        $layout_fields_arr['_blank_1'] = 1;
        $layout_fields_arr['_blank_2'] = 1;
        $layout_fields_arr['_blank_3'] = 1;
        $layout_fields_arr['_blank_3'] = 1;
        $layout_fields_arr['_blank_4'] = 1;
        $layout_fields_arr['_blank_5'] = 1;
        $layout_fields_arr['_blank_6'] = 1;
        $layout_fields_arr['_blank_7'] = 1;
        $layout_fields_arr['_blank_8'] = 1;
        $layout_fields_arr['_blank_9'] = 1;
        $layout_fields_arr['_blank_10'] = 1;
        $layout_fields_arr['_blank_11'] = 1;
        $layout_fields_arr['_blank_12'] = 1;
        $layout_fields_arr['_blank_13'] = 1;
        $layout_fields_arr['_blank_14'] = 1;
        $layout_fields_arr['_blank_15'] = 1;
        $layout_fields_arr['_blank_16'] = 1;
        $layout_fields_arr['_blank_17'] = 1;
        $layout_fields_arr['_blank_18'] = 1;
        $layout_fields_arr['_blank_19'] = 1;
        $layout_fields_arr['_blank_20'] = 1;
        $layout_fields_arr['_blank_21'] = 1;
        $layout_fields_arr['_blank_22'] = 1;
        $layout_fields_arr['_value_0'] = 1;
        $layout_fields_arr['_value_0bis'] = 1;
        $layout_fields_arr['_value_1'] = 1;
        $layout_fields_arr['_value_1bis'] = 1;
        $layout_fields_arr['_value_2'] = 1;
        $layout_fields_arr['_value_3'] = 1;
        $layout_fields_arr['_value_y'] = 1;
        $layout_fields_arr['_value_n'] = 1;

        // Custom Fields
        $custom_fields_arr = array();
        $custom_fields_arr['pm_audience'] = 1;
        $custom_fields_arr['pm_category'] = 1;
        $custom_fields_arr['pm_category_bis'] = 1;
        $custom_fields_arr['pm_comment'] = 1;
        $custom_fields_arr['pm_gender'] = 1;
        $custom_fields_arr['pm_full_id'] = 1;
        $custom_fields_arr['pm_full_id_bis'] = 1;
        $custom_fields_arr['pm_initial_price'] = 1;
        $custom_fields_arr['pm_final_price'] = 1;
        $custom_fields_arr['pm_type'] = 1;
        $custom_fields_arr['pm_weight'] = 1;
        $custom_fields_arr['main_reference'] = 1;
        $custom_fields_arr['reference_bis'] = 1;
        $custom_fields_arr['name_bis'] = 1;
        $custom_fields_arr['id_product_bis'] = 1;
        $custom_fields_arr['category_name'] = 1;
        $custom_fields_arr['name_with_attributes'] = 1;
        $custom_fields_arr['attributes_short'] = 1;
        $custom_fields_arr['attributes_long'] = 1;
        $custom_fields_arr['tax_rate'] = 1;
        $custom_fields_arr['image_url'] = 1;
        $custom_fields_arr['image_url_2'] = 1;
        $custom_fields_arr['image_url_3'] = 1;
        $custom_fields_arr['image_url_4'] = 1;
        $custom_fields_arr['product_url'] = 1;
        $custom_fields_arr['supplier_name'] = 1;
        $custom_fields_arr['manufacturer_name'] = 1;

        // Shop Fields
        //  
        $shop_fields_arr = array();
        $shop_fields_arr['shop_name'] = 1;
        $shop_fields_arr['shop_name'] = 1;
        $shop_fields_arr['shop_email'] = 1;
        $shop_fields_arr['shop_details'] = 1;
        $shop_fields_arr['shop_addr1'] = 1;
        $shop_fields_arr['shop_addr2'] = 1;
        $shop_fields_arr['shop_fulladdr'] = 1;
        $shop_fields_arr['shop_postcode'] = 1;
        $shop_fields_arr['shop_city'] = 1;
        $shop_fields_arr['shop_state'] = 1;
        $shop_fields_arr['shop_country'] = 1;
        $shop_fields_arr['shop_phone'] = 1;
        $shop_fields_arr['shop_fax'] = 1;

        $custom_fields = array_keys($custom_fields_arr);
        $layout_fields = array_keys($layout_fields_arr);
        $shop_fields = array_keys($shop_fields_arr);
        
        $profiles_formats = unserialize(base64_decode(self::configurationGet('PM_PROFILES_FORMATS')));
        $profiles_settings = unserialize(base64_decode(self::configurationGet('PM_PROFILES')));
        $fashion_custom_attr = unserialize(base64_decode(self::configurationGet('PM_CUSTOM_ATTR')));

        if ($profiles_settings)
        {

            foreach ($profiles_settings as $key => $profile_language)
            {
                foreach ($profile_language as $index => $profile)
                {

                    $profiles = array();
                    $profile_format = array();
                    $actual_fields = array();
                    foreach ($profiles_formats as $key => $format)
                    {
                        if ($key == $profile['ids'])
                        {
                            $profile_format = $format;
                            $actual_fields = array_flip($profile_format['fields']);
                            break;
                        }
                    }

                    $profiles['ids'] = $profile['ids'];
                    $profiles['fs'] = isset($profile_format['fs']) ? $profile_format['fs'] : '';
                    if ($profiles['fs'])
                    {
                        $profiles['fs_01_selected'] = ($profile_format['fs'] == ';' ? 'selected="selected"' : '');
                        $profiles['fs_02_selected'] = ($profile_format['fs'] == ',' ? 'selected="selected"' : '');
                        $profiles['fs_03_selected'] = ($profile_format['fs'] == '|' ? 'selected="selected"' : '');
                        $profiles['fs_04_selected'] = ($profile_format['fs'] == 'Tabulation' ? 'selected="selected"' : '');
                    }
                    else
                    {
                        $profiles['fs_01_selected'] = '';
                        $profiles['fs_02_selected'] = '';
                        $profiles['fs_03_selected'] = '';
                        $profiles['fs_04_selected'] = '';
                    }

                    $profiles['del'] = isset($profile_format['del']) ? $profile_format['del'] : '';
                    if ($profiles['del'])
                    {
                        $profiles['del_01_selected'] = ($profile_format['del'] == 1 ? 'selected="selected"' : '');
                        $profiles['del_02_selected'] = ($profile_format['del'] == 2 ? 'selected="selected"' : '');
                    }
                    else
                    {
                        $profiles['del_01_selected'] = '';
                        $profiles['del_02_selected'] = '';
                    }

                    // Fetch Product field list
                    //
                    $fields = PSPM_Product::getColumnsNames($this->id_lang, PSPM_Product::COLUMN_PRODUCT);
                    $profiles['fields'] = array();
                    foreach (array_keys($fields) as $field)
                    {
                        $value = null;

                        switch ($field)
                        {
                            case 'id_product' : $value = $this->l('Product Id');
                                break;
                            case 'on_sale' : $value = $this->l('On Sale');
                                break;
                            case 'ean13' : $value = $this->l('EAN13');
                                break;
                            case 'upc' : $value = $this->l('UPC');
                                break;
                            case 'ecotax' : $value = $this->l('Ecotax');
                                break;
                            case 'online_only' : $value = $this->l('Online Only');
                                break;
                            case 'quantity' : $value = $this->l('Quantity');
                                break;
                            case 'price' : $value = $this->l('Price on my Prestashop');
                                break;
                            case 'reference' : $value = $this->l('Reference (SKU)');
                                break;
                            case 'supplier_reference' : $value = $this->l('Supplier Reference');
                                break;
                            case 'width' : $value = $this->l('Width');
                                break;
                            case 'height' : $value = $this->l('Height');
                                break;
                            case 'depth' : $value = $this->l('Depth');
                                break;
                            case 'weight' : $value = $this->l('Weight');
                                break;
                            case 'condition' : $value = $this->l('Condition');
                                break;
                            case 'date_add' : $value = $this->l('Date Add');
                                break;
                            case 'description' : $value = $this->l('Description');
                                break;
                            case 'description_short' : $value = $this->l('Short Description');
                                break;
                            case 'name' : $value = $this->l('Product Name');
                                break;
                            case 'meta_title' : $value = $this->l('Meta Title');
                                break;
                            case 'meta_keywords' : $value = $this->l('Meta Keywords');
                                break;
                            case 'meta_description' : $value = $this->l('Meta Description');
                                break;
                        }

                        if (!$value)
                        {
                            continue;
                        }

                        if (!isset($actual_fields[$field]))
                        {
                            $profiles['fields'][] = array("value" => $field, "desc" => $value);
                        }
                        else
                        {
                            $actual_fields[$field] = $value;
                        }
                    }

                    $profiles['custom_fields'] = array();
                    foreach ($custom_fields as $field)
                    {
                        $value = null;

                        switch ($field)
                        {
                            case 'pm_audience' : $value = $this->l('Public/Audience');
                                break;
                            case 'pm_gender' : $value = $this->l('Gender/Sex');
                                break;
                            case 'pm_category' : $value = $this->l('PriceMinister Category (1)');
                                break;
                            case 'pm_category_bis' : $value = $this->l('PriceMinister Category (2)');
                                break;
                            case 'pm_type' : $value = $this->l('Product Type');
                                break;
                            case 'pm_comment' : $value = $this->l('Comment');
                                break;
                            case 'pm_full_id' : $value = $this->l('Full Product ID');
                                break;
                            case 'pm_full_id_bis' : $value = $this->l('Full Product ID') . ' (2)';
                                break;
                            case 'pm_initial_price' : $value = $this->l('Shop Price');
                                break;
                            case 'pm_final_price' : $value = $this->l('Price on PriceMinister');
                                break;
                            case 'main_reference' : $value = $this->l('Parent Reference (Parent SKU)');
                                break;
                            case 'reference_bis' : $value = $this->l('Reference (SKU)');
                                break;
                            case 'name_bis' : $value = $this->l('Product Name') . ' (2)';
                                break;
                            case 'id_product_bis' : $value = $this->l('Product Id') . ' (2)';
                                break;
                            case 'category_name' : $value = $this->l('Category Name');
                                break;
                            case 'name_with_attributes' : $value = $this->l('Product Name (w/Attributes)');
                                break;
                            case 'attributes_short' : $value = $this->l('Attributes (Short)');
                                break;
                            case 'attributes_long' : $value = $this->l('Attributes (Long)');
                                break;
                            case 'tax_rate' : $value = $this->l('Tax Rate');
                                break;
                            case 'image_url' : $value = $this->l('Image 1 URL');
                                break;
                            case 'image_url_2' : $value = $this->l('Image 2 URL');
                                break;
                            case 'image_url_3' : $value = $this->l('Image 3 URL');
                                break;
                            case 'image_url_4' : $value = $this->l('Image 4 URL');
                                break;
                            case 'product_url' : $value = $this->l('Product URL');
                                break;
                            case 'manufacturer_name' : $value = $this->l('Manufacturer');
                                break;
                        }
                        if (!$value)
                            continue;

                        if (!isset($actual_fields[$field]))
                            $profiles['custom_fields'][] = array("value" => $field, "desc" => $value);
                        else
                            $actual_fields[$field] = $value;
                    }
                    $profiles['shop_fields'] = array();
                    foreach ($shop_fields as $field)
                    {
                        $value = null;

                        switch ($field)
                        {
                            case 'shop_name' : $value = $this->l('Shop Name');
                                break;
                            case 'shop_email' : $value = $this->l('Shop Email');
                                break;
                            case 'shop_details' : $value = $this->l('Shop Details');
                                break;
                            case 'shop_addr1' : $value = $this->l('Shop Address 1');
                                break;
                            case 'shop_addr2' : $value = $this->l('Shop Address 2');
                                break;
                            case 'shop_fulladdr' : $value = $this->l('Shop Complete Address');
                                break;
                            case 'shop_city' : $value = $this->l('Shop City');
                                break;
                            case 'shop_country' : $value = $this->l('Shop Country');
                                break;
                            case 'shop_phone' : $value = $this->l('Shop Phone');
                                break;
                            case 'shop_fax' : $value = $this->l('Shop Fax');
                                break;
                        }
                        if (!$value)
                            continue;

                        if (!isset($actual_fields[$field]))
                        {
                            $profiles['shop_fields'][] = array("value" => $field, "desc" => $value);
                        }
                        else
                        {
                            $actual_fields[$field] = $value;
                        }
                    }
                     
                    $profiles['shipping_fields'] = array();
                    foreach(self::$pm_shipping_zones as $key => $shipping_zone)
                    {
                        $value = sprintf('%s: %s', $this->l('Shipping'), $key) ;
                        $field = 'shipping_' . $key ;
                        
                        if (!isset($actual_fields[$field]))
                        {
                            $profiles['shipping_fields'][] = array("value" => $field, "desc" => $value);
                        }
                        else
                        {
                            $actual_fields[$field] = $value;
                        }
                    }
                    
                    /*
                     * debuss-a
                     * Customisable attributes list
                     */
                    $profiles['custom_attr'] = array();
                    if ( is_array($fashion_custom_attr) && count($fashion_custom_attr) )
                        foreach($fashion_custom_attr as $key => $cs_attr)
                        {
                            $field = 'custom_attr_' . $key ;

                            if (!isset($actual_fields[$field]))
                                $profiles['custom_attr'][] = array("value" => $field, "desc" => $cs_attr['name']);
                            else
                                $actual_fields[$field] = $cs_attr['name'];
                        }
                          
                    $profiles['layout_fields'] = array();
                    foreach ($layout_fields as $field)
                    {
                        if (substr($field, 1, 5) == 'blank')
                            $value = sprintf('%s (%d)', $this->l('Empty Column'), substr($field, 7));
                        elseif (substr($field, 1, 5) == 'value')
                            $value = sprintf('%s: "%s"', $this->l('Value'), strtoupper(substr(str_replace('bis', '', $field), 7)));
                        else
                            $value = $field;

                        if (!isset($actual_fields[$field]))
                        {
                            $profiles['layout_fields'][] = array("value" => $field, "desc" => $value);
                        }
                        else
                        {
                            $actual_fields[$field] = $value;
                        }
                    }

                    // Fetch Product field list
                    //
                    $fields = PSPM_Product::getColumnsNames($this->id_lang, PSPM_Product::COLUMN_FEATURES);
                    $profiles['product_fields'] = array();
                    foreach ($fields as $field => $value)
                    {
                        if (!isset($actual_fields[$field]))
                        {
                            $profiles['product_fields'][] = array("value" => $field, "desc" => $value);
                        }
                        else
                        {
                            $actual_fields[$field] = $value;
                        }
                    }

                    // Fetch Product field list
                    //
                    $fields = PSPM_Product::getColumnsNames($this->id_lang, PSPM_Product::COLUMN_ATTRIBUTES);
                    $profiles['attribute_fields'] = array();
                    foreach ($fields as $field => $value)
                    {
                        if (!isset($actual_fields[$field]))
                        {
                            $profiles['attribute_fields'][] = array("value" => $field, "desc" => $value);
                        }
                        else
                        {
                            $actual_fields[$field] = $value;
                        }
                    }
                    
                    $profiles['actual_fields'] = array();
                    foreach ($actual_fields as $field => $key)
                    {
                        if ($key)
                        {
                            $value = $key;
                        }
                        else
                        {
                            $value = $field;
                        }
                        $profiles['actual_fields'][] = array("value" => $field, "desc" => $value);
                    }
                    $view_params[] = $profiles;
                }
            }
        }
        
        return ($view_params);
    }

    private function _categories()
    {
        $view_params = array();

        if ($this->_categories == null)
        {
            $categories = Category::getCategories(intval($this->id_lang), $this->onlyActivesCategories);
            $this->_categories = $categories;
        }
        else
        {
            $categories = $this->_categories;
        }
        $index = array();

        $default_categories = unserialize(base64_decode(self::configurationGet('PM_CATEGORIES')));
        $default_formulas = unserialize(base64_decode(self::configurationGet('PM_CATEGORIES_FORMULA')));
        $default_mappings = unserialize(base64_decode(self::configurationGet('PM_CATEGORIES_MAPPING')));

        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {            
            $shop = $this->context->shop;
            $first = null;

            foreach ($categories as $categories1)
                foreach ($categories1 as $category)
                    if ($category['infos']['id_category'] == Category::getRootCategory(null, $shop)->id_category)
                        $first = $category;

            $default_category = $shop->id_category;
        }
        else
        {
            foreach ($categories as $first1 => $categories_array)
                break;
            foreach ($categories_array as $first2 => $categories_array2)
                break;
            $first = $categories[$first1][$first2];
            $default_category = 1;
        }

        $html_categories = self::recurseCategoryForInclude($index, $categories, $first, $default_category, null, $default_categories, $default_formulas, $default_mappings);
        $view_params['html_categories'] = $html_categories;

        return $view_params;
    }

    private function _settings($id_lang)
    {
        require_once(_PS_MODULE_DIR_ . $this->name . '/classes/PSPM_Tools.class.php');
        $settings = array();
        $settings['lang'] = Language::getIsoById($id_lang);
        // Categories
        if ($this->_categories == null)
        {
            $ps_categories = Category::getCategories(intval($this->id_lang), $this->onlyActivesCategories);
            $this->_categories = $ps_categories;
        }
        else
        {
            $ps_categories = $this->_categories;
        }
        $index = array();

        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {
            
            $shop = $this->context->shop;
            $first = null;

            foreach ($ps_categories as $categories1)
                foreach ($categories1 as $category)
                    if ($category['infos']['id_category'] == Category::getRootCategory(null, $shop)->id_category)
                        $first = $category;

            $default_category = $shop->id_category;
        }
        else
        {
            foreach ($ps_categories as $first1 => $categories_array)
                break;
            foreach ($categories_array as $first2 => $categories_array2)
                break;
            $first = $ps_categories[$first1][$first2];
            $default_category = 1;
        }
        $categories = PSPM_Tools::getCategories($ps_categories, $first);
        // Stock
        $outOfStocks = unserialize(base64_decode(self::configurationGet('PM_OUT_OF_STOCK')));
        // Price Formula
        $formulas = unserialize(base64_decode(self::configurationGet('PM_PRICE_FORMULA')));
        // Comment
        $comments = unserialize(base64_decode(self::configurationGet('PM_COMMENT')));
        // Specials & Taxes
        $specials = unserialize(base64_decode(self::configurationGet('PM_SPECIALS')));
        $taxes = unserialize(base64_decode(self::configurationGet('PM_TAXES')));
        //Settings values        
        $settings['out_of_stock'] = isset($outOfStocks[$id_lang]) ? $outOfStocks[$id_lang] : 0;
        $settings['shipping_price'] = isset($shippingPrices[$id_lang]) ? $shippingPrices[$id_lang] : '';
        $settings['formula'] = isset($formulas[$id_lang]) ? $formulas[$id_lang] : $this->_default_formula;
        $settings['comment'] = isset($comments[$id_lang]) ? $comments[$id_lang] : $this->_default_comment;
        //$selected = isset($selecteds[$id_lang]) ? $selecteds[$id_lang] : '';        
        $settings['special'] = isset($specials[$id_lang]) ? $specials[$id_lang] : 1;
        $settings['special_checked'] = $settings['special'] ? 'checked="checked"' : '';
        $settings['taxe'] = isset($taxes[$id_lang]) ? $taxes[$id_lang] : 1;
        $settings['taxe_checked'] = $settings['taxe'] ? 'checked="checked"' : '';
        $settings['categories'] = array();
        $settings['profiles'] = array();
        

        $profiles_settings = unserialize(base64_decode(self::configurationGet('PM_PROFILES')));
        $i = 0;

        foreach ($categories as $key => $category)
        {
            $cat = array();
            $cat['selected'] = '';
            $cat['value'] = trim($key);
            $cat['desc'] = $category;
            $settings['categories'][] = $cat;
        }

        $settings['count'] = isset($profiles_settings[$id_lang]) ? count($profiles_settings[$id_lang]) : 0;
        $settings['i'] = $i;

        if ($settings['count'])
        {

            for ($i = count($profiles_settings[$id_lang]) - 1; $i >= 0; $i--)
            {
                $index = $i + 1;
                $profile = array();
                $profile['index'] = $index;
                $profile['value'] = trim($profiles_settings[$id_lang][$i]['ids']);
                $profile['categories'] = array();

                foreach ($categories as $key => $category)
                {
                    $cat_sel = array();
                    if (isset($profiles_settings[$id_lang][$i]['categories']) && $profiles_settings[$id_lang][$i]['categories'] &&
                            in_array($key, $profiles_settings[$id_lang][$i]['categories']))
                    {
                        $selected = 'selected="selected"';
                    }
                    else
                    {
                        $selected = '';
                    }
                    $cat_sel['selected'] = $selected;
                    $cat_sel['value'] = trim($key);
                    $cat_sel['desc'] = $category;
                    $profile['categories'][] = $cat_sel;
                }

                $settings['profiles'][] = $profile;
            }
        }

        return $settings;
    }

    private function _parameters()
    {
        global $cookie;
        $view_params = array();

        $selected_tab = ($lng = Tools::getValue('selected_tab')) ? $lng : strtolower(Language::getIsoById(self::configurationGet('PS_LANG_DEFAULT')));

        // Order State
        //
        $param = self::configurationGet('PM_STATE') ;
        
        if ( $param == null )
            $state = defined('_PS_OS_PAYMENT_') ? _PS_OS_PAYMENT_ : (int) Configuration::get('PS_OS_PAYMENT');
        else
            $state = base64_decode($param);

        $param = self::configurationGet('PM_SENTSTATE') ;
    
        if ( $param == null )
            $sentstate = defined('_PS_OS_SHIPPING_') ? _PS_OS_SHIPPING_ : (int) Configuration::get('PS_OS_SHIPPING');
        else
            $sentstate = base64_decode($param);

        $import_methods = base64_decode(self::configurationGet('PM_IMPORT_METHOD'));
        $import_method = isset($import_methods) && $import_methods ? $import_methods : 'SKU';

        $customer_account = base64_decode(self::configurationGet('PM_CUSTOMER_ACCOUNT'));

        $update_modes = base64_decode(self::configurationGet('PM_UPDATE_MODE'));
        $update_mode_enabled = (bool)self::configurationGet('PM_UPDATE_MODE_ENABLED');
        $update_mode = isset($update_modes) && $update_modes ? $update_modes : 'PRICEQUANTITY';

        $view_params['fashion_mode'] = true ;
        $view_params['fashion_mode_checked'] = $view_params['fashion_mode'] ? 'checked="checked" ' : '';

        // PS 1.5
        $warehouse = (int) self::configurationGet('PM_WAREHOUSE');
        $image_type = self::configurationGet('PM_IMAGE_TYPE');

        $conditionMap = unserialize(base64_decode(self::configurationGet('PM_CONDITION_MAP')));
        
        $safe_descriptions = self::configurationGet('PM_SAFE_DESCRIPTIONS') ;
                
        // Shop Configuration
        //
        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {
            $view_params['version_1_5'] = 1;
            $view_params['version_1_5_3_1'] = version_compare(_PS_VERSION_, '1.5.3.1', '>=');
            $view_params['version_1_5_2_0'] = version_compare(_PS_VERSION_, '1.5.2', '>=');
            
            // Warehouse (PS 1.5 with Stock Management) 
            //
            if (self::configurationGet('PS_ADVANCED_STOCK_MANAGEMENT'))
            {
                $view_params['advanced_management'] = '1';
                $view_params['advanced_management_options'] = array();
                $current_id_warehouse = (int) $warehouse;

                foreach (Warehouse::getWarehouses(true) as $warehouse)
                {
                    $advmgt_option = array();
                    if (intval($warehouse['id_warehouse']) == $current_id_warehouse)
                    {
                        $selected = 'selected="selected"';
                    }
                    else
                    {
                        $selected = '';
                    }
                    $advmgt_option['selected'] = $selected;
                    $advmgt_option['value'] = intval($warehouse['id_warehouse']);
                    $advmgt_option['desc'] = $warehouse['name'];
                    $view_params['advanced_management_options'][] = $advmgt_option;
                }
            }
        }
        //
        // Image Type (PS 1.5.2+)
        //
        if (version_compare(_PS_VERSION_, '1.5.2', '>='))
        {
            if ( $image_type == null )
                 $image_type = 'thickbox_default' ;
            
            foreach( ImageType::getImagesTypes() as $imageType )
            {
                $image_type_option = array();
                
                if ( ! (bool)$imageType['products'] ) continue ;
                
                if ( $imageType['name'] == $image_type)
                {
                    $selected = 'selected="selected"';
                }
                else
                {
                    $selected = '';
                }
                $image_type_option['selected'] = $selected;
                $image_type_option['value'] = $imageType['name'] ;
                $image_type_option['desc'] = $imageType['name'] ;
                $view_params['image_types'][] = $image_type_option;                
            }
        }
        $view_params['image_optionnal'] = (bool)self::configurationGet('PM_IMAGE_OPTIONNAL') ;
        
        //
        // Order Statuses - Incoming Order
        //
        $orderStates = OrderState::getOrderStates($this->id_lang);
        $view_params['order_states'] = array();
        foreach ($orderStates as $orderState)
        {
            $order_state_option = array();
            if (intval($orderState['id_order_state']) == $state)
            {
                $selected = 'selected="selected"';
            }
            else
            {
                $selected = '';
            }
            $order_state_option['selected'] = $selected;
            $order_state_option['value'] = intval($orderState['id_order_state']);
            $order_state_option['desc'] = $orderState['name'];
            $view_params['order_states'][] = $order_state_option;
        }
        
        //
        // Order Statuses - Sent Orders
        //
        $orderStates = OrderState::getOrderStates($this->id_lang);
        $view_params['sentorder_states'] = array();
        foreach ($orderStates as $orderState)
        {
            $order_state_option = array();
            if (intval($orderState['id_order_state']) == $sentstate)
            {
                $selected = 'selected="selected"';
            }
            else
            {
                $selected = '';
            }
            $order_state_option['selected'] = $selected;
            $order_state_option['value'] = intval($orderState['id_order_state']);
            $order_state_option['desc'] = $orderState['name'];
            $view_params['sentorder_states'][] = $order_state_option;
        }
        
        
        $view_params['sku_import_selected'] = $import_method == 'SKU' ? 'checked="checked" ' : '';
        $view_params['id_import_selected'] = $import_method == 'ID' ? 'checked="checked" ' : '';

        if (!$customer_account)
        {
            $customer_account = self::ONE_CUSTOMER_ACCOUNT;
        }

        $view_params['one_customer_account'] = self::ONE_CUSTOMER_ACCOUNT;
        $view_params['individual_customer_account'] = self::INDIVIDUAL_CUSTOMER_ACCOUNT;
        $view_params['one_customer_account_checked'] = $customer_account == self::ONE_CUSTOMER_ACCOUNT ? 'checked="checked" ' : '';
        $view_params['individual_customer_account_checked'] = $customer_account == self::INDIVIDUAL_CUSTOMER_ACCOUNT ? 'checked="checked" ' : '';
        $view_params['domain'] = base64_decode(self::configurationGet('PM_INDIVIDUAL_DOMAIN'));
        $view_params['set_domain_style'] = '';

        if ($customer_account == self::ONE_CUSTOMER_ACCOUNT)
        {
            $view_params['set_domain_style'] = 'display:none;';
        }
        $var = explode('@', self::configurationGet('PS_SHOP_EMAIL'));

        if (empty($view_params['domain']))
        {
            $view_params['domain'] = sprintf('@%s', $var[1]);
        }

        // Products Condition/State
        $sql = 'SHOW COLUMNS FROM `' . _DB_PREFIX_ . 'product` where Field = "condition"';
        $query = Db::getInstance()->ExecuteS($sql);

        if (is_array($query))
        {
            $query = array_shift($query);
        }
     
        // Uncompatible with PS < 1.4 / Looking for compatibility or assuming New as default
        if (isset($query['Field']) && $query['Field'] == 'condition')
        {
            $view_params['product_conditions'] = array();
            $ps_conditions = array();
            // Fetch columns names
            preg_match_all("/'([\w ]*)'/", $query['Type'], $ps_conditions);
            $i = 1;
            foreach ($this->_conditions as $key => $condition)
            {
                $product_condition = array();
                $product_condition['value'] = sprintf('%s (%s)', $condition, $key);
                $product_condition['key'] = $key;
                $product_condition['index'] = $i;
                $product_condition['options'] = array();
                $i++;

                foreach ($ps_conditions[1] as $ps_condition)
                {
                    $product_condition_options = array();
                    if (isset($conditionMap[$key]) && !empty($conditionMap[$key]) && $conditionMap[$key] == $ps_condition)
                    {
                        $selected = 'selected="selected"';
                    }
                    elseif ( $conditionMap == null && $condition == 'Neuf' && $ps_condition == 'new' ) // Default
                    {
                        $selected = 'selected="selected"';
                    }
                    else
                    {
                        $selected = '';
                    }
                    $product_condition_options['selected'] = $selected;
                    $product_condition_options['value'] = $ps_condition;
                    $product_condition_options['desc'] = ucfirst($this->l($ps_condition));
                    $product_condition['options'][] = $product_condition_options;
                }
               
                $view_params['product_conditions'][] = $product_condition;
            }
        }
        $view_params['safe_descriptions'] = $safe_descriptions ;
        
        $view_params['update_mode_enabled'] = $update_mode_enabled ;
        $view_params['mode_price_selected'] = $update_mode == 'PRICE' ? ' selected="selected"' : '';
        $view_params['mode_quantity_selected'] = $update_mode == 'QUANTITY' ? ' selected="selected"' : '';
        $view_params['mode_pricequantity_selected'] = $update_mode == 'PRICEQUANTITY' ? ' selected="selected"' : '';
        $view_params['mode_fulladvert_selected'] = $update_mode == 'FULLADVERT' ? ' selected="selected"' : '';

        return $view_params;
    }

    private function _shipping()
    {
        $selected_tab = ($lng = Tools::getValue('selected_tab')) ? $lng : strtolower(Language::getIsoById(self::configurationGet('PS_LANG_DEFAULT')));
        
        $view_params = array();

        $settings = array();
        $settings['lang'] = 'fr' ; // fr - others langs no longer exists
        $id_lang = Language::getIdByIso('fr') ;
        
        /*
         * Carrier Mapping
         */
        $carriers = Carrier::getCarriers($id_lang);
        $settings_pm_carriers = unserialize(base64_decode(self::configurationGet('PM_PM_CARRIERS')));
        $settings_ps_carriers = unserialize(base64_decode(self::configurationGet('PM_PS_CARRIERS')));

        foreach (self::$pm_shipping_methods[$settings['lang']] as $shipping_method)
        {
            $shipping = array();
            $shipping['method'] = $shipping_method;
            $shipping['pm_carriers'] = array();
            $shipping['ps_carriers'] = array();

            foreach (self::$pm_carriers[$settings['lang']] as $pm_carrier)
            {
                $carrier = array();
                if (isset($settings_pm_carriers[$settings['lang']][$shipping_method]) && $settings_pm_carriers[$settings['lang']][$shipping_method] == $pm_carrier)
                {
                    $selected = 'selected="selected"';
                }
                else
                {
                    $selected = '';
                }
                $carrier['selected'] = $selected;
                $carrier['value'] = $pm_carrier;
                $carrier['desc'] = $pm_carrier;
                $shipping['pm_carriers'][] = $carrier;
            }

            foreach ($carriers as $ps_carrier)
            {
                $carrier = array();
                if (isset($settings_ps_carriers[$settings['lang']][$shipping_method]) && $settings_ps_carriers[$settings['lang']][$shipping_method] == $ps_carrier['id_carrier'])
                {
                    $selected = 'selected="selected"';
                }
                else
                {
                    $selected = '';
                }
                $carrier['selected'] = $selected;
                $carrier['value'] = $ps_carrier['id_carrier'];
                $carrier['desc'] = $ps_carrier['name'];
                $shipping['ps_carriers'][] = $carrier;
            }
            $view_params['shipping_methods'][] = $shipping;
        }        
        
        $view_params['shipping_zones'] = array() ;
        $shipping_table = unserialize(base64_decode(self::configurationGet('PM_SHIPPING_TABLE')));
        $shipping_defaults = unserialize(base64_decode(self::configurationGet('PM_SHIPPING_DEFAULTS')));
        $view_params['ps_zones'] = Zone::getZones(false);
        
        foreach(self::$pm_shipping_zones as $key => $pm_shipping_zone)
        {
            $shipping_settings = array() ;
            $shipping_settings['key'] = $key ;
            $shipping_settings['name'] = $pm_shipping_zone ;

            if ( isset($shipping_table['zone'][$key]) && $shipping_table['zone'][$key] )
                $shipping_settings['selected_zone'] = $shipping_table['zone'][$key] ;
            else
                $shipping_settings['selected_zone'] = null ;

            if ( isset($shipping_table['carrier'][$key]) && $shipping_table['carrier'][$key] )
                $shipping_settings['selected_carrier'] = $shipping_table['carrier'][$key] ;
            else
                $shipping_settings['selected_carrier'] = null ;
            
            if ( isset($shipping_defaults['minimum'][$key]) && $shipping_defaults['minimum'][$key] )
                $shipping_settings['minimum'] = sprintf('%.02f', $shipping_defaults['minimum'][$key]) ;
            else
                $shipping_settings['minimum'] = null ;

            $view_params['shipping_table'][] = $shipping_settings ;
        }
        
        
        return($view_params) ;
    }    
    
    private function _fashion()
    {
        $view_params = array();
        $attributes_groups = AttributeGroup::getAttributesGroups((int) ($this->id_lang));
        $attributes = Attribute::getAttributes((int) ($this->id_lang), true);
        $attributeList = array();

        foreach ($attributes AS $k => $attribute)
        {
            $attributeList[$attribute['id_attribute_group']][$attribute['id_attribute']] = $attribute['name'];
        }

        $fashion_left = unserialize(base64_decode(self::configurationGet('PM_ATTRIBUTES_MAPPING_L')));
        $fashion_right = unserialize(base64_decode(self::configurationGet('PM_ATTRIBUTES_MAPPING_R')));
        $previousgrp = false;
        $index = 0;

        if ($attributeList)
        {
            $view_params['attributes'] = array();
            $view_params['custom_attributes'] = array();
            
            foreach ($attributeList AS $idgrp => $group)
            {
                if ($idgrp !== $previousgrp)
                {
                    $index = 0;
                }
                $previousgrp = $idgrp;
                $saved = array_merge(array(0 => false), isset($fashion_left[$idgrp]) ? $fashion_left[$idgrp] : array());
                $attr_group = array();
                $attr_group['idgrp'] = $idgrp;
                $attr_group['saved'] = array();
                foreach ($attributes_groups as $attributes_group)
                {
                    if (isset($attributes_group['id_attribute_group']) && $attributes_group['id_attribute_group'] == $idgrp)
                    {
                        $attr_group['group_name'] = $attributes_group['name'];
                        break;
                    }
                }
                foreach ($saved as $key => $selected)
                {
                    if (!$selected && $selected !== false)
                    {
                        continue;
                    }
                    $attr_saved = array();
                    $attr_saved['index'] = $index;
                    $attr_saved['selected'] = $selected;
                    $attr_saved['select_disabled'] = $selected ? '' : 'disabled';
                    $attr_saved['select_options'] = array();

                    if ($group)
                    {
                        foreach ($group AS $idattr => $attrname)
                        {
                            $attr_option = array();
                            if ($selected == $idattr)
                            {
                                $set = ' selected="selected"';
                            }
                            else
                            {
                                $set = '';
                            }
                            $attr_option['selected'] = $set;
                            $attr_option['value'] = $idattr;
                            $attr_option['desc'] = addslashes($attrname);
                            $attr_saved['select_options'][] = $attr_option;
                        }
                    }
                    $attr_saved['display_del'] = $index == 0 ? 'display:none' : '';
                    $attr_saved['display_add'] = $index > 0 ? 'display:none' : '';

                    $attr_saved['fashion_pm_value'] = isset($fashion_right[$idgrp]) && isset($fashion_right[$idgrp][$selected]) ? $fashion_right[$idgrp][$selected] : '';
                    $attr_saved['fashion_pm_selected'] = $selected ? '' : 'disabled';

                    $index++;
                    $attr_group['saved'][] = $attr_saved;
                }

                $view_params['attributes'][] = $attr_group;
            }
        }


        /*
         * Features
         */
        $id_lang = intval($this->id_lang);

        $features_mapping_left = unserialize(base64_decode(self::configurationGet('PM_FEATURES_MAPPING_L')));
        $features_mapping_right = unserialize(base64_decode(self::configurationGet('PM_FEATURES_MAPPING_R')));

        $previous_id_feature = 0;
        $index = 0;
        $unique = array();
        $view_params['features'] = array();
        foreach (Feature::getFeatures($id_lang) AS $key => $feature)
        {
            $id_feature = $feature['id_feature'];
            $feature_arr = array();

            // Avoid Duplicates (There is duplicates on PS 1.5 due to multishop) 
            // TODO : multishop compatibility
            if (isset($unique[$id_feature]))
            {
                continue;
            }
            $unique[$id_feature] = true;

            if ($id_feature != $previous_id_feature)
            {
                $index = 0;
            }
            $previous_id_feature = $id_feature;

            $values = FeatureValue::getFeatureValuesWithLang($id_lang, $id_feature);
            if (!count($values))
            {
                continue;
            }
            $featuresValues = array_merge(array(0 => false), $values);
            $feature_arr['feature_id'] = $id_feature;
            $feature_arr['feature_name'] = $feature['name'];
            $selected = 0;
            $feature_arr['saved'] = array();
            foreach ($featuresValues as $featureValue)
            {
                $id_feature_value = isset($featureValue['id_feature_value']) ? $featureValue['id_feature_value'] : 0;
                $feature_saved = array();
                $feature_saved['value'] = $id_feature_value;
                $feature_saved['index'] = $index;
                $feature_saved['select_disabled'] = $index == 0 ? ' disabled="disabled"' : '';

                if ($featureValue !== false && (!isset($features_mapping_left[$id_feature][$feature_saved['value']]) || !$features_mapping_left[$id_feature][$feature_saved['value']]))
                {
                    continue;
                }
                $feature_saved['select_options'] = array();
                foreach ($featuresValues as $featureItem)
                {
                    $feature_option = array();
                    $id_feature_value_item = $featureItem['id_feature_value'];

                    if ($featureValue !== false && isset($features_mapping_left[$id_feature][$id_feature_value_item]) && isset($features_mapping_left[$id_feature][$id_feature_value_item]) && $id_feature_value == $id_feature_value_item)
                    {
                        $set = ' selected="selected"';
                    }
                    else
                    {
                        $set = '';
                    }
                    $feature_option['selected'] = $set;
                    $feature_option['value'] = $id_feature_value_item;
                    $feature_option['desc'] = addslashes($featureItem['value']);
                    $feature_saved['select_options'][] = $feature_option;
                }

                $feature_saved['display_del'] = $index == 0 ? 'display:none' : '';
                $feature_saved['display_add'] = $index > 0 ? 'display:none' : '';
                $feature_saved['mapping_pm'] = ($featureValue !== false && isset($features_mapping_right[$id_feature]) && isset($features_mapping_right[$id_feature][$id_feature_value]) ? $features_mapping_right[$id_feature][$id_feature_value] : '');
                $feature_saved['mapping_pm_selected'] = $index == 0 ? ' disabled="disabled"' : '';

                $index++;
                $feature_arr['saved'][] = $feature_saved;
            }
            $view_params['features'][] = $feature_arr;
        }

        //
        // Categories to gender mapping

        if ($this->_categories == null)
        {
            $categories = Category::getCategories(intval($this->id_lang), $this->onlyActivesCategories);
            $this->_categories = $categories;
        }
        else
        {
            $categories = $this->_categories;
        }
        $index = array();

        $profiles_settings = unserialize(base64_decode(self::configurationGet('PM_PROFILES')));
        $selected_categories = array();

        // Display only selected categories selected in the profiles
        if ($profiles_settings)
        {
            foreach ($profiles_settings as $profiles)
            {
                if ($profiles)
                {
                    foreach ($profiles as $profile)
                    {
                        if ($profile['categories'])
                        {
                            foreach ($profile['categories'] as $id_category)
                            {
                                $selected_categories[$id_category] = true;
                            }
                        }
                    }
                }
            }
        }
        $gender_categories = array();

        foreach ($categories as $key => $category)
        {
            foreach ($category as $key2 => $category_info)
            {
                if (isset($selected_categories[$category_info['infos']['id_category']]))
                {
                    $gender_categories[] = array_shift($category_info);
                }
            }
        }
        $default_gender_mapping = unserialize(base64_decode(self::configurationGet('PM_FASHION_GENDER')));
        $default_audience_mapping = unserialize(base64_decode(self::configurationGet('PM_FASHION_AUDIENCE')));
        $default_type_mapping = unserialize(base64_decode(self::configurationGet('PM_FASHION_TYPE')));

        if (count($selected_categories) && is_array($selected_categories))
        {
            $view_params['gender_categories'] = self::gender_categories($gender_categories, $default_gender_mapping, $default_audience_mapping, $default_type_mapping);
        }
        
        /*
         * debuss-a
         * Customisable Attributes List
         */
        $view_params['custom_attr_list'] = unserialize(base64_decode(self::configurationGet('PM_CUSTOM_ATTR')));

        return $view_params;
    }


    private function _filters()
    {
        $view_params = array() ;
        $view_params['selected_tab']         = $this->_selected_tab();
        $view_params['selected_tab_filters'] = $view_params['selected_tab'] == 'filters' ? 'selected' : '' ; 
        $view_params['images']               = $this->images ; 
        $view_params['url']                  = $this->url ; 

        
        $selected_manufacturers = unserialize(base64_decode(self::configurationGet('PM_FILTER_MANUFACTURERS')));
        $selected_suppliers = unserialize(base64_decode(self::configurationGet('PM_FILTER_SUPPLIERS')));
        
        // Manufacturers Filtering
        //
        $manufacturers = Manufacturer::getManufacturers(false, $this->id_lang) ;

        $filtered_manufacturers  = array() ;
        $available_manufacturers = array() ;
        
        if ( is_array($manufacturers) && count($manufacturers) )
        {
            foreach($manufacturers as $manufacturer) 
            {
                if ( is_array($selected_manufacturers) && in_array((string)$manufacturer['id_manufacturer'], $selected_manufacturers) )   continue ;
                
                $available_manufacturers[ $manufacturer['id_manufacturer'] ] = $manufacturer['name'] ; 
            }
            if ( is_array($selected_manufacturers) && count($selected_manufacturers) )
            {
                foreach($manufacturers as $manufacturer) 
                {
                    if ( is_array($selected_manufacturers) && ! in_array((string)$manufacturer['id_manufacturer'], $selected_manufacturers) )   continue ;
                    
                    $filtered_manufacturers[ $manufacturer['id_manufacturer'] ] = $manufacturer['name'] ; 
                }            
            }
        }
        $view_params['manufacturers'] = array() ;
        $view_params['manufacturers']['available'] = $available_manufacturers ;
        $view_params['manufacturers']['filtered'] = $filtered_manufacturers ;

        // Suppliers Filtering
        //
        $suppliers = Supplier::getSuppliers(false, $this->id_lang) ;
        
        $filtered_suppliers  = array() ;
        $available_suppliers = array() ;
        
        if ( is_array($suppliers) && count($suppliers) )
        {
            foreach($suppliers as $supplier) 
            {
                if ( is_array($selected_suppliers) && in_array((string)$supplier['id_supplier'], $selected_suppliers) )   continue ;
                
                $available_suppliers[ $supplier['id_supplier']  ] = $supplier['name'] ; 
            }  
            if ( is_array($selected_suppliers) && count($selected_suppliers) )
            {
                foreach($suppliers as $supplier) 
                {
                    if ( is_array($selected_suppliers) && ! in_array((string)$supplier['id_supplier'], $selected_suppliers) )   continue ;

                    $filtered_suppliers[ $supplier['id_supplier'] ] = $supplier['name'] ; 
                }            
            }
        }
        $view_params['suppliers'] = array() ;
        $view_params['suppliers']['available'] = $available_suppliers ;
        $view_params['suppliers']['filtered'] = $filtered_suppliers ;
        
        return($view_params) ;
    }    
        
    private function _cron()
    {
        // no more other countries than France
        $id_lang = Language::getIdByIso('fr') ;
        //French might not be set as language for the shop...
        if(!$id_lang){
            $default_lang = Language::getLanguages(true);
            $id_lang = ( count($default_lang)>0) ? $default_lang[0]['id_lang']: 1 ;
        }
        $pmTokens = unserialize(base64_decode(self::configurationGet('PM_CRON_TOKEN')));
        $token = isset($pmTokens[$id_lang]) ? $pmTokens[$id_lang] : null ;
        
        $view_params = array() ;
        $context_key = PM_Context::getKey(Validate::isLoadedObject($this->context->shop) ? $this->context->shop : NULL);
        
        if ( $token )
        {
            $view_params['accept_url'] = PSPM_Tools::getHttpHost(true, true) . __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->name . '/functions/orders.php?action=accept&cron=1&lang=fr&pm_token=' . $token . '&context_key=' . $context_key;
            $view_params['import_url'] = PSPM_Tools::getHttpHost(true, true) . __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->name . '/functions/orders.php?action=import&cron=1&lang=fr&pm_token=' . $token . '&context_key=' . $context_key;                
            $view_params['create_url'] = PSPM_Tools::getHttpHost(true, true) . __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->name . '/functions/productexport.php?action=cron&cron=1&lang=fr&pm_token=' . $token . '&context_key=' . $context_key;
            $view_params['synch_url']  = PSPM_Tools::getHttpHost(true, true) . __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->name . '/functions/productexport.php?action=cron&cron=1&lang=fr&update=1&pm_token=' . $token . '&context_key=' . $context_key;
        }
        else
        {
            $view_params['accept_url'] = $this->l('Your module is not yet configured !') ;
            $view_params['import_url'] = $this->l('Your module is not yet configured !') ;
            $view_params['create_url'] = $this->l('Your module is not yet configured !') ;
            $view_params['synch_url']  = $this->l('Your module is not yet configured !') ;
        }
        return($view_params) ;
    }

    // Display category tree
    //
	public function recurseCategoryForInclude($indexedCategories, $categories, $current, $id_category = 1, $id_category_default = NULL, $default_categories = array(), $default_formulas = array(), $default_mappings = array())
    {
        global $done;
        static $irow;
        global $chtml;
        $chtml = isset($chtml) ? $chtml : null;

        if (is_array($default_categories) && in_array($id_category, $default_categories))
            $checked = ' checked="checked"';
        else
            $checked = '';

        if (!isset($done[$current['infos']['id_parent']]))
            $done[$current['infos']['id_parent']] = 0;
        $done[$current['infos']['id_parent']] += 1;

        if (isset($current['infos']['id_parent']))
            $todo = sizeof($categories[$current['infos']['id_parent']]);
        else
            $todo = null;
        $doneC = $done[$current['infos']['id_parent']];

        $level = $current['infos']['level_depth'] + 1;
        $img = $level == 1 ? 'lv1.gif' : 'lv' . $level . '_' . ($todo == $doneC ? 'f' : 'b') . '.gif';

        if (is_array($default_formulas) && count($default_formulas) && isset($default_formulas[$id_category]))
            $default_formula = $default_formulas[$id_category];
        else
            $default_formula = '';

        if (is_array($default_mappings) && count($default_mappings) && isset($default_mappings[$id_category]))
            $default_mapping = $default_mappings[$id_category];
        else
            $default_mapping = '';


        $chtml .= '
		<tr class="cat-line' . ($irow++ % 2 ? ' alt_row' : '') . '">
		<td>
		' . $id_category . '
		</td>
		<td style="cursor:pointer">
		<img src="' . $this->images . $img . '" alt="" /> &nbsp;<label for="categoryBox_' . $id_category . '" class="t">' . stripslashes($current['infos']['name']) . '</label>
		</td>
		<td>
		<input type="text" name="categories_mapping[' . $id_category . ']" value="' . $default_mapping . '" style="margin-right:10px;width:180px" />
		</td>
		<td>
		<input type="text" name="categories_formulas[' . $id_category . ']" value="' . $default_formula . '" style="margin-right:35px" />
		</td>
		</tr>';

        if (isset($categories[$id_category]))
        {
            foreach ($categories[$id_category] AS $key => $row)
                if ($key != 'infos')
                    self::recurseCategoryForInclude($indexedCategories, $categories, $categories[$id_category][$key], $key, $id_category_default, $default_categories, $default_formulas, $default_mappings);
        }

        return($chtml);
    }

    // Display category tree for Gender
    //
    public function gender_categories($categories, $default_mappings_g = array(), $default_mappings_a = array(), $default_mappings_t = array())
    {
        static $irow;
        $ghtml = '';

        require_once($this->path . 'classes/PSPM_Tools.class.php');

        if ($categories)
            foreach ($categories as $category)
            {
                if (!isset($category['id_category']) || $category['id_category'] == 1)
                    continue;

                $id_category = $category['id_category'];

                $options_g = array();
                $options_g[] = '<option></option>';
                $options_g[] = '<option value="1"' . (isset($default_mappings_g[$id_category]) && $default_mappings_g[$id_category] == '1' ? 'selected="selected" ' : '') . '>' . $this->l('Man') . '</option>' . "\n";
                $options_g[] = '<option value="2"' . (isset($default_mappings_g[$id_category]) && $default_mappings_g[$id_category] == '2' ? 'selected="selected" ' : '') . '>' . $this->l('Woman') . '</option>' . "\n";
                $options_g[] = '<option value="3"' . (isset($default_mappings_g[$id_category]) && $default_mappings_g[$id_category] == '3' ? 'selected="selected" ' : '') . '>' . $this->l('Baby Boy') . '</option>' . "\n";
                $options_g[] = '<option value="4"' . (isset($default_mappings_g[$id_category]) && $default_mappings_g[$id_category] == '4' ? 'selected="selected" ' : '') . '>' . $this->l('Baby Girl') . '</option>' . "\n";
                $options_g[] = '<option value="5"' . (isset($default_mappings_g[$id_category]) && $default_mappings_g[$id_category] == '5' ? 'selected="selected" ' : '') . '>' . $this->l('Boy') . '</option>' . "\n";
                $options_g[] = '<option value="6"' . (isset($default_mappings_g[$id_category]) && $default_mappings_g[$id_category] == '6' ? 'selected="selected" ' : '') . '>' . $this->l('Girl') . '</option>' . "\n";
                $options_g[] = '<option value="7"' . (isset($default_mappings_g[$id_category]) && $default_mappings_g[$id_category] == '7' ? 'selected="selected" ' : '') . '>' . $this->l('Child (Mixed)') . '</option>' . "\n";
                $options_g[] = '<option value="8"' . (isset($default_mappings_g[$id_category]) && $default_mappings_g[$id_category] == '8' ? 'selected="selected" ' : '') . '>' . $this->l('Baby (Mixed)') . '</option>' . "\n";
                $options_g[] = '<option value="9"' . (isset($default_mappings_g[$id_category]) && $default_mappings_g[$id_category] == '9' ? 'selected="selected" ' : '') . '>' . $this->l('Pregnant') . '</option>' . "\n";
                $options_g[] = '<option value="10"' . (isset($default_mappings_g[$id_category]) && $default_mappings_g[$id_category] == '10' ? 'selected="selected" ' : '') . '>' . $this->l('Mixed (Adult)') . '</option>' . "\n";
                $options_g[] = '<option value="0">----------------</option>' . "\n";
                $options_g[] = '<option value="11"' . (isset($default_mappings_g[$id_category]) && $default_mappings_g[$id_category] == '11' ? 'selected="selected" ' : '') . '>' . $this->l('Teenager') . '</option>' . "\n";
                $options_g[] = '<option value="12"' . (isset($default_mappings_g[$id_category]) && $default_mappings_g[$id_category] == '12' ? 'selected="selected" ' : '') . '>' . $this->l('Adult') . '</option>' . "\n";
                $options_g[] = '<option value="13"' . (isset($default_mappings_g[$id_category]) && $default_mappings_g[$id_category] == '13' ? 'selected="selected" ' : '') . '>' . $this->l('Child') . '</option>' . "\n";
                $options_g[] = '<option value="14"' . (isset($default_mappings_g[$id_category]) && $default_mappings_g[$id_category] == '14' ? 'selected="selected" ' : '') . '>' . $this->l('Family') . '</option>' . "\n";
                $options_g[] = '<option value="15"' . (isset($default_mappings_g[$id_category]) && $default_mappings_g[$id_category] == '15' ? 'selected="selected" ' : '') . '>' . $this->l('First Age') . '</option>' . "\n";

                $options_a = array();
                $options_a[] = '<option></option>';
                $options_a[] = '<option value="1"' . (isset($default_mappings_a[$id_category]) && $default_mappings_a[$id_category] == '1' ? 'selected="selected" ' : '') . '>' . $this->l('Man') . '</option>' . "\n";
                $options_a[] = '<option value="2"' . (isset($default_mappings_a[$id_category]) && $default_mappings_a[$id_category] == '2' ? 'selected="selected" ' : '') . '>' . $this->l('Woman') . '</option>' . "\n";
                $options_a[] = '<option value="3"' . (isset($default_mappings_a[$id_category]) && $default_mappings_a[$id_category] == '3' ? 'selected="selected" ' : '') . '>' . $this->l('Mixed') . '</option>' . "\n";
                $options_a[] = '<option value="0">----------------</option>' . "\n";
                $options_a[] = '<option value="4"' . (isset($default_mappings_a[$id_category]) && $default_mappings_a[$id_category] == '4' ? 'selected="selected" ' : '') . '>' . $this->l('Girl') . '</option>' . "\n";
                $options_a[] = '<option value="5"' . (isset($default_mappings_a[$id_category]) && $default_mappings_a[$id_category] == '5' ? 'selected="selected" ' : '') . '>' . $this->l('Boy') . '</option>' . "\n";
                ;
                $ghtml .= '
			<tr class="cat-line' . ($irow++ % 2 ? ' alt_row' : '') . '">
			<td style="cursor:pointer">
			&nbsp;<label for="category_' . $id_category . '" class="t">' . PSPM_Tools::cPath($id_category) . '</label>
			</td>
                        <td>
                        <input name="fashion_type[' . $id_category . ']" value="' . (isset($default_mappings_t[$id_category]) ? $default_mappings_t[$id_category] : '') . '"/>' . "\n" . '
                        </td>
			<td>
			<select name="fashion_gender[' . $id_category . ']" >' . "\n";
                if ($options_g)
                    foreach ($options_g as $option)
                        $ghtml .= $option . "\n";
                $ghtml .= '
			</select>
			</td>
			<td>
			<select name="fashion_audience[' . $id_category . ']" >' . "\n";
                if ($options_a)
                    foreach ($options_a as $option)
                        $ghtml .= $option . "\n";
                $ghtml .= '
			</select>
			</td>
			</tr>';
            }


        return($ghtml);
    }

    //
    // Hook Update Order - Notify the customer with the shipping number if exists
    //
    public function hookActionOrderStatusUpdate($params)
    {
        require_once(_PS_MODULE_DIR_ . $this->name . '/classes/PSPM_Order.class.php');
        require_once(_PS_MODULE_DIR_ . $this->name . '/classes/PSPM_Tools.class.php');

        $id_order = intval($params['id_order']);

        if (!($order = new PSPM_Order($id_order)))
            return(false);

        if ( ! Validate::isLoadedObject($order) )
            return(false) ;
        
        // Not a price minister order
        //
        if ($order->module != $this->name)
            return;

        // Config
        //
        $sentstate = base64_decode(self::configurationGet('PM_SENTSTATE'));
        $id_lang = intval($order->id_lang);

        $lang = Language::getIsoById($id_lang);

        // Matching Order Status
        //
        if ($params['newOrderStatus']->id != $sentstate)
            return(false);

        // Test & Debug
        $test_mode = unserialize(base64_decode(PriceMinister::configurationGet('PM_TEST')));
        $pm_debug = unserialize(base64_decode(PriceMinister::configurationGet('PM_DEBUG')));

        if ( isset($pm_debug[PriceMinister::$id_lang_default]) && $pm_debug[PriceMinister::$id_lang_default] ||  isset($pm_debug[$id_lang]) && $pm_debug[$id_lang] )
            $debug = true ;
        else
            $debug = false ;
        
        $address = new Address($order->id_address_delivery);
        $trackingNumber = null;

        if (isset($order->shipping_number) && !empty($order->shipping_number))
            $trackingNumber = $order->shipping_number;
        elseif (($shipping_number = Tools::getValue('shipping_number')) && !empty($shipping_number))
            $trackingNumber = $shipping_number;

        // Shipping empty
        //
        if (empty($trackingNumber) || empty($order->marketPlaceShipping))
        {
            if ( $debug )
                die(sprintf("%s(%d): Debug Mode On: Tracking Number is empty", basename(__FILE__), __LINE__)) ;
            return(false);
        }

        // Get item list
        //
        $ordered_items = $order->getMarketplaceItem();

        if (!$ordered_items)
        {
            if ( $debug )
                die(sprintf("%s(%d): Debug Mode On: Ordered item list is empty", basename(__FILE__), __LINE__)) ;            
            return(false);
        }
        // Shipping Matrix
        //
        $shipping_methods = unserialize(base64_decode(PriceMinister::configurationGet('PM_SHIPPING_METHODS')));
        $pm_carriers = unserialize(base64_decode(PriceMinister::configurationGet('PM_PM_CARRIERS')));
        $ps_carriers = unserialize(base64_decode(PriceMinister::configurationGet('PM_PS_CARRIERS')));

        if (isset($shipping_methods[$lang]) && isset($pm_carriers[$lang]) && isset($ps_carriers[$lang]))
        {
            $shipping_methods = $shipping_methods[$lang];
            $pm_carriers = $pm_carriers[$lang];
            $ps_carriers = $ps_carriers[$lang];
        }
        else
        {
            if ( $debug )
                die(sprintf("%s(%d): Debug Mode On: Shipping Matrix is not configured for this order (%d)", basename(__FILE__), __LINE__, $order->id )) ;                    
            return(false);
        }

        if (!isset($pm_carriers[$order->marketPlaceShipping]) || !$pm_carriers[$order->marketPlaceShipping])
        {
            if ( $debug )
                die(sprintf("%s(%d): Debug Mode On: No associated carrier for this order (%d)", basename(__FILE__), __LINE__, $order->id )) ;                                
            return(false);
        }

        $carrier = new Carrier((int) $ps_carriers[$order->marketPlaceShipping]);

        if (!Validate::isLoadedObject($carrier))
        {
            if ( $debug )
                die(sprintf("%s(%d): Debug Mode On: Unable to load carrier for this order (%s/%d)", basename(__FILE__), __LINE__, $ps_carriers[$order->marketPlaceShipping], $order->id )) ;                                            
            return(false);
        }
        $trackingUrl = str_replace('@', $trackingNumber, $carrier->url);

        // PM Configuration
        //
        $config = PSPM_Tools::Auth($lang);

        if (!is_array($config))
        {
            if ( $debug )
                die(sprintf("%s(%d): Debug Mode On: Module is not enough configured", basename(__FILE__), __LINE__)) ;                                                        
            return(false);
        }

        // Orders Output Settings
        //
        $config['output_type'] = 'juicy';
        $config['output'] = 'json';

        // PM Settings
        //
        $params = array();
        $params['field'] = '';

        require_once(_PS_MODULE_DIR_ . $this->name . '/classes/Priceminister_Webservices.class.php');
        require_once(_PS_MODULE_DIR_ . $this->name . '/classes/PM_Sales.class.php');

        $pmSales = new PM_Sales($config);

        foreach ($ordered_items as $ordered_item)
        {
            $itemid = $ordered_item['itemid'];

            // PM Settings
            //
            $params = array();
            $params['field'] = '';
            $params['itemid'] = $itemid;
            $params['transporter_name'] = $pm_carriers[$order->marketPlaceShipping];
            $params['tracking_number'] = $trackingNumber;
            $params['tracking_url'] = $trackingUrl;

            if ($test_mode[$id_lang])
            {
                if ($debug)
                {
                    echo "PriceMinister, Debug Mode On: Params: ";
                    echo nl2br(print_r($params, true));
                    die;
                }
            }
            else
            {
                $result = $pmSales->settrackingpackageinfos($params);

                if ($debug)
                {
                    echo "PriceMinister, Debug Mode On: W/S Result: ";
                    echo nl2br(print_r($result, true));
                    die;
                }
            }
        }
        return(true);
    }

    // Update date_upd on stock moves 
    //
    public function hookActionProductUpdate($params)
    {
        if (file_exists(dirname(__FILE__) . '/classes/PSPM_Product.class.php'))
            require_once(dirname(__FILE__) . '/classes/PSPM_Product.class.php');

        // Maintain compatibility accross PS releases ...
        //
        if (isset($params['product']) && is_object($params['product']))
            $id_product = intval($params['product']->id);
        elseif (isset($params['id_product']))
            $id_product = $params['id_product'];
        elseif (isset($params['product']['id_product']))
            $id_product = intval($params['product']['id_product']);

        PSPM_Product::updateProductDate($id_product);
    }

    //
    // Gestion des relations avec la MarketPlace sur la commande
    //
    public function hookDisplayAdminOrder($params)
    {
        require_once(_PS_MODULE_DIR_ . $this->name . '/classes/PSPM_Order.class.php');
        require_once(_PS_MODULE_DIR_ . $this->name . '/classes/PSPM_Tools.class.php');

        // JS
        //
        $this->_html .= '<script type="text/javascript" src="' . $this->url . 'js/order.js"></script>';
        
        require_once(dirname(__FILE__) . '/classes/PM_Context.class.php');
        $context_key = PM_Context::getKey(Validate::isLoadedObject($this->context->shop) ? $this->context->shop : NULL);
        
        if (version_compare(_PS_VERSION_, '1.6', '>='))
            $style = 'style="margin:30px;"';        
        elseif (version_compare(_PS_VERSION_, '1.5', '<'))
            $style = 'style="width:400px;margin-top:10px;"';
        else
            $style = 'style="margin-top:10px;"';

        $this->_html .= '
		<form name="pmUpdateOrder" id="pmUpdateOrder" method="post" />
		<fieldset ' . $style . '>
		<legend><img src="' . $this->images . 'logo.gif" alt="' . $this->l('Price Minister') . '">&nbsp;' . $this->l('Price Minister') . '</legend>';

        $id_order = intval($params['id_order']);

        $order = new PSPM_Order($id_order);

        // Not a price minister order
        //
        if ($order->module != $this->name)
            return;

        $pmTokens = unserialize(base64_decode(self::configurationGet('PM_CRON_TOKEN')));

        $this->_html .= '<label>' . sprintf('%s : ', $this->l('Purchase ID')) . '</label><span style="margin-left:15px;position:relative;top:2px;">';
        $this->_html .= $order->marketPlaceOrderId;
        $this->_html .= '</span><br />';

        $this->_html .= '<label>' . sprintf('%s : ', $this->l('Shipping Type')) . '</label><span style="margin-left:15px;position:relative;top:2px;">';
        $this->_html .= $order->marketPlaceShipping;
        $this->_html .= '</span><br />';

        $this->_html .= '<input type="button" class="button btn btn-default" style="margin:15px 0 0 15px;cursor:pointer" onclick="javascript:window.open(\'' . PSPM_Tools::orderPageURL($order->marketPlaceOrderId) . '\');" value="' . $this->l('Voir sur Price Minister') . '" /><br />';

        $this->_html .= '</fieldset>
		<input type="hidden" id="order_id" value="' . $order->id . '" />
		<input type="hidden" id="pm_order_id" value="' . $order->marketPlaceOrderId . '" />
		<input type="hidden" id="pm_order_lang" value="' . Language::getIsoById($order->id_lang) . '" />
		<input type="hidden" id="pm_tokens" name="pm_token[' . $order->id_lang . ']" value="' . $pmTokens[$order->id_lang] . '" />';

        $this->_html .= '</fieldset>
		<input type="hidden" id="pm_order_url" value="' . $this->url . 'functions/orders.php&context_key=' . $context_key . '" />
		</form>';

        return($this->_html);
    }

    public function hookActionCarrierUpdate($params)
    {
        $carriers = unserialize(base64_decode(self::configurationGet('PM_PS_CARRIERS')));
        
        if ( is_array($carriers) )        
        foreach ($carriers as $id_lang => $ps_carriers)
            foreach ($ps_carriers as $index => $carrier)
            {
                if ($carriers[$id_lang][$index] == $params['id_carrier'])
                    $carriers[$id_lang][$index] = $params['carrier']->id;
            }

        self::configurationUpdateValue('PM_PS_CARRIERS', base64_encode(serialize($carriers)));
    }

    // Hook for the optional module :
    // Market Place Strategies - Strategies on the products price
    // displayed on the product tab
    //
    public function hookDisplayBackOfficeHeader($params)
    {
        $html = null ;
        $isPmTab = false;
        
        if (version_compare(_PS_VERSION_, '1.5', '<'))
            $isPmTab = strtolower(Tools::getValue('tab')) == 'admincatalog' ;
        else
            $isPmTab = strtolower(Tools::getValue('controller')) == 'adminproducts' ;

        $updateproduct = (Tools::getValue('addproduct') !== false || Tools::getValue('updateproduct') !== false) && Tools::getValue('id_product') !== false ;
        
        if ( $isPmTab && $updateproduct ) 
        {  
            $html .= $this->_autoAddJS($this->url . 'js/product_extpm.js') ;
            $html .= $this->_autoAddCSS($this->url . 'css/product_ext.css') ;
        }

        
        if (version_compare(_PS_VERSION_, '1.4', '<'))
            print($html);
        else
            return($html);
    }

    /* HOOKS FOR BACKWARD COMPATIBILITY - PRESTASHOP 1.3 and 1.4 */

    public function hookUpdateCarrier($params)
    {
        return( $this->hookActionCarrierUpdate($params) );
    }

    public function hookUpdateQuantity($params)
    {
        return( $this->hookActionProductUpdate($params) );
    }

    public function hookUpdateProduct($params)
    {
        return( $this->hookActionProductUpdate($params) );
    }

    public function hookAdminOrder($params)
    {
        return( $this->hookDisplayAdminOrder($params) );
    }

    public function hookUpdateOrderStatus($params)
    {
        return( $this->hookActionOrderStatusUpdate($params) );
    }

    public function hookBackOfficeHeader($params)
    {
        return($this->hookDisplayBackOfficeHeader($params));
    }

    //
    // HOOKs SETUP for all Prestashop releases
    //
    private function _hookSetup($action)
    {
        if (version_compare(_PS_VERSION_, '1.5', '<'))
        {
            $expectedHooks =
                    array('updateQuantity', 'updateproduct', 'updateCarrier', 'adminOrder', 'backOfficeHeader', 'updateOrderStatus');
        }
        else
        {
            $expectedHooks =
                    array('displayBackOfficeHeader', 'actionCarrierUpdate', 'actionUpdateQuantity', 'actionProductUpdate', 'actionOrderStatusUpdate', 'displayAdminOrder');
        }
        $pass = true;

        if ($action == self::Add)
            foreach ($expectedHooks as $expectedHook)
                if (!$this->isRegisteredInHook($expectedHook))
                    if (!$this->registerHook($expectedHook))
                    {
                        $this->_postErrors[] = $this->l('Unable to Register Hook') . ':' . $expectedHook;
                        $pass = false;
                    }
        if ($action == self::Remove)
            foreach ($expectedHooks as $expectedHook)
                if ($this->isRegisteredInHook($expectedHook))
                    if (!$this->unregisterHook($expectedHook))
                    {
                        $this->_postErrors[] = $this->l('Unable to Unregister Hook') . ':' . $expectedHook;
                        $pass = false;
                    }

        return($pass);
    }

    // Install module tabs in native mode (PS1.2, 1.3, 1.4, 1.5)
    //
    public function _tabSetup($action)
    {
        $pass = true;
        
        // Adding Tab
        switch ($action)
        {
            case PriceMinister::Add :
                // For PS 1.5+
                if (version_compare(_PS_VERSION_, '1.5', '>='))
                {
                    if (Tab::getIdFromClassName('AdminPriceMinisterProducts') && Tab::getIdFromClassName('AdminPriceMinisterOrders'))
                        return(true);

                    if (!$this->installModuleTab('AdminPriceMinisterProducts', 'PriceMinister', 'AdminCatalog'))
                    {
                        $this->_errors[] = $this->l('Unable to install: ProductsPriceMinister');
                        $pass = false;
                    }
                    if (!$this->installModuleTab('AdminPriceMinisterOrders', 'PriceMinister', 'AdminOrders'))
                    {
                        $this->_errors[] = $this->l('Unable to install: OrdersPriceMinister');
                        $pass = false;
                    }
                }
                // For PS < 1.5
                else
                {
                    if (Tab::getIdFromClassName('PriceMinisterProduct') && Tab::getIdFromClassName('PriceMinisterOrder'))
                        return(true);

                    if (!$this->installModuleTab('PriceMinisterProduct', 'PriceMinister', 'AdminCatalog'))
                    {
                        $this->_errors[] = $this->l('Unable to install: PriceMinisterProduct');
                        $pass = false;
                    }
                    if (!$this->installModuleTab('PriceMinisterOrder', 'PriceMinister', 'AdminOrders'))
                    {
                        $this->_errors[] = $this->l('Unable to install: OrdersPriceMinister');
                        $pass = false;
                    }
                }
                break;
            case PriceMinister::Update :
                if (version_compare(_PS_VERSION_, '1.5', '>='))
                {
                    // Removing Old AdminTabs
                    //
                    if (Tab::getIdFromClassName('PriceMinisterProduct') && Tab::getIdFromClassName('PriceMinisterOrder'))
                    {
                        if (!$this->uninstallModuleTab('PriceMinisterProduct'))
                        {
                            $this->_errors[] = $this->l('Unable to uninstall: PriceMinisterProduct Tab');
                            $pass = false;
                        }
                        if (!$this->uninstallModuleTab('PriceMinisterOrder'))
                        {
                            $this->_errors[] = $this->l('Unable to uninstall: PriceMinisterOrder Tab');
                            $pass = false;
                        }
                    }
                    // Adding New 
                    $pass = $this->_tabSetup(PriceMinister::Add);
                }
                break;
            case PriceMinister::Remove :
                // Removing New AdminTabs
                //
                if (Tab::getIdFromClassName('AdminPriceMinisterProducts'))
                {
                    if (!$this->uninstallModuleTab('AdminPriceMinisterProducts'))
                    {
                        $this->_errors[] = $this->l('Unable to uninstall: AdminPriceMinisterProducts Tab');
                        $pass = false;
                    }
                }
                if (Tab::getIdFromClassName('AdminPriceMinisterOrders'))
                {
                    if (!$this->uninstallModuleTab('AdminPriceMinisterOrders'))
                    {
                        $this->_errors[] = $this->l('Unable to uninstall: AdminPriceMinisterOrders Tab');
                        $pass = false;
                    }
                }
                if (Tab::getIdFromClassName('PriceMinisterProduct'))
                {
                    if (!$this->uninstallModuleTab('PriceMinisterProduct'))
                    {
                        $this->_errors[] = $this->l('Unable to uninstall: PriceMinisterProduct Tab');
                        $pass = false;
                    }
                }
                if (Tab::getIdFromClassName('PriceMinisterOrder'))
                {
                    if (!$this->uninstallModuleTab('PriceMinisterOrder'))
                    {
                        $this->_errors[] = $this->l('Unable to uninstall: PriceMinisterOrder Tab');
                        $pass = false;
                    }
                }
                break;
        }

        return $pass;
    }
    
    // Add Custom Tables
    //
    private function _installTables()
    {
        $pass = true;
        $errors = null ;

        // Check if exists
        //
        $tables = array();
        $query = Db::getInstance()->ExecuteS('show tables');
        foreach ($query as $rows)
            foreach ($rows as $table)
                $tables[$table] = 1;

        if (!isset($tables[_DB_PREFIX_ . 'priceminister_product_ordered']))
        {
            $sql = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'priceminister_product_ordered` (
                        `id_order` INT NOT NULL ,
                        `id_product` INT NULL DEFAULT NULL,
                        `id_product_attribute` INT NULL DEFAULT NULL ,
                        `itemid` INT NULL DEFAULT NULL
                            ) ;';

            if (!Db::getInstance()->Execute($sql))
            {
                $errors .= 'ERROR: ' . $sql ;
                $pass = false;
            }
        }

        if (isset($tables[_DB_PREFIX_ . 'priceminister_product_option']))
        {
            $pass = true;
            $sqls = array();

            $fields = array();

            // Price Minister Update - Add new fields
            //
            $query = Db::getInstance()->ExecuteS('show columns from `' . _DB_PREFIX_ . 'priceminister_product_option`');
            foreach ($query as $row)
                $fields[$row['Field']] = 1;

            // For 1st Update
            //
            if (!isset($fields['disable']))
                $sqls[] = 'ALTER TABLE  `' . _DB_PREFIX_ . 'priceminister_product_option` ADD  `disable` TINYINT NULL DEFAULT NULL AFTER `force`';
            if (!isset($fields['price']))
                $sqls[] = 'ALTER TABLE  `' . _DB_PREFIX_ . 'priceminister_product_option` ADD  `price` FLOAT NULL DEFAULT NULL AFTER `disable`';
            if (!isset($fields['text']))
                $sqls[] = 'ALTER TABLE  `' . _DB_PREFIX_ . 'priceminister_product_option` ADD  `text` VARCHAR(128) NULL DEFAULT NULL AFTER `price`';

            // For Next updates
            //
            if (isset($fields['disable']))
                $sqls[] = 'ALTER TABLE  `' . _DB_PREFIX_ . 'priceminister_product_option` CHANGE  `disable`  `disable` TINYINT NULL DEFAULT NULL';
            if (isset($fields['force']))
                $sqls[] = 'ALTER TABLE  `' . _DB_PREFIX_ . 'priceminister_product_option` CHANGE  `force`  `force` TINYINT NULL DEFAULT NULL';
            if (isset($fields['text']))
                $sqls[] = 'ALTER TABLE  `' . _DB_PREFIX_ . 'priceminister_product_option` CHANGE  `text`  `text` VARCHAR(128) NULL DEFAULT NULL';

            foreach ($sqls as $sql)
                if (!Db::getInstance()->Execute($sql))
                {
                    $errors .= 'ERROR: ' . $sql ;
                    $pass = false;
                }                    
        }
        else
        {
            $sql = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'priceminister_product_option` (
                    `id_product` INT NOT NULL ,
                    `id_lang` INT NOT NULL ,
                    `force` TINYINT NULL DEFAULT NULL ,
                    `disable` TINYINT NULL DEFAULT NULL,
                    `price` FLOAT NULL NULL DEFAULT NULL,
                    `text` VARCHAR(128) NULL DEFAULT NULL,
                    UNIQUE KEY `id_product` (`id_product`,`id_lang`)
                            ) ;';
            
            if (!Db::getInstance()->Execute($sql))
            {
                $errors .= 'ERROR: ' . $sql ;
                $pass = false;
            }        
        }

        if ($errors)
            $this->_postErrors[] = $errors ;
        
        return($pass);
    }

    private function _removeTables()
    {
        $sql = 'DROP TABLE  `' . _DB_PREFIX_ . 'priceminister_product_option` ; ';

        return( Db::getInstance()->Execute($sql) );
    }

    // Add MarketPlace OrderID in the order table
    //
    private function _addMarketPlaceField()
    {
        $pass = true;
        $errors = null ;
        
        //
        // 1 - get existing columns
        // 2 - create the column if not exists
        // 3 - save the status of the column : existing at this time ? write in configuration to do not remove when uninstall the module
        //
		
		
        // Adding Marketplace fields - order
        //
        $fields = array();
        $query = Db::getInstance()->ExecuteS('show columns from `' . _DB_PREFIX_ . 'orders`');
        foreach ($query as $row)
            $fields[$row['Field']] = 1;

        if (!isset($fields['mp_order_id']))
        {
            $sql = 'ALTER TABLE  `' . _DB_PREFIX_ . 'orders` ADD  `mp_order_id` VARCHAR( 24 ) NULL , ADD INDEX (`mp_order_id` )' ;
            
            if (!Db::getInstance()->Execute($sql))
            {
                $errors .= 'ERROR: ' . $sql ;
                $pass = false;
            }   
        }

        // Adding Marketplace fields - status
        //
        if (!isset($fields['mp_status']))
        {
            $sql = 'ALTER TABLE  `' . _DB_PREFIX_ . 'orders` ADD  `mp_status` VARCHAR( 24 ) NULL , ADD INDEX (`mp_status` )' ;
            
            if (!Db::getInstance()->Execute($sql))
            {
                $errors .= 'ERROR: ' . $sql ;
                $pass = false;
            }  
        }

        // Adding Marketplace fields - shipping
        //
        if (!isset($fields['mp_shipping']))
        {
            $sql = 'ALTER TABLE  `' . _DB_PREFIX_ . 'orders` ADD  `mp_shipping` VARCHAR( 24 ) NULL ' ;
            
            if (!Db::getInstance()->Execute($sql))
            {
                $errors .= 'ERROR: ' . $sql ;
                $pass = false;
            }  
        }
        
        if ($errors)
            $this->_postErrors[] = $errors ;
        
        return($pass);
    }

    private function _removeMarketPlaceField()
    {
        $pass = true;
        
        return($pass) ;

        // Exists
        //
        $fields = array();
        $query = Db::getInstance()->ExecuteS('show columns from `' . _DB_PREFIX_ . 'orders`');
        foreach ($query as $row)
            $fields[$row['Field']] = 1;

        //
        // Remove field only if they doesn't exists before installing this module
        //
        $sql = 'ALTER TABLE  `' . _DB_PREFIX_ . 'orders` DROP `mp_order_id` ;';

        if (isset($fields['mp_order_id']))
            if (!Db::getInstance()->Execute($sql))
                $pass = false;

        $sql = 'ALTER TABLE  `' . _DB_PREFIX_ . 'orders` DROP `mp_status` ;';

        if (isset($fields['mp_status']))
            if (!Db::getInstance()->Execute($sql))
                $pass = false;
        $sql = 'ALTER TABLE  `' . _DB_PREFIX_ . 'orders` DROP `mp_shipping` ;';

        if (isset($fields['mp_shipping']))
            if (!Db::getInstance()->Execute($sql))
                $pass = false;

        return($pass);
    }

    //
    // Install Alt TABS
    //
    private function installModuleTab($tabClass, $tabName, $tabParent)
    {
        $pass = true;
        $tabNameLang = array();

        @copy(_PS_MODULE_DIR_ . $this->name . '/logo.gif', _PS_IMG_DIR_ . 't/' . $tabClass . '.gif');

        foreach (Language::getLanguages() as $language)
            $tabNameLang[$language['id_lang']] = $tabName;

        $tab = new Tab();
        $tab->name = $tabNameLang;
        $tab->class_name = $tabClass;
        $tab->module = $this->name;
        $tab->id_parent = Tab::getIdFromClassName($tabParent);

        // For Prestashop 1.2
        //
	if (preg_match('/^1\.[1-2]/', _PS_VERSION_))
        {
            $pass = $tab->add();
        }
        else
        {
            $pass = $tab->save();
        }
        return($pass);
    }

    private function uninstallModuleTab($tabClass)
    {
        $pass = true;
        @unlink(_PS_IMG_DIR_ . 't/' . $tabClass . '.gif');
        $idTab = Tab::getIdFromClassName($tabClass);
        if ($idTab != 0)
        {
            $tab = new Tab($idTab);
            $pass = $tab->delete();
        }
        return($pass);
    }

    // Add a customer / it will hold the market place orders
    // the customer is fake and has a random id, and random password
    //
    private function _createCustomer()
    {
        $pass = true;

        if ( ($id_customer = (int)self::configurationGet('PM_CUSTOMER_ID')) )
        {
            $customer = new Customer($id_customer);
            
            if ( Validate::isLoadedObject($customer) )
                return($customer->id) ;
        }
        
        // Fakemail
        //
        $var = explode('@', self::configurationGet('PS_SHOP_EMAIL'));
        $email = 'no-reply-' . rand(500, 9999999999) . '@' . $var[1];

        $customer = new Customer();
        $customer->firstname = 'Price Minister';
        $customer->lastname = 'Price Minister';
        $customer->email = $email;
        $customer->newsletter = false;
        $customer->optin = false;
        $customer->passwd = md5(rand(50000000, 9999999999));
        $customer->active = true;

        $pass = $customer->add();

        if ( Validate::isLoadedObject($customer) )
        {
            self::configurationUpdateValue('PM_CUSTOMER_ID', $customer->id);
            return($customer->id) ;
        }
        return($pass) ;
    }

    private function _deleteCustomer()
    {
        $customer = new Customer();
        $customer->id = self::configurationGet('PM_CUSTOMER_ID');

        return ( $customer->delete() );
    }

    // Compatibilty for configuration functions
    //
    public static function configurationGet($param)
    {
        return Configuration::get($param);
    }

    public static function configurationUpdateValue($param, $value)
    {
        return Configuration::updateValue($param, $value);
    }

}

?>