//
// $.live() not available on PS < 1.4 (jquery1.2.6)
//
$(document).ready(function() {

    if ( $.datepicker.initialized !== 'undefined' )
        $('input[id^="date-start-"]').each(function()
        {
            $('#' + $(this).attr('id') ).datepicker({
                                prevText:"",
                                nextText:"",
                                dateFormat:"yy-mm-dd"});        
        }) ;
        
    $('li[id^="menu-"]').click(function()
    {
       result = $(this).attr('id').match('^(.*)-(.*)$') ;
       lang = result[2] ;

       $('input[name=selected_tab]').val(lang) ;

       if ( ! $(this).hasClass('selected') )
       {
            $('li[id^="menu-"]').removeClass('selected') ;
            $(this).addClass('selected') ;
            $('div[id^="menudiv-"]').hide() ;
            $('div[id^="menudiv-' + lang + '"]').show() ;
       }
    });

    $('.accept-lookup').click(function()
    {
        var lang = $('.selected_tab').val() ;
        button = $(this) ;

        $('#accept-result-' + lang).append('<span class="pmloader" />') ;
        
        // Lookup for Orders
        //
        $.ajax({
        type: 'POST',
        url: $('input[name=orders_url]').val() + '?action=new-orders&lang=' + lang + '&callback=?',
        data: $('input[name^="pm_token"]').serialize() + '&context_key=' + $('input[name=context_key]').val(),
        dataType:'json',
        success: function(data) {
                $('#accept-result-' + lang).html('') ;

                if ( data.count )
                {
                  DisplayDetails(data.orders, data.count, 'accept') ;
                  AcceptOrderHandler(data.orders, button) ;
                }

                $('#accept-result-' + lang).append('<span class="output-' + lang + ' success">' + data.output + '</span>') ;
                removeMsgs() ;

            },
        error: function(data) {
                $('.pmloader').remove() ;
                $('.output-' + lang).remove() ;
                $('#accept-result').append( '<span class="error">' + $('input[name=text_ajax_error]').val() + '</span>') ;
                removeMsgs() ;
            }
        });

    });

    //
    // Transform Lookup Button to Accept Button
    //
    function AcceptOrderHandler(orders, button)
    {
        var lang = $('input[name=selected_tab]').val() ;

        // Select All checkboxes
        //
        $('.accept-table .select-all').click(function() {
              $('.accept-table .order-item').each(function() {
                if( $(this).attr('checked') )
                      $(this).attr('checked', false) ;
                else
                    if ( ! $(this).attr('disabled') )
                      $(this).attr('checked', 'checked') ;
              });
        });

        button.unbind('click') ;

        // Change name of button
        //
        button.val( $('input[name=button_accept_orders]').val() ) ;

        // Become Import button
        //
        button.click(function()
        {
            var lang = $('input[name=selected_tab]').val() ;
            var button = $(this);
            type = 'accept' ;
            
            // Import Orders
            //
            $.ajax({
            type: 'POST',
            url: $('input[name=orders_url]').val() + '?action=accept&lang=' + lang + '&callback=?',
            data: $('input[name^="pm_token"]').serialize() + '&' + $('input[type=checkbox]').serialize() + '&context_key=' + $('input[name=context_key]').val() + '&orders=' +  encodeURIComponent(JSON.stringify(orders)), // jQuery.parseJSON( orders ),
            dataType:'json',
            beforeSend:
            function(data) {
                  $('#accept-result-' + lang).append('<span class="pmloader" />') ;
                  button.remove() ;
                },
            success: function(data) {
                    $('#accept-result-' + lang).children().remove();

                    if ( data.error )
                    {
                      $(data.errors).each(function(e, error) {
                        $('#accept-result-' + lang).append( '<span class="error">' + error + '</span>') ;
                      });
                    }

                    if ( data.orders )
                    {
                        $('#accept-result-' + lang).append('<span class="output-' + lang + ' success" style="width:95%">' + data.output + '</span>') ;

                        $.each(data.orders.sales, function(o,order){
                            $('#O-' + type + '-' + order.purchaseid).find('input[type=checkbox]').attr('disabled', 'disabled') ;
                            $('#P-' + type + '-' + order.purchaseid).find('input[type=checkbox]').attr('disabled', 'disabled') ;

                            if ( order.checked )
                            {
                                $('#O-' + order.purchaseid).removeClass('orderl').addClass('imported');
                            }
                            else
                            {
                                $('#O-' + type + '-' + order.purchaseid).removeClass('orderl').addClass('import-error');
                            }

                        });

                    }
                    removeMsgs() ;
                },
            error: function(data) {
                    $('#accept-result-' + lang).children().remove();
                    $('#accept-result-' + lang).append( '<span class="error">' + $('input[name=text_ajax_error]').val() + '</span>') ;
                    removeMsgs() ;
                }
            });

        });

    }


    // Display Orders
    //
    function DisplayDetails(orders, count, type)
    {
       var lang = $('input[name=selected_tab]').val() ;

        $('#' + type + '-table-fr tr:gt(1)').remove() ;
        
        if ( count == 1 )
        {
           DisplayOrderLine(orders.sales.sale, type);
        }
        else
        {
           $.each(orders.sales.sale, function(s,sale){
                DisplayOrderLine(sale, type);
            });
        }

    }

    function DisplayOrderLine(sale, type)
    {
            var target = null ;
            var lang = $('input[name=selected_tab]').val() ;

            if ( console )
                console.log(sale)
                
            if ( typeof(sale.deliveryinformation.deliveryaddress) == 'undefined' && typeof(sale.deliveryinformation.billingaddress) == 'undefined' )
                return ;

            if (  typeof(sale.deliveryinformation.deliveryaddress) != 'object' )
                sale.deliveryinformation.deliveryaddress = sale.deliveryinformation.billingaddress ;
            
            statusl = '' ;
            checked = 'checked ' ;

            if ( sale.imported ) 
            {
                statusl ='disabled' ;
                checked = '' ;
            }
            
            html =
              '<tr id="O-'+ type + '-' + sale.purchaseid +'" class="orderl" rel="'+ sale.purchaseid +'">'
                    +'<td><input type="checkbox" value="'+ sale.purchaseid +'" class="order-item" name="selected[]" ' + checked + statusl + '/></td>'
                    +'<td>'+sale.purchaseid+'</td>'
                    +'<td>'+sale.purchasedate+'</td>'
                    +'<td>'+capitalise(sale.deliveryinformation.deliveryaddress.firstname)+' '+capitalise(sale.deliveryinformation.deliveryaddress.lastname) + '</td>'
                    +'<td>'+sale.deliveryinformation.deliveryaddress.zipcode+'</td>'
                    +'<td>'+sale.deliveryinformation.deliveryaddress.city.toUpperCase()+'</td>'
                    +'<td>'+sale.deliveryinformation.shippingtype+'</td>'
                    +'</tr>'
                    +'<tr><td>&nbsp;</td><td colspan="6" id="P-' + type + '-' + sale.purchaseid+'"></td></tr>'
                   ;

            $('#' + type + '-table-' + lang + ' tr.orderl:first').after(html);

            target = $('#P-' + type + '-' + sale.purchaseid) ;
            target.html('');

            cloned = $('#' + type + '-product-table-' + lang).clone().appendTo(target).show() ;
            cloned.attr('id', '') ;

            // Order Checkbox/Table Trigger
            //
            $('#O-' + type + '-' + sale.purchaseid).click(function(event) {
                checkbox = $(this).find('.order-item') ;

                if (event.target.type !== 'checkbox')
                    $(checkbox, this).trigger('click');
            });


            $.each(sale.items, function(i,item){
              itemTable = '#P-' + type + '-' + sale.purchaseid ;

              // Un ou plusieurs produits
              //
              if ( item.length >= 1 )
              {
                $.each(item, function(i,product){
                DisplayProducts(product, itemTable, sale.purchaseid, type, statusl) ;
                });
              }
              else
              {
                DisplayProducts(item, itemTable, sale.purchaseid, type, statusl) ;
              }
            });

    }

    // Display Ordered Products
    //
    function DisplayProducts(product, itemTable, purchaseid, type, statusl)
    {
        var lang = $('input[name=selected_tab]').val() ;

        if ( statusl.length )
            checked = ''  ;
        else
            checked = 'checked ' ;
        
        
        if( type == 'import' )
        {
            if ( product.itemstatus != 'ACCEPTED' || product.paymentstatus != 'INCOMING' ) 
            {
                statusl ='disabled' ;
                checked = '' ;
            }
        }

        html =
              '<tr class="imported-item" id="PI-' + type + '-' + product.itemid + '">'
                    +'<td><input type="checkbox" value="'+purchaseid+'_'+product.itemid+'" class="product-item" name="products[]" ' + statusl + checked + '/></td>'
                    +'<td>'+product.itemid+'</td>'
                    +'<td>'+product.sku+'</td>'
                    +'<td>'+product.headline+'</td>'
                    +'<td>'+product.itemshippingcostprice.amount+'</td>'
                    +'<td>'+product.itemshippingcostprice.currency+'</td>'
                    +'<td>'+product.paymentstatus+'</td>'
                    +'<td>'+product.itemstatus+'</td>'
                    +'<td class="right">'+product.price.amount+'</td>'
      				+'<td>'+product.price.currency+'</td>'

                    +'</tr>'
                   ;

        $(itemTable + ' tr:last').after(html);

        // Product Checkbox/Table Trigger
        //
        $('#PI-'+ type + '-' + product.itemid).click(function(event) {
            checkbox = $(this).find('.product-item') ;

            if (event.target.type !== 'checkbox')
                $(checkbox, this).trigger('click');
        });
    }


    /*
     * Import Orders
     */
    $('.import-lookup').click(function()
    {
        var lang = $('.selected_tab').val() ;
        button = $(this) ;
        
        $('#import-result-' + lang).append('<span class="pmloader" />') ;

        pAjax = new Object() ;
        pAjax.type       = 'POST' ;
        pAjax.url        = $('input[name=orders_url]').val() + '?action=list-orders&lang=' + lang + '&callback=?' ;
        pAjax.data       = $('input[name^="pm_token"]').serialize() + '&context_key=' + $('input[name=context_key]').val() + '&' + $('input[name^="date-start"]').serialize() ;
        pAjax.data_type  = 'json' ;

        if ( window.console )
            console.log(pAjax) ;        
        
        // Lookup for Orders
        //
        $.ajax({
        type: pAjax.type,
        url: pAjax.url,
        data: pAjax.data,
        dataType: pAjax.data_type,
        success: function(data) {
                $('#import-result-' + lang).html('') ;

                if ( data.count )
                {
                  DisplayDetails(data.orders, data.count, 'import') ;
                  ImportOrderHandler(data.orders, button) ;
                }

                $('#import-result-' + lang).append('<span class="output-' + lang + ' success">' + data.output + '</span>') ;
                removeMsgs() ;

            },
        error: function(data) {
                $('.pmloader').remove() ;
                $('.output-' + lang).remove() ;
                $('#import-result-' + lang).addClass('error') ;
                ManageAjaxError(pAjax, data, $('#import-result-' + lang)) ;
                removeMsgs() ;
            }
        });

    });    

    //
    // Transform Lookup Button to Accept Button
    //
    function ImportOrderHandler(orders, button)
    {
        var lang = $('input[name=selected_tab]').val() ;

        // Select All checkboxes
        //
        $('.import-table .select-all').click(function() {
              $('.accept-table .order-item').each(function() {
                if( $(this).attr('checked') )
                      $(this).attr('checked', false) ;
                else
                    if ( ! $(this).attr('disabled') )
                      $(this).attr('checked', 'checked') ;
              });
        });

        button.unbind('click') ;

        // Change name of button
        //
        button.val( $('input[name=button_import_orders]').val() ) ;

        // Become Import button
        //
        button.click(function()
        {
            var lang = $('input[name=selected_tab]').val() ;
            var button = $(this);
            type = 'import' ;

            pAjax = new Object() ;
            pAjax.type       = 'POST' ;
            pAjax.url        = $('input[name=orders_url]').val() + '?action=import&lang=' + lang + '&callback=?' ;
            pAjax.data       = $('input[name^="pm_token"]').serialize() + '&context_key=' + $('input[name=context_key]').val() + '&' + $('input[type=checkbox]').serialize() + '&orders=' +  encodeURIComponent(JSON.stringify(orders)) ;
            pAjax.data_type  = 'json' ;

            if ( window.console )
                console.log(pAjax) ;
            
            // Import Orders
            //
            $.ajax({
            type: pAjax.type,
            url: pAjax.url,
            data: pAjax.data,
            dataType: pAjax.data_type,
            beforeSend:
            function(data) {
                  $('#import-result-' + lang).html('<span class="pmloader" />')  ;
                  button.remove() ;
                },
            success: function(data) {
                    $('#import-result-' + lang).html('') ;

                    if ( data.error )
                    {
                      $(data.errors).each(function(e, error) {
                        $('#import-result-' + lang).append( '<span class="error">' + error + '</span>') ;
                      });
                    }

                    if ( data.orders )
                    {
                        $('#import-result-' + lang).append('<span class="output-' + lang + ' success" style="width:95%">' + data.output + '</span>') ;

                        $.each(data.orders.sales, function(o,order){
                         
                            $('#O-' + type + '-' + order.purchaseid).find('input[type=checkbox]').attr('disabled', 'disabled') ;
                            $('#P-' + type + '-' + order.purchaseid).find('input[type=checkbox]').attr('disabled', 'disabled') ;

                            if ( order.checked )
                            {
                                $('#O-' + type + '-' + order.purchaseid).removeClass('orderl').addClass('imported');
                            }
                            else
                            {
                                $('#O-' + type + '-' + order.purchaseid).removeClass('orderl').addClass('import-error');
                            }

                        });

                    }
                    removeMsgs() ;
                },
            error: function(data) {
                    $('#import-result-' + lang).addClass('error') ;
                    ManageAjaxError(pAjax, data, $('#import-result-' + lang)) ;
                    removeMsgs() ;
                }
            });

        });

    }
    function ManageAjaxError(aCall, data, outdiv)
    {
        if (window.console)
        {
            console.log('Ajax Error') ;
            console.log(aCall)
            console.log(data) ;
        }
        outdiv.show().html( $('input[name=text_ajax_error]').val() )

        if (data.output)
            outdiv.append('<br />' + data.output);

        if (data.responseText)
            outdiv.append('<br />' + data.responseText);
        
        outdiv.append('<hr />') ;
        outdiv.append( $('#sdebug').val() + ':  ') ; 
        
        outdiv.append('<form method="' + aCall.type + '" action="' + aCall.url + '&debug=1&' + aCall.data + '" target="_blank">' +
                      '<input type="submit" class="button btn btn-default" id="send-debug" value="Execute in Debug Mode" /></form>') ;
    }

    // http://stackoverflow.com/questions/1026069/capitalize-the-first-letter-of-string-in-javascript
    function capitalise(string)
    {
        return string.charAt(0).toUpperCase() + string.slice(1);
    }

    function removeMsgs()
    {
      return ;
      setTimeout(function()
      {
              $('span[class^=ouput]').fadeOut().remove() ;
              $('.error').fadeOut().remove() ;
      }, 4000);
    }
});
