<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: contact@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@smartmarseille.com
 * ...........................................................................
 * @package    PriceMinister
 * @copyright  Copyright (c) 2011-2014 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2014 Common Services Co Ltd (http://www.common-services.com)
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * 
 */

if ( isset($_SERVER['DropBox']) && $_SERVER['DropBox'] )
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') ) ;
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') ) ;
}
else    
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php') ;
    @require_once(dirname(__FILE__) . '/../../../init.php');
}

require_once(dirname(__FILE__) . '/../priceminister.php');

require_once(dirname(__FILE__) . '/../classes/Priceminister_Webservices.class.php');
require_once(dirname(__FILE__) . '/../classes/PM_Stock.class.php');
require_once(dirname(__FILE__) . '/../classes/PSPM_Product.class.php');
require_once(dirname(__FILE__) . '/../classes/PSPM_Tools.class.php');

class PriceMinister_Ext extends PriceMinister
{

    # Warning Don't remove construct

    public function __construct()
    {
        parent::__construct();
        
        require_once(dirname(__FILE__) . '/../classes/PM_Context.class.php');

        PM_Context::restore($this->context, Validate::isLoadedObject($this->context->shop) ? $this->context->shop : NULL) ;
    }

}

class PriceMinisterProductExport extends Module
{

    const _limit = 20000;

    private $module = 'priceminister';
    public $name = 'priceminister';
    private $_priceminister;

    public function __construct()
    {
        global $cookie, $_MODULE;

        $langFile = _PS_MODULE_DIR_ . $this->module . '/' . Language::getIsoById(intval($cookie->id_lang)) . '.php';
        $mySelf = basename(__FILE__, '.php');

        if (file_exists($langFile))
        {
            require_once $langFile;
            foreach ($_MODULE as $key => $value)
                $_MODULE[str_replace($mySelf . '_', $this->module . '_', $key)] = $value;
        }

        // Get Fields
        //
      $moduleurl = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->module . '/';

        $this->images = $moduleurl . 'images/';
        $this->moduleurl = $moduleurl;

        $this->_priceminister = new PriceMinister();

        parent::__construct();
    }

    public function l($string, $specific = false, $id_lang = null)
    {
        return( $this->_priceminister->l($string, $specific = false, $id_lang = null) );
    }

    public function Dispatch()
    {
        if (version_compare(_PS_VERSION_, '1.5', '<'))
            $configItem = PriceMinister::configurationGet('PM_TEST');
        else
            $configItem = PriceMinister::configurationGet('PM_TEST');

        $this->_test_mode = unserialize(base64_decode($configItem));

        $pm_token = Tools::getValue('pm_token');
        $callback = Tools::getValue('callback');
        $lang = Tools::getValue('lang');
        $id_lang = Language::getIdByIso($lang);
        //  Check Access Tokens
        //

        $pmTokens = unserialize(base64_decode($configItem));
        //  Check Access Tokens
        //
        if (version_compare(_PS_VERSION_, '1.5', '<'))
            $configItem = PriceMinister::configurationGet('PM_CRON_TOKEN');
        else
            $configItem = PriceMinister::configurationGet('PM_CRON_TOKEN');

        $pmTokens = unserialize(base64_decode($configItem));

        if (is_array($pm_token))
            $pm_token = $pm_token[$id_lang];

        if (!isset($pmTokens[$id_lang]) || $pmTokens[$id_lang] != $pm_token)
        {
            echo $this->l('Wrong Token');

            $some_output = ob_get_clean();

            $json = PSPM_Tools::jsonEncode(array('orders' => 0, 'count' => 0, 'error' => false, 'errors' => array($some_output), 'outputs' => $some_output));

            // jQuery Output or PHP Output
            //
            if ($callback) // jquery
            {
                echo strval($callback) . '(' . $json . ')';
                die;
            }
            else // cron
            {
                echo $json;
                die;
            }
        }

        switch (Tools::getValue('action'))
        {
            case 'export' :
                $this->Exports();
                break;
            case 'synchronize' :
                $this->Exports(true);
                break;
            case 'cron' :
                $this->Batch();
                break;
            case 'default' :
                if (Tools::getValue('cron'))
                    $this->Batch();
                break;
        }
    }

    public function ExportFile($profile, $profile_format, $categories, $synchronize = false)
    {
        global $cookie;

        $pmext = new PriceMinister_Ext();

        $id_lang = Language::getIdByIso(Tools::getValue('selected_tab') ? Tools::getValue('selected_tab') : 'fr' );

        ob_start();

        $pass = true;
        $errors = array();
        $messages = array();
        $export_products = array();
        $p = 0;

        $baseurl = 'http://' . htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8') . __PS_BASE_URI__;
        $image_baseurl = $baseurl . 'img/p/';


        $categories_formulas = unserialize(base64_decode(PriceMinister::configurationGet('PM_CATEGORIES_FORMULA')));
        $default_formulas = unserialize(base64_decode(PriceMinister::configurationGet('PM_PRICE_FORMULA')));
        $categories_campaings = unserialize(base64_decode(PriceMinister::configurationGet('PM_CATEGORIES_CAMPAIGN')));
        $categories_mappings = unserialize(base64_decode(PriceMinister::configurationGet('PM_CATEGORIES_MAPPING')));
        $categories_mappings = unserialize(base64_decode(PriceMinister::configurationGet('PM_CATEGORIES_MAPPING')));

        $comments = unserialize(base64_decode(PriceMinister::configurationGet('PM_COMMENT')));

        $outOfStocks = unserialize(base64_decode(PriceMinister::configurationGet('PM_OUT_OF_STOCK')));

        // Specials & Taxes
        //
        $specials = unserialize(base64_decode(PriceMinister::configurationGet('PM_SPECIALS')));
        $useTaxes = unserialize(base64_decode(PriceMinister::configurationGet('PM_TAXES')));

        $import_method = base64_decode(PriceMinister::configurationGet('PM_IMPORT_METHOD'));

        $update_modes = base64_decode(PriceMinister::configurationGet('PM_UPDATE_MODE'));
        $update_mode = isset($update_modes) && $update_modes ? $update_modes : 'PRICEQUANTITY';

        $safe_descriptions = PriceMinister::configurationGet('PM_SAFE_DESCRIPTIONS');
        
        $image_optionnal = PriceMinister::configurationGet('PM_IMAGE_OPTIONNAL') ;
        
        $shipping_table = unserialize(base64_decode(PriceMinister::configurationGet('PM_SHIPPING_TABLE')));
        $shipping_defaults = unserialize(base64_decode(PriceMinister::configurationGet('PM_SHIPPING_DEFAULTS')));
        
        $defaultComment = $comments[$this->_id_lang];
        $formula = $default_formulas[$this->_id_lang];
        $outOfStock = $outOfStocks[$this->_id_lang];

        $special = $specials[$this->_id_lang];
        $useTax = $useTaxes[$this->_id_lang];

        $lang = Tools::getValue('lang');

        $spain = ($lang == 'es') ? true : false;

        $limiters = Tools::getValue('limiter');

        if (isset($limiters[$lang]) && $limiters[$lang])
            $limiter = $limiters[$lang];
        else
            $limiter = null;

        $pm_debugs = unserialize(base64_decode(PriceMinister::configurationGet('PM_DEBUG')));
        $pm_debug = isset($pm_debugs[$this->_id_lang]) && $pm_debugs[$this->_id_lang];

        if (Tools::getValue('debug'))
            $pm_debug = true;

        if ($pm_debug)
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);
        }

        $conditionMap = array_flip(unserialize(base64_decode(PriceMinister::configurationGet('PM_CONDITION_MAP'))));

        $id_warehouse = (int) PriceMinister::configurationGet('PM_WAREHOUSE');
        
        $productHistory = array();

        $fashion_right = unserialize(base64_decode(PriceMinister::configurationGet('PM_ATTRIBUTES_MAPPING_R')));
        /* debuss-a */
        $custom_attr = unserialize(base64_decode(PriceMinister::configurationGet('PM_CUSTOM_ATTR')));
        /* !debuss-a */
        $features_mapping_right = unserialize(base64_decode(PriceMinister::configurationGet('PM_FEATURES_MAPPING_R')));

        $categories2genders = unserialize(base64_decode(PriceMinister::configurationGet('PM_FASHION_GENDER')));
        $categories2audiences = unserialize(base64_decode(PriceMinister::configurationGet('PM_FASHION_AUDIENCE')));
        $categories2type = unserialize(base64_decode(PriceMinister::configurationGet('PM_FASHION_TYPE')));

        $excluded_manufacturers = unserialize(base64_decode(PriceMinister::configurationGet('PM_FILTER_MANUFACTURERS')));
        $excluded_suppliers = unserialize(base64_decode(PriceMinister::configurationGet('PM_FILTER_SUPPLIERS')));

        $addressMap = unserialize(base64_decode(PriceMinister::configurationGet('PM_ADDRESS_MAP'))) ;
        
        $carrier_tax_rate = null ;
        $id_address = null ;
        
        if ( ! is_array($addressMap) || ! isset($addressMap['fr']) )
        {
            $errors[] = sprintf('%s(%s): %s', basename(__FILE__), __LINE__, $this->l('Configuration is incomplete - please save the configuration of your module...'));
            $pass = false;                 
        }
        else
        {
            $id_address = (int)$addressMap['fr'] ;
        }
        
        if ($synchronize)
            $file = dirname(__FILE__) . '/../export/' . $profile . '.sync.csv';
        else
            $file = dirname(__FILE__) . '/../export/' . $profile . '.csv';

        // Field Delimiter
        //
        switch ($profile_format['del'])
        {
            case 1 :
                $delimiter = "'";
                break;
            case 2 :
                $delimiter = '"';
                break;
            default :
                $delimiter = '';
        }

        // Create file
        //
        if (file_put_contents($file, '') === FALSE)
        {
            $errors[] = sprintf($this->l('Unable to open file %s for writing'), $file);
            $pass = false;
        }
        $count = 0;

        if ($pass)
            foreach ($categories as $id_category_export)
            {
                if ($limiter && $count > $limiter)
                    break;

                $products = PSPM_Product::getUpdateProducts($id_category_export, true, true, false);
                
                foreach ($products as $product)
                {
                    if ($limiter && $count++ > $limiter)
                        break;

                    // Anti Duplicate Entries
                    //
                    if (isset($productHistory[$product['id_product']]))
                    {
                        // duplicate
                        continue;
                    }
                    $productHistory[$product['id_product']] = true;

                    $details = new PSPM_Product($product['id_product'], false, $this->_id_lang);

                    // Filtering Manufacturer & Supplier
                    //
                    if ($details->id_manufacturer)
                    {
                        if ( is_array($excluded_manufacturers) && in_array($details->id_manufacturer, $excluded_manufacturers) )
                        {
                            continue;
                        }
                    }

                    if ($details->id_supplier)
                    {
                        if ( is_array($excluded_suppliers) && in_array($details->id_supplier, $excluded_suppliers) )
                        {
                            continue;
                        }
                    }

                    $id_category = $details->id_category_default;

                    // Products Option
                    //
                    $options = PSPM_Product::getProductOptions($details->id, $this->_id_lang);

                    $disabled = $options['disable'] ? true : false;
                    $force = $options['force'] ? true : false;
                    $text = $options['text'];

                    if (!empty($text))
                        $comment = $text;
                    else
                        $comment = $defaultComment;

                    if ($disabled)
                        continue;

                    if (!empty($options['price']) && is_numeric(floatval($options['price'])))
                        $priceOverride = floatval($options['price']);
                    else
                        $priceOverride = false;

                    $details->manufacturer_name = Manufacturer::getNameById(intval($details->id_manufacturer));
                    $details->supplier_name = Supplier::getNameById(intval($details->id_supplier));
                    $details->attributes = '';

                    if (version_compare(_PS_VERSION_, '1.5', '<'))
                        $combinations = $details->getAttributeCombinaisons($this->_id_lang);
                    else
                        $combinations = $details->getAttributeCombinations($this->_id_lang);

                    $details->attributes_long = '';
                    $details->attributes_short = '';

                    // Pas de combinaison, on en cr�e une fictive pour rentrer dans la boucle
                    //
                    if (!is_array($combinations) or empty($combinations))
                        $combinations = array(0 => array(
                                'reference' => $details->reference,
                                'price' => 0,
                                'ecotax' => $details->ecotax,
                                'quantity' => $details->quantity,
                                'ean13' => $details->ean13,
                                'id_product_attribute' => 0
                            ));

                    // Grouping Combinations
                    //
                    asort($combinations);

                    $group_details = array();

                    foreach ($combinations as $comb => $combination)
                    {
                        $id_product_attribute = isset($combination['id_product_attribute']) ? $combination['id_product_attribute'] : 0;
                        $id_attribute_group = isset($combination['id_attribute_group']) ? $combination['id_attribute_group'] : 0;
                        $id_attribute = isset($combination['id_attribute']) ? $combination['id_attribute'] : 0;

                        $group_details[$id_product_attribute][$id_attribute_group] = array();
                        $group_details[$id_product_attribute][$id_attribute_group]['reference'] = $combination['reference'];
                        $group_details[$id_product_attribute][$id_attribute_group]['price'] = 0;

                        if (!isset($group_details[$id_product_attribute][$id_attribute_group]['ecotax']))
                            $group_details[$id_product_attribute][$id_attribute_group]['ecotax'] = $combination['ecotax'];
                        $group_details[$id_product_attribute][$id_attribute_group]['ecotax'] = $combination['ecotax'];

                        if (!isset($group_details[$id_product_attribute][$id_attribute_group]['price']))
                            $group_details[$id_product_attribute][$id_attribute_group]['price'] = $combination['price'];
                        $group_details[$id_product_attribute][$id_attribute_group]['price'] = $combination['price'];


                        if (!isset($group_details[$id_product_attribute][$id_attribute_group]['quantity']))
                            $group_details[$id_product_attribute][$id_attribute_group]['quantity'] = $combination['quantity'];
                        $group_details[$id_product_attribute][$id_attribute_group]['quantity'] = $combination['quantity'];

                        // Synch Field (EAN, UPC, SKU ...)
                        //
                        $group_details[$id_product_attribute][$id_attribute_group]['ean13'] = $combination['ean13'];

                        if (isset($combination['attribute_name']))
                            $group_details[$id_product_attribute][$id_attribute_group]['attribute_name'] = $combination['attribute_name'];
                        else
                            $group_details[$id_product_attribute][$id_attribute_group]['attribute_name'] = '';

                        if (isset($combination['group_name']))
                            $group_details[$id_product_attribute][$id_attribute_group]['group_name'] = $combination['group_name'];
                        else
                            $group_details[$id_product_attribute][$id_attribute_group]['group_name'] = '';

                        if ($fashion_right && $id_attribute)
                        {
                            if (isset($fashion_right[$id_attribute_group]) && isset($fashion_right[$id_attribute_group][$id_attribute]))
                                $group_details[$id_product_attribute][$id_attribute_group]['attr_mapping'] = $fashion_right[$id_attribute_group][$id_attribute];
                        }
                    }

                    // Export Combinations or Products Alone
                    //
                    foreach ($group_details as $id_combination => $combination)
                    {
                        $details->image_url = '';
                        $details->id_product_attribute = $id_combination;
                        $group_detail = array();
                        $details->price = $details->getPrice($useTax, $details->id_product_attribute, 6, NULL, false, $special);

                        $details->attributes_long = '';
                        $details->attributes_short = '';

                        foreach ($combination as $id_group => $group_detail)
                        {
                            if ($group_detail['attribute_name'])
                                $details->attributes_short .= sprintf('%s, ', $group_detail['attribute_name']);
                            if ($group_detail['group_name'])
                                $details->attributes_long .= sprintf('%s: %s, ', $group_detail['group_name'], $group_detail['attribute_name']);
                            if (isset($group_detail['ecotax']))
                                $details->ecotax = $group_detail['ecotax'];
                            if (isset($group_detail['ean13']))
                            {
                                $details->ean13 = $group_detail['ean13'];
                                $product['ean13'] = $group_detail['ean13'];
                            }
                            if (isset($group_detail['reference']))
                            {
                                $product['reference'] = $group_detail['reference'];
                            }

                            $quantity = $group_detail['quantity'];

                            if (isset($group_detail['attr_mapping']))
                            {
                                 $fashion[$id_group] = $group_detail['attr_mapping'];
                            }

                            // In overwrite mode, skip oos or disabled products 
                            //
                        if (!$synchronize && ((!$quantity && !$force) || ($disabled || !$details->active) ))
                                continue;
                        }

                        if (version_compare(_PS_VERSION_, '1.5', '>='))
                        {
                            $quantity = Product::getRealQuantity($details->id, $details->id_product_attribute ? $details->id_product_attribute : null, $id_warehouse);
                        }
                        // PM limit
                        if ($quantity > 1000)
                            $quantity = 999;

                        $image_index = 0;

                        $images = array();
                        foreach (PSPM_Tools::getProductImages($details->id, $details->id_product_attribute, $this->_id_lang) as $image)
                            $images[] = 'http://' . htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8') . __PS_BASE_URI__ . 'img/p/' . $image;

                        $line = '';

                        if ($import_method == 'SKU' && (empty($product['reference']) || empty($details->reference)))
                        {
                            $errors[] = sprintf($this->l('Missing Reference(SKU) for Product ID: %d/%d'), $details->id, $details->id_product_attribute);
                            continue;
                        }

                        foreach ($details as $key => $value)
                            if (!isset($product[$key]))
                                $product[$key] = $value;

                        $p++;

                        // Synchro par SKU/EAN
                        //
                        if ($synchronize)
                        {

                            if ($import_method == 'ID')
                            {
                                if ($details->id_product_attribute)
                                    $sku = sprintf('%d_%d', $details->id, $details->id_product_attribute);
                                else
                                    $sku = $details->id;
                            }
                            else
                                $sku = $product['reference'];

                            if (isset($categories_formulas[$id_category]) && !empty($categories_formulas[$id_category]))
                            {
                                $productPrice = PSPM_Tools::Formula($details->getPrice($useTax, $details->id_product_attribute, 6, NULL, false, $special), $categories_formulas[$id_category]);
                            }
                            elseif (isset($formula) && !empty($formula))
                            {
                                $productPrice = PSPM_Tools::Formula($details->getPrice($useTax, $details->id_product_attribute, 6, NULL, false, $special), $formula);
                            }
                            else
                            {
                                $productPrice = $details->getPrice($useTax, $details->id_product_attribute, 6, NULL, false, $special);
                            }

                            if ($priceOverride)
                                $productPrice = $priceOverride;

                            $price = $productPrice;

                            if (isset($details->condition) && !empty($details->condition) && isset($conditionMap[$details->condition]) && !empty($conditionMap[$details->condition]))
                                $condition = $conditionMap[$details->condition];
                            else
                                $condition = 'N';

                            if ($force)
                                $quantity = 999;

                            if ($disabled)
                                $quantity = 0;

                            switch ($update_mode)
                            {
                                case 'PRICE' :
                                    $export_products[$p][0] = $sku;
                                    $export_products[$p][1] = $price;
                                    break;
                                case 'QUANTITY' :
                                    $export_products[$p][0] = $sku;
                                    $export_products[$p][1] = $quantity;
                                    break;
                                case 'FULLADVERT' :
                                    if (!$details->ean13)
                                        continue;

                                    $export_products[$p][0] = $sku;
                                    $export_products[$p][1] = $details->ean13;
                                    $export_products[$p][2] = $price;
                                    $export_products[$p][3] = $quantity;
                                    $export_products[$p][4] = $condition;
                                    $export_products[$p][5] = $comment;
                                    break;
                                default:
                                    $export_products[$p][0] = $sku;
                                    $export_products[$p][1] = $price;
                                    $export_products[$p][2] = $quantity;
                            }
                        }
                        else
                        {
                            $productPrice = $details->getPrice($useTax, $details->id_product_attribute, 6, NULL, false, $special);

                            if ($productPrice && isset($categories_formulas[$id_category]) && !empty($categories_formulas[$id_category]))
                            {
                                $productPrice = PSPM_Tools::Formula($productPrice, $categories_formulas[$id_category]);
                            }
                            elseif ($productPrice && isset($formula) && !empty($formula))
                            {
                                $productPrice = PSPM_Tools::Formula($productPrice, $formula);
                            }

                            if ($priceOverride)
                                $productPrice = $priceOverride;
                            
                            if (! $image_optionnal && !count($images))
                            {
                                $errors[] = sprintf($this->l('Missing Image for Product ID: %d/%d'), $details->id, $details->id_product_attribute);
                                continue;
                            }

                            foreach ($profile_format['fields'] as $field)
                            {
                                // is a custom field
                                //
                                switch ($field)
                                {
                                    case '_blank_1' :
                                    case '_blank_2' :
                                    case '_blank_3' :
                                    case '_blank_4' :
                                    case '_blank_5' :
                                    case '_blank_6' :
                                    case '_blank_6' :
                                    case '_blank_6' :
                                    case '_blank_7' :
                                    case '_blank_8' :
                                    case '_blank_9' :
                                    case '_blank_10' :
                                    case '_blank_11' :
                                    case '_blank_12' :
                                    case '_blank_12' :
                                    case '_blank_13' :
                                    case '_blank_14' :
                                    case '_blank_15' :
                                    case '_blank_16' :
                                    case '_blank_17' :
                                    case '_blank_18' :
                                    case '_blank_19' :
                                    case '_blank_20' :
                                    case '_blank_21' :
                                    case '_blank_22' :
                                        $product[$field] = '';
                                        break;
                                    case '_value_0' :
                                    case '_value_0bis' :
                                        $product[$field] = 0;
                                        break;
                                    case '_value_1' :
                                    case '_value_1bis' :
                                        $product[$field] = 1;
                                        break;
                                    case '_value_2' :
                                    case '_value_2bis' :
                                        $product[$field] = 2;
                                        break;
                                    case '_value_y' :
                                        $product[$field] = 'Y';
                                        break;
                                    case '_value_n' :
                                        $product[$field] = 'N';
                                        break;
                                    case 'pm_audience' :
                                        if (isset($categories2audiences[$id_category_export]))
                                            $audience_id = $categories2audiences[$id_category_export];
                                        elseif (isset($categories2audiences[$id_category]))
                                            $audience_id = $categories2audiences[$id_category];
                                        else
                                            $audience_id = null;

                                        switch ($audience_id)
                                        {
                                            case '1' :
                                                $audience = 'Homme';
                                                break;
                                            case '2' :
                                                $audience = 'Femme';
                                                break;
                                            case '3' :
                                                $audience = 'Mixte';
                                                break;
                                            case '4' :
                                                $audience = 'Fille';
                                                break;
                                            case '5' :
                                                $audience = 'Gar&ccedil;on';
                                                break;
                                            default :
                                                $audience = null;
                                                break;
                                        }

                                        if ($audience)
                                            $product[$field] = mb_convert_encoding($audience, 'UTF-8', 'HTML-ENTITIES');
                                        else
                                            $product[$field] = '';
                                        break;
                                    case 'pm_shipping_delay' :
                                        $product[$field] = $shipping_delay;
                                        break;
                                    case 'pm_category' :
                                    case 'pm_category_bis' :
                                        if (isset($categories_mappings[$id_category]))
                                            $product[$field] = $categories_mappings[$id_category];
                                        else
                                            $product[$field] = '';
                                        break;
                                    case 'pm_campaign' :
                                        if (isset($categories_campaings[$id_category]))
                                            $product[$field] = $categories_campaings[$id_category];
                                        else
                                            $product[$field] = '';
                                        break;
                                    case 'pm_comment' :
                                        if (!empty($comment))
                                            $product[$field] = str_replace(array("\n", "\r"), '<br />', $comment) ;
                                        else
                                            $product[$field] = '';
                                        break;
                                    case 'pm_full_id' :
                                    case 'pm_full_id_bis' :
                                        if ($details->id_product_attribute)
                                            $product[$field] = sprintf('%d_%d', $details->id, $details->id_product_attribute);
                                        else
                                            $product[$field] = $details->id;
                                        break;

                                    case 'pm_final_price' :
                                        $product[$field] = $productPrice;
                                        break;
                                    case 'pm_gender' :
                                        if (isset($categories2genders[$id_category_export]))
                                            $gender_id = $categories2genders[$id_category_export];
                                        elseif (isset($categories2genders[$id_category]))
                                            $gender_id = $categories2genders[$id_category];
                                        else
                                            $gender_id = null;

                                        switch ($gender_id)
                                        {
                                            case '1' :
                                                $categories2gender = 'Homme';
                                                break;
                                            case '2' :
                                                $categories2gender = 'Femme';
                                                break;
                                            case '3' :
                                                $categories2gender = 'B&eacute;b&eacute; Gar&ccedil;on';
                                                break;
                                            case '4' :
                                                $categories2gender = 'B&eacute;b&eacute; Fille';
                                                break;
                                            case '5' :
                                                $categories2gender = 'Gar&ccedil;on';
                                                break;
                                            case '6' :
                                                $categories2gender = 'Fille';
                                                break;
                                            case '7' :
                                                $categories2gender = 'Mixte Enfant';
                                                break;
                                            case '8' :
                                                $categories2gender = 'Mixte B&eacute;b&eacute;';
                                                break;
                                            case '9' :
                                                $categories2gender = 'Pregnant';
                                                break;
                                            case '10' :
                                                $categories2gender = 'Mixte (Adulte)';
                                                break;
                                            case '11' :
                                                $categories2gender = 'Adolescent';
                                                break;
                                            case '12' :
                                                $categories2gender = 'Adulte';
                                                break;
                                            case '13' :
                                                $categories2gender = 'Enfant';
                                                break;
                                            case '14' :
                                                $categories2gender = 'Famille';
                                                break;
                                            case '15' :
                                                $categories2gender = 'Premier &acirc;ge';
                                                break;
                                            default :
                                                $categories2gender = null;
                                                break;
                                        }

                                        if ($categories2gender)
                                            $product[$field] = mb_convert_encoding($categories2gender, 'UTF-8', 'HTML-ENTITIES');
                                        else
                                            $product[$field] = '';
                                        break;
                                    case 'pm_type' :
                                        if (isset($categories2type[$id_category_export]))
                                            $type = $categories2type[$id_category_export];
                                        elseif (isset($categories2type[$id_category]))
                                            $type = $categories2type[$id_category];
                                        else
                                            $type = null;

                                        if ($type)
                                            $product[$field] = $type;
                                        else
                                            $product[$field] = '';
                                        break;
                                    case 'pm_initial_price' :

                                        if (isset($categories_formulas[$id_category]) && !empty($categories_formulas[$id_category]))
                                        {
                                            $initialPrice = PSPM_Tools::Formula($details->getPrice($useTax, $details->id_product_attribute, 6, NULL, false, false), $categories_formulas[$id_category]);
                                        }
                                        elseif (isset($formula) && !empty($formula))
                                        {
                                            $initialPrice = PSPM_Tools::Formula($details->getPrice($useTax, $details->id_product_attribute, 6, NULL, false, false), $formula);
                                        }
                                        else
                                        {
                                            $initialPrice = $details->getPrice($useTax, $details->id_product_attribute, 6, NULL, false, false);
                                        }
                                        $product[$field] = $initialPrice;
                                        break;

                                    case 'image_url' :
                                    case 'image_url_2' :
                                    case 'image_url_3' :
                                    case 'image_url_4' :
                                        $product[$field] = '';
                                        if (isset($images[$image_index]))
                                            $product[$field] = $images[$image_index];
                                        $image_index++;
                                        break;

                                    case 'quantity' :
                                        $product[$field] = $quantity;

                                        if ($details->out_of_stock == 1 && $quantity < $outOfStock)
                                            $product[$field] = 999;
                                        elseif ($quantity < $outOfStock)
                                            $product[$field] = 0;

                                        if (!$details->active)
                                            $product[$field] = 0;

                                        if ($disabled)
                                            $product[$field] = 0;

                                        if ($force)
                                            $product[$field] = 999;

                                        // Do not export
                                        //
                                        if ($product[$field] < $outOfStock)
                                        {
                                            $product['export'] = false;
                                        }

                                        break;
                                    case 'product_url' :
                                        $product[$field] = $baseurl . 'product.php?id_product=' . $product['id_product'];
                                        break;
                                    case 'description' :
                                    case 'description_short' :
                                    case 'meta_description' :
                                        $product[$field] = strip_tags($product[$field], '<br><b><strong><ul><li>');
                                        $product[$field] = str_replace(array(chr(13), chr(10)), '<br />', $product[$field]);
                                        $product[$field] = preg_replace('#[\n]+#i', "<br />", $product[$field]);

                                        if ($safe_descriptions)
                                            $product[$field] = PSPM_Tools::safeText($product[$field]);

                                        $product[$field] = str_replace($profile_format['fs'], '', $product[$field]);
                                        break;
                                    case 'category_name' :
                                        if (!isset($categories_names[$details->id_category_default]))
                                        {
                                            $categorie = new Category($details->id_category_default, $this->_id_lang);
                                            $categories_names[$details->id_category_default] = $categorie->name;
                                            $product[$field] = $categorie->name;
                                            unset($categorie);
                                        }
                                        else
                                        {
                                            $product[$field] = $categories_names[$details->id_category_default];
                                        }
                                        break;
                                    case 'attributes_long' :
                                        $product[$field] = rtrim(rtrim($details->attributes_long, ', '), ' - ');
                                        break;
                                    case 'attributes_short' :
                                        $product[$field] = rtrim(rtrim($details->attributes_short, ', '), ' - ');
                                        break;
                                    case 'name_with_attributes' :
                                        $product[$field] = rtrim(sprintf('%s - %s', $details->name, rtrim($details->attributes_short, ', ')), ' - ');
                                        ;
                                        break;
                                    case 'shop_name' :
                                        $product[$field] = PriceMinister::configurationGet('PS_SHOP_NAME');
                                        break;
                                    case 'shop_email' :
                                        $product[$field] = PriceMinister::configurationGet('PS_SHOP_EMAIL');
                                        break;
                                    case 'shop_details' :
                                        $product[$field] = PriceMinister::configurationGet('PS_SHOP_DETAILS');
                                        break;
                                    case 'shop_addr1' :
                                        $product[$field] = str_replace(array(chr(13), chr(10), $profile_format['fs']), '', PriceMinister::configurationGet('PS_SHOP_ADDR1'));
                                        break;
                                    case 'shop_addr2' :
                                        $product[$field] = str_replace(array(chr(13), chr(10), $profile_format['fs']), '', PriceMinister::configurationGet('PS_SHOP_ADDR2'));
                                        break;
                                    case 'shop_fulladdr' :
                                        $product[$field] = str_replace(array(chr(13), chr(10), $profile_format['fs']), '', PriceMinister::configurationGet('PS_SHOP_ADDR1') . ' - ' . PriceMinister::configurationGet(PS_SHOP_ADDR2));
                                        break;
                                    case 'shop_postcode' :
                                        $product[$field] = PriceMinister::configurationGet('PS_SHOP_CODE');
                                        break;
                                    case 'shop_city' :
                                        $product[$field] = PriceMinister::configurationGet('PS_SHOP_CITY');
                                        break;
                                    case 'shop_state' :
                                        $product[$field] = PriceMinister::configurationGet('PS_SHOP_STATE');
                                        break;
                                    case 'shop_country' :
                                        $product[$field] = PriceMinister::configurationGet('PS_SHOP_COUNTRY');
                                        break;
                                    case 'shop_phone' :
                                        $product[$field] = PriceMinister::configurationGet('PS_SHOP_PHONE');
                                        break;
                                    case 'shop_fax' :
                                        $product[$field] = PriceMinister::configurationGet('PS_SHOP_FAX');
                                        break;
                                    case 'main_reference' :
                                        $product[$field] = $details->reference;
                                        break;
                                    case 'reference' :
                                    case 'reference_bis' :
                                        $product[$field] = $product['reference'];
                                        break;
                                    case 'id_product_bis' :
                                        $product[$field] = $details->id;
                                        break;
                                    case 'name_bis' :
                                        $product[$field] = $product['name'];
                                        break;
                                    case 'condition' :
                                        if (isset($product['condition']) && !empty($product['condition']) && isset($conditionMap[$product['condition']]) && !empty($conditionMap[$product['condition']]))
                                            $condition = $conditionMap[$details->condition];
                                        else
                                            $condition = 'N';
                                        $product[$field] = $condition;
                                        break;
                                    case 'weight' :
                                        $product[$field] = intval($details->weight * 1000);
                                        break;
                                    case 'pm_weight' :
                                        $weight = floatval($details->weight);

                                        if ($weight <= 0.1)
                                            $value = "0 a 100 g";
                                        elseif ($weight > 0.100 && $weight <= 0.250)
                                            $value = "100 a 250 g";
                                        elseif ($weight > 0.250 && $weight <= 0.500)
                                            $value = "250 a 500 g";
                                        elseif ($weight > 0.500 && $weight <= 3)
                                            $value = "500 a 3 kg";
                                        elseif ($weight > 3 && $weight <= 10)
                                            $value = "3 a 10 kg";
                                        elseif ($weight > 10 && $weight <= 15)
                                            $value = "10 a 15 kg";
                                        elseif ($weight > 15 && $weight <= 30)
                                            $value = "15 a 30 kg";
                                        elseif ($weight > 30 && $weight <= 50)
                                            $value = "30 a 50 kg";
                                        elseif ($weight > 50 && $weight <= 70)
                                            $value = "50 a 70 kg";
                                        elseif ($weight > 70 && $weight <= 100)
                                            $value = "70 a 100 kg";
                                        elseif ($weight > 100)
                                            $value = "+ de 100 kg";
                                        else
                                            $value = '';

                                        $product[$field] = $value;

                                        break;

                                    default :
                                        break;
                                }

                                if (isset($product[$field]) && is_array($product[$field]))
                                {
                                    $product[$field] = implode($profile_format['fs'] == ';' ? ',' : ';', $product[$field]);
                                }

                                if ( strpos($field, 'shipping_') !== false )
                                {
                                    $shipping_method = substr($field, 9) ;
                                    $product[$field] = '' ;
                                    $shipping_tax_incl = 0 ;
                                    
                                    if ( isset(PriceMinister::$pm_shipping_zones[$shipping_method]) )
                                    {
                                        $id_carrier = isset($shipping_table['carrier'][$shipping_method]) ? (int)$shipping_table['carrier'][$shipping_method] : null ;
                                        $id_zone = isset($shipping_table['zone'][$shipping_method]) ? (int)$shipping_table['zone'][$shipping_method] : null ;
                                        
                                        if ( $id_carrier && $id_zone )
                                        {
                                            $carrier = new Carrier($id_carrier) ;

                                            if ( ! Validate::isLoadedObject($carrier) )
                                            {
                                                $errors[] = sprintf('%s(%d): %s (%d)', basename(__FILE__), __LINE__, $this->l('Unable to load carrier'), $id_carrier);
                                            }                                            
                                            else
                                            {
                                                $carrier_tax_rate = 0 ;

                                                // Carrier Taxes
                                                //
                                                if (method_exists('Carrier', 'getTaxesRate'))
                                                {
                                                    $tax_address = new Address((int)$id_address);

                                                    if ( Validate::isLoadedObject($tax_address) )
                                                            $carrier_tax_rate = (float)$carrier->getTaxesRate($tax_address);
                                                }
                                                else if (method_exists('Tax', 'getCarrierTaxRate'))
                                                {
                                                    $carrier_tax_rate = (float)Tax::getCarrierTaxRate($id_carrier, (int)$id_address);
                                                }        

                                                $carrier_shipping_price = 0 ;
                                                $shipping_tax_incl = 0 ;

                                                if ($carrier instanceOf Carrier && method_exists('Carrier', 'getDeliveryPriceByWeight') )
                                                {
                                                    $carrier_shipping_price = $carrier->getDeliveryPriceByWeight($details->weight, $id_zone);

                                                    $shipping_tax_excl = $carrier_shipping_price ;
                                                    $shipping_tax_incl = ( ((floatval($carrier_tax_rate) * floatval($shipping_tax_excl)) / 100) + floatval($shipping_tax_excl) ) ;
                                                }

                                                if ( ! (int)$carrier_shipping_price && $carrier instanceOf Carrier && method_exists('Carrier', 'getDeliveryPriceByPrice') ) 
                                                {
                                                    $carrier_shipping_price = $carrier->getDeliveryPriceByPrice($productPrice, $id_zone);
                                                    $shipping_tax_excl = $carrier_shipping_price ;
                                                    $shipping_tax_incl = ( ((floatval($carrier_tax_rate) * floatval($shipping_tax_excl)) / 100) + floatval($shipping_tax_excl) ) ;
                                                }   
                                            }
                                        }
                                        $minimum = isset($shipping_defaults['minimum'][$shipping_method]) ? (float)$shipping_defaults['minimum'][$shipping_method] : null ;
                                                
                                        if ( $minimum > $shipping_tax_incl )
                                            $product[$field] = sprintf('%.02f', $minimum) ;
                                        else
                                            $product[$field] = sprintf('%.02f', $shipping_tax_incl) ;                                        
                                    }
                                }
                                elseif (strpos($field, 'zz_') !== false)
                                {
                                    $product[$field] = '';

                                    $result = PSPM_Product::getIdFeatureByTitle($product['id_product'], $this->_id_lang, substr($field, 3));

                                    if (isset($result['name']) && isset($result['value']))
                                    {
                                        if (isset($features_mapping_right[$result['id_feature']][$result['id_feature_value']]) && $features_mapping_right[$result['id_feature']][$result['id_feature_value']])
                                            $product[$field] = $features_mapping_right[$result['id_feature']][$result['id_feature_value']];
                                        else
                                            $product[$field] = $result['value'];
                                    }
                                }
                                elseif (strpos($field, 'attribute_') !== false)
                                {
                                    $product[$field] = '';

                                    $result = PSPM_Product::getAttributeValueByAttributeName($details->id_product_attribute, $this->_id_lang, substr($field, 10));

                                    if (isset($result['name']) && isset($result['value']))
                                    {
                                        // Attribute Mapping
                                        if (isset($fashion_right[ $result['id_attribute_group'] ]) && isset($fashion_right[ $result['id_attribute_group'] ][ $result['id_attribute'] ]))
                                             $product[$field] = $fashion_right[ $result['id_attribute_group'] ][ $result['id_attribute'] ] ;
                                        else $product[$field] = $result['value'];
                                    }
                                    else
                                    {
                                        $product[$field] = '';
                                    }
                                }
                                elseif (strpos($field, 'custom_attr_') !== false)
                                {
                                    $product[$field] = '';
                                    
                                    $product_attr_combs = $details->getAttributeCombinationsById($details->id_product_attribute, $this->_id_lang); // check compat

                                    if (array_key_exists(substr($field, 12), $custom_attr))
                                    {
                                        foreach ($custom_attr[substr($field, 12)]['selected'] as $cs_attr_id)
                                        {
                                            $break = false;
                                            
                                            foreach ($product_attr_combs as $product_attr_comb)
                                            {
                                                if ((int)$product_attr_comb['id_attribute_group'] === (int)$cs_attr_id)
                                                {
                                                    $product[$field] = $product_attr_comb['attribute_name'];
                                                    $break = true;
                                                    break;
                                                }
                                            }
                                            
                                            if ($break)
                                                break;
                                        }
                                    }
                                }

                                if (!isset($product[$field]))
                                    continue;

                                $export_products[$p][$field] = $product[$field];
                            }
                        }
                    }
                }
            }

        if ($profile_format['fs'] == 'Tabulation')
            $profile_format['fs'] = chr(9);

        if ($pass)
        {
            // Mappingalias mode
            //
          if ($synchronize)
            {
                foreach ($export_products as $product)
                {
                    $line = '';
                    foreach ($product as $field)
                    {
                        if ($delimiter)
                            $field = str_replace($delimiter, '', $field);
                        $line .= $field . ';';
                    }
                    $line = rtrim($line, ';') . "\n";

                    file_put_contents($file, $line, FILE_APPEND);
                }
            }
            else // file mode
            {
                foreach ($export_products as $product)
                {

                    $line = '';
                    if (isset($product['quantity']) && $product['quantity'] < $outOfStock)
                        continue;

                    foreach ($product as $field)
                    {
                        if ($delimiter)
                            $field = str_replace($delimiter, '', $field);
                        $line .= sprintf('%s%s%s%s', $delimiter, $field, $delimiter, $profile_format['fs']);
                    }
                    $line = rtrim($line, $profile_format['fs']) . "\n";

                    file_put_contents($file, $line, FILE_APPEND);
                }
            }
        }
        // PM Configuration
        //
        $config = array();

        if ($pass)
            $config = PSPM_Tools::Auth($this->_lang);

        if (!is_array($config) || !count($config))
        {
            $pass = false;
            $errors[] = $this->l('Unexpected error, missing configuration');
        }

        if (!$p)
        {
            $errors[] = $this->l('0 Product to export ...');
            $pass = false;
        }
        else
        {
            $messages[] = sprintf($this->l('%d exported products for profile %s'), $p, $profile);
        }


        // Orders Output Settings
        //
        $config['output_type'] = 'juicy';
        $config['output'] = 'array';
        $config['profileid'] = $profile;

        // PM Settings
        //
        $params = array(
            "file" => "@" . realpath($file)
        );

        if ($this->_test_mode[$this->_id_lang])
        {
            $server_output = array('type' => 'Test Mode', 'code' => 'Test Mode', 'message' => 'Developpment Mode. Nothing was sent');
        }
        else
        {
            $oStock = new PM_Stock($config);

            if ($pm_debug)
                $oStock->debug();

            if ($synchronize)
                $server_output = $oStock->synch($params, $update_mode);
            else
                $server_output = $oStock->import($params);
        }

        return( array('profile' => $profile, 'error' => !$pass, 'messages' => $messages, 'count' => $p, 'errors' => $errors, 'server' => $server_output, 'outputs' => ob_get_clean()) );
    }

    public function Exports($synchronize = false)
    {
        $categories_formula = unserialize(base64_decode(PriceMinister::configurationGet('PM_CATEGORIES_FORMULA')));
        $profiles_formats = unserialize(base64_decode(PriceMinister::configurationGet('PM_PROFILES_FORMATS')));

        $this->_id_lang = Tools::getValue('id_lang');
        $this->_lang = Tools::getValue('lang');

        $profiles = Tools::getValue('profiles');
        $categories = Tools::getValue('categories');
        $export = Tools::getValue('export');

        $callback = Tools::getValue('callback');
        $results = array();

        if ($profiles)
        {
            foreach ($profiles as $profile)
            {
                if (!isset($export[$profile])) // unselected
                    continue;

                if (!isset($profiles_formats[$profile])) // no associate profile
                    continue;

                if (!isset($categories) || !count($categories[$profile]))
                    continue;

                $results[] = $this->ExportFile($profile, $profiles_formats[$profile], $categories[$profile], $synchronize);
            }
            if (!count($results))
            {
                echo $this->l('Please check your profiles configuration');
                $results[] = array('profile' => null, 'error' => true, 'messages' => null, 'count' => 0, 'errors' => null, 'server' => null, 'outputs' => ob_get_clean());
            }
        }
        else
        {
            echo $this->l('Nothing to do');
            $results[] = array('profile' => null, 'error' => true, 'messages' => null, 'count' => 0, 'errors' => null, 'server' => null, 'outputs' => ob_get_clean());
        }
        $json = PSPM_Tools::jsonEncode($results);


        // jQuery Output or PHP Output
        //
        if ($callback) // jquery
        {
            echo strval($callback) . '(' . $json . ')';
        }
        else // cron
        {
            echo $json;
            return;
        }
    }

    //
    // Cron Mode / Batch mode : usage : wget http://productexport.php?lang=fr&action=cron&update=1
    //
    public function Batch()
    {
        $cr = "<br />\n";

        $profiles_settings = unserialize(base64_decode(PriceMinister::configurationGet('PM_PROFILES')));
        $profiles_formats = unserialize(base64_decode(PriceMinister::configurationGet('PM_PROFILES_FORMATS')));

        if (Tools::getValue('update'))
            $update = true;
        else
            $update = false;

        $this->_lang = Tools::getValue('lang');
        $this->_id_lang = Language::getIdByIso($this->_lang);

        $profiles_settings = $profiles_settings[$this->_id_lang];
        $results = array();

        echo sprintf('%s - Lang: %s(%d)' . $cr, $this->l('Price Minister - Batch Mode'), $this->_lang, $this->_id_lang);

        if ($profiles_settings)
        {
            foreach ($profiles_settings as $profile)
            {
                if (!isset($profile['ids'])) // unselected
                    continue;

                if (!isset($profiles_formats[$profile['ids']])) // no associate profile
                    continue;

                $categories = $profile['categories'];
                $fields = $profiles_formats[$profile['ids']];
                $profileid = $profile['ids'];

                $results[] = $this->ExportFile($profileid, $fields, $categories, $update);
            }
        }

        $json = PSPM_Tools::jsonEncode($results);
        echo $json . "\n";
    }

}

$pm_export = new PriceMinisterProductExport();
$pm_export->Dispatch();
?>