<?php
/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: contact@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@smartmarseille.com
 * ...........................................................................
 * @copyright  Copyright (c) 2011-2011 S.A.R.L SMC (http://www.smartmarseille.com)
 * @copyright  Copyright (c) 2011-2014 Common Services Co Ltd (http://www.common-services.com)
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  olivier@smartmarseille.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * 
 */

/*
 Warning in Prestashop >= 1.3.6 - 1.4
 @ to prevent notice in Tools class in E_STRICT | E_ALL mode :
 Notice: Undefined index:  HTTP_HOST in /classes/Tools.php on line 71
*/
if ( isset($_SERVER['DropBox']) && $_SERVER['DropBox'] )
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') ) ;
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') ) ;
}
else    
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php') ;
    @require_once(dirname(__FILE__) . '/../../../init.php');
}

require_once(dirname(__FILE__).'/../priceminister.php');
require_once(dirname(__FILE__).'/../classes/PSPM_Product.class.php');
require_once(dirname(__FILE__) . '/../classes/PM_Context.class.php');     

class Product_Ext_Manager extends PriceMinister
{
  private $module   = 'priceminister';
  public $name   = 'priceminister';
  private $_priceminister ;

  public $id_lang ;
  
  public function __construct()
  {
    global $cookie, $_MODULE;
    
    if (version_compare(_PS_VERSION_, '1.5', '>='))
    {
        $this->id_lang = (int) Context::getContext()->language->id;
    }
    else
    {
        $this->id_lang = (int) $cookie->id_lang;
    }    
    $langFile = _PS_MODULE_DIR_.$this->module.'/'.Language::getIsoById($this->id_lang).'.php';
    $mySelf   = basename(__FILE__, '.php') ;

    if(file_exists($langFile))
    {
      require_once $langFile;
      foreach($_MODULE  as $key=>$value)
          $_MODULE[str_replace($mySelf . '_' , $this->module . '_', $key)] = $value;
    }

    // Get Fields
    //
    $moduleurl = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->module . '/' ;

    $this->images = $moduleurl . 'images/';
    $this->moduleurl = $moduleurl;

    $this->_priceminister = new PriceMinister() ;

     parent::__construct() ;
     PM_Context::restore($this->context,Validate::isLoadedObject($this->context->shop) ? $this->context->shop : NULL) ;
     
  }

  public function l($string, $specific = false, $id_lang = null)
  {
    return( $this->_priceminister->l($string, $specific = false, $id_lang = null) ) ;
  }

  private function _displayCheckBox($name, $value, $fieldvalue=1)
  {
    global $cookie ;
    
    if ( $value == $fieldvalue )
        $checked = 'checked="checked"' ;
    else
        $checked = '' ;


    $html = '
        <tr class="productpm-details">
          <td class="col-left">' . $this->l($name) . ': </td>
          <td style="padding-bottom:5px;">
          <input type="checkbox" name="' . $this->normalstring($name) . '" value="'.$fieldvalue.'" ' . $checked . ' />
          </td>
        </tr>
        ' ;
    return($html) ;
  }

  private function _displayInput($name, $value)
  {
    global $cookie ;
    
    $html = '
        <tr class="productpm-details">
          <td class="col-left">' . $this->l($name) . ': </td>
          <td style="padding-bottom:5px;">
          <input type="text" name="' . $this->normalstring($name) . '" value="'.$value.'" />
          </td>
        </tr>
        ' ;
    return($html) ;
  }

  private function _displaySelectBox($name, $value, $fieldvalue = array())
  {
    global $cookie ;


    $html = '
        <tr class="productpm-details">
          <td class="col-left">' . $this->l($name) . ': </td>
          <td style="padding-bottom:5px;">
          <select name="'.$this->normalstring($name).'" style="width:150px" >';
          foreach($fieldvalue as $key => $item)
          {
            if ( $value == $key )
                $checked = 'selected="selected"';
            else
                $checked = '';
            $html .= '<option value="' . $key . '" '.$checked.'>' . $item . '</option>'."\n";
          }
          '
          </select>
          </td>
        </tr>
        ' ;
    return($html) ;
  }

  private function _displayRadio($name, $value, $fieldvalue = array())
  {
    global $cookie ;

    $html = '
        <tr class="productpm-details">
          <td class="col-left">' . $this->l($name) . ': </td>
          <td style="padding-bottom:5px;">';
          foreach($fieldvalue as $key => $item)
          {
            if ( $value == $key )
                $checked = 'checked="checked"';
            else
                $checked = '';
            $html .= '<input type="radio" name="'.$this->normalstring($name).'" value="' . $key . '" '.$checked.' />' . "&nbsp;".$item."&nbsp;&nbsp;&nbsp;". "\n";
          }
          '
          </select>
          </td>
        </tr>
        ' ;
    return($html) ;
  }

  private function _forceUnavailable($default)
  {
      $view_params = array();
      $view_params["checked"] = $default ? 'checked="checked"' : '' ;
      return($view_params) ;
  }


  private function _forceInStock($default)
  {
      $view_params = array();
      $view_params["checked"] = $default ? 'checked="checked"' : '' ;
      return($view_params) ;
  }

  private function   _extraText($default)
  {
      $view_params = array();
      $view_params["value"] = $default;
      return($view_params) ;
  }

  private function   _extraPrice($default)
  {
      $view_params = array();
      $view_params["value"] = (floatval($default) ? sprintf('%.02f', $default) : '');
      
      return($view_params) ;
  }



  public function doIt()
  {
    global $cookie ;

    $id_lang = $this->id_lang ;

    $this->id_product = Tools::getValue('id_product') ;
    
    $view_params = array();
    $view_params["id_lang"] = $id_lang;
    $view_params["images"] = $this->images;
    $view_params["module_url"] = $this->moduleurl;
    $view_params["id_product"] = Tools::getValue('id_product');
    
    $view_params["pm_context_key"] = "";
    
    if(Validate::isLoadedObject($this->context->shop)){
        $view_params["pm_context_key"] = PM_Context::getKey($this->context->shop);
    }
    
    
    $defaults = PSPM_Product::getProductOptions($this->id_product, $id_lang) ;

    $view_params["force_unavailable"] = $this->_forceUnavailable($defaults['disable']) ;

    $view_params["force_in_stock"] = $this->_forceInStock($defaults['force']) ;

    $view_params["force_extra_text"]= $this->_extraText($defaults['text']) ;

    $view_params["force_extra_price"]= $this->_extraPrice($defaults['price']) ;

    
    $this->context->smarty->assign($view_params);
    echo $this->context->smarty->fetch($this->path . 'views/catalog/product_extpm.tpl');
  }


}
$productExtManager = new Product_Ext_Manager() ;
$productExtManager->DoIt() ;

?>
