<?php
/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: contact@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est 
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@smartmarseille.com
 * ...........................................................................
 * @copyright  Copyright (c) 2011-2011 S.A.R.L SMC (http://www.smartmarseille.com)
 * @copyright  Copyright (c) 2011-2014 Common Services Co Ltd (http://www.common-services.com)
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  olivier@smartmarseille.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * 
 */

/*
 Warning in Prestashop >= 1.3.6 - 1.4
 @ to prevent notice in Tools class in E_STRICT | E_ALL mode :
 Notice: Undefined index:  HTTP_HOST in /classes/Tools.php on line 71
*/

if ( isset($_SERVER['DropBox']) && $_SERVER['DropBox'] )
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') ) ;
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') ) ;
}
else    
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php') ;
    @require_once(dirname(__FILE__) . '/../../../init.php');
}

require_once(dirname(__FILE__).'/../priceminister.php');
require_once(dirname(__FILE__).'/../classes/PSPM_Product.class.php');

class Product_Ext_ManagerJSON extends PriceMinister
{
    public $module = 'priceminister';
    # Warning Don't remove construct
    private $_priceminister ;

    public function __construct(){
        global $cookie, $_MODULE;
        
        $langFile = _PS_MODULE_DIR_.$this->module.'/'.Language::getIsoById(intval($cookie->id_lang)).'.php';
        $mySelf   = basename(__FILE__, '.php') ;

        if(file_exists($langFile))
        {
          require_once $langFile;
          foreach($_MODULE  as $key=>$value)
              $_MODULE[str_replace($mySelf . '_' , $this->module . '_', $key)] = $value;
        }

        $cookie->id_lang = (int)Configuration::get('PS_LANG_DEFAULT') ;

          // Get Fields
          //
          $moduleurl = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->module . '/' ;

          $this->images = $moduleurl . 'images/';
          $this->moduleurl = $moduleurl;

          $this->_priceminister = new PriceMinister() ;

          parent::__construct() ;
          require_once(dirname(__FILE__) . '/../classes/PM_Context.class.php');
     
          PM_Context::restore($this->context, Validate::isLoadedObject($this->context->shop) ? $this->context->shop : NULL) ;
      }
  public function l($string, $specific = false, $id_lang = null)
  {
    return( $this->_priceminister->l($string, $specific = false, $id_lang = null) ) ;
  }

  public function doIt()
  {
      $callback     = Tools::getValue('callback') ;
      $langs        = Tools::getValue('pm_option_lang') ;
      $id_product   = Tools::getValue('id_product') ;
      $id_category  = Tools::getValue('id_category_default') ;
      $id_manufacturer = Tools::getValue('id_manufacturer') ;

      switch( Tools::getValue('action') )
      {
          case 'set' : // Set Product Opton
              $pass = true ;

              foreach($langs as $key => $val)
              {

                  $id_lang      = intval($val) ;
                  $disable      = Tools::getValue('pm-disable-' . intval($id_lang)) ? 1 : 0 ;
                  $force        = Tools::getValue('pm-force-' . intval($id_lang))  ? 1 : 0 ;
                  $price        = Tools::getValue('pm-price-' . intval($id_lang));
                  $text         = Tools::getValue('pm-text-' . intval($id_lang));

                  $options      = array('force' => $force, 'disable' => $disable, 'price' => $price,'text' => $text) ;

                  if ( ! PSPM_Product::setProductOptions($id_product, $id_lang, $options) )
                    $pass = false ;
              }

              if ( $pass )
                    echo $this->l('Parameters successfully saved') ;
              else  echo $this->l('Unable to save parameters...') ;

              break ;

          case 'propagate-text-cat' : // Propagate product option text
              $pass = true ;

              foreach($langs as $key => $val)
              {
                  $id_lang = intval($val) ;
                  $text   = Tools::getValue('pm-text-' . intval($id_lang));

                  $options = array('text' => $text) ;

                  if ( ! PSPM_Product::propagateProductOptionsText($id_product, $id_lang, $id_category, $options) )
                    $pass = false ;
              }
              if ( $pass )
                    echo $this->l('Parameters successfully saved') ;
              else  echo $this->l('Unable to save parameters...') ;

              break ;

          case 'propagate-text-shop' : // Propagate product option text
              $pass = true ;

              foreach($langs as $key => $val)
              {
                  $id_lang = intval($val) ;
                  $text    = Tools::getValue('pm-text-' . intval($id_lang));

                  $options = array('text' => $text) ;

                  if ( ! PSPM_Product::propagateToShopProductOptionsText($id_product, $id_lang, $options) )
                    $pass = false ;
              }
              if ( $pass )
                    echo $this->l('Parameters successfully saved') ;
              else  echo $this->l('Unable to save parameters...') ;

              break ;

          case 'propagate-text-manufacturer' : // Propagate product option text
              $pass = true ;

              foreach($langs as $key => $val)
              {
                  $id_lang = intval($val) ;
                  $text    = Tools::getValue('pm-text-' . intval($id_lang));

                  $options = array('text' => $text) ;

                  if ( ! PSPM_Product::propagateToManufacturerProductOptionsText($id_product, $id_lang, $id_manufacturer, $options) )
                    $pass = false ;
              }
              if ( $pass )
                    echo $this->l('Parameters successfully saved') ;
              else  echo $this->l('Unable to save parameters...') ;

              break ;

          case 'propagate-disable-cat' : // Propagate product option text
              $pass = true ;

              foreach($langs as $key => $val)
              {
                  $id_lang = intval($val) ;
                  $value   = Tools::getValue('pm-disable-' . intval($id_lang));

                  $options = array('disable' => $value) ;

                  if ( ! PSPM_Product::propagateProductOptionsDisable($id_product, $id_lang, $id_category, $options) )
                    $pass = false ;
              }
              if ( $pass )
                    echo $this->l('Parameters successfully saved') ;
              else  echo $this->l('Unable to save parameters...') ;

              break ;

          case 'propagate-disable-shop' : // Propagate product option text
              $pass = true ;

              foreach($langs as $key => $val)
              {
                  $id_lang = intval($val) ;
                  $value   = Tools::getValue('pm-disable-' . intval($id_lang));

                  $options = array('disable' => $value) ;

                  if ( ! PSPM_Product::propagateToShopProductOptionsDisable($id_product, $id_lang, $options) )
                    $pass = false ;
              }
              if ( $pass )
                    echo $this->l('Parameters successfully saved') ;
              else  echo $this->l('Unable to save parameters...') ;

              break ;

          case 'propagate-disable-manufacturer' : // Propagate product option text
              $pass = true ;

              foreach($langs as $key => $val)
              {
                  $id_lang = intval($val) ;
                  $value   = Tools::getValue('pm-disable-' . intval($id_lang));

                  $options = array('disable' => $value) ;

                  if ( ! PSPM_Product::propagateToManufacturerProductOptionsDisable($id_product, $id_lang, $id_manufacturer, $options) )
                    $pass = false ;
              }
              if ( $pass )
                    echo $this->l('Parameters successfully saved') ;
              else  echo $this->l('Unable to save parameters...') ;

              break ;

          case 'propagate-force-cat' : // Propagate product option text
              $pass = true ;

              foreach($langs as $key => $val)
              {
                  $id_lang = intval($val) ;
                  $text   = Tools::getValue('pm-force-' . intval($id_lang));

                  $options = array('force' => $text) ;

                  if ( ! PSPM_Product::propagateProductOptionsForce($id_product, $id_lang, $id_category, $options) )
                    $pass = false ;
              }
              if ( $pass )
                    echo $this->l('Parameters successfully saved') ;
              else  echo $this->l('Unable to save parameters...') ;

              break ;

          case 'propagate-force-shop' : // Propagate product option text
              $pass = true ;

              foreach($langs as $key => $val)
              {
                  $id_lang = intval($val) ;
                  $value   = Tools::getValue('pm-force-' . intval($id_lang));

                  $options = array('force' => $value) ;

                  if ( ! PSPM_Product::propagateToShopProductOptionsForce($id_product, $id_lang, $options) )
                    $pass = false ;
              }
              if ( $pass )
                    echo $this->l('Parameters successfully saved') ;
              else  echo $this->l('Unable to save parameters...') ;

              break ;

          case 'propagate-force-manufacturer' : // Propagate product option text
              $pass = true ;

              foreach($langs as $key => $val)
              {
                  $id_lang = intval($val) ;
                  $value   = Tools::getValue('pm-force-' . intval($id_lang));

                  $options = array('force' => $value) ;

                  if ( ! PSPM_Product::propagateToManufacturerProductOptionsForce($id_product, $id_lang, $id_manufacturer, $options) )
                    $pass = false ;
              }
              if ( $pass )
                    echo $this->l('Parameters successfully saved') ;
              else  echo $this->l('Unable to save parameters...') ;

              break ;

          default :
              break ;

      }

  }
}
$ext = new Product_Ext_ManagerJSON() ;
$ext->doIt() ;
