<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: contact@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@smartmarseille.com
 * ...........................................................................
 * @package    PriceMinister
 * @copyright  Copyright (c) 2011-2014 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2014 Common Services Co Ltd (http://www.common-services.com)
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * 
 */

if ( isset($_SERVER['DropBox']) && $_SERVER['DropBox'] )
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') ) ;
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') ) ;
}
else    
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php') ;
    @require_once(dirname(__FILE__) . '/../../../init.php');
}


require_once(dirname(__FILE__) . '/../priceminister.php');

require_once(dirname(__FILE__) . '/../classes/Priceminister_Webservices.class.php');
require_once(dirname(__FILE__) . '/../classes/PM_Sales.class.php');

require_once(dirname(__FILE__) . '/../classes/PSPM_Tools.class.php');
require_once(dirname(__FILE__) . '/../classes/PSPM_Cart.class.php');
require_once(dirname(__FILE__) . '/../classes/PSPM_Order.class.php');
require_once(dirname(__FILE__) . '/../classes/PSPM_Product.class.php');
require_once(dirname(__FILE__) . '/../classes/PSPM_OrderHistory.class.php');
require_once(dirname(__FILE__) . '/../classes/PSPM_Payment.class.php');
require_once(dirname(__FILE__) . '/../classes/PSPM_Address.class.php');


class PriceMinisterOrder extends PriceMinister
{

    public $name = 'priceminister';
    private $_priceminister;

    public function __construct()
    {
        global $cookie, $_MODULE, $_LANGADM;

        $langFile = _PS_MODULE_DIR_ . $this->name . '/' . Language::getIsoById(intval($cookie->id_lang)) . '.php';
        $mySelf = basename(__FILE__, '.php');

        if (file_exists($langFile))
        {
            require_once $langFile;
            if ( $_MODULE )
                foreach ($_MODULE as $key => $value)
                    $_MODULE[str_replace($mySelf . '_', $this->name . '_', $key)] = $value;
        }

        $this->url = 'http://' . htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8') . __PS_BASE_URI__ . 'modules/' . $this->name;
        $this->module = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->name . '/';
        $this->images = $this->module . 'images/';

        $this->test_mode = unserialize(base64_decode(PriceMinister::configurationGet('PM_TEST')));

        $this->_priceminister = new PriceMinister();

        parent::__construct();
        
        require_once(dirname(__FILE__) . '/../classes/PM_Context.class.php');
        PM_Context::restore($this->context, Validate::isLoadedObject($this->context->shop) ? $this->context->shop : NULL) ;
    }

    public function l($string, $specific = false, $id_lang = null)
    {
        return( $this->_priceminister->l($string, $specific = false, $id_lang = null) );
    }

    public function Dispatch()
    {
        $pm_token = Tools::getValue('pm_token');
        $callback = Tools::getValue('callback');
        $lang = Tools::getValue('lang');
        $id_lang = Language::getIdByIso($lang);

        //  Check Access Tokens
        //
        $pmTokens = unserialize(base64_decode(PriceMinister::configurationGet('PM_CRON_TOKEN')));

        if (is_array($pm_token))
            $pm_token = $pm_token[$id_lang];
    
        if (!isset($pmTokens[$id_lang]) || $pmTokens[$id_lang] != $pm_token)
        {
            echo $this->l('Wrong Token');

            $some_output = ob_get_clean();

            $json = PSPM_Tools::jsonEncode(array('orders' => 0, 'count'  => 0, 'error'  => false, 'errors' => array($some_output), 'output' => $some_output));

            // jQuery Output or PHP Output
            //
            if ($callback) // jquery
            {
                echo strval($callback) . '(' . $json . ')';
                die;
            }
            else // cron
            {
                echo $json;
                die;
            }
        }
        
        if ( Tools::getValue('cron') )
             $cron = true ;
        else $cron = false ;

        switch (Tools::getValue('action'))
        {
            case 'shipping' :
                $this->UpdateShipping();
                break;
            // new accepted orders
            case 'list-orders' :
                $this->ListOrders();
                break;
            // orders to accept
            case 'new-orders' :
                $this->NewOrders();
                break;
            case 'import' :
                if ( $cron )
                {
                    $json = $this->ListOrders($cron);
                    $result = $this->Import($json, $cron);
                    echo nl2br(print_r(json_decode($result), true));
                }
                else
                {
                    $this->Import();
                }
                break;
            case 'accept' :
                if ( $cron )
                {
                    $json = $this->NewOrders();
                    $result = $this->Accept($json);
                    echo nl2br(print_r(json_decode($result), true));
                }
                else
                {
                    $this->Accept();
                }                
                
                break;   
                
            case 'update' :
                die('Obsolete removed function !') ;
                break;
            
            case 'cron' :
                die('The cron task URL has changed. Please copy the URL from your module configuration and update your crontab !') ;
                break;
        }
    }

    public function UpdateShipping()
    {
        $lang = Tools::getValue('pm_order_lang');

        if ( ! ($orders = PSPM_Order::getShippingToUpdateOrders()) ) return(false) ;
        
        foreach($orders as $order)
        {
            $id_order = $order['id_order'] ;
            $mp_order_id = $order['mp_order_id'] ;
            
            $this->Update($mp_order_id, $id_order) ;
        }
    }
    
    public function GetOrderTotal($pm_order_id, $lang)
    {
        // PM Configuration
        //
        $config = array();
        $config = PSPM_Tools::Auth($lang);

        if (!is_array($config))
        {
            $pass = false;
            $errors[] = $this->l('Unexpected error, missing configuration');
        }
        $config['output_type'] = 'juicy';
        $config['output'] = 'json';


        $params = array();
        $params['purchaseid'] = $pm_order_id;

        $aSales = new PM_Sales($config);
        #$aSales->debug(true);

        $aSale = $aSales->getbillinginformation($params);
        $billinginformation = PSPM_Tools::jsonDecode($aSale);

        if (!isset($billinginformation->billinginformation))
        {
            echo Tools::displayError($this->l('Unable to retrieve order informations'));
            return;
        }

        $shippingprice = 0;
        $paymentamount = 0;

        // Plusieurs Articles
        //
        if (isset($billinginformation->billinginformation->items->item) && is_array($billinginformation->billinginformation->items->item))
            $billinginformation->billinginformation->items = $billinginformation->billinginformation->items->item;

        foreach ($billinginformation->billinginformation->items as $item)
        {
            $shippingprice += $item->shippingsaleprice->amount;
            $paymentamount += $item->itemsaleprice->amount;
        }     
        return( array('amount' => $paymentamount, 'shipping' => $shippingprice)) ;
    }
    
    public function Update($pm_order_id = null, $order_id = null)
    {
        if ( ! $pm_order_id )
            $pm_order_id = Tools::getValue('pm_order_id');
        
        if ( ! $order_id )
            $order_id = Tools::getValue('order_id');
        
        $lang = Tools::getValue('pm_order_lang');

        $order_total = $this->GetOrderTotal($pm_order_id, $lang) ;
        
        $shippingprice = $order_total['amount'] ; 
        $paymentamount = $order_total['shipping'] ;
        
        $updateOrder = new Order($order_id);

        if (!Validate::isLoadedObject($updateOrder))
        {
            echo Tools::displayError($this->l('Invalid Order'));
            return;
        }
        $updateOrder->total_shipping = $shippingprice;
        $updateOrder->total_paid = $paymentamount + $shippingprice;
        $updateOrder->total_paid_real = $paymentamount + $shippingprice;

        $updateOrder->total_products = $paymentamount;
        $updateOrder->total_products_wt = $paymentamount;

        $updateOrder->update();
    }


    public function ListOrders($cron = false)
    {
        global $cookie;

        $callback = Tools::getValue('callback');
        $lang = Tools::getValue('lang');
        $pass = true;
        $errors = array();
        $id_lang = Language::getIdByIso($lang);
        $count = false; 
          
        $dateStart = Tools::getValue('date-start-' . $lang) ;
        
        ob_start();

        // PM Configuration
        //
        $config = array();
        $config = PSPM_Tools::Auth($lang);

        if (!is_array($config))
        {
            $pass = false;
            $errors[] = $this->l('Unexpected error, missing configuration');
        }

        // Orders Output Settings
        //
        $config['output_type'] = 'juicy';
        $config['output'] = 'json';

        // PM Settings
        //
        $params = array();
        $params['field'] = '';
            
        $pmSales = new PM_Sales($config);

        $pm_debug = unserialize(base64_decode(PriceMinister::configurationGet('PM_DEBUG')));
        if ($pm_debug[$id_lang])
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);                
            
            $pmSales->debug();
        }

        if ( Validate::isDate($dateStart) )
            $params['purchasedate'] = $dateStart ;
        
        if ($this->test_mode[$id_lang])
        {
            $result = unserialize(chop(file_get_contents(dirname(__FILE__) . '/orderlist.test.out')));
            $sales = $result;
        }
        else
        {
            $result = $pmSales->getcurrentsales($params);
            $sales = PSPM_Tools::jsonDecode($result);

            # debug purpose
            #file_put_contents(dirname(__FILE__).'/orderlist.test.out', serialize($sales)) ;        
        }
        
        if ( is_array($sales->sales->sale) )
        {
            foreach($sales->sales->sale as $key => $sale)
            {
                if (($mp_order = PSPM_Order::checkByMpId($sale->purchaseid)))
                {
                    $sales->sales->sale[$key]->imported = true ;
                }    
            }
        }
        else
        {
            if (($mp_order = PSPM_Order::checkByMpId($sales->sales->sale->purchaseid)))
            {
                $sales->sales->sale->imported = true ;
            }              
        }

        if (!isset($sales->sales))
        {
            $count = 0;
            $sales = null;
            echo $this->l('No pending orders on Price Minister...');
        }
        else
        {
            if ( isset($sales->sales->sale) )
                $count = count($sales->sales->sale);

            if ($count == 1)
            {
                echo $this->l('One order pending on Price Minister');
            }
            else
            {
                echo ($count ? $count : $this->l('No')) . ' ' . $this->l('Orders pending on Price Minister');
            }
        }

        $some_output = ob_get_clean();

        $json = PSPM_Tools::jsonEncode(array('orders' => $sales, 'count'  => $count, 'error'  => !$pass, 'errors' => $errors, 'output' => $some_output));

        // jQuery Output or PHP Output
        //
        if ($callback && ! $cron) // jquery
        {
            echo strval($callback) . '(' . $json . ')';
        }
        else // cron
        {
            return $json;
        }
    }
    
    
    public function Import($json = null, $cron = false)
    {
        $callback = Tools::getValue('callback');
        $orders = null;
        $lang = Tools::getValue('lang');
        $pass = true;
        $count = null;
        $errors = array();
        $id_lang = Language::getIdByIso($lang);
        $tokenOrders = Tools::getValue('token_order');

        ob_start();
        
        $id_warehouse           = (int)PriceMinister::configurationGet('PM_WAREHOUSE') ;
        
        // PM Configuration
        //
        $config = array();
        $config = PSPM_Tools::Auth($lang);

        if (!is_array($config))
        {
            $pass = false;
            $errors[] = $this->l('Unexpected error, missing configuration');
        }
        $config['output_type'] = 'juicy';
        $config['output'] = 'json';

        // Tools::getValue remove the slashes :(
        // sometimes usefull ...
        // sur les environnements les plus hostiles, remplacer par : PSPM_Tools::jsonDecode( stripcslashes($_POST['orders']) )

        if ($json == null && !count($orders = PSPM_Tools::jsonDecode($_POST['orders'])))
            $orders = PSPM_Tools::jsonDecode(stripcslashes($_POST['orders']));

        if ($json && $cron) // CronMode
        {
            $cronMode = true ;
            $orders = PSPM_Tools::jsonDecode($json);
            $orders = $orders->orders;

            $selecteds = array();
            $products = array();
        }
        else
        {
            $cronMode = 0;
            // Tools::getValue messup the JSON structure, using _POST instead
            $selecteds = isset($_POST['selected']) ? $_POST['selected'] : array() ;
            $products = isset($_POST['products']) ? $_POST['products'] : array() ;
        }

        // Import Method
        //
        $import_method = base64_decode(PriceMinister::configurationGet('PM_IMPORT_METHOD'));
        $customer_account = base64_decode(PriceMinister::configurationGet('PM_CUSTOMER_ACCOUNT'));


        if ($customer_account == PriceMinister::INDIVIDUAL_CUSTOMER_ACCOUNT)
            $customer_account = PriceMinister::INDIVIDUAL_CUSTOMER_ACCOUNT;
        else
            $customer_account = PriceMinister::ONE_CUSTOMER_ACCOUNT;

        $customer_domain = base64_decode(PriceMinister::configurationGet('PM_INDIVIDUAL_DOMAIN'));


        // Patch !
        //
        if (isset($orders->sales->sale) && is_array($orders->sales->sale) )
            $orders->sales = $orders->sales->sale;

        // Filtering on selection
        //
        foreach ($orders->sales as $key => $order)
        {
            // One or more items
            //
            if (is_array($order->items->item))
                $order->items = $order->items->item;

            if (!$cronMode && !in_array($order->purchaseid, $selecteds))
            {
                $order->skip = 1;
                continue;
            }
            else
                $order->skip = 0;

            foreach ($order->items as $i => $item)
            {
                if (!$cronMode && !( $products && in_array($order->purchaseid . '_' . $item->itemid, $products)))
                    $item->skip = 1;
                else
                    $item->skip = 0;
            }
        }
 
        /*
         * Parametres du Module PM
         */

        // Customer ID
        //
        $customerId = PriceMinister::configurationGet('PM_CUSTOMER_ID');

        // Carriers
        //
        $shipping_methods = unserialize(base64_decode(PriceMinister::configurationGet('PM_SHIPPING_METHODS')));
        $pm_carriers = unserialize(base64_decode(PriceMinister::configurationGet('PM_PM_CARRIERS')));
        $ps_carriers = unserialize(base64_decode(PriceMinister::configurationGet('PM_PS_CARRIERS'))); 
      
        if ( isset($shipping_methods[$lang]) && isset($pm_carriers[$lang]) && isset($ps_carriers[$lang]) )
        {
            $shipping_methods = $shipping_methods[$lang] ;
            $pm_carriers = $pm_carriers[$lang] ;
            $ps_carriers = $ps_carriers[$lang] ;
        }   
        else
        {
            $shipping_methods = null ;
            $pm_carriers = null ;
            $ps_carriers = null ;
        }
        
        // Order State
        //
        $state = base64_decode(PriceMinister::configurationGet('PM_STATE'));

        // Force import on out of stock
        //
        $force_import = base64_decode(PriceMinister::configurationGet('PM_FORCE_IMPORT')) ? true : false;

        foreach ($orders->sales as $order)
        {
            if ($order->skip)
                continue;

            if (($mp_order = PSPM_Order::checkByMpId($order->purchaseid)))
            {
                $errors[] = $this->l('This order was already imported') . ' : ' . $mp_order['mp_order_id'] . "(" . $mp_order['id_order'] . ")\n" . nl2br(print_r($mp_order, true));
                $pass = false;
                continue;
            }
            if ( ! isset($order->deliveryinformation->deliveryaddress) )
              $order->deliveryinformation->deliveryaddress = $order->deliveryinformation->billingaddress ;            
            
            // Customer individual account
            //
            if ($customer_account == PriceMinister::INDIVIDUAL_CUSTOMER_ACCOUNT)
            {
                $name = PSPM_Address::toEmailAddress($order->deliveryinformation->deliveryaddress);

                if (!isset($name['firstname']) || empty($name['firstname']) || !isset($name['lastname']) || empty($name['lastname']))
                {
                    $errors[] = sprintf('%s/%s: %s: %s', basename(__FILE__), __LINE__, $this->l('Couldn\'t add this customer'), nl2br(print_r($name, true)));
                    $pass = false;
                    continue;
                }
                $firstname = $name['firstname'];
                $lastname = $name['lastname'];

                $email_address = sprintf('%s.%s@%s', $firstname, $lastname, str_replace('@', '', $customer_domain));

                // Use buyer email instead generated email
                //
                if ( isset($order->deliveryinformation->purchasebuyeremail) && Validate::isEmail($order->deliveryinformation->purchasebuyeremail) ) 
                    $email_address = $order->deliveryinformation->purchasebuyeremail ;
                
                if ( ! Validate::isEmail($email_address) )
                {   
                    $errors[] = sprintf('%s/%s: %s (%s)', basename(__FILE__), __LINE__, $this->l('Invalid email address'), $email_address);
                    $pass = false;
                    continue;                    
                }
                $customer = new Customer();
                $customer->getByEmail($email_address);                
                
                if ($customer->id)
                {
                    $customerId = $customer->id;
                }
                else
                {
                    $customer->firstname = $firstname;
                    $customer->lastname = $lastname;
                    $customer->email = $email_address;
                    $customer->passwd = md5(rand());
    
                    
                    if (!$customer->add())
                    {
                        $errors[] = sprintf('%s/%s: %s (%s)', basename(__FILE__), __LINE__, $this->l('Couldn\'t add this customer'), $email_address);
                        $pass = false;
                        continue;
                    }
                    else
                    {
                        $customerId = $customer->id;
                    }
                }
            }

            /*
             * Matching the method with the shipping matrix
             */
            $shipping_method = PSPM_Tools::cleanShippingMethod( strval($order->deliveryinformation->shippingtype) ) ;

            if ( ! isset($shipping_methods[$shipping_method]) || ! isset($pm_carriers[$shipping_method]) || ! isset($ps_carriers[$shipping_method]) || ! $pm_carriers[$shipping_method] || ! $ps_carriers[$shipping_method] )
            {
                $errors[] = sprintf($this->l('The shipping matrix doesn\'t match this case: %s - Please configure your shipping matrix in your module configuration'), $shipping_method) ;
                $pass = false ;
                continue;                
            }
            $mpShipping = $shipping_method ;
        
            $carrier = new Carrier( (int)$ps_carriers[$shipping_method] ) ;
            
            if ( ! Validate::isLoadedObject($carrier) )
            {
                $errors[] = sprintf($this->l('Carrier validation failed for: %s - Please configure the carrier in your shipping matrix in your module configuration'), $shipping_method) ;
                $pass = false ;
                continue;                
            }
            
            /*
            On 16/10/2012 19:22, Yan Gueguen wrote:
            > Bonjour,
            >
            >
            > Vous devez indiquer :
            >
            > -  deliveryaddress lors de commande par relais, colis standard etc..
            > -  billingaddress lors de commande avec collissimo, chronopost ..
            >
            >
            > Cordialement,
            >
            > Yan Gueguen
            > PriceMinister
            */
            if ( isset($order->deliveryinformation->deliveryaddress) )
                $deliveryaddress = $order->deliveryinformation->deliveryaddress ;
            else
                $deliveryaddress = $order->deliveryinformation->billingaddress ;
            
            // Create or get address book entry
            //
            $shipping_address = new PSPM_Address();
            $shipping_address->id_customer = $customerId;
            $shipping_address_id = $shipping_address->lookupOrCreateAddress($order->deliveryinformation->deliveryaddress);

            $created_at = sprintf('%d-%02d-%02d %02d:%02d:00', substr($order->purchasedate, 6, 4), substr($order->purchasedate, 3, 2), substr($order->purchasedate, 0, 2), substr($order->purchasedate, 11, 2), substr($order->purchasedate, 14, 2));

            $itemDetails = array();

            // Building Cart
            //
            $cart = new PSPM_Cart();
            $cart->id_address_delivery = $shipping_address_id;
            $cart->id_address_invoice = $shipping_address_id;
            $cart->id_carrier = $carrier->id;;
            $cart->id_currency = false;
            $cart->id_customer = $customerId;
            $cart->id_lang = $id_lang;

            foreach ($order->items as $item)
            {

                if ($item->skip)
                    continue;

                echo $item->headline . '<br />';

                if ($item->paymentstatus != 'INCOMING')
                {
                    $errors[] = 'Payment Status Error : ' . nl2br(print_r($item->paymentstatus, true));
                    $pass = false;
                    continue;
                }

                $product_name = strval($item->headline);
                $quantity = 1; // !
                $price = floatval($item->price->amount);

                // Initializing cart & currency on first item
                //
                if ($cart->id_currency === false)
                {
                    $id_currency = Currency::getIdByIsoCode($item->price->currency);
                    $cart->id_currency = $id_currency;
                    $cart->add();
                }

                // Product Combinations
                //
                $id_product_attribute = false;
                $id_combination = false;
                
                if ( $import_method == 'SKU' ) // search by reference (SKU)
                {
                    $product_item = PSPM_Product::getBySKU(strval($item->sku), $id_lang);

                    if ( ! $product_item )
                    {
                        $errors[] = $this->l('Unable to import product') . ' : ' . strval($item->sku) . ' line (' . __LINE__ . ')';
                        $pass = false && $pass;
                        continue;
                    }
                    $id_product = $product_item->id_product ;
                    $id_combination = $product_item->id_product_attribute;

                    // Load Product
                    //
                    $product = new Product($id_product, $id_lang);

                    if (!Validate::isLoadedObject($product))
                    {
                        $errors[] = $this->l('Unable to import product') . ' : ' . $id_product . ' line (' . __LINE__ . ')';
                        $pass = false && $pass;
                        continue;
                    }
                    // Load Combination
                    //
                    if ($id_combination)
                    {
                        $id_product_attribute = null ;
                        
                        if (version_compare(_PS_VERSION_, '1.5', '<'))
                            $combinations = $product->getAttributeCombinaisons($id_lang) ;
                        else
                            $combinations = $product->getAttributeCombinations($id_lang) ;

                        if ($combinations)
                            foreach ($combinations as $key => $combination)
                                if ($combination['id_product_attribute'] == $id_combination)
                                    $id_product_attribute = $combination['id_product_attribute'];

                        if (!$id_product_attribute)
                        {
                            $errors[] = sprintf('%s : %d (%d)', $this->l('Couln\'t match product attributes for product'), $id_product, $id_combination);
                            $pass = false && $pass;
                            continue;
                        }
                    }                    
                    
                }                
                elseif ( $import_method == 'ID' ) // search by product_id
                {
                    // Product has Combination
                    //
                    if (strpos($item->sku, '_'))
                    {
                        $split_combination = explode('_', $item->sku);
                        $id_product = intval($split_combination[0]);
                        $id_combination = intval($split_combination[1]);
                    }
                    else
                    {
                        $id_combination = false;
                        $id_product = intval($item->sku);
                    }

                    // Load Product
                    //
                    $product = new Product($id_product, $id_lang);

                    if (!Validate::isLoadedObject($product))
                    {
                        $errors[] = $this->l('Unable to import product') . ' : ' . $id_product . ' line (' . __LINE__ . ')';
                        $pass = false && $pass;
                        continue;
                    }

                    // Load Combination
                    //
                    if ($id_combination)
                    {
                        if (version_compare(_PS_VERSION_, '1.5', '<'))
                            $combinations = $product->getAttributeCombinaisons($id_lang) ;
                        else
                            $combinations = $product->getAttributeCombinations($id_lang) ;

                        if ($combinations)
                            foreach ($combinations as $key => $combination)
                                if ($combination['id_product_attribute'] == $id_combination)
                                    $id_product_attribute = $combination['id_product_attribute'];

                        if (!$id_product_attribute)
                        {
                            $errors[] = sprintf('%s : %d (%d)', $this->l('Couln\'t match product attributes for product'), $id_product, $id_combination);
                            $pass = false && $pass;
                            continue;
                        }
                    }
                }

                if (version_compare(_PS_VERSION_, '1.5', '<'))
                {
                    $productQuantity = Product::getQuantity(intval($id_product), $id_product_attribute ? $id_product_attribute : null);
                }
                else
                {
                    $productQuantity = Product::getRealQuantity($id_product, $id_product_attribute ? $id_product_attribute : null, $id_warehouse);
                }

                if ( ! $force_import && $productQuantity - $quantity < 0 )
                {
                    $errors[] = sprintf('%s ID: %s SKU: %s', $this->l('Not enough stock for this product'), $id_product, $item->sku) ;
                    $pass = false && $pass;
                    $order->skip = true;
                    continue ;
                }
                
                if ( $cart->updateQty($quantity, $id_product, $id_product_attribute) < 0 )
                {
                    $errors[] = sprintf('%s : ID: %d - SKU: %d - %s', $this->l('Not enough stock for this product'), $id_product, $item->sku, $product_name);
                    $pass = false && $pass;
                    $order->skip = true;
                    continue;
                }

                // PS 1.4 sinon 1.3
                //
                if (method_exists('Tax', 'getProductTaxRate'))
                    $product_tax_rate = (float) (Tax::getProductTaxRate($product->id, $shipping_address_id));
                else
                    $product_tax_rate = (float) (Tax::getApplicableTax($product->id_tax, $product->tax_rate, $shipping_address_id));

                
                if (isset($itemDetails[strval($item->itemid)]))
                {
                    $itemDetails[strval($item->itemid)]['qty'] += $quantity;
                }
                else
                {
                    $itemDetails[strval($item->itemid)] =
                            array(
                                'id_product'          => (int)$id_product,
                                'id_attribute'        => (int)$id_product_attribute,
                                'qty'                 => $quantity,
                                'price'               => $price,
                                'name'                => $product_name,
                                'itemid'              => strval($item->itemid),
                                'tax_rate'            => $product_tax_rate,
                                'id_tax'              => isset($product->id_tax) ? $product->id_tax : false,
                                'id_address_delivery' => $shipping_address_id
                            );
                }
            }

            if (!count($itemDetails))
            {
                $errors[] = $this->l('Cart empty, could save order') . ' (' . $order->purchaseid . ')';
                $pass = $pass && false;
                
                if (Validate::isLoadedObject($cart))
                    $cart->delete() ;   
                
                continue;
            }

            $order_id = strval($order->purchaseid);
            
            $order_total = $this->GetOrderTotal($order_id, $lang) ;

            $shippingprice = $order_total['shipping'] ; 

            
            // Using price, shipping details etc... from the Market Place
            //
            $cart->pmProducts = $itemDetails;
            $cart->pmShipping = $shippingprice;
            $cart->pmDate = $created_at;

            $mpStatusId = true;
            $mpItems = null ; // obsolete

            // duplication du panier, important !!!
            //
            $acart = $cart;

            $payment = new PSPM_PaymentModule();
            $newOrderId = null;

            if (!$order->skip && ($newOrderId = $payment->validateMarketplaceOrder($cart->id, $state, 'Price Minister', $order_id, $mpStatusId, $mpShipping, $mpItems, $acart, true, $created_at)))
            {
                $params = array();

                foreach ($itemDetails as $item)
                {
                    $params['itemid'] = $item['itemid'];
                    $order->checked = false ;
                    
                    if (!$this->test_mode[$id_lang])
                    {
                        $aSales = new PM_Sales($config);
                        $result = $aSales->acceptsale($params);
                        if ( $result )
                            $order->checked = true ;
                    }
                    else    $order->checked = true ;
                }

                $order->order_id = $newOrderId;
                $count++;
            }
            else
            {
                $errors[] = sprintf($this->l('1 or more error occurs, unable to import order ID : %s'), $order_id);
                $pass = $pass && false;
            }

            if ($newOrderId)
            {
                if ($tokenOrders)
                {
                    $imported = '';
                    $imported .= sprintf('<hr style="width:60%%;"/><span style="color:green;display:inline-block;margin-bottom:5px;">' . $this->l('Order ID %s(%s) Successfully imported in the Order Tab') . '</span><br />' . "\n", $order_id, $newOrderId);
                    $imported .= sprintf('%s: <img src="%sdetails.gif" style="cursor:pointer;" onclick="window.open(\'?tab=AdminOrders&id_order=%s&vieworder&token=%s\')"><br />' . "\n", $this->l('Go to the order in a new window'), $this->images, $newOrderId, $tokenOrders);
                    echo $imported;
                }
                else
                {
                    printf($this->l('Order ID %s(%s) Successfully imported in the Order Tab') . "<br />\n", $order_id, $newOrderId);
                }
            }
            else
                printf($this->l('Order ID %s Skipped') . "<br />\n", $order_id);
        }
  
        if ($count == 1)
            echo $this->l('One order imported ...');
        elseif ($count > 1)
            printf($this->l('%d orders imported...'), $count);
        else
            printf($this->l('No order imported...'), $count);

        $some_output = ob_get_clean();

        $json = PSPM_Tools::jsonEncode(array('orders' => $orders, 'count'  => $count, 'error'  => !$pass, 'errors' => $errors, 'output' => $some_output));

        // jQuery Output or PHP Output
        //
      if ($callback && ! $cron) // jquery
        {
            echo strval($callback) . '(' . $json . ')';
        }
        else // cron
        {
            return $json;
        }
    }

    
    public function Accept($json = null)
    {
        $callback = Tools::getValue('callback');
        $orders = null;
        $lang = Tools::getValue('lang');
        $pass = true;
        $count = null;
        $errors = array();
        $id_lang = Language::getIdByIso($lang);

        ob_start();

        $id_warehouse           = (int)PriceMinister::configurationGet('PM_WAREHOUSE') ;
                
        // PM Configuration
        //
        $config = PSPM_Tools::Auth($lang);

        if (!is_array($config))
        {
            $pass = false;
            $errors[] = $this->l('Unexpected error, missing configuration');
        }
        $config['output_type'] = 'juicy';
        $config['output'] = 'json';

        // Tools::getValue remove the slashes :(
        // sometimes usefull ...
        // sur les environnements les plus hostiles, remplacer par : PSPM_Tools::jsonDecode( stripcslashes($_POST['orders']) )

        if ($json == null && !count($orders = PSPM_Tools::jsonDecode($_POST['orders'])))
            $orders = PSPM_Tools::jsonDecode(stripcslashes($_POST['orders']));

        if ($json) // CronMode
        {
            $cronMode = 1;
            $orders = PSPM_Tools::jsonDecode($json);
            $orders = $orders->orders;

            $selecteds = array();
            $products = array();
        }
        else
        {
            $cronMode = 0;
            // Tools::getValue messup the JSON structure, using _POST instead
            $selecteds = isset($_POST['selected']) ? $_POST['selected'] : array() ;
            $products = isset($_POST['products']) ? $_POST['products'] : array() ;
        }

        // Import Method
        //
        $import_method = base64_decode(PriceMinister::configurationGet('PM_IMPORT_METHOD'));

        // Patch !
        //
        if (isset($orders->sales->sale) && is_array($orders->sales->sale))
            $orders->sales = $orders->sales->sale;

        // Filtering on selection
        //
        foreach ($orders->sales as $key => $order)
        {
            // One or more items
            //
            if (is_array($order->items->item))
                $order->items = $order->items->item;

            if (!$cronMode && !in_array($order->purchaseid, $selecteds))
            {
                $order->skip = 1;
                continue;
            }
            else
                $order->skip = 0;

            foreach ($order->items as $i => $item)
            {
                if (!$cronMode && !( $products && in_array($order->purchaseid . '_' . $item->itemid, $products)))
                    $item->skip = 1;
                else
                    $item->skip = 0;
            }
        }

        // Force import on out of stock
        //
        $force_import = base64_decode(PriceMinister::configurationGet('PM_FORCE_IMPORT')) ? true : false;

        foreach ($orders->sales as $order)
        {
            if ($order->skip)
                continue;

            if (($mp_order = PSPM_Order::checkByMpId($order->purchaseid)))
            {
                $errors[] = $this->l('This order was already imported') . ' : ' . $mp_order['mp_order_id'] . "(" . $mp_order['id_order'] . ")\n" . nl2br(print_r($mp_order, true));
                $pass = false;
                continue;
            }
            
            $itemDetails = array();
            $shipping_price = 0;
            $mpStatusId = null;
            $mpItems = null;

            foreach ($order->items as $item)
            {
                if ($item->skip)
                    continue;

                echo $item->headline . '<br />';

                if ($item->paymentstatus != 'INCOMING')
                {
                    $errors[] = 'Payment Status Error : ' . nl2br(print_r($item->paymentstatus, true));
                    $pass = false;
                    continue;
                }

                $product_name = strval($item->headline);
                $quantity = 1; // !
                $price = floatval($item->price->amount);

                // Product Combinations
                //
                $id_product_attribute = false;
                $id_combination = false;
                
                if ( $import_method == 'SKU' ) // search by reference (SKU)
                {
                    $product_item = PSPM_Product::getBySKU(strval($item->sku), $id_lang);

                    if ( ! $product_item )
                    {
                        $errors[] = $this->l('Unable to accept product') . ' : ' . strval($item->sku) . ' line (' . __LINE__ . ')';
                        $pass = false && $pass;
                        continue;
                    }
                    $id_product = $product_item->id_product ;
                    $id_combination = $product_item->id_product_attribute;

                    // Load Product
                    //
                    $product = new Product($id_product, $id_lang);

                    if (!Validate::isLoadedObject($product))
                    {
                        $errors[] = $this->l('Unable to accept this product') . ' : ' . $id_product . ' line (' . __LINE__ . ')';
                        $pass = false && $pass;
                        continue;
                    }
                    // Load Combination
                    //
                    if ($id_combination)
                    {
                        $id_product_attribute = null ;
                        
                        if (version_compare(_PS_VERSION_, '1.5', '<'))
                            $combinations = $product->getAttributeCombinaisons($id_lang) ;
                        else
                            $combinations = $product->getAttributeCombinations($id_lang) ;

                        if ($combinations)
                            foreach ($combinations as $key => $combination)
                                if ($combination['id_product_attribute'] == $id_combination)
                                    $id_product_attribute = $combination['id_product_attribute'];

                        if (!$id_product_attribute)
                        {
                            $errors[] = sprintf('%s : %d (%d)', $this->l('Couln\'t match product attributes for product'), $id_product, $id_combination);
                            $pass = false && $pass;
                            continue;
                        }
                    }                    
                    
                }                
                elseif ( $import_method == 'ID' ) // search by product_id
                {
                    // Product has Combination
                    //
                    if (strpos($item->sku, '_'))
                    {
                        $split_combination = explode('_', $item->sku);
                        $id_product = intval($split_combination[0]);
                        $id_combination = intval($split_combination[1]);
                    }
                    else
                    {
                        $id_combination = false;
                        $id_product = intval($item->sku);
                    }

                    // Load Product
                    //
                    $product = new Product($id_product, $id_lang);

                    if (!Validate::isLoadedObject($product))
                    {
                        $errors[] = $this->l('Unable to import product') . ' : ' . $id_product . ' line (' . __LINE__ . ')';
                        $pass = false && $pass;
                        continue;
                    }

                    // Load Combination
                    //
                    if ($id_combination)
                    {
                        if (version_compare(_PS_VERSION_, '1.5', '<'))
                            $combinations = $product->getAttributeCombinaisons($id_lang) ;
                        else
                            $combinations = $product->getAttributeCombinations($id_lang) ;

                        if ($combinations)
                            foreach ($combinations as $key => $combination)
                                if ($combination['id_product_attribute'] == $id_combination)
                                    $id_product_attribute = $combination['id_product_attribute'];

                        if (!$id_product_attribute)
                        {
                            $errors[] = sprintf('%s : %d (%d)', $this->l('Couln\'t match product attributes for product'), $id_product, $id_combination);
                            $pass = false && $pass;
                            continue;
                        }
                    }
                }


                if (version_compare(_PS_VERSION_, '1.5', '<'))
                {
                    $productQuantity = Product::getQuantity(intval($id_product), $id_product_attribute ? $id_product_attribute : null);
                }
                else
                {
                    $productQuantity = Product::getRealQuantity($id_product, $id_product_attribute ? $id_product_attribute : null, $id_warehouse);
                }

                if ( ! $force_import && $productQuantity - $quantity < 0 )
                {
                    $errors[] = sprintf('%s ID: %s SKU: %s', $this->l('Not enough stock for this product'), $id_product, $item->sku) ;
                    $pass = false && $pass;
                    $order->skip = true;
                    continue ;
                }

                if (isset($itemDetails[$id_product]))
                {
                    $itemDetails[strval($item->itemid)]['qty'] += $quantity;
                }
                else
                {
                    $itemDetails[strval($item->itemid)] =
                            array(
                                'id_product'          => (int)$id_product,
                                'id_attribute'        => (int)$id_product_attribute,
                                'qty'                 => $quantity,
                                'price'               => $price,
                                'name'                => $product_name,
                                'itemid'              => strval($item->itemid),
                            );
                }
            }

            if (!count($itemDetails))
            {
                $errors[] = $this->l('Cart empty, could save order') . ' (' . $order->purchaseid . ')';
                $pass = $pass && false;
                
                continue;
            }

            $order_id = strval($order->purchaseid);
            
            if ( ! $order->skip ) 
            {
                $order->checked = false ;
                foreach ($itemDetails as $item)
                {
                    $params['itemid'] = $item['itemid'];

                    if (!$this->test_mode[$id_lang])
                    {
                        $aSales = new PM_Sales($config);
                        $result = $aSales->acceptsale($params);
                    }
                    else
                    {
                        $result = true ;
                    }
                    $order->checked = ($result ? true : false) ;
                }
                if ( $order->checked )
                        $count++ ;
            }
            else
            {
                $errors[] = sprintf($this->l('1 or more error occurs, unable to import order ID : %s'), $order_id);
                $pass = $pass && false;
            }

        }

        if ($count == 1)
            echo $this->l('One order accepted ...');
        elseif ($count > 1)
            printf($this->l('%d orders accepted...'), $count);
        else
            printf($this->l('No order accepted...'), $count);

        $some_output = ob_get_clean();

        $json = PSPM_Tools::jsonEncode(array('orders' => $orders, 'count'  => $count, 'error'  => !$pass, 'errors' => $errors, 'output' => $some_output));

        // jQuery Output or PHP Output
        //
        if ($callback) // jquery
        {
            echo strval($callback) . '(' . $json . ')';
        }
        else // cron
        {
            return $json;
        }
    }
    
    public function NewOrders()
    {
        global $cookie;

        $callback = Tools::getValue('callback');
        $lang = Tools::getValue('lang');
        $pass = true;
        $errors = array();
        $id_lang = Language::getIdByIso($lang);
        $count = false; 
        
        ob_start();

        // PM Configuration
        //
        $config = array();
        $config = PSPM_Tools::Auth($lang);

        if (!is_array($config))
        {
            $pass = false;
            $errors[] = $this->l('Unexpected error, missing configuration');
        }

        // Orders Output Settings
        //
        $config['output_type'] = 'juicy';
        $config['output'] = 'json';

        // PM Settings
        //
        $params = array();
        $params['field'] = '';

        $pmSales = new PM_Sales($config);

        $pm_debug = unserialize(base64_decode(PriceMinister::configurationGet('PM_DEBUG')));
        if ($pm_debug[$id_lang])
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);                
            
            $pmSales->debug();
        }
        if ($this->test_mode[$id_lang])
        {
            $result = PSPM_Tools::jsonDecode(unserialize(chop(file_get_contents(dirname(__FILE__) . '/orders.test2.out'))));
            $sales = $result;
        }
        else
        {
            $result = $pmSales->getnewsales($params);
            $sales = PSPM_Tools::jsonDecode($result);
        }
# debug purpose
#        file_put_contents(dirname(__FILE__).'/orders.test.out', serialize($result)) ;

        if (!isset($sales->sales))
        {
            $count = 0;
            $sales = null;
            echo $this->l('No pending orders on Price Minister...');
        }
        else
        {
            if ( isset($sales->sales->sale) )
                $count = count($sales->sales->sale);

            if ($count == 1)
            {
                echo $this->l('One order pending on Price Minister');
            }
            else
            {
                echo ($count ? $count : $this->l('No')) . ' ' . $this->l('Orders pending on Price Minister');
            }
        }

        $some_output = ob_get_clean();

        $json = PSPM_Tools::jsonEncode(array('orders' => $sales, 'count'  => $count, 'error'  => !$pass, 'errors' => $errors, 'output' => $some_output));

        // jQuery Output or PHP Output
        //
        if ($callback) // jquery
        {
            echo strval($callback) . '(' . $json . ')';
        }
        else // cron
        {
            return $json;
        }
    }

}

$pmoc = new PriceMinisterOrder();
$pmoc->Dispatch();
?>