<?php
/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: contact@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@smartmarseille.com
 * ...........................................................................
 * @package    PriceMinister
 * @copyright  Copyright (c) 2011-2014 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2014 Common Services Co Ltd (http://www.common-services.com)
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * 
 */

if ( isset($_SERVER['DropBox']) && $_SERVER['DropBox'] )
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') ) ;
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') ) ;
}
else    
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php') ;
    @require_once(dirname(__FILE__) . '/../../../init.php');
}
require_once(dirname(__FILE__).'/../priceminister.php');

require_once(dirname(__FILE__).'/../classes/Priceminister_Webservices.class.php');
require_once(dirname(__FILE__).'/../classes/PM_Wallet.class.php');

require_once(dirname(__FILE__).'/../classes/PSPM_Tools.class.php');

class PriceMinisterConnexionCheck extends PriceMinister
{
    public function __construct()
    {
        $this->name = 'priceminister' ;

        $this->test_mode    =   unserialize(base64_decode(PriceMinister::configurationGet('PM_TEST')) ) ;

        $this->path = _PS_MODULE_DIR_ . '/' . $this->name . '/' ;
        $this->url = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->name ;
        $this->images = $this->url . '/images/';
        parent::__construct();
        
        require_once(dirname(__FILE__) . '/../classes/PM_Context.class.php');

        PM_Context::restore($this->context, Validate::isLoadedObject($this->context->shop) ? $this->context->shop : NULL) ;
    }

    public function Dispatch()
    {
       switch( Tools::getValue('action'))
       {
         case 'check' :
            $this->Check() ;
            break ;
       }
    }


    public function Check()
    {
        $id_lang = Tools::getValue('id_lang') ;

        $lang = Language::getIsoById($id_lang) ;

        $pm_debug = unserialize(base64_decode(PriceMinister::configurationGet('PM_DEBUG')) ) ;
        
        if ( $pm_debug[$id_lang] )
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);            
        }            
        // PM Configuration
        //
        $config = array() ;
        $config = PSPM_Tools::Auth($lang, Tools::getValue('login'), Tools::getValue('token')) ;
        $config['output'] = 'json' ;
        $config['output_type'] = 'pair' ;

        $params = array() ;


        $wallet = new PM_Wallet($config);
        $result = $wallet->getoperations($params);

        $json = PSPM_Tools::jsonDecode($result) ;

        $test_mode    =   unserialize(base64_decode(PriceMinister::configurationGet('PM_TEST')) ) ;
        if ( isset($test_mode) && intval($test_mode[$id_lang]) )
            die('<span class="connectivity-ok">Test Mode, assuming the Connexion is Ok !</span>') ;

        if ( isset($json->error->message) )
        {
            print('<span class="connectivity-error">Connexion to Price Minister : ERROR !</span><br />') ;
            die($json->error->message) ;
        }
        elseif ( ! isset($json->response) )
        {
            print('<span class="connectivity-error">Connexion to Price Minister : ERROR !</span><br />') ;
            die( nl2br(print_r($json, true)) ) ;
        }
        else
        {
            die('<span class="connectivity-ok">Connexion to Price Minister : OK !</span>') ;
        }
    }
}
$pmConnexionCheck = new PriceMinisterConnexionCheck() ;
$pmConnexionCheck->Dispatch() ;

?>