<?php

class AdminPriceMinisterProductsControllerExt extends PriceMinister {

    public $id_lang;
    private $module = 'priceminister';
    protected $url;
    protected $path;
    protected $images;
    protected $debug;

    public function __construct($id_lang) {
        $this->id_lang = $id_lang;
        parent::__construct();
        $this->url = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->module;
        $this->path = str_replace('\\', '/', _PS_MODULE_DIR_) . $this->module . '/';
        $this->images = $this->url . '/images/';
        $this->debug = PriceMinister::configurationGet('PM_DEBUG') ? true : false;
        
    }
    public function l($string, $specific = false, $id_lang = null)
    {
      return( parent::l($string, 'AdminPriceMinisterProductsController', $this->id_lang) );
    }
    
    public function content($smarty) {
        
        if(version_compare(_PS_VERSION_, '1.5', '>=')){
            require_once(dirname(__FILE__) . '/../../classes/PM_Context.class.php');
           $smarty->assign('context_key', PM_Context::getKey($this->context->shop)) ;
        }else{
           $smarty->assign('context_key','0'); 
        }
        
        $smarty->assign('path', $this->url);
        $smarty->assign('images', $this->images);
        $smarty->assign('export_url', $this->url . '/functions/productexport.php');
        $smarty->assign('export_products_js', $this->url . '/js/productexport.js');
        $smarty->assign('langs', $this->_tabs());
        $smarty->assign('langs_content', $this->_exporttab());
        
        if (method_exists($smarty, 'setTemplateDir')) {
            $currentTemplates = $smarty->getTemplateDir();
            $additionnalTemplates = array($this->path . 'views/catalog/');
            $smarty->setTemplateDir(is_array($currentTemplates) ? array_merge($currentTemplates, $additionnalTemplates) : $additionnalTemplates );
        } else {
            $smarty->template_dir = $this->path . 'views/catalog/';
        }

        return( $smarty->fetch($this->path . 'views/catalog/AdminCatalogPriceMinister.tpl') );
    }

    private function _tabs() {
        $view_params = array();
        $languages = Language::getLanguages();
        $selected_tab = ($lng = Tools::getValue('selected_tab')) ? $lng : strtolower(Language::getIsoById((int)Configuration::get('PS_LANG_DEFAULT')));

        $i = 0;
        foreach ($languages as $language) {
            // For active languages
            //
        if ($language['active'] === false) {
                continue;
            }
            // Allow only available platforms
            //
        switch ($language['iso_code']) {
                case 'fr' :
                //case 'es' :
                    $pass = true;
                    break;
                default :
                    $pass = false;
                    continue;
            }
            if (!$pass) {
                continue;
            }
            $view_params[] = array("lang_iso_code" => $language['iso_code'],
                "lang_selected" => $selected_tab == $language['iso_code'] ? 'selected' : '',
                "lang_id" => $language['id_lang'],
                "lang_name" => $language['name']
            );
            $i++;
        }

        return $view_params;
    }

    private function _exporttab() {
        $file = $this->path . 'export/%s.csv';
        $languages = Language::getLanguages();
        $selected_tab = ($lng = Tools::getValue('selected_tab')) ? $lng : strtolower(Language::getIsoById(Configuration::get('PS_LANG_DEFAULT')));
        $view_params = array();
        $i = 0;

        $update_mode_enabled = (bool)Configuration::get('PM_UPDATE_MODE_ENABLED');
        
        if (version_compare(_PS_VERSION_, '1.5', '<')) {
            
            $profiles_settings = unserialize(base64_decode(Configuration::get('PM_PROFILES')));
            $profiles_formats = unserialize(base64_decode(Configuration::get('PM_PROFILES_FORMATS')));
            $default_categories = unserialize(base64_decode(Configuration::get('PM_CATEGORIES')));
            $export_reports = unserialize(base64_decode(Configuration::get('PM_EXPORTS')));
        } else {
            $profiles_settings = unserialize(base64_decode(PriceMinister::configurationGet('PM_PROFILES')));
            $profiles_formats = unserialize(base64_decode(PriceMinister::configurationGet('PM_PROFILES_FORMATS')));
            $default_categories = unserialize(base64_decode(PriceMinister::configurationGet('PM_CATEGORIES')));
            $export_reports = unserialize(base64_decode(PriceMinister::configurationGet('PM_EXPORTS')));
        }

        $pmTokens = unserialize(base64_decode(Configuration::get('PM_CRON_TOKEN')));

        foreach ($languages as $language) {

            // For active languages
            //
          if ($language['active'] === false) {
                continue;
            }
            // Allow only available platforms
            //
          switch ($language['iso_code']) {
                case 'fr' :
                    $pass = true;
                    break;
                default :
                    $pass = false;
                    continue;
            }
            if (!$pass) {
                continue;
            }

            $id_lang = $language['id_lang'];
            $content = array();
            $content['lang_id'] = $id_lang;
            $content['lang_name'] = $language['name'];
            $content['lang_selected'] = $selected_tab == $language['iso_code'] ? 'selected' : '';
            $content['lang_iso_code'] = $language['iso_code'];
            $content['lang_pm_token'] = isset($pmTokens[$id_lang]) ? $pmTokens[$id_lang] : null;
            $content['request_uri'] = $_SERVER['REQUEST_URI'];
            $content['selected_tab'] = $selected_tab;
            $content['update_mode_enabled'] = $update_mode_enabled;
            $content['profiles'] = array();
            if ($profiles_settings[$language['id_lang']]) {
                foreach ($profiles_settings[$language['id_lang']] as $profile) {
                    $p = array();
                    $p['ids'] = $profile['ids'];

                    $p['categories'] = array();
                    if ($profile['categories']) {
                        foreach ($profile['categories'] as $id_category) {
                            $p['categories'][] = array("value" => $id_category, "desc" => self::_cPath($id_category));
                        }
                    }

                    if (file_exists(sprintf($file, $profile['ids']))) {
                        $export = sprintf($file, $profile['ids']);
                        $stat = stat($export);
                        $mtime = date('Y-m-d H:i:s', $stat['mtime']);
                        $href = $this->url . '/export/' . basename($export) . '?date=' . $mtime;
                        $target = ' target="_blank"';
                        $color = 'style="color:green"';
                    } else {
                        $export = sprintf($file, $profile['ids']);
                        $mtime = $this->l('Never Exported');
                        $href = '#';
                        $target = '';
                        $color = 'style="color:grey"';
                    }
                    $p['export'] = basename($export);
                    $p['mtime'] = $mtime;
                    $p['href'] = $href;
                    $p['target'] = $target;
                    $p['color'] = $color;

                    $content['profiles'][] = $p;
                }
            }

            if (count($profiles_settings[$language['id_lang']]) > 0) {
                $content['configured'] = '1';
            }
            $i++;
            $view_params[] = $content;
        }
        return $view_params;
    }

    private static function _cPath($id_category) {
        global $cookie;

        $c = new Category($id_category, $cookie->id_lang);

        if (!isset($category))
            $category = '';

        if ($c->id_parent)
            $category .= self::_cPath($c->id_parent) . ' > ';

        $category .= $c->name;

        return(rtrim($category, ' > '));
    }

}