<?php

class AdminPriceMinisterOrdersControllerExt extends PriceMinister
{
    public $id_lang ;
    private $module = 'priceminister';
    
    protected $url ;
    protected $path ;
    protected $images ;
    protected $debug ;    
    
    public function __construct($id_lang)
    {
        $this->id_lang  = $id_lang ; 
        parent::__construct();   
        $this->url      = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->module . '/' ;
        $this->path     = str_replace('\\', '/', _PS_MODULE_DIR_) . $this->module . '/' ;
        $this->images   = $this->url . '/images/';
        $this->debug    = PriceMinister::configurationGet('PM_DEBUG') ? true : false ;        
    }
    public function l($string, $specific = false, $id_lang = null)
    {
      return( parent::l($string, 'AdminPriceMinisterOrdersController', $this->id_lang) );
    }
    
    public function content($smarty)
    {
        global $cookie ;
        
        if(version_compare(_PS_VERSION_, '1.5', '>=')){
           require_once(dirname(__FILE__) . '/../../classes/PM_Context.class.php');
           $smarty->assign('context_key', 
                   PM_Context::getKey(Validate::isLoadedObject($this->context->shop) ? $this->context->shop : NULL)) ;
        }else{
           $smarty->assign('context_key','0'); 
        }
        
        $smarty->assign('path', $this->url) ;
        $smarty->assign('images', $this->images) ;
        $smarty->assign('js_file', $this->module . '/js/ordertab.js') ;
        $smarty->assign('image_loading', $this->url . '/images/loading.gif') ;        
        
        $view_params = array();        
        
        if (method_exists($smarty, 'setTemplateDir')) {
            $currentTemplates = $smarty->getTemplateDir();
            $additionnalTemplates = array($this->path . 'views/orders/');
            $smarty->setTemplateDir(is_array($currentTemplates) ? array_merge($currentTemplates, $additionnalTemplates) : $additionnalTemplates );
        } else {
            $smarty->template_dir = $this->path . 'views/orders/';
        }
        
        $smarty->assign('path', $this->url) ;
        $smarty->assign('tokenOrders', Tools::getAdminToken('AdminOrders' . (int) Tab::getIdFromClassName('AdminOrders') . (int) $cookie->id_employee)) ;
        $images = $this->url . 'images/';
        $smarty->assign('loader', $images . 'loading.gif') ;
        $smarty->assign('orders_url', $this->url . 'functions/orders.php') ;
        
        // PS/PM - API Access Checking
        $this->pm_logins = unserialize(base64_decode(Configuration::get('PM_LOGIN')));
        $this->pm_tokens = unserialize(base64_decode(Configuration::get('PM_TOKEN')));
        $this->cron_tokens = unserialize(base64_decode(Configuration::get('PM_CRON_TOKEN')));
        
        $selected_tab = ($lng = Tools::getValue('selected_tab')) ? $lng : strtolower(Language::getIsoById((int)Configuration::get('PS_LANG_DEFAULT')));
        $i = 0;
        
        $view_params['langs']  =array();
        foreach ($this->_get_active_langs() as $language)
        {
            $view_params['langs'][] = array(
                        "lang_iso_code"=>$language['iso_code'], 
                        "lang_selected"=> ($selected_tab == $language['iso_code'] ? 'selected' : ''),
                        "lang_id"=>$language['id_lang'],
                        "lang_name"=>$language['name'],
                );            
        }
        
        if (count($view_params['langs'])==0)
        {            
            $smarty->assign('review_module_settings', '1') ;
        } else {        
            $smarty->assign('langs', $view_params['langs']) ;

            $view_params['langs_content']  =array();
            foreach ($this->_get_active_langs() as $language)
            {
                $id_lang = (int)$language['id_lang'];
                $lang = trim($language['iso_code']);
                $content = array();
                $content['cron_token'] = isset($this->cron_tokens[$id_lang]) ? $this->cron_tokens[$id_lang] : null ;
                // Order Accept
                $content['accept_tab'] = $this->_accept_management($lang);
                // Order Import
                $content['import_tab'] = $this->_import_management($lang);
                $view_params['langs_content'][] = $content;
            }
            $smarty->assign('langs_content', $view_params['langs_content']);
        }
        $smarty->assign('selected_tab', $selected_tab) ;
        
        return( $smarty->fetch($this->path . 'views/orders/AdminOrdersPriceMinister.tpl') ) ;

    }

    function _accept_management($lang)
    {
        $view_params = array();
        
        $view_params['request_uri'] = $_SERVER['REQUEST_URI'];
        $view_params['lang'] = $lang;
        
        return $view_params;
    }

    function _import_management($lang)
    {
        $view_params = array();
        $view_params['request_uri'] = $_SERVER['REQUEST_URI'];
        $view_params['lang'] = $lang;
        $view_params['date_start']  =date('Y-m-d', strtotime('yesterday'));
        
        return $view_params;
    }  
    
    private function _get_active_langs()
    {
        $ps_languages = Language::getLanguages();
        $languages = array();

        foreach ($ps_languages as $language)
        {
            $id_lang = $language['id_lang'];

            // For active languages
            //
        if ($language['active'] === false)
                continue;

            // Allow only available platforms
            //
            switch ($language['iso_code'])
            {
                case 'fr' :
                //case 'es' :
                    $pass = true;
                    break;
                default :
                    $pass = false;
                    continue;
            }
            if (!$pass)
                continue;

            if ( ! isset($this->pm_tokens[$id_lang]) || empty($this->pm_logins[$id_lang]) || empty($this->pm_tokens[$id_lang]))
                continue;

            $languages[] = $language;
        }
        return($languages);
    }


}