<?php
/*
    Filename:           Priceminister_Webservices.class.php - Base Class
    Created:            7/17/2011, � 2006 kernelbd.com Abdul Mohymen
    Descripton:         Base class of Webserivces of PriceMinister.com API
    Requirements:
        - PHP with XML support
        - a Developer's token from PriceMinister (https://ws.priceminister.co.uk/)
*/
interface iPriceminister
{
    public function make_request($url, $params);
    public function data_check($result);
	public function process_response($result);
	public function jsondata($response);
	public function post_curl($url, $params);
	public function xml2array($contents, $get_attributes=1, $priority = 'tag');
}

abstract class Priceminister_Webservices implements iPriceminister {
	public $config = array();
	public $params = array();
    private $_debug = false ;

	function debug($debug = true) {
		$this->_debug = $debug;
	} // end func

	public function make_request($url, $params) {
		$result = $this->post_curl($url, $params);
		$response_array = $this->xml2array($result);
		$response = $this->data_check($response_array);
		return (isset($this->config['output']) && $this->config['output'] == 'json') ? $this->jsondata($response) : $response;
	} // end func

	public function data_check($result) {
		return (isset($result['errorresponse'])) ? $result['errorresponse'] : $this->process_response($result);
	} // end func

	public function process_response($result) {
		if( isset($this->config['output_type']) && $this->config['output_type'] == 'raw') {
			return $result;
		}
		else {
			$result = array_shift($result);
			return (isset($this->config['output_type']) && $this->config['output_type'] == 'pair') ? $result : (isset($result['response']) ? $result['response'] : null) ;
		}
	} // end func

	public function jsondata($response) {
		return PSPM_Tools::jsonEncode($response);
	} // end func


	public function post_curl($url, $params) {
		$ch = curl_init();

        // Patch - la soumission ne fonctionne pas sur certaines configuration (?)
        //
        $currentDir = getcwd() ;
        if ( isset($params['file']) && $params['file'] )
        {
          $file = realpath(substr($params['file'], 1)) ;
          chdir(dirname($file));
          $file = basename($file);
          $params['file'] = '@'.$file ;
        }

		curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.1) Gecko/20061204 Firefox/2.0.0.1");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
		curl_setopt($ch, CURLOPT_URL, $url);

		$page = curl_exec($ch);

        chdir($currentDir) ; // pour le patch

        if ( $this->_debug )
        {
          print "<pre>\n";
          print_r(curl_getinfo($ch));  // get error info
          echo "cURL error number:" .curl_errno($ch) . "\n"; // print error info
          echo "cURL error:" . curl_error($ch) . "\n";
          echo htmlspecialchars(print_r($page, true));
          print "</pre>\n";
        }

        curl_close($ch);

		return $page;
	} // end func


    /*  XML 2 ARRAY
        Event handler called by the expat library when an element's end tag is encountered.
    */
	public function xml2array($contents, $get_attributes=1, $priority = 'tag') {
		if(!$contents) return array();

		if(!function_exists('xml_parser_create')) {
			//print "'xml_parser_create()' function not found!";
			return array();
		}

		//Get the XML parser of PHP - PHP must have this module for the parser to work
		$parser = xml_parser_create('');
		xml_parser_set_option($parser, XML_OPTION_TARGET_ENCODING, "UTF-8"); # http://minutillo.com/steve/weblog/2004/6/17/php-xml-and-character-encodings-a-tale-of-sadness-rage-and-data-loss
		xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
		xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
		xml_parse_into_struct($parser, trim($contents), $xml_values);
		xml_parser_free($parser);

		if(!$xml_values) return;//Hmm...

		//Initializations
		$xml_array = array();
		$parents = array();
		$opened_tags = array();
		$arr = array();

		$current = &$xml_array; //Refference

		//Go through the tags.
		$repeated_tag_index = array();//Multiple tags with same name will be turned into an array
		foreach($xml_values as $data) {
			unset($attributes,$value);//Remove existing values, or there will be trouble
	
			//This command will extract these variables into the foreach scope
			// tag(string), type(string), level(int), attributes(array).
			extract($data);//We could use the array by itself, but this cooler.
	
			$result = array();
			$attributes_data = array();
			
			if(isset($value)) {
				if($priority == 'tag') $result = $value;
				else $result['value'] = $value; //Put the value in a assoc array if we are in the 'Attribute' mode
			}
	
			//Set the attributes too.
			if(isset($attributes) and $get_attributes) {
				foreach($attributes as $attr => $val) {
					if($priority == 'tag') $attributes_data[$attr] = $val;
					else $result['attr'][$attr] = $val; //Set all the attributes in a array called 'attr'
				}
			}
	
			//See tag status and do the needed.
			if($type == "open") {//The starting of the tag '<tag>'
				$parent[$level-1] = &$current;
				if(!is_array($current) or (!in_array($tag, array_keys($current)))) { //Insert New tag
					$current[$tag] = $result;
					if($attributes_data) $current[$tag. '_attr'] = $attributes_data;
					$repeated_tag_index[$tag.'_'.$level] = 1;
	
					$current = &$current[$tag];
	
				} else { //There was another element with the same tag name
	
					if(isset($current[$tag][0])) {//If there is a 0th element it is already an array
						$current[$tag][$repeated_tag_index[$tag.'_'.$level]] = $result;
						$repeated_tag_index[$tag.'_'.$level]++;
					} else {//This section will make the value an array if multiple tags with the same name appear together
						$current[$tag] = array($current[$tag],$result);//This will combine the existing item and the new item together to make an array
						$repeated_tag_index[$tag.'_'.$level] = 2;
						
						if(isset($current[$tag.'_attr'])) { //The attribute of the last(0th) tag must be moved as well
							$current[$tag]['0_attr'] = $current[$tag.'_attr'];
							unset($current[$tag.'_attr']);
						}
	
					}
					$last_item_index = $repeated_tag_index[$tag.'_'.$level]-1;
					$current = &$current[$tag][$last_item_index];
				}
	
			} elseif($type == "complete") { //Tags that ends in 1 line '<tag />'
				//See if the key is already taken.
				if(!isset($current[$tag])) { //New Key
					$current[$tag] = $result;
					$repeated_tag_index[$tag.'_'.$level] = 1;
					if($priority == 'tag' and $attributes_data) $current[$tag. '_attr'] = $attributes_data;
	
	
				} else { //If taken, put all things inside a list(array)
					if(isset($current[$tag][0]) and is_array($current[$tag])) {//If it is already an array...
	
						// ...push the new element into that array.
						$current[$tag][$repeated_tag_index[$tag.'_'.$level]] = $result;

						if($priority == 'tag' and $get_attributes and $attributes_data) {
							$current[$tag][$repeated_tag_index[$tag.'_'.$level] . '_attr'] = $attributes_data;
						}
						$repeated_tag_index[$tag.'_'.$level]++;
	
					} else { //If it is not an array...
						$current[$tag] = array($current[$tag],$result); //...Make it an array using using the existing value and the new value
						$repeated_tag_index[$tag.'_'.$level] = 1;
						if($priority == 'tag' and $get_attributes) {
							if(isset($current[$tag.'_attr'])) { //The attribute of the last(0th) tag must be moved as well

								$current[$tag]['0_attr'] = $current[$tag.'_attr'];
								unset($current[$tag.'_attr']);
							}
							
							if($attributes_data) {
								$current[$tag][$repeated_tag_index[$tag.'_'.$level] . '_attr'] = $attributes_data;
							}
						}
						$repeated_tag_index[$tag.'_'.$level]++; //0 and 1 index is already taken
					}
				}
	
			} elseif($type == 'close') { //End of tag '</tag>'
				$current = &$parent[$level-1];
			}
		}
		
		return($xml_array);
	}
} // end class definition


?>