<?php

class PSPM_Tools extends Tools
{

    static public function Auth($lang, $force_login = false, $force_token = false)
    {
        switch ($lang)
        {
            case 'fr' :
                $pm_http_url = 'http://ws.priceminister.com/';
                $pm_https_url = 'https://ws.priceminister.com/';
                break;
            case 'es' :
                $pm_http_url = 'http://ws.priceminister.es/';
                $pm_https_url = 'https://ws.priceminister.es/';
                break;
            default :
                return(false);
        }

        $id_lang = Language::getIdByIso($lang);

        if ($force_login && $force_token)
        {
            $pm_logins = array();
            $pm_logins[$id_lang] = $force_login;

            $pm_tokens = array();
            $pm_tokens[$id_lang] = $force_token;
        }
        else
        {
            $pm_logins = unserialize(base64_decode(PriceMinister::configurationGet('PM_LOGIN')));
            $pm_tokens = unserialize(base64_decode(PriceMinister::configurationGet('PM_TOKEN')));
        }

        $pm_login = isset($pm_logins[$id_lang]) ? trim($pm_logins[$id_lang]) : '';
        $pm_token = isset($pm_tokens[$id_lang]) ? trim($pm_tokens[$id_lang]) : '';
        $pm_profileid = isset($pm_profileids[$id_lang]) ? trim($pm_profileids[$id_lang]) : '';

        // Price Minister Parameters
        //
        $pm_config = array();
        $pm_config['login'] = $pm_login;
        $pm_config['pwd'] = $pm_token;

        if ($pm_profileid)
            $pm_config['profileid'] = $pm_login;

        $pm_config['http_url'] = $pm_http_url;
        $pm_config['https_url'] = $pm_https_url;

        return($pm_config);
    }

    static public function hfilter($str)
    {
        $str = htmlspecialchars(strip_tags($str));
        $str = preg_replace("/\\n/i", '<br>', $str);
        $str = preg_replace("/\\r/i", '<br>', $str);
        return($str);
    }

    static public function Formula($price, $formula)
    {
        $formula = trim(str_replace(',', '.', $formula));
        $formula = preg_replace("/\\n/i", '', $formula);
        $formula = preg_replace("/\\r/i", '', $formula);

        if (preg_match('#([0-9\., ]*)%#', $formula, $result))
        {
            $toPercent = $price * (floatval($result[1]) / 100);
            $formula = preg_replace('#([0-9\., ]*)%#', $toPercent, $formula);
        }
        $formula = str_replace('%', '', $formula);
        $equation = str_replace('@', $price ? $price : 0, $formula);

        $result = self::_matheval($equation);
        return($result);
    }

    /*
      found there :
      http://fr.php.net/eval
      David Schumann
      04-Nov-2003 08:17
      To evaluate math expressions (multiply, divide, addition, subtraction, percentages),
      use the following function, based on Taras Young's 'evalsum' function posted earlier
      MERCI !
     */

    static private function _matheval($equation)
    {
        $equation = preg_replace("/[^0-9+\-.*\/()%]/", "", $equation);
        $equation = preg_replace("/([+-])([0-9]+)(%)/", "*(1\$1.\$2)", $equation);
        // you could use str_replace on this next line
        // if you really, really want to fine-tune this equation
        $equation = preg_replace("/([0-9]+)(%)/", ".\$1", $equation);
        if ($equation == "")
        {
            $return = 0;
        }
        else
        {
            eval("\$return=" . $equation . ";");
        }
        return $return;
    }

    static public function toCurrency($price, $to_currency = NULL)
    {
        //$currency = Currency::getCurrent();

        $c_rate = (is_array($to_currency) ? $to_currency['conversion_rate'] : $to_currency->conversion_rate);

        if ($to_currency)
            $price /= $c_rate;

        return $price;
    }

    static public function fromCurrency($price, $from_currency = NULL)
    {
        //$currency = Currency::getCurrent();

        $c_rate = (is_array($from_currency) ? $from_currency['conversion_rate'] : $to_currency->conversion_rate);

        if ($from_currency)
            $price *= $c_rate;

        return $price;
    }

    static public function getCategories($categories, $current, $id_category = 1)
    {
        global $done;
        global $html;
        $html = isset($html) ? $html : null;


        if (!isset($done[$current['infos']['id_parent']]))
            $done[$current['infos']['id_parent']] = 0;
        $done[$current['infos']['id_parent']] += 1;

        if (isset($current['infos']['id_parent']))
            $todo = sizeof($categories[$current['infos']['id_parent']]);
        else
            $todo = null;

        $doneC = $done[$current['infos']['id_parent']];

        $level = $current['infos']['level_depth'] + 1;

        for ($spacer = '', $i = 0; $i < $level; $i++)
            if ($level != 1)
                $spacer .= '&nbsp;&nbsp;';

        $html[$id_category] = $spacer . stripslashes($current['infos']['name']);

        if (isset($categories[$id_category]))
            foreach ($categories[$id_category] AS $key => $row)
                if ($key != 'infos')
                    self::getCategories($categories, $categories[$id_category][$key], $key);

        return($html);
    }

    static public function orderPageURL($order_id)
    {
        return(sprintf('http://www.priceminister.com/purchase?action=saleview&purchaseid=%s', $order_id));
    }

    /**
     * jsonDecode convert json string to php array / object
     *
     * @param string $json
     * @param boolean $assoc  (since 1.4.2.4) if true, convert to associativ array
     * @return array
     */
    public static function jsonDecode($json, $assoc = false)
    {
        if (function_exists('json_decode'))
            return json_decode($json, $assoc);
        else
        {
            include_once(dirname(__FILE__) . '/json/json.php');
            $pearJson = new Services_JSON(($assoc) ? SERVICES_JSON_LOOSE_TYPE : 0);
            return $pearJson->decode($json);
        }
    }

    /**
     * Convert an array to json string
     *
     * @param array $data
     * @return string json
     */
    public static function jsonEncode($data)
    {
        if (function_exists('json_encode'))
            return json_encode($data);
        else
        {
            include_once(dirname(__FILE__) . '/json/json.php');
            $pearJson = new Services_JSON();
            return $pearJson->encode($data);
        }
    }

    public static function cPath($id_category)
    {
        global $cookie;

        $c = new Category($id_category, $cookie->id_lang);

        if (!isset($category))
            $category = '';

        if ($c->id_parent && $c->id_parent != 1)
            $category .= self::cPath($c->id_parent) . ' > ';

        $category .= $c->name;

        return(rtrim($category, ' > '));
    }

    // Simply remove accents from shipping methods !
    // $order->deliveryinformation->shippingtype 
    public static function cleanShippingMethod($shipping_method)
    {
        return( preg_replace(array('/&szlig;/', '/&(..)lig;/', '/&([aouAOU])uml;/', '/&(.)[^;]*;/'), array('ss', "$1", "$1" . 'e', "$1"), htmlentities($shipping_method, ENT_NOQUOTES, 'UTF-8')) );
    }

    static public function getProductImages($id_product, $id_product_attribute, $id_lang)
    {
        $product = new Product($id_product);

        if (intval($id_product_attribute))
        {
            $images = $product->getCombinationImages($id_lang);
            $id_images = array();

            if (is_array($images) && count($images))
            {
                if (isset($images[$id_product_attribute]))
                {
                    foreach ($images[$id_product_attribute] as $key => $image)
                        $id_images[] = $image['id_image'];
                }
                else
                    $id_images = false;
            }
            else
            {
                $images = $product->getImages($id_lang);
                if (is_array($images) && count($images))
                {
                    foreach ($images as $key => $image)
                        $id_images[] = $image['id_image'];
                }
                else
                    $id_images = false;
            }
        }
        else
        {
            $images = $product->getImages($id_lang);
            if (is_array($images) && count($images))
            {
                foreach ($images as $key => $image)
                    $id_images[] = $image['id_image'];
            }
            else
                $id_images = false;
        }
        $images = array();

        if ($id_images)
            foreach ($id_images as $id_image)
                $images[] = self::getImageUrl($id_image, $id_product);
        return($images);
    }

    static public function getImageUrl($id_image, $productid)
    {
        $image_type = 'large';
        $ext = 'jpg';

        #image url
        if (version_compare(_PS_VERSION_, '1.4', '>='))
        {
            $image_obj = new Image($id_image);

            // PS > 1.4.3
            if (method_exists($image_obj, 'getExistingImgPath'))
            {
                $img_path = $image_obj->getExistingImgPath();
                $imageurl = $img_path;
            }
            else
            {
                $imageurl = $productid . '-' . $id_image;
            }
        }
        else
            $imageurl = $productid . '-' . $id_image;

        if (version_compare(_PS_VERSION_, '1.5.2', '>='))
        {
            $image_type = PriceMinister::configurationGet('PM_IMAGE_TYPE');

            if (empty($image_type))
                $image_type = ImageType::getFormatedName('large');
        }
        elseif (version_compare(_PS_VERSION_, '1.5', '>='))
            $image_type = 'large_default';
        else
            $image_type = 'large';

        $imageurl = sprintf('%s-%s.%s', $imageurl, $image_type, $ext);

        return $imageurl;
    }

    /*
     * For PS 1.2 compatibility
     */

    static public function getHttpHost($http = false, $entities = false, $ignore_port = false)
    {
        if (method_exists('Tools', 'getHttpHost'))
        {
            return( Tools::getHttpHost($http, $entities, $ignore_port) );
        }
        else
        {
            $host = (isset($_SERVER['HTTP_X_FORWARDED_HOST']) ? $_SERVER['HTTP_X_FORWARDED_HOST'] : $_SERVER['HTTP_HOST']);
            if ($entities)
                $host = htmlspecialchars($host, ENT_COMPAT, 'UTF-8');
            if ($http)
                $host = (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://') . $host;
            return $host;
        }
    }

    public static function safeText($string)
    {
        $string = @utf8_encode(utf8_decode($string));
        $string = html_entity_decode($string, ENT_COMPAT, 'UTF-8');

        if (function_exists('filter_var'))
            $string = filter_var($string, FILTER_UNSAFE_RAW, FILTER_FLAG_STRIP_LOW);
        $string = str_replace('&#39;', "'", $string);

        return($string);
    }

}

?>