<?php
/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: contact@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@smartmarseille.com
 * ...........................................................................
 * @package    PriceMinister
 * @copyright  Copyright (c) 2011-2014 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2014 Common Services Co Ltd (http://www.common-services.com)
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * 
 */
class PSPM_Product extends Product
{
    const COLUMN_PRODUCT    = 1 ;
    const COLUMN_FEATURES   = 2 ;
    const COLUMN_ATTRIBUTES = 3 ;
    
    public static function getUpdateProducts($category, $create_active, $create_in_stock, $debug = false)
    {
        if ( $create_active )
            $create_active = ' p.`active` > 0 ' ;
        else
            $create_active = ' 1 ' ;

        if (version_compare(_PS_VERSION_, '1.5', '<'))
        {        
            
            if ( $create_in_stock )
                $in_stock = ' p.`quantity` > 0 ' ;
            else
                $in_stock = ' 1 ' ;

            $sql = '
                SELECT p.id_product FROM `'._DB_PREFIX_.'product` p 
                    LEFT JOIN `'._DB_PREFIX_.'category_product` cp on (cp.id_product = p.id_product) '
                . ' WHERE cp.`id_category` = ' . intval($category) . ' AND '
                . $create_active . 'AND'
                . $in_stock ;
        }
        else
        {
            if ( $create_in_stock )
                $in_stock = ' sa.`quantity` > 0 ' ;
            else
                $in_stock = ' 1 ' ;

            $sql = '
                SELECT p.id_product FROM `'._DB_PREFIX_.'product` p 
                    LEFT JOIN `'._DB_PREFIX_.'category_product` cp on (cp.id_product = p.id_product) 
                    LEFT JOIN `'._DB_PREFIX_.'stock_available` sa on (p.id_product = sa.id_product)
                    WHERE cp.`id_category` = ' . intval($category) . ' AND '
                . $create_active . 'AND'
                . $in_stock . '
                GROUP by p.id_product' ;
        }
        
        if ( $debug )
            echo nl2br("\nSQL :" . print_r($sql, true)) ;

		$rq = Db::getInstance()->ExecuteS($sql) ;

        if ( $debug )
            echo nl2br("\nSQL :" . print_r($rq, true)) ;

		return ($rq);
    }

  static public	function getColumnsNames($id_lang, $type = null)
  {
        $columns = array() ;

        switch($type)
        {
            case self::COLUMN_PRODUCT :
                $query  = Db::getInstance()->ExecuteS('SHOW COLUMNS FROM `' . _DB_PREFIX_ . 'product`') ;

                foreach($query as $row)
                    $columns[ $row['Field'] ] = 1 ;  
                
                $query  = Db::getInstance()->ExecuteS('SHOW COLUMNS FROM `' . _DB_PREFIX_ . 'product_lang`') ;

                if ( $query )
                 foreach($query as $row)
                     $columns[ $row['Field'] ] = 1 ;                

                $query  = Db::getInstance()->ExecuteS('SHOW COLUMNS FROM `' . _DB_PREFIX_ . 'product_attribute`') ;

                if ( $query )
                foreach($query as $row)
                    $columns[ $row['Field'] ] = 1 ;                
                break;

            case self::COLUMN_FEATURES :
                $sql = '
                     SELECT `name`, concat("zz_", `name`) as Field FROM `' . _DB_PREFIX_ . 'feature_value`  fv
                     JOIN `' . _DB_PREFIX_ . 'feature_lang` fl on (fl.id_feature = fv.id_feature and fl.id_lang = ' . intval($id_lang) . ')
                     JOIN `' . _DB_PREFIX_ . 'feature_value_lang` fvl on (fv.id_feature_value = fvl.id_feature_value and fvl.id_lang = ' . intval($id_lang) . ')
                     GROUP by `name`;' ;

                $query  = Db::getInstance()->ExecuteS($sql) ;

                if ( $query )
                 foreach($query as $row)
                     $columns[ $row['Field'] ] = $row['name'] ;          
                break;   
                
            case self::COLUMN_ATTRIBUTES :
                $sql = 'SELECT md5(`name`) as md5, concat("attribute_", `name`) as Field, `name` FROM `' . _DB_PREFIX_ . 'attribute_group_lang` ' ;

                $query  = Db::getInstance()->ExecuteS($sql) ;

                if ( $query )
                 foreach($query as $row)
                     $columns[ $row['Field'] ] = $row['name'] ;
                break;
        }
       return( $columns ) ;
  }

  static public function getIdFeatureByTitle($id_product, $id_lang, $title)
  {
       $sql = '
            SELECT md5(fl.`name`) as md5, fl.`id_feature` as id_feature, fl.`name`, fvl.`value`, fp.id_feature_value FROM `' . _DB_PREFIX_ . 'feature_product`  fp
            LEFT JOIN `' . _DB_PREFIX_ . 'feature_value_lang` fvl on (fvl.id_feature_value = fp.id_feature_value and fvl.id_lang = ' . intval($id_lang) . ')
            LEFT JOIN `' . _DB_PREFIX_ . 'feature_lang` fl on (fl.id_feature = fp.id_feature and fl.id_lang = ' . intval($id_lang) . ')
            WHERE fp.id_product =  ' . intval($id_product) . '
            HAVING md5 = md5("' . pSQL($title) . '")' ;

       $query  = Db::getInstance()->ExecuteS($sql) ;

       if ( $query )
            return($query[0]);
       else
            return(false);
  }
  static public function getAttributeValueByAttributeName($id_attribute, $id_lang, $name)
  {
       $sql = '
          SELECT md5(agl.`name`) as md5, agl.`name` as name, al.`name` as `value` , al.`id_attribute`, a.`id_attribute_group` FROM `' . _DB_PREFIX_ . 'product_attribute_combination` pac
          JOIN `' . _DB_PREFIX_ . 'attribute_lang` al on (al.id_attribute = pac.id_attribute)
          LEFT JOIN `' . _DB_PREFIX_ . 'attribute` a on (a.id_attribute = al.id_attribute)
          LEFT JOIN `' . _DB_PREFIX_ . 'attribute_group_lang` agl on (a.id_attribute_group = agl.id_attribute_group and agl.id_lang = ' . intval($id_lang) . ')
          WHERE id_product_attribute = ' . intval($id_attribute) . ' and al.id_lang = ' . intval($id_lang) . '
          HAVING md5 = md5("' . $name . '")' ;

       $query  = Db::getInstance()->ExecuteS($sql) ;

       if ( $query )
            return($query[0]);
       else
            return(false);
  }


  // Options produits (actif, stock etc..)
  //
  static public	function getProductOptions($id_product, $id_lang)
  {
      $sql = 'SELECT * FROM `'._DB_PREFIX_.'priceminister_product_option` p where id_product = "' . $id_product . '" and id_lang = "' . $id_lang . '" ;' ;

      $rq = Db::getInstance()->ExecuteS($sql);

      if ( $rq )
        return( array_shift($rq) ) ;
      else
        return( array('force' => 0, 'disable' => 0, 'price' => '', 'text' => '', 'shipping' => '') ) ;
  }
  static public	function setProductOptions($id_product, $id_lang, $options)
  {
      $pass = true ;

      $sql = 'REPLACE INTO `'._DB_PREFIX_.'priceminister_product_option`
              (`id_product`, `id_lang`, `force`, `price`, `text`, `disable`) values(' .
              pSQL($id_product)                 . ', ' .
              pSQL($id_lang)                    . ', ' .
              intval($options['force'])         . ', ' .
              floatval($options['price'])       . ', "' .
              pSQL($options['text'])            . '", ' .
              intval($options['disable'])       . '); ' ;

      $rq = Db::getInstance()->Execute($sql);

      $pass = self::updateProductDate($id_product) && $pass ;

      if ( $rq ) return(true && $pass) ;

      return(false);
  }

  static public function initProductOptions($id_lang)
  {
      $pass = true ;
      $products = Db::getInstance()->ExecuteS('SELECT id_product from `'._DB_PREFIX_.'product`') ;

      foreach($products as $product)
      {
        $sql = 'INSERT IGNORE `'._DB_PREFIX_.'priceminister_product_option`
            (`id_product`,`id_lang`) values (
            '. $product['id_product'] .', ' . intval($id_lang) . ')' ;

        if ( ! Db::getInstance()->Execute($sql) ) $pass = $pass && false ;
      }
      return($pass) ;
  }

  // Propagate Text
  //
  static public	function propagateProductOptionsText($id_product, $id_lang, $id_category, $option)
  {
      $pass = true ;

      $pass = self::initProductOptions($id_lang) && $pass ;

      $sql = 'UPDATE `'._DB_PREFIX_.'priceminister_product_option` mpo, `'._DB_PREFIX_.'product` p SET
            mpo.`text` = "' . pSQL($option['text']) . '"
            WHERE p.id_product = mpo.id_product and p.id_category_default = ' . intval($id_category) . ' and id_lang = ' . intval($id_lang)  ;

      if ( ! Db::getInstance()->Execute($sql) ) $pass = false && $pass ;

      $pass = self::updateProductDate($id_product) && $pass ;

      return($pass) ;
  }

  static public	function propagateToShopProductOptionsText($id_product, $id_lang, $option)
  {
      $pass = true ;

      $pass = self::initProductOptions($id_lang) && $pass ;

      $sql = 'UPDATE `'._DB_PREFIX_.'priceminister_product_option` mpo, `'._DB_PREFIX_.'product` p SET
            mpo.`text` = "' . pSQL($option['text']) . '"
            WHERE p.id_product = mpo.id_product and id_lang = ' . intval($id_lang)  ;

      if ( ! Db::getInstance()->Execute($sql) ) $pass = $pass && false ;

      $pass = self::updateProductDate($id_product) && $pass ;


      return($pass) ;
  }

  static public	function propagateToManufacturerProductOptionsText($id_product, $id_lang, $id_manufacturer, $option)
  {
      $pass = true ;

      $pass = self::initProductOptions($id_lang) && $pass ;

      $sql = 'UPDATE `'._DB_PREFIX_.'priceminister_product_option` mpo, `'._DB_PREFIX_.'product` p, `'._DB_PREFIX_.'manufacturer` m SET
            mpo.`text` = "' . pSQL($option['text']) . '"
            WHERE p.id_product = mpo.id_product and id_lang = ' . intval($id_lang) . ' and p.`id_manufacturer` = m.`id_manufacturer` AND p.`id_manufacturer`=' . intval($id_manufacturer) ;

      if ( ! Db::getInstance()->Execute($sql) ) $pass = $pass && false ;

      $pass = self::updateProductDate($id_product) && $pass ;


      return($pass) ;
  }

  // Propagate Disable
  //
  static public	function propagateProductOptionsDisable($id_product, $id_lang, $id_category, $option)
  {
      $pass = true ;

      $pass = self::initProductOptions($id_lang) && $pass ;

      $sql = 'UPDATE `'._DB_PREFIX_.'priceminister_product_option` mpo, `'._DB_PREFIX_.'product` p SET
            mpo.`disable` = ' . intval($option['disable']) . '
            WHERE p.id_product = mpo.id_product and p.id_category_default = ' . intval($id_category) . ' and id_lang = ' . intval($id_lang)  ;

      if ( ! Db::getInstance()->Execute($sql) ) $pass = false && $pass ;

      $pass = self::updateProductDate($id_product) && $pass ;

      return($pass) ;
  }

  static public	function propagateToShopProductOptionsDisable($id_product, $id_lang, $option)
  {
      $pass = true ;

      $pass = self::initProductOptions($id_lang) && $pass ;

      $sql = 'UPDATE `'._DB_PREFIX_.'priceminister_product_option` mpo, `'._DB_PREFIX_.'product` p SET
            mpo.`disable` = ' . intval($option['disable']) . '
            WHERE p.id_product = mpo.id_product and id_lang = ' . intval($id_lang)  ;

      if ( ! Db::getInstance()->Execute($sql) ) $pass = $pass && false ;

      $pass = self::updateProductDate($id_product) && $pass ;

      return($pass) ;
  }

  static public	function propagateToManufacturerProductOptionsDisable($id_product, $id_lang, $id_manufacturer, $option)
  {
      $pass = true ;

      $pass = self::initProductOptions($id_lang) && $pass ;

      $sql = 'UPDATE `'._DB_PREFIX_.'priceminister_product_option` mpo, `'._DB_PREFIX_.'product` p, `'._DB_PREFIX_.'manufacturer` m SET
            mpo.`disable` = ' . intval($option['disable']) . '
            WHERE p.id_product = mpo.id_product and id_lang = ' . intval($id_lang) . ' and p.`id_manufacturer` = m.`id_manufacturer` AND p.`id_manufacturer`=' . intval($id_manufacturer) ;

      if ( ! Db::getInstance()->Execute($sql) ) $pass = $pass && false ;

      $pass = self::updateProductDate($id_product) && $pass ;

      return($pass) ;
  }

  // Propagate Force
  //
  static public	function propagateProductOptionsForce($id_product, $id_lang, $id_category, $option)
  {
      $pass = true ;

      $pass = self::initProductOptions($id_lang) && $pass ;

      $sql = 'UPDATE `'._DB_PREFIX_.'priceminister_product_option` mpo, `'._DB_PREFIX_.'product` p SET
            mpo.`force` = ' . intval($option['force']) . '
            WHERE p.id_product = mpo.id_product and p.id_category_default = ' . intval($id_category) . ' and id_lang = ' . intval($id_lang)  ;

      if ( ! Db::getInstance()->Execute($sql) ) $pass = false && $pass ;

      $pass = self::updateProductDate($id_product) && $pass ;

      return($pass) ;
  }

  static public	function propagateToShopProductOptionsForce($id_product, $id_lang, $option)
  {
      $pass = true ;

      $pass = self::initProductOptions($id_lang) && $pass ;

      $sql = 'UPDATE `'._DB_PREFIX_.'priceminister_product_option` mpo, `'._DB_PREFIX_.'product` p SET
            mpo.`force` = ' . intval($option['force']) . '
            WHERE p.id_product = mpo.id_product and id_lang = ' . intval($id_lang)  ;

      if ( ! Db::getInstance()->Execute($sql) ) $pass = $pass && false ;

      $pass = self::updateProductDate($id_product) && $pass ;

      return($pass) ;
  }

  static public	function propagateToManufacturerProductOptionsForce($id_product, $id_lang, $id_manufacturer, $option)
  {
      $pass = true ;

      $pass = self::initProductOptions($id_lang) && $pass ;

      $sql = 'UPDATE `'._DB_PREFIX_.'priceminister_product_option` mpo, `'._DB_PREFIX_.'product` p, `'._DB_PREFIX_.'manufacturer` m SET
              mpo.`force` = ' . intval($option['force']) . '
              WHERE p.id_product = mpo.id_product and id_lang = ' . intval($id_lang) . ' and p.`id_manufacturer` = m.`id_manufacturer` AND p.`id_manufacturer`=' . intval($id_manufacturer) ;

      if ( ! Db::getInstance()->Execute($sql) ) $pass = $pass && false ;

      $pass = self::updateProductDate($id_product) && $pass ;

      return($pass) ;
  }


  static public function updateProductDate($id_product)
  {
      $sql = '
          UPDATE `'._DB_PREFIX_.'product` set date_upd = "' . date('Y-m-d H:i:s') . '" where id_product=' . intval($id_product) ;

      $rq = Db::getInstance()->Execute($sql);

      return ($rq);
  }

    public static function getBySKU($SKU)
    {
            if (!Validate::isReference($SKU))
                    die(Tools::displayError(__FILE__ . '  ' . __LINE__));

            $result = Db::getInstance()->getRow('
                SELECT IF(pa.reference, pa.reference, p.reference) as reference, p.id_product, IF (pa.id_product_attribute, pa.id_product_attribute, NULL) as id_product_attribute FROM `'._DB_PREFIX_.'product` p
                LEFT JOIN `'._DB_PREFIX_.'product_attribute` pa ON (p.id_product = pa.id_product) 
                WHERE p.`reference` = "' . pSQL($SKU) . '" OR pa.`reference` = "' . pSQL($SKU) . '" GROUP BY id_product') ;                

            if (!isset($result['id_product']))
                    return false;

            $product_item = new StdClass ;
            $product_item->id_product = (int)$result['id_product'] ;
            $product_item->id_product_attribute = $result['id_product_attribute'] ;
            
            return($product_item) ;
    }
  
    /**
        * @deprecated
        * @param string $reference
        */
    public static function getByReference($reference)
    {
            if (!Validate::isReference($reference))
                    die(Tools::displayError(__FILE__ . '  ' . __LINE__));

            $result = Db::getInstance()->getRow('
            SELECT `id_product`
            FROM `'._DB_PREFIX_.'product` p
            WHERE p.`reference` = \''.pSQL($reference).'\'');
            if (!isset($result['id_product']))
                    return false;

            return new self((int)$result['id_product']);
    }
    
    public function getAttributeCombinationsById($id_product_attribute, $id_lang)
    {
            if ( method_exists('Combination', 'isFeatureActive') && !Combination::isFeatureActive() )
                    return array();
            
            if ( method_exists('Product', 'getAttributeCombinationsById') )
                    return(parent::getAttributeCombinationsById($id_product_attribute, $id_lang)) ;
            
            $sql = 'SELECT pa.*, ag.`id_attribute_group`, ag.`is_color_group`, agl.`name` AS group_name, al.`name` AS attribute_name,
                                    a.`id_attribute`, pa.`unit_price_impact`
                            FROM `'._DB_PREFIX_.'product_attribute` pa
                            LEFT JOIN `'._DB_PREFIX_.'product_attribute_combination` pac ON pac.`id_product_attribute` = pa.`id_product_attribute`
                            LEFT JOIN `'._DB_PREFIX_.'attribute` a ON a.`id_attribute` = pac.`id_attribute`
                            LEFT JOIN `'._DB_PREFIX_.'attribute_group` ag ON ag.`id_attribute_group` = a.`id_attribute_group`
                            LEFT JOIN `'._DB_PREFIX_.'attribute_lang` al ON (a.`id_attribute` = al.`id_attribute` AND al.`id_lang` = '.(int)$id_lang.')
                            LEFT JOIN `'._DB_PREFIX_.'attribute_group_lang` agl ON (ag.`id_attribute_group` = agl.`id_attribute_group` AND agl.`id_lang` = '.(int)$id_lang.')
                            WHERE pa.`id_product` = '.(int)$this->id.'
                            AND pa.`id_product_attribute` = '.(int)$id_product_attribute.'
                            GROUP BY pa.`id_product_attribute`, ag.`id_attribute_group`
                            ORDER BY pa.`id_product_attribute`';

            $res = Db::getInstance()->executeS($sql);

            return $res;
    }
    

}

?>