<?php

class PSPM_Order extends Order
{

    public $marketPlaceOrderId = null;
    public $marketPlaceOrderStatus = null;
    public $marketPlaceShipping = null ;

    public function __construct($id = NULL, $id_lang = NULL)
    {
        parent::__construct($id, $id_lang);

        if ($id)
            $this->_getMpFields();
    }

    public function add($autodate = true, $nullValues = false, $marketPlaceOrderId = false, $marketPlaceOrderStatus = false, $marketPlaceShipping = false)
    {
        $pass = parent::add($autodate);

        $this->marketPlaceOrderId = $marketPlaceOrderId;
        $this->marketPlaceOrderStatus = $marketPlaceOrderStatus;
	$this->marketPlaceShipping = $marketPlaceShipping ;

        $pass = $pass === false ? $pass : $this->_updOrder();

        return $pass;
    }
    public function addMarketplaceItem($id_product, $id_product_attribute, $itemid)
    {
        $sql = 'REPLACE INTO `' . _DB_PREFIX_ . 'priceminister_product_ordered`
                        (`id_order`, `id_product`, `id_product_attribute`, `itemid`) 
                VALUES  (' . (int)$this->id . ', ' . (int)$id_product . ', ' . ($id_product_attribute ? $id_product_attribute : 'NULL') . ', ' . (int)$itemid . ') ;'  ;

        if (!Db::getInstance()->Execute($sql))
            return false;

        return(true);
    }    
    public function getMarketplaceItem()
    {
        $sql = 'SELECT * FROM `' . _DB_PREFIX_ . 'priceminister_product_ordered` WHERE `id_order` = ' . (int)$this->id ;

        if (!($result = Db::getInstance()->ExecuteS($sql)))
            return(false);

        return( $result );
    }  
    
    static public function checkByMpId($marketPlaceOrderId)
    {
        $sql = 'SELECT `id_order`, `mp_order_id` FROM `' . _DB_PREFIX_ . 'orders`
          where `mp_order_id` = "' . pSQL($marketPlaceOrderId) . '" ORDER BY `id_order` DESC ;';

        if (!($result = Db::getInstance()->ExecuteS($sql)))
            return(false);

        return( $result[0] );
    }

    public function updateMpStatus($marketPlaceStatus)
    {
        $this->marketPlaceOrderStatus = $marketPlaceStatus;

        $sql = 'UPDATE  `' . _DB_PREFIX_ . 'orders`
          SET `mp_status` = "' . pSQL($this->marketPlaceOrderStatus) . '"
          WHERE `id_order` = "' . pSQL($this->id) . '" ;';

        if (!Db::getInstance()->Execute($sql))
            return false;

        return(true);
    }

    static public function getShippingToUpdateOrders()
    {
        $sql = 'SELECT `id_order`, `mp_order_id` FROM `' . _DB_PREFIX_ . 'orders`
                    WHERE `module` = "priceminister" and `mp_order_id` > "" AND
                    `total_shipping` = 0 and `date_add` > DATE_SUB(NOW(), INTERVAL 24 HOUR)';

        if (!($result = Db::getInstance()->ExecuteS($sql)))
            return(false);

        return( $result );
    }

    private function _getMpFields()
    {
        $sql = 'SELECT mp_order_id, mp_shipping, mp_status FROM `' . _DB_PREFIX_ . 'orders`
          WHERE `id_order` = ' . (int) $this->id . ' LIMIT 1 ;';

        if ($result = Db::getInstance()->ExecuteS($sql))
        {
            $result = array_shift($result);
            $this->marketPlaceOrderId = $result['mp_order_id'];
            $this->marketPlaceOrderStatus = $result['mp_status'];
	    $this->marketPlaceShipping = $result['mp_shipping'] ;

            return(true);
        }
        else
            return(false);
    }

    private function _updOrder()
    {
        $sql = 'UPDATE  `' . _DB_PREFIX_ . 'orders`
          set mp_order_id = "' . pSQL($this->marketPlaceOrderId) . '",
              mp_status = "' . pSQL($this->marketPlaceOrderStatus) . '",
	      mp_shipping = "' . pSQL($this->marketPlaceShipping) .'"
         where `id_order` = ' . (int) $this->id . ' ;';

        if (!Db::getInstance()->Execute($sql))
            return false;

        return(true);
    }

}

?>