<?php
/**
  * Mail class, Mail.php
  * Mails management
  * @category classes
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 1.3
  *
  * Modified for :
  * @package    PriceMinister
  * @copyright  Copyright (c) 2011-2014 S.A.R.L SMC (http://www.common-services.com)
  * @copyright  Copyright (c) 2011-2014 Common Services Co Ltd (http://www.common-services.com)
  * @author     Olivier B.
  * @license    Commercial license
  * Support by mail  :  contact@common-services.com
  * Support on forum :  delete
  * Skype : delete13_fr
  * 
  *
  */

require_once(dirname(__FILE__).'/../classes/Priceminister_Webservices.class.php');
require_once(dirname(__FILE__).'/../classes/PM_Sales.class.php');
require_once(dirname(__FILE__).'/../classes/PSPM_Tools.class.php');

class PSPM_Mail
{
	static public function Send($id_lang, $template, $subject, $templateVars, $to, $toName = NULL, $from = NULL, $fromName = NULL, $fileAttachment = NULL, $modeSMTP = NULL, $templatePath = _PS_MAIL_DIR_)
	{
		$configuration = Configuration::getMultiple(array('PS_SHOP_EMAIL', 'PS_MAIL_METHOD', 'PS_MAIL_SERVER', 'PS_MAIL_USER', 'PS_MAIL_PASSWD', 'PS_SHOP_NAME', 'PS_MAIL_SMTP_ENCRYPTION', 'PS_MAIL_SMTP_PORT', 'PS_MAIL_METHOD', 'PS_MAIL_TYPE'));
		if(!isset($configuration['PS_MAIL_SMTP_ENCRYPTION'])) $configuration['PS_MAIL_SMTP_ENCRYPTION'] = "off";
		if(!isset($configuration['PS_MAIL_SMTP_PORT'])) $configuration['PS_MAIL_SMTP_PORT'] = "default";

		if (!isset($from)) $from = $configuration['PS_SHOP_EMAIL'];
		if (!isset($fromName)) $fromName = $configuration['PS_SHOP_NAME'];

		if (!empty($fromName) AND !Validate::isMailName($fromName))
	 		die (Tools::displayError('error / mail: parameter "fromName" is corrupted'));

		if (!is_array($templateVars))
	 		die (Tools::displayError('error / mail: parameter "templateVars" is not an array'));

		// Do not crash for this error, that may be a complicated customer name
		if (!empty($toName) AND !Validate::isMailName($toName))
	 		$toName = NULL;

		if (!Validate::isTplName($template))
	 		die (Tools::displayError('error / mail: template name is corrupted'));

		if (!Validate::isMailSubject($subject))
	 		die (Tools::displayError('error / mail: subject name is not valid'));

    	// Get templates content
    	$iso = Language::getIsoById(intval($id_lang));
    	if (!$iso)
    		die (Tools::displayError('Error - No iso code for email !'));

        $templatePath = realpath( dirname(__FILE__) . '/..' ) . '/' ;
        $template = sprintf('%s_%s', $template, $iso) ;

    	if (!file_exists($templatePath.$template.'.txt') )
    		die(Tools::displayError('Error - The following email template is missing:').' '.$templatePath.$template.'.txt');

    	$templateTxt = strip_tags(html_entity_decode(file_get_contents($templatePath.$template.'.txt'), NULL, 'utf-8'));

    	include_once(_PS_ROOT_DIR_.'/mails/'.$iso.'/lang.php');

    	global $_LANGMAIL;

    	$templateVars['{shop_name}'] = Tools::safeOutput(Configuration::get('PS_SHOP_NAME'));
    	$templateVars['{shop_url}'] = 'http://'.Tools::getHttpHost(false, true).__PS_BASE_URI__;

        $message = $templateTxt ;

        foreach($templateVars as $var => $text)
        {
            $message = str_replace($var, $text, $message) ;
        }

        // **********************************************************************
        // Send the message throught the Price Minister API
        // **********************************************************************

        $lang = Language::getIsoById($id_lang) ;

        // PM Configuration
        //
        $config = array() ;
        $config = PSPM_Tools::Auth($lang) ;

        $itemid   = $templateVars['{itemid}'] ;

        $config['itemid'] = $itemid ;
        $config['content'] = $message ;

        $params = array() ;
        
        $oSales = new PM_Sales($config);
        $result = $oSales->contactuseraboutitem($params);

        return(true);
    }

}
?>