<?php

class PSPM_Address extends Address
{
    // Use to manage shipping cost calculation
    //
    static public function createShippingLocations($id_customer)
    {
        $addressMap = array();
        $marketplaces = array('fr');
        $pass = false;

        if (is_array($marketplaces))
        {
            $pass = true;

            foreach ($marketplaces as $region)
            {
                $city = null;
                $state = null;
                $iso_code = null;
                $postcode = null;

                switch ($region)
                {
                    case 'fr' : // France
                        $city = 'Paris';
                        $postcode = '75000';
                        break;
                }
                if (!$iso_code)
                    $iso_code = strtoupper($region);

                if (!$city)
                    continue;

                $locationAlias = 'PriceMinister - ' . strtoupper($region);

                if (($id_address = self::addressExistsByAlias($locationAlias, $id_customer)))
                {
                    $addressMap[$region] = $id_address;
                    continue;
                }
                $address = new Address();
                $address->alias = $locationAlias;
                $address->id_customer = $id_customer;
                $address->firstname = 'PriceMinister';
                $address->lastname = 'Marketplace';
                $address->address1 = 'PriceMinister shipping reference address';
                $address->address2 = 'Please do not remove';
                $address->postcode = $postcode;
                $address->other = 'This address is used by the PriceMinister Marketplace Module, please do not edit or remove !';
                $address->city = $city;
                $address->state = $state;
                $address->id_country = Country::getByIso($iso_code);
                $address->add();

                if (Validate::isLoadedObject($address))
                    $pass = true && $pass;
                else
                    $pass = false && $pass;

                $addressMap[$region] = $address->id;
            }
            Configuration::updateValue('PM_ADDRESS_MAP', base64_encode(serialize($addressMap)));
        }
        return($pass);
    }

    // Genere un cle qui sera le nom d'alias dans la table
    //
      public function hash($obj)
    {
        $str = $obj->lastname . $obj->firstname . $obj->address1 . $obj->zipcode . $obj->city . $obj->country;

        return( md5($str) );
    }

    /**
     * Specify if an address is already in base
     *
     * @param $alias
     * @return id_address
     */
    static public function addressExistsByAlias($alias, $id_customer = null)
    {
        if ( $id_customer )
            $customer_filter = ' AND a.`id_customer`=' . (int)$id_customer ;
        else
            $customer_filter = '' ;

        $row = Db::getInstance()->getRow('
             SELECT `id_address`
             FROM ' . _DB_PREFIX_ . 'address a
             WHERE a.`alias` = "' . pSQL($alias) . '"' . $customer_filter);

        return($row['id_address']);
    }      

    static public function toEmailAddress($delivery_address)
    {
        if (!isset($delivery_address->firstname) || !isset($delivery_address->firstname))
            return(false);

        $firstname = (string) $delivery_address->firstname;
        $lastname = (string) $delivery_address->lastname;

        $ret = array();

        foreach (array('firstname' => $firstname, 'lastname' => $lastname) as $key => $field)
        {
            $field = htmlentities($field, ENT_NOQUOTES, 'UTF-8'); // to HTML
            $field = preg_replace(array('/&szlig;/', '/&(..)lig;/', '/&([aouAOU])uml;/', '/&(.)[^;]*;/'), array('ss', "$1", "$1" . 'e', "$1"), $field); // remove accents
            $field = preg_replace('/[!<>?=+@{}_$%]*$/u', '', $field);
            $field = preg_replace('/[^\p{L} \.\-]+/', '', $field);
            $field = str_replace(' ', '', $field);
            $ret[$key] = $field;
        }
        return($ret);
    }

    private function _filter($text)
    {
        $text = htmlentities($text, ENT_NOQUOTES, 'UTF-8');
        $text = preg_replace(array('/&szlig;/', '/&(..)lig;/', '/&([aouAOU])uml;/', '/&(.)[^;]*;/'), array('ss', "$1", "$1" . 'e', "$1"), $text);
        $text = str_replace('_', '/', $text);
        $text = preg_replace('/[\x00-\x1F\x21-\x2E\x3A-\x3F\x5B-\x60\x7B-\x7F]/', '', $text); // remove non printable
        return $text;
    }

    private function _nfilter($text)
    {
        $text = htmlentities($text, ENT_NOQUOTES, 'UTF-8');
        $text = preg_replace(array('/&szlig;/', '/&(..)lig;/', '/&([aouAOU])uml;/', '/&(.)[^;]*;/'), array('ss', "$1", "$1" . 'e', "$1"), $text);
        $text = str_replace(str_split('/[]!<>?=+@(){}_$%*$'), ' ', $text);
        $text = preg_replace('/[^\p{L} \.\-]+/', '', $text);
        return $text;
    }

    public function lookupOrCreateAddress($pmAddress)
    {
        global $cookie;
        // Cl� MD qui est l'alias dans la DB
        //
        $alias = $this->hash($pmAddress);

        if ($pmAddress->countryalpha2 == 'FX')
            $cc = 'FR';
        else
            $cc = $pmAddress->countryalpha2;

        // !! DELIVERY
        // On recherche si le client existe d�ja, sinon on cr�e son entr�e dans le carnet d'adresse
        //
        if (!($id_address = $this->addressExistsByAlias($alias)))
        {
            // L'adresse n'existe pas on la cr�e
            //
          $this->id_country = Country::getByIso(strtoupper(strval($cc)));
            $this->country = Country::getNameById($cookie->id_lang, $this->id_country);
            $this->alias = $alias;

            $this->lastname = !empty($pmAddress->lastname) ? $this->_nfilter($pmAddress->lastname) : 'unknown';
            $this->firstname = !empty($pmAddress->firstname) ? $this->_nfilter($pmAddress->firstname) : 'unknown';

            $this->address1 = strval($this->_filter($pmAddress->address1));
            $this->address2 = '';

            if (isset($pmAddress->address2) && is_array($pmAddress->address2))
            {
                foreach ($pmAddress->address2 as $address2)
                    $this->address2 .= strval($this->_filter($address2));
            }
            if (isset($pmAddress->address2) && !empty($pmAddress->address2))
            {
                $this->address2 .= strval($this->_filter($pmAddress->address2));
            }

            $this->postcode = strval($pmAddress->zipcode);
            $this->city = $this->_nfilter(strval(ucfirst($pmAddress->city)));


            if (isset($pmAddress->phonenumber1) && Validate::isPhoneNumber($pmAddress->phonenumber1))
                $this->phone = $pmAddress->phonenumber1;
            elseif (isset($pmAddress->phonenumber2) && Validate::isPhoneNumber($pmAddress->phonenumber2))
                $this->phone = $pmAddress->phonenumber2;

            //  fields sizes must match with parent Address class
            //
          foreach (array('company', 'firstname', 'lastname', 'address1', 'address2', 'postcode', 'city', 'phone', 'phone_mobile') as $field)
                $this->{$field} = substr($this->{$field}, 0, $this->fieldsSize[$field]);

            $this->add();

            return($this->id);
        }
        else
        {
            return($id_address);
        }
    }

}

?>