<?php
/*
    Filename:           stock.class.php
    Created:            7/17/2011,  2006 kernelbd.com Abdul Mohymen
    Descripton:         Webserivce of stock/inventory from PriceMinister.com API 
    Requirements:    
        - PHP with XML support
		- priceminister.class.php
        - a Developer's token from PriceMinister -
			= http://www.priceminister.com/res/schema/import/import.2010-09-20.xsd
			= http://www.priceminister.com/res/schema/importreport/importreport.2010-11-02.xsd
			= http://www.priceminister.com/res/schema/export/export.2011-02-17.xsd
*/
class PM_Stock extends Priceminister_Webservices {
   const _VER_IMPORT_ = '2010-09-20';
   const _VER_IMPORTREPORT_ = '2011-06-21';
   const _VER_EXPORT_ = '2011-02-17';
   
   function __construct($config = array()) {
        $this->config = $config;
    } // end func

	public function import($params=array()) {
		//Service URL
		$url = $this->config['https_url'].'stock_ws?action=import&login='.$this->config['login'].'&pwd='.$this->config['pwd'].'&profileid='.$this->config['profileid'].'&version='.self::_VER_IMPORT_;//.'&mappingalias=categorie;identifiant_unique;titre;prix;URL_produit;URL_image;description;reference_modele;livraison;shipping_delay;D3E;disponibilite;marque;ean;garantie;prix_barre;Rapport';

		//Request Response
		return $this->make_request($url, $params);
	} // end func

	public function synch($params=array(), $kindof='PRICEQUANTITY') {
		//Service URL
		$url = $this->config['https_url'].'stock_ws?action=import&login='.$this->config['login'].'&pwd='.$this->config['pwd'].'&mappingalias='.$kindof.'&version='.self::_VER_IMPORT_;

		//Request Response
		return $this->make_request($url, $params);
	} // end func

	public function importreport($params=array()) {
		if(!isset($params['fileid'])) $params['fileid'] = '';
		
		//Service URL
		$url = $this->config['https_url'].'stock_ws?action=importreport&login='.$this->config['login'].'&pwd='.$this->config['pwd'].'&version='.self::_VER_IMPORTREPORT_.'&fileid='.$params['fileid'];
		
		//Request Response
		return $this->make_request($url, $params);
	} // end func
	
	public function export($params=array()) {
		if(!isset($params['nexttoken'])) $params['nexttoken'] = '';
		if(!isset($params['scope'])) $params['scope'] = '';
		
		//Service URL
		$url = $this->config['https_url'].'stock_ws?action=export&login='.$this->config['login'].'&pwd='.$this->config['pwd'].'&report_type=inventory'.'&version='.self::_VER_EXPORT_.'&nexttoken='.$params['nexttoken'].'&scope='.$params['scope'];		
		
		//Request Response
		return $this->make_request($url, $params);
		
	} // end func
} // end class definition

?>