<?php
/*
    Filename:           sales.class.php
    Created:            7/17/2011, � 2006 kernelbd.com Abdul Mohymen
    Descripton:         Webserivces of sales from PriceMinister.com API
    Requirements:
        - PHP with XML support
		- shopminister.class.php
        - a Developer's token from PriceMinister (https://ws.priceminister.co.uk/sales_ws?)
*/
class PM_Sales extends Priceminister_Webservices {

	const _VER_GETCURRENTSALES_ = '2013-06-25';
	const _VER_GETNEWSALES_ = '2011-03-29';
	const _VER_ACCEPTSALE_ = '2010-09-20';
	const _VER_REFUSESALE_ = '2010-09-20';
	const _VER_GETITEMTODOLIST_ = '2011-02-02';
	const _VER_GETITEMINFOS_ = '2011-02-02';
	const _VER_CANCELITEM_ = '2011-02-02';
	const _VER_CONTACTPRICEMINISTERABOUTITEM_ = '2011-02-02';
	const _VER_CONTACTUSERABOUTITEM_ = '2011-02-02';
	const _VER_GETCOMPENSATIONDETAILS_ = '2011-03-29';
	const _VER_GETBILLINGINFORMATION_ = '2011-03-29';
	const _VER_GETSHIPPINGINFORMATION_ = '2011-03-29';
	const _VER_SETTRACKINGPACKAGEINFOS_ = '2012-11-06';

	function __construct($config = array()) {
		$this->config = $config;
	} // end func


	public function settrackingpackageinfos($params=array()) {
		if(!isset($params['field'])) $params['field'] = '';

                $opts = '' ;
                $opts .= isset($params['itemid']) ? '&itemid=' . $params['itemid'] : '' ;
                $opts .= isset($params['transporter_name']) ? '&transporter_name=' . urlencode($params['transporter_name']) : '' ;
                $opts .= isset($params['tracking_number']) ? '&tracking_number=' . $params['tracking_number'] : '' ;
                $opts .= isset($params['tracking_url']) ? '&tracking_url=' . urlencode($params['tracking_url']) : '' ;

		//Service URL
		$url = $this->config['https_url'].'sales_ws?action=settrackingpackageinfos&login='.$this->config['login'].'&pwd='.$this->config['pwd'].'&channel=common-services&version='.self::_VER_SETTRACKINGPACKAGEINFOS_ . $opts ;

                unset($params['transporter_name']) ;
                unset($params['tracking_number']) ;
                unset($params['tracking_url']) ;
                unset($params['itemid']) ;

		//Request Response
		return $this->make_request($url, $params);
	} // end func    
        
	public function getcurrentsales($params=array()) {
		if(!isset($params['field'])) $params['field'] = '';

                $opts = isset($params['purchasedate']) ? '&purchasedate=' . $params['purchasedate'] : '' ;
                
		//Service URL
		$url = $this->config['https_url'].'sales_ws?action=getcurrentsales&login='.$this->config['login'].'&pwd='.$this->config['pwd'].'&channel=common-services&version='.self::_VER_GETCURRENTSALES_ . $opts;

                unset($params['purchasedate']) ;

		//Request Response
		return $this->make_request($url, $params);
	} // end func        
        
	public function getnewsales($params=array()) {
		if(!isset($params['field'])) $params['field'] = '';

		//Service URL
		$url = $this->config['https_url'].'sales_ws?action=getnewsales&login='.$this->config['login'].'&pwd='.$this->config['pwd'].'&channel=common-services&version='.self::_VER_GETNEWSALES_;

		//Request Response
		return $this->make_request($url, $params);
	} // end func

	public function acceptsale($params=array()) {
		if(!isset($params['itemid'])) $params['itemid'] = '';

		//Service URL
		$url = $this->config['https_url'].'sales_ws?action=acceptsale&login='.$this->config['login'].'&pwd='.$this->config['pwd'].'&version='.self::_VER_ACCEPTSALE_.'&itemid='.$params['itemid'];

		//Request Response
		return $this->make_request($url, $params);
	} // end func

	public function refusesale($params=array()) {	
		if(!isset($params['itemid'])) $params['itemid'] = '';

		//Service URL
		$url = $this->config['https_url'].'sales_ws?action=refusesale&login='.$this->config['login'].'&pwd='.$this->config['pwd'].'&version='.self::_VER_REFUSESALE_.'&itemid='.$params['itemid']; //&itemid=104918937

		//Request Response
		return $this->make_request($url, $params);
	} // end func	
	
	public function getitemtodolist($params=array()) {
		//Service URL
		$url = $this->config['https_url'].'sales_ws?action=getitemtodolist&login='.$this->config['login'].'&pwd='.$this->config['pwd'].'&version='.self::_VER_GETITEMTODOLIST_;
		
		//Request Response
		return $this->make_request($url, $params);
	} // end func
	
	public function getiteminfos($params=array()) {	
		if(!isset($params['itemid'])) $params['itemid'] = '';
		
		//Service URL
		$url = $this->config['https_url'].'sales_ws?action=getiteminfos&login='.$this->config['login'].'&pwd='.$this->config['pwd'].'&version='.self::_VER_GETITEMINFOS_.'&itemid='.$params['itemid'];
		
		//Request Response
		return $this->make_request($url, $params);
	} // end func	
	
	public function cancelitem($params=array()) {	
		if(!isset($params['itemid'])) $params['itemid'] = '';
		if(!isset($params['comment'])) $params['comment'] = '';
		
		//Service URL
		$url = $this->config['https_url'].'sales_ws?action=cancelitem&login='.$this->config['login'].'&pwd='.$this->config['pwd'].'&version='.self::_VER_CANCELITEM_.'&itemid='.$params['itemid'];
		
		//Request Response
		return $this->make_request($url, $params);
	} // end func		
	
	public function contactpriceministeraboutitem($params=array()) {
		if(!isset($params['itemid'])) $params['itemid'] = '';
		if(!isset($params['comment'])) $params['comment'] = '';
		if(!isset($params['mailparentid'])) $params['mailparentid'] = '';
		
		//Service URL
		$url = $this->config['https_url'].'sales_ws?action=contactpriceministeraboutitem&login='.$this->config['login'].'&pwd='.$this->config['pwd'].'&version='.self::_VER_CONTACTPRICEMINISTERABOUTITEM_.'&itemid='.$params['itemid'].'&itemid='.$params['itemid'].'&itemid='.$params['itemid'];
		
		//Request Response
		return $this->make_request($url, $params);
	} // end func	
	
	public function contactuseraboutitem($params=array()) {
		if(!isset($params['itemid'])) $params['itemid'] = '';
		if(!isset($params['content'])) $params['content'] = '';

		//Service URL
		$url = $this->config['https_url'].'sales_ws?action=contactuseraboutitem&login='.$this->config['login'].'&pwd='.$this->config['pwd'].'&version='.self::_VER_CONTACTUSERABOUTITEM_.'&itemid='.$params['itemid'].'&content='.$params['content'];

                unset($params['content']) ;
                unset($params['itemid']) ;

		//Request Response
		return $this->make_request($url, $params);
	} // end func

	public function getcompensationdetails($params=array()) {
		if(!isset($params['compensationid'])) $params['compensationid'] = '';
		
		//Service URL
		$url = $this->config['https_url'].'sales_ws?action=getcompensationdetails&login='.$this->config['login'].'&pwd='.$this->config['pwd'].'&version='.self::_VER_GETCOMPENSATIONDETAILS_.'&compensationid='.$params['compensationid'];
		
		//Request Response
		return $this->make_request($url, $params);
	} // end func	
	
	public function getbillinginformation($params=array()) {
		if(!isset($params['purchaseid'])) $params['purchaseid'] = '';
		
		//Service URL
		$url = $this->config['https_url'].'sales_ws?action=getbillinginformation&login='.$this->config['login'].'&pwd='.$this->config['pwd'].'&version='.self::_VER_GETBILLINGINFORMATION_.'&purchaseid='.$params['purchaseid'];
		
		//Request Response
		return $this->make_request($url, $params);
	} // end func						
} // end class definition
?>