<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: contact@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Mon Echelle
 * @copyright  Copyright (c) 2011-2014 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2014 Common Services Co Ltd (http://www.common-services.com)
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * 
 */

class PM_Shop extends Shop
{
    static public function setShop($shop)
    {
        self::$context_id_shop = $shop->id;
        self::$context_id_shop_group = $shop->id_shop_group;
        self::$context = self::CONTEXT_SHOP;
    }    
}


class PM_Context
{
    static public function restore(&$context, $shop = null)
    {
        if ( version_compare(_PS_VERSION_, '1.5', '>=') )
        {
            $storedContexts = unserialize(base64_decode(Configuration::getGlobalValue('PM_CONTEXT_DATA'))) ;

            if ( $shop instanceOf Shop )
            {
                $context_key = self::getKey($shop) ;
            }
            else
            {
                $context_key = Tools::getValue('context_key') ;
            }
            
            if ( ! is_array($storedContexts) || ! count($storedContexts) || ! $context_key )
            {
                printf('%s(#%d): Wrong context, please configure your module first', basename(__FILE__), __LINE__) ;
                return(false) ;
            }
            
            if ( ! isset($storedContexts[$context_key]) || ! $storedContexts[$context_key] || !  $storedContexts[$context_key] instanceOf Context )
            {
                printf('%s(#%d): Wrong context, please configure your module first', basename(__FILE__), __LINE__) ;
                return(false) ;
            }
            
            $context->employee = $storedContexts[$context_key]->employee ;
            $context->currency = $storedContexts[$context_key]->currency ;
            $context->country = $storedContexts[$context_key]->country ;
            $context->shop = $storedContexts[$context_key]->shop ;    
            $context->language = $storedContexts[$context_key]->language ;   

            if ( Shop::isFeatureActive() )
                PM_Shop::setShop($context->shop) ;            
        }
        return(true) ;
    }
    
    static public function save($context, $employee = null)
    {
        if ( version_compare(_PS_VERSION_, '1.5', '>=') )
        {
            $storedContexts = unserialize(base64_decode(Configuration::getGlobalValue('PM_CONTEXT_DATA'))) ;
            
            if ( is_array($storedContexts) && count($storedContexts) )
                $PMContexts = $storedContexts ;
            else
                $PMContexts = array() ;
            
            $contextData = new Context() ;
            $contextData->shop = $context->shop ;
            
            if ( Validate::isLoadedObject($employee) )
                    $contextData->employee = $employee ;
            else    $contextData->employee = $context->employee ;
            
            $contextData->shop = $context->shop ;
            $contextData->currency = $context->currency ;
            $contextData->country = $context->country ;
            $contextData->language = $context->language ;
            
            $contextKey = self::getKey($contextData->shop) ;
            
            if ( ! isset($PMContexts[$contextKey]) || ! is_array($PMContexts[$contextKey]) )
                $PMContexts[$contextKey] = array() ;
            
            $PMContexts[$contextKey] = $contextData ;
            
            return( Configuration::updateGlobalValue('PM_CONTEXT_DATA', base64_encode(serialize($PMContexts))) )  ;
        }
        return(true) ;
    }
 
    public static function getKey($shop)
    {
        if ( ! $shop instanceOf Shop )
            return(false) ;
        
        $id_shop = (int)$shop->id ;
        $id_shop_group = (int)$shop->id_shop_group ;
            
        $context_key = dechex(crc32(sprintf('%02d_%02d', $id_shop, $id_shop_group))) ; // create a short key     

        return($context_key) ;
    }   
}