<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: contact@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@smartmarseille.com
 * ...........................................................................
 * @package    Rue Du Commerce
 * @copyright  Copyright (c) 2011-2011 S.A.R.L SMC (http://www.smartmarseille.com)
 * @copyright  Copyright (c) 2011-2014 Common Services Co Ltd (http://www.common-services.com)
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  olivier@smartmarseille.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * 
 */

// PS < 1.5
if (defined('PS_ADMIN_DIR'))
    include_once(PS_ADMIN_DIR . '/../classes/AdminTab.php');

require_once(dirname(__FILE__) . '/priceminister.php');
require_once(dirname(__FILE__) . '/controllers/admin/AdminPriceMinisterProductsController.inc.php');

class PriceMinisterProduct extends AdminTab
{
    public $name = 'priceminister';
    private $module = 'priceminister';

    private $priceMinisterProductController = null;
    
    public $multishop_context;
    public $multishop_context_group;

    public function __construct()
    {
        global $cookie, $_LANGADM;

        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {
            $this->multishop_context = Shop::CONTEXT_ALL;
            $this->id_lang = (int) Context::getContext()->language->id;
        }
        else
        {
            $this->id_lang = (int) $cookie->id_lang;
        }
                
        $langFile = _PS_MODULE_DIR_ . $this->module . '/' . Language::getIsoById(intval($this->id_lang)) . '.php';
        if (file_exists($langFile))
        {
            require_once($langFile);

            if (isset($_MODULE))
            {
                foreach ($_MODULE as $key => $value)
                {
                    if (preg_match('#^..' . $this->module . '#', $key))
                    {
                        $_LANGADM[str_replace('_', '', strip_tags($key))] = $value;
                    }
                }
            }
        }
        $this->url = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->name . '/';
        $this->images = $this->url . 'images/';
        
        $this->priceMinisterProductController = new AdminPriceMinisterProductsControllerExt($this->id_lang);

        parent::__construct();
    }

    public function display()
    {
        global $smarty;

        $this->addCSS($this->url . 'css/priceminister.css', 'screen');

        $this->addJS($this->url . 'js/productexport.js') ;
        
        echo $this->priceMinisterProductController->content($smarty);
    }

    function addCSS($css)
    {
        echo '<link type="text/css" rel="stylesheet" href="' . $css . '" />' . "\n";
        return;
    }

    function addJS($js)
    {
        echo '<script type="text/javascript" src="' . $js . '"></script>' . "\n";

        return;
    }

}

?>
