<?php
/**
  * PDF class, PDF.php
  * PDF product
  *
  */

include_once(_PS_FPDF_PATH_.'fpdf.php');

class PDF_PageGroup_jc extends FPDF
{
	var $NewPageGroup;   // variable indicating whether a new group was requested
	var $PageGroups;	 // variable containing the number of pages of the groups
	var $CurrPageGroup;  // variable containing the alias of the current page group

	// create a new page group; call this before calling AddPage()
	function StartPageGroup()
	{
		$this->NewPageGroup=true;
	}

	// current page in the group
	function GroupPageNo()
	{
		return $this->PageGroups[$this->CurrPageGroup];
	}

	// alias of the current page group -- will be replaced by the total number of pages in this group
	function PageGroupAlias()
	{
		return $this->CurrPageGroup;
	}

	function _beginpage($orientation, $arg2)
	{
		parent::_beginpage($orientation, $arg2);
		if($this->NewPageGroup)
		{
			// start a new group
			$n = sizeof($this->PageGroups)+1;
			$alias = "{nb$n}";
			$this->PageGroups[$alias] = 1;
			$this->CurrPageGroup = $alias;
			$this->NewPageGroup=false;
		}
		elseif($this->CurrPageGroup)
			$this->PageGroups[$this->CurrPageGroup]++;
	}

	function _putpages()
	{
		$nb = $this->page;
		if (!empty($this->PageGroups))
		{
			// do page number replacement
			foreach ($this->PageGroups as $k => $v)
				for ($n = 1; $n <= $nb; $n++)
					$this->pages[$n]=str_replace($k, $v, $this->pages[$n]);
		}
		parent::_putpages();
	}
}

class PDF_jc extends PDF_PageGroup_jc
{
	private static $_priceDisplayMethod;

// 09/02/2011
// Johann Corbel
	private static $product = NULL;

	/** @var object Order currency object */
	private static $currency = NULL;

	private static $_iso;

	/** @var array Special PDF params such encoding and font */

	private static $_pdfparams = array();
	private static $_fpdf_core_fonts = array('courier', 'helvetica', 'helveticab', 'helveticabi', 'helveticai', 'symbol', 'times', 'timesb', 'timesbi', 'timesi', 'zapfdingbats');

	/**
	* Constructor
	*/
	public function __construct($orientation='P', $unit='mm', $format='A4')
	{
		global $cookie;
		if (!isset($cookie) OR !is_object($cookie))
			$cookie->id_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
		self::$_iso = strtoupper(Language::getIsoById($cookie->id_lang));
		FPDF::FPDF($orientation, $unit, $format);
		$this->_initPDFFonts();
	}

	private function _initPDFFonts()
	{
		if (!$languages = Language::getLanguages())
			die(Tools::displayError());
		foreach ($languages AS $language)
		{
			$isoCode = strtoupper($language['iso_code']);
			$conf = Configuration::getMultiple(array('PS_PDF_ENCODING_'.$isoCode, 'PS_PDF_FONT_'.$isoCode));
			self::$_pdfparams[$isoCode] = array(
				'encoding' => (isset($conf['PS_PDF_ENCODING_'.$isoCode]) AND $conf['PS_PDF_ENCODING_'.$isoCode] == true) ? $conf['PS_PDF_ENCODING_'.$isoCode] : 'iso-8859-1',
				'font' => (isset($conf['PS_PDF_FONT_'.$isoCode]) AND $conf['PS_PDF_FONT_'.$isoCode] == true) ? $conf['PS_PDF_FONT_'.$isoCode] : 'helvetica'
			);
		}

		if ($font = self::embedfont())
		{
			$this->AddFont($font);
			$this->AddFont($font, 'B');
		}
	}

	/**
	* Invoice header
	*/
	public function Header()
	{
		global $cookie;
		return;
   }

	/**
	* Invoice footer
	*/
	public function Footer()
	{
		$this->Ln(5);
		$this->SetXY(10,280);
		$arrayConf = array('PS_SHOP_NAME', 'PS_SHOP_ADDR1', 'PS_SHOP_ADDR2', 'PS_SHOP_CODE', 'PS_SHOP_CITY', 'PS_SHOP_COUNTRY', 'PS_SHOP_DETAILS', 'PS_SHOP_PHONE', 'PS_SHOP_STATE');
		$conf = Configuration::getMultiple($arrayConf);
		$conf['PS_SHOP_NAME_UPPER'] = Tools::strtoupper($conf['PS_SHOP_NAME']);
		foreach($conf as $key => $value)
			$conf[$key] = Tools::iconv('utf-8', self::encoding(), $value);
		foreach ($arrayConf as $key)
			if (!isset($conf[$key]))
				$conf[$key] = '';
		$this->SetFillColor(240, 240, 240);
		$this->SetTextColor(0, 0, 0);
		$this->SetFont(self::fontname(), '', 8);
		$this->Cell(0, 5, $conf['PS_SHOP_NAME_UPPER'] . ' - ' . $conf['PS_SHOP_ADDR1'] . ' ' . $conf['PS_SHOP_CODE'].' '.
		$conf['PS_SHOP_CITY'], 0, 1, 'C', 1);
		$this->Cell(0, 5, self::l('PHONE:').' '.$conf['PS_SHOP_PHONE'] . " - " . "Site web : www.garage-batayer.fr", 0, 1, 'C', 1);
	}



	static private function convertSign($s)
	{
		return str_replace('¥', chr(165), str_replace('£', chr(163), str_replace('€', chr(128), $s)));
	}

	static protected function l($string)
	{
		global $cookie;
		if (@!include(_PS_TRANSLATIONS_DIR_.Language::getIsoById($cookie->id_lang).'/pdf.php'))
			die('Cannot include PDF translation language file : '._PS_TRANSLATIONS_DIR_.Language::getIsoById($cookie->id_lang).'/pdf.php');

		if (!is_array($_LANGPDF))
			return str_replace('"', '&quot;', $string);
		$key = md5(str_replace('\'', '\\\'', $string));
		$str = (key_exists('PDF_invoice'.$key, $_LANGPDF) ? $_LANGPDF['PDF_invoice'.$key] : $string);

		return (Tools::iconv('utf-8', self::encoding(), $str));
	}

	static private function encoding()
	{
		return (isset(self::$_pdfparams[self::$_iso]) AND is_array(self::$_pdfparams[self::$_iso]) AND self::$_pdfparams[self::$_iso]['encoding']) ? self::$_pdfparams[self::$_iso]['encoding'] : 'iso-8859-1';
	}

	static private function embedfont()
	{
		return (((isset(self::$_pdfparams[self::$_iso]) AND is_array(self::$_pdfparams[self::$_iso]) AND self::$_pdfparams[self::$_iso]['font']) AND !in_array(self::$_pdfparams[self::$_iso]['font'], self::$_fpdf_core_fonts)) ? self::$_pdfparams[self::$_iso]['font'] : false);
	}

	static private function fontname()
	{
		$font = self::embedfont();
		if (in_array(self::$_pdfparams[self::$_iso]['font'], self::$_fpdf_core_fonts))
			$font = self::$_pdfparams[self::$_iso]['font'];
		return $font ? $font : 'Arial';
 	}

	public static function product($product, $id_lang)
	{
		global $cookie;
		if (!Validate::isLoadedObject($product))
			die('Invalid product or invalid order state');
		self::$product = $product;

		$sql = '
		SELECT p.*,
			pl.`description`, pl.`description_short`, pl.`link_rewrite`, pl.`meta_description`, pl.`meta_keywords`, pl.`meta_title`, pl.`name`,
			i.`id_image`, il.`legend`, pl.`meta_keywords`, pl.`meta_title`, pl.`meta_description` 
		FROM `'._DB_PREFIX_.'product`  p
		LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (p.`id_product` = pl.`id_product` AND pl.`id_lang` = '.intval($id_lang).')
		LEFT JOIN `'._DB_PREFIX_.'image` i ON (i.`id_product` = p.`id_product` AND i.`cover` = 1)
		LEFT JOIN `'._DB_PREFIX_.'image_lang` il ON (i.`id_image` = il.`id_image` AND il.`id_lang` = '.intval($id_lang).')
		WHERE p.`active` = 1
		AND p.`id_product` = ' . $product->id;
		$row = Db::getInstance()->getRow($sql);
			
		if (!$multiple)
			$pdf = new PDF_jc('P', 'mm', 'A4');

//		$pdf->SetAutoPageBreak(true, 20);
		$pdf->StartPageGroup();

		$pdf->AliasNbPages();
		$pdf->AddPage();


		$pdf->SetFont(self::fontname(), '', 20);
		
		$euro = chr(164);

		$pdf->Cell(140, 10, Tools::iconv('utf-8', self::encoding(), $product->name[intval($cookie->id_lang)]), 0, 'L');
		$pdf->Cell(0, 10, number_format($product->price, 0, ",", " ") . " " . chr(128), 0, 'R');
		
		$pdf->Ln(1);
		$pdf->SetXY(10,20);

//   		$pdf->Image(_PS_PROD_IMG_DIR_ . $product->id . "-" . $row['id_image'] . ".jpg", null, null,190);
//  		$pdf->Image(__PS_BASE_URI__ . $row['id_image'] . "/" . $product->link_rewrite[intval($cookie->id_lang)] . ".jpg", null, null,190);
   		$pdf->Image("http://www.garage-batayer.fr" . "/" . $row['id_image'] . "/" . $product->link_rewrite[intval($cookie->id_lang)] . ".jpg", null, null,190);
	
		$pdf->SetFont(self::fontname(), '', 7);
		$pdf->Ln(5);

		$features = $product->getFrontFeatures(intval($cookie->id_lang));

		for ($i=0; $i < count($features); $i++)
		{
			$pdf->Cell(70, 4, Tools::iconv('utf-8', self::encoding(), $features[$i]['name']), 0, 'L');
			$pdf->MultiCell(120, 4, Tools::iconv('utf-8', self::encoding(), $features[$i]['value']), 0, 'L');
//			$pdf->Ln(4);
		}

		return $pdf->Output($product->name[intval($cookie->id_lang)] . '.pdf', 'D');
	}
}
